/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.document.DocumentHost;
import com.jetbrains.resharper.editors.ITextControlHost;
import com.jetbrains.resharper.editors.MyVisibleAreaListener;
import com.jetbrains.resharper.editors.ProjectContextWidget;
import com.jetbrains.resharper.editors.TargetFrameworkIdWidget;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.editors.TextControlHostKt;
import com.jetbrains.resharper.editors.TextControlUtilsKt;
import com.jetbrains.resharper.editors.TextEditingGateway;
import com.jetbrains.resharper.editors.TextEditingGatewayKt;
import com.jetbrains.resharper.editors.VisibleEditorsChange;
import com.jetbrains.resharper.internal.RiderInternalDumpWidget;
import com.jetbrains.resharper.internal.RiderInternalTools;
import com.jetbrains.resharper.internal.RiderInternalWidget;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.RiderOpenFileDescriptorKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.protocol.IPermittedModalities;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.resharper.util.idea.RiderDocumnetUtilKt;
import com.jetbrains.rider.framework.base.RdBindableBase;
import com.jetbrains.rider.framework.impl.RdProperty;
import com.jetbrains.rider.model.EditableEntity;
import com.jetbrains.rider.model.EditableEntityCollection;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.LastFocusedTextControl;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.ScrollingInfo;
import com.jetbrains.rider.model.SelectionRange;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.model.TextControlModel;
import com.jetbrains.rider.model.TextControlTuple;
import com.jetbrains.rider.model.TextControlsCollection;
import com.jetbrains.rider.model.VisibleRange;
import com.jetbrains.rider.util.IDisposable;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.IViewable;
import com.jetbrains.rider.util.reactive.IViewableMap;
import com.jetbrains.rider.util.reactive.Property;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import com.jetbrains.rider.util.reactive.ViewableMap;
import com.jetbrains.rider.util.wrappers.Session;
import com.jetbrains.rider.util.wrappers.SessionKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u0091\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0004\u0091\u0001\u0092\u0001B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0015H\u0014J\u0018\u0010K\u001a\u00020G2\u0006\u0010L\u001a\u00020M2\u0006\u0010J\u001a\u00020\u0015H\u0002J\u0018\u0010N\u001a\u00020G2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0002J\u0015\u0010S\u001a\u00020G2\u0006\u0010J\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u00020V2\u0006\u0010J\u001a\u00020\u0015H\u0002J\u0010\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020,J\u0010\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020G2\u0006\u0010[\u001a\u00020\\H\u0016J\u001a\u0010^\u001a\u0004\u0018\u00010\u00152\u0006\u0010O\u001a\u00020P2\u0006\u0010_\u001a\u00020,H\u0002J\u0018\u0010`\u001a\u00020G2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010a\u001a\u00020bH\u0016J\u0018\u0010c\u001a\u00020G2\u0006\u0010d\u001a\u00020\b2\u0006\u0010Q\u001a\u00020RH\u0016J\u0018\u0010e\u001a\u00020G2\u0006\u0010d\u001a\u00020\b2\u0006\u0010Q\u001a\u00020RH\u0016J\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00150gJ\b\u0010h\u001a\u0004\u0018\u00010\u0015J\b\u0010i\u001a\u0004\u0018\u00010\u0014J\u0010\u0010j\u001a\u00020b2\u0006\u0010k\u001a\u00020RH\u0002J\b\u0010l\u001a\u0004\u0018\u00010\u0015J\u0012\u0010m\u001a\u0004\u0018\u00010n2\u0006\u0010o\u001a\u00020\u0014H\u0002J\u000e\u0010p\u001a\u00020G2\u0006\u0010q\u001a\u00020,J\u0010\u0010r\u001a\u00020G2\u0006\u0010J\u001a\u00020\u0015H\u0002J\u0018\u0010s\u001a\u00020G2\u0006\u0010t\u001a\u00020M2\u0006\u0010u\u001a\u00020nH\u0002J \u0010v\u001a\u00020G2\u0006\u0010w\u001a\u00020P2\u0006\u0010x\u001a\u00020y2\u0006\u0010J\u001a\u00020\u0015H\u0002J\u0010\u0010z\u001a\u00020G2\u0006\u0010[\u001a\u00020{H\u0016J\b\u0010|\u001a\u00020GH\u0002J\u0018\u0010}\u001a\u00020G2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010u\u001a\u00020nH\u0002J\u001d\u0010~\u001a\u00020G2\u0006\u0010J\u001a\u00020\u00152\u0006\u0010u\u001a\u00020nH\u0000\u00a2\u0006\u0002\b\u007fJ4\u0010\u0080\u0001\u001a\u00020G2\u0007\u0010\u0081\u0001\u001a\u00020\u00172\u0007\u0010\u0082\u0001\u001a\u00020\u00142\u0007\u0010\u0083\u0001\u001a\u00020n2\u0006\u0010x\u001a\u00020y2\u0006\u0010J\u001a\u00020\u0015H\u0002J2\u0010\u0084\u0001\u001a\u00020G2\u0006\u0010o\u001a\u00020\u00142\u0006\u0010u\u001a\u00020n2\u0007\u0010\u0085\u0001\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u00152\u0006\u0010x\u001a\u00020yH\u0002J\u000f\u0010\u0086\u0001\u001a\u00020GH\u0000\u00a2\u0006\u0003\b\u0087\u0001J\u0010\u0010\u0088\u0001\u001a\u00020G2\u0007\u0010\u0081\u0001\u001a\u00020\u0017J\u0017\u0010\u0089\u0001\u001a\u00020G2\u0006\u0010o\u001a\u00020\u0014H\u0000\u00a2\u0006\u0003\b\u008a\u0001J3\u0010\u008b\u0001\u001a\u00020G2\u0007\u0010\u0081\u0001\u001a\u00020\u00172!\u0010\u008c\u0001\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0014\u0012\u0005\u0012\u00030\u008e\u0001\u0012\u0004\u0012\u00020G0\u008d\u0001J\u0015\u0010\u008f\u0001\u001a\u00020b*\u00020b2\u0006\u0010k\u001a\u00020RH\u0002J\r\u0010\u0090\u0001\u001a\u00020b*\u00020bH\u0002R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020,8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020/0(8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010*R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001502X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0012\u00109\u001a\u00020,8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0017\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006\u0093\u0001"}, d2={"Lcom/jetbrains/resharper/editors/TextControlHost;", "Lcom/jetbrains/resharper/editors/ITextControlHost;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "documentHost", "Lcom/jetbrains/resharper/document/DocumentHost;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "virtualFileIndex", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileEditorManager;Lcom/intellij/openapi/editor/EditorFactory;Lcom/jetbrains/resharper/document/DocumentHost;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;)V", "_openedEditors", "Lcom/jetbrains/rider/util/reactive/ViewableMap;", "Lcom/jetbrains/rider/model/TextControlId;", "Lcom/intellij/openapi/editor/Editor;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "currentlyBindingEditor", "getCurrentlyBindingEditor", "()Lcom/intellij/openapi/editor/Editor;", "setCurrentlyBindingEditor", "(Lcom/intellij/openapi/editor/Editor;)V", "getDocumentHost", "()Lcom/jetbrains/resharper/document/DocumentHost;", "editableEntities", "Lcom/jetbrains/rider/model/EditableEntityCollection;", "getEditableEntities", "()Lcom/jetbrains/rider/model/EditableEntityCollection;", "getFileEditorManager", "()Lcom/intellij/openapi/fileEditor/FileEditorManager;", "focusedTextControl", "Lcom/jetbrains/rider/util/wrappers/Session;", "getFocusedTextControl", "()Lcom/jetbrains/rider/util/wrappers/Session;", "holdUpState", "", "isListeningToFrontendFocus", "lastFocusedTextControl", "Lcom/jetbrains/rider/model/TextControlTuple;", "getLastFocusedTextControl", "openedEditors", "Lcom/jetbrains/rider/util/reactive/IViewableMap;", "getOpenedEditors", "()Lcom/jetbrains/rider/util/reactive/IViewableMap;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProjectModelViewHost", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "syncingFromBackend", "updatingFromBackend", "getUpdatingFromBackend", "()Z", "setUpdatingFromBackend", "(Z)V", "getVirtualFileIndex", "()Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "visibleEditorsChange", "Lcom/jetbrains/rider/util/reactive/Property;", "Lcom/jetbrains/resharper/editors/VisibleEditorsChange;", "getVisibleEditorsChange", "()Lcom/jetbrains/rider/util/reactive/Property;", "applyScrollingFromBackend", "", "backendScrolling", "Lcom/jetbrains/rider/model/ScrollingInfo;", "editor", "applySelectionFromBackend", "backendSelection", "Lcom/jetbrains/rider/model/SelectionRange;", "assertCorrectContextForSharedFile", "editableEntityId", "Lcom/jetbrains/rider/model/EditableEntityId;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "bindEditor", "bindEditor$rider", "calculateVisibleRange", "Lcom/jetbrains/rider/model/VisibleRange;", "dumpBackendEditors", "", "precisePaths", "editorCreated", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "ensureEditorOpened", "activate", "ensureIdForEditor", "projectModelId", "", "fileClosed", "source", "fileOpened", "getAllIdeaEditors", "", "getFocusedEditor", "getFocusedTextControlId", "getIdFromNavigation", "virtualFile", "getLastFocusedEditor", "getTextControlModel", "Lcom/jetbrains/rider/model/TextControlModel;", "textControlId", "holdUpFrontendState", "close", "onEditorClosed", "performSend", "model", "textControl", "registerTextControl", "entityId", "editableEntity", "Lcom/jetbrains/rider/model/EditableEntity;", "selectionChanged", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "sendFocusedTextControlState", "sendSelection", "sendVisibleRange", "sendVisibleRange$rider", "subscribeForEditor", "lifetime", "actualTextControlId", "textControlToSubscribe", "subscribeForTextControlChanges", "textControlLifetime", "syncFocusedEditor", "syncFocusedEditor$rider", "syncFromBackend", "unbindEditor", "unbindEditor$rider", "withLastFocusedTextControl", "handler", "Lkotlin/Function3;", "Lcom/jetbrains/rider/model/LastFocusedTextControl;", "adjustIfShared", "shouldOpenInMiscFiles", "Companion", "ListeningFrontendFocusCookie", "rider"})
public class TextControlHost
implements ITextControlHost,
FileEditorManagerListener,
EditorFactoryListener,
ILifetimedComponent {
    private boolean updatingFromBackend;
    @Nullable
    private Editor currentlyBindingEditor;
    private final ViewableMap<TextControlId, Editor> _openedEditors;
    @NotNull
    private final IViewableMap<TextControlId, Editor> openedEditors;
    @NotNull
    private final Property<VisibleEditorsChange> visibleEditorsChange;
    private volatile boolean holdUpState;
    private volatile boolean syncingFromBackend;
    private boolean isListeningToFrontendFocus;
    @NotNull
    private final Project project;
    @NotNull
    private final FileEditorManager fileEditorManager;
    @NotNull
    private final DocumentHost documentHost;
    @NotNull
    private final ProjectModelViewHost projectModelViewHost;
    @NotNull
    private final VirtualFileIndex virtualFileIndex;
    @NotNull
    private static final Key<TextControlId> textControlIdKey;
    @NotNull
    private static final Key<TextControlModel> textControlKey;
    @NotNull
    private static final Key<Integer> projectModelIdKey;
    private static final Logger logger;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    protected final EditableEntityCollection getEditableEntities() {
        return SolutionHostExtensionsKt.getSolution(this.project).getEditors();
    }

    public final boolean getUpdatingFromBackend() {
        return this.updatingFromBackend;
    }

    public final void setUpdatingFromBackend(boolean bl) {
        this.updatingFromBackend = bl;
    }

    @Nullable
    public final Editor getCurrentlyBindingEditor() {
        return this.currentlyBindingEditor;
    }

    public final void setCurrentlyBindingEditor(@Nullable Editor editor) {
        this.currentlyBindingEditor = editor;
    }

    @Override
    @NotNull
    public IViewableMap<TextControlId, Editor> getOpenedEditors() {
        return this.openedEditors;
    }

    @NotNull
    public final Property<VisibleEditorsChange> getVisibleEditorsChange() {
        return this.visibleEditorsChange;
    }

    @NotNull
    public final Session<TextControlId> getFocusedTextControl() {
        IProperty<TextControlId> iProperty = this.getEditableEntities().getFocusedTextControlSession();
        if (iProperty == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.framework.impl.RdProperty<com.jetbrains.rider.model.TextControlId?>");
        }
        return new Session<TextControlId>(((RdProperty)iProperty).slave());
    }

    @NotNull
    public final Session<TextControlTuple> getLastFocusedTextControl() {
        return new Session<TextControlTuple>(this.getEditableEntities().getLastFocusedTextControlSession());
    }

    private final void subscribeForEditor(Lifetime lifetime, TextControlId actualTextControlId, TextControlModel textControlToSubscribe, EditableEntity editableEntity, Editor editor) {
        boolean bl;
        boolean bl2 = bl = editor.getUserData(Companion.getTextControlIdKey()) == null;
        if (!bl) {
            String string2 = "subscribing on already registered editor";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        textControlToSubscribe.getTabSize().advise(lifetime, (Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(editor){
            final /* synthetic */ Editor $editor;

            public final void invoke(int it) {
                Editor editor = this.$editor;
                if (editor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                }
                ((EditorEx)editor).reinitSettings();
            }
            {
                this.$editor = editor;
                super(1);
            }
        }));
        textControlToSubscribe.getIndentSize().advise(lifetime, (Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(editor){
            final /* synthetic */ Editor $editor;

            public final void invoke(int it) {
                Editor editor = this.$editor;
                if (editor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                }
                ((EditorEx)editor).reinitSettings();
            }
            {
                this.$editor = editor;
                super(1);
            }
        }));
        textControlToSubscribe.getUseTab().advise(lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(editor){
            final /* synthetic */ Editor $editor;

            public final void invoke(boolean it) {
                Editor editor = this.$editor;
                if (editor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                }
                ((EditorEx)editor).reinitSettings();
            }
            {
                this.$editor = editor;
                super(1);
            }
        }));
        textControlToSubscribe.getRightMargin().advise(lifetime, (Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(editor){
            final /* synthetic */ Editor $editor;

            public final void invoke(int rightMargin) {
                this.$editor.getSettings().setRightMargin(rightMargin);
            }
            {
                this.$editor = editor;
                super(1);
            }
        }));
        editor.putUserData(Companion.getTextControlIdKey(), (Object)actualTextControlId);
        editor.putUserData(Companion.getTextControlKey(), (Object)textControlToSubscribe);
        editor.putUserData(Companion.getProjectModelIdKey(), (Object)actualTextControlId.getDocumentId().getProjectModelElementId());
        Map map2 = this._openedEditors;
        Editor editor2 = editor;
        map2.put(actualTextControlId, editor2);
        PropertyExKt.adviseNotNull((IReadonlyProperty)textControlToSubscribe.isVisible(), lifetime, (Function1)new Function1<Boolean, Unit>(this, editor, actualTextControlId){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ TextControlId $actualTextControlId;

            public final void invoke(boolean isVisible) {
                if (!isVisible) {
                    return;
                }
                Editor selectedEditor = FileEditorManager.getInstance((Project)this.this$0.getProject()).getSelectedTextEditor();
                if (selectedEditor != null && selectedEditor.equals(this.$editor)) {
                    return;
                }
                TextControlHost.access$ensureEditorOpened(this.this$0, this.$actualTextControlId.getDocumentId(), false);
                this.this$0.ensureIdForEditor(this.$editor, this.$actualTextControlId.getDocumentId().getProjectModelElementId());
            }
            {
                this.this$0 = textControlHost;
                this.$editor = editor;
                this.$actualTextControlId = textControlId;
                super(1);
            }
        });
        LifetimeExKt.plusAssign(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(this, actualTextControlId, editor){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ TextControlId $actualTextControlId;
            final /* synthetic */ Editor $editor;

            public final void invoke() {
                TextControlHost.access$get_openedEditors$p(this.this$0).remove(this.$actualTextControlId);
                this.$editor.putUserData(TextControlHost.Companion.getTextControlKey(), null);
                this.$editor.putUserData(TextControlHost.Companion.getTextControlIdKey(), null);
                this.$editor.putUserData(TextControlHost.Companion.getProjectModelIdKey(), null);
            }
            {
                this.this$0 = textControlHost;
                this.$actualTextControlId = textControlId;
                this.$editor = editor;
                super(0);
            }
        }));
        this.subscribeForTextControlChanges(actualTextControlId, textControlToSubscribe, lifetime, editor, editableEntity);
        this.sendSelection(editor, textControlToSubscribe);
    }

    /*
     * WARNING - void declaration
     */
    private final Editor ensureEditorOpened(EditableEntityId editableEntityId, boolean activate) {
        void editor;
        if (this.currentlyBindingEditor != null) {
            return this.currentlyBindingEditor;
        }
        TextControlHost.Companion.getLogger().info("Trying to open backend textControl on frontend. File: " + editableEntityId.getFilePath() + ".");
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(editableEntityId.getFilePath()), (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!file2.exists()) {
            return null;
        }
        VirtualFile virtualFile2 = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        this.assertCorrectContextForSharedFile(editableEntityId, virtualFile2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        CommandProcessor.getInstance().executeCommand(this.project, new Runnable(this, editableEntityId, (Ref.ObjectRef)editor, file2, activate){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ EditableEntityId $editableEntityId;
            final /* synthetic */ Ref.ObjectRef $editor;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ boolean $activate;

            public final void run() {
                RiderOpenFileDescriptorKt.withProjectModelIdUpdateFocus(this.$editableEntityId.getProjectModelElementId(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ ensureEditorOpened.1 this$0;

                    public final void invoke() {
                        this.this$0.$editor.element = TextControlHostKt.access$getSingleEditor(this.this$0.this$0.getFileEditorManager().openFile(this.this$0.$file, this.this$0.$activate, true));
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = textControlHost;
                this.$editableEntityId = editableEntityId;
                this.$editor = objectRef;
                this.$file = virtualFile;
                this.$activate = bl;
            }
        }, "", null);
        return (Editor)editor.element;
    }

    /*
     * WARNING - void declaration
     */
    private final void assertCorrectContextForSharedFile(EditableEntityId editableEntityId, VirtualFile file2) {
        VirtualFileIndexEntry entry;
        boolean isShared = ProjectModelNodeExtensionKt.isFromSharedProject(this.projectModelViewHost, editableEntityId.getProjectModelElementId());
        if (isShared && (entry = this.virtualFileIndex.get(file2)) != null) {
            boolean bl;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)entry.getProjectModelIds();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                if (!(!ProjectModelNodeExtensionKt.isFromSharedProject(this.projectModelViewHost, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            int normalProjectsCount = collection.size();
            boolean bl2 = bl = normalProjectsCount == 0;
            if (!bl) {
                String string2 = "Request to sync shared projectFile when there are normal project contexts";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
        }
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEditor().getProject(), (Object)this.project) ^ true) {
            return;
        }
        Editor editor = event.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"event.editor");
        if (!RiderDocumnetUtilKt.isRealDocument(editor)) {
            return;
        }
        Editor editor2 = event.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"event.editor");
        this.bindEditor$rider(editor2);
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEditor().getProject(), (Object)this.project) ^ true) {
            return;
        }
        Logger $receiver$iv = TextControlHost.Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Editor released. " + event.getEditor();
            logger.trace(string2);
        }
        TextControlId textControlId = DocumentExKt.getTextControlId(event.getEditor());
        if (textControlId == null) {
            return;
        }
        TextControlId textControlId2 = textControlId;
        this.unbindEditor$rider(textControlId2);
        TextEditingGatewayKt.onSyncFromBackendFinished(TextEditingGateway.Companion.getInstance(this.project), this.getComponentLifetime(), (Function0<Unit>)((Function0)new Function0<Unit>(event){
            final /* synthetic */ EditorFactoryEvent $event;

            public final void invoke() {
                ApplicationKt.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ editorReleased.2 this$0;

                    public final void run() {
                        FileDocumentManager.getInstance().saveDocument(this.this$0.$event.getEditor().getDocument());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$event = editorFactoryEvent;
                super(0);
            }
        }));
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
    }

    /*
     * WARNING - void declaration
     */
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Object[] objectArray = $receiver$iv = (Object[])event.getManager().getSelectedEditors();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv$iv).length; ++i2) {
            Editor editor;
            void element$iv$iv$iv = $receiver$iv$iv$iv[i2];
            void element$iv$iv = element$iv$iv$iv;
            FileEditor it = (FileEditor)element$iv$iv;
            FileEditor fileEditor = it;
            if (!(fileEditor instanceof TextEditor)) {
                fileEditor = null;
            }
            TextEditor textEditor = (TextEditor)fileEditor;
            Object object = textEditor != null ? textEditor.getEditor() : null;
            if (object == null) continue;
            Editor it$iv$iv = editor = object;
            destination$iv$iv.add(it$iv$iv);
        }
        List editors = (List)destination$iv$iv;
        Property<VisibleEditorsChange> change = this.visibleEditorsChange;
        change.setValue(new VisibleEditorsChange(change.getValue().getNewVisible(), editors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bindEditor$rider(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (Intrinsics.areEqual((Object)editor.getProject(), (Object)this.project) ^ true) {
            return;
        }
        try {
            VirtualFile virtualFile;
            EditorImpl editorImpl;
            this.currentlyBindingEditor = editor;
            Editor editor2 = editor;
            if (!(editor2 instanceof EditorImpl)) {
                editor2 = null;
            }
            if ((editorImpl = (EditorImpl)editor2) == null || (editorImpl = editorImpl.getDisposable()) == null) {
                editorImpl = (Disposable)this.project;
            }
            EditorImpl parentDisposable = editorImpl;
            IPermittedModalities iPermittedModalities = IPermittedModalities.Companion.getInstance();
            JComponent jComponent = editor.getComponent();
            Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.component");
            iPermittedModalities.allowPumpProtocolForComponent(jComponent, (Disposable)parentDisposable);
            Document ideaDocument = editor.getDocument();
            if (FileDocumentManager.getInstance().getFile(ideaDocument) == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            String filePath = virtualFile2.getPath();
            VirtualFile virtualFile3 = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
            int projectModelId = this.shouldOpenInMiscFiles(this.getIdFromNavigation(virtualFile3));
            VirtualFile virtualFile4 = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"virtualFile");
            projectModelId = this.adjustIfShared(projectModelId, virtualFile4);
            String string2 = filePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"filePath");
            EditableEntityId editableEntityId = new EditableEntityId(projectModelId, string2);
            Document document = ideaDocument;
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"ideaDocument");
            EditableEntity editableEntity = this.documentHost.registerModelDocument$rider(editableEntityId, document);
            this.registerTextControl(editableEntityId, editableEntity, editor);
        }
        finally {
            this.currentlyBindingEditor = null;
        }
    }

    private final int shouldOpenInMiscFiles(int $receiver) {
        if ($receiver != 0) {
            ProjectModelNode projectModelNode = this.projectModelViewHost.getItemById($receiver);
            if ((projectModelNode != null ? projectModelNode.getDescriptor() : null) instanceof RdUnloadProjectDescriptor) {
                return 0;
            }
        }
        return $receiver;
    }

    private final int adjustIfShared(int $receiver, VirtualFile virtualFile) {
        boolean isShared = ProjectModelNodeExtensionKt.isFromSharedProject(this.projectModelViewHost, $receiver);
        if (isShared) {
            Object v1;
            block4: {
                VirtualFileIndexEntry virtualFileIndexEntry = this.virtualFileIndex.get(virtualFile);
                if (virtualFileIndexEntry == null) {
                    return $receiver;
                }
                VirtualFileIndexEntry entry = virtualFileIndexEntry;
                Iterable $receiver$iv = entry.getProjectModelIds();
                for (Object element$iv : $receiver$iv) {
                    int it = ((Number)element$iv).intValue();
                    if (!(!ProjectModelNodeExtensionKt.isFromSharedProject(this.projectModelViewHost, it))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Integer firstWithRealContext = v1;
            if (firstWithRealContext != null) {
                return firstWithRealContext;
            }
        }
        return $receiver;
    }

    private final int getIdFromNavigation(VirtualFile virtualFile) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (RiderOpenFileDescriptorKt.getCurrentProjectModelIdNavigation() != null) {
            Integer n2 = RiderOpenFileDescriptorKt.getCurrentProjectModelIdNavigation();
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            return n2;
        }
        VirtualFileIndexEntry entry = this.virtualFileIndex.get(virtualFile);
        if (entry != null) {
            Integer n3 = (Integer)CollectionsKt.firstOrNull((Iterable)entry.getProjectModelIds());
            return n3 != null ? n3 : 0;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerTextControl(EditableEntityId entityId, EditableEntity editableEntity, Editor editor) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl;
        boolean bl2 = bl = editor.getUserData(Companion.getTextControlIdKey()) == null;
        if (!bl) {
            String string2 = "registering already registered editor";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        TextControlId actualTextControlId = new TextControlId(entityId, 1);
        Iterable iterable = $receiver$iv = (Iterable)editableEntity.getTabsForDocument().getTextControls().keySet();
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TextControlId it = (TextControlId)element$iv$iv;
            if (!(!this.getOpenedEditors().containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unregisteredTabsForThisEditableEntity = (List)destination$iv$iv;
        if (!unregisteredTabsForThisEditableEntity.isEmpty()) {
            $receiver$iv = unregisteredTabsForThisEditableEntity;
            boolean bl3 = $receiver$iv = $receiver$iv.size() == 1;
            if (!$receiver$iv) {
                destination$iv$iv = "More than one unbinded textControls";
                throw (Throwable)new IllegalArgumentException(destination$iv$iv.toString());
            }
            actualTextControlId = (TextControlId)CollectionsKt.single((List)unregisteredTabsForThisEditableEntity);
        } else {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2 = editableEntity.getTabsForDocument().getTextControls().keySet();
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                TextControlId $i$a$1$filter = (TextControlId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                Integer n2 = it.getTabIndex();
                collection.add(n2);
            }
            List tabIndexes = (List)destination$iv$iv2;
            if (!tabIndexes.isEmpty()) {
                Comparable comparable = CollectionsKt.max((Iterable)tabIndexes);
                if (comparable == null) {
                    Intrinsics.throwNpe();
                }
                actualTextControlId = new TextControlId(entityId, ((Number)((Object)comparable)).intValue() + 1);
            }
        }
        Map $receiver$iv2 = editableEntity.getTabsForDocument().getTextControls();
        Object object = $receiver$iv2.get(actualTextControlId);
        if (object == null) {
            TextControlModel textControlModel;
            TextControlId it = actualTextControlId;
            int spaceWidth = EditorUtil.getSpaceWidth(0, editor);
            TextControlModel textControl = new TextControlModel(entityId);
            textControl.getSelection().setValue(TextControlUtilsKt.toModel(editor.getSelectionModel()));
            textControl.getVisibleRange().setValue(this.calculateVisibleRange(editor));
            PropertyExKt.set(textControl.getSpaceWidth(), spaceWidth);
            TextControlHost.Companion.getLogger().info("Adding textControl to the model. File: " + textControl.getContent().getFilePath() + ". " + ("Caret offset: " + textControl.getSelection().getValue().getActivePosition() + ". Selection: [" + textControl.getSelection().getValue().getSelectionAnchor() + " - " + textControl.getSelection().getValue().getActivePosition() + "]"));
            TextControlModel it$iv = textControlModel = textControl;
            Map map2 = $receiver$iv2;
            TextControlId textControlId = actualTextControlId;
            TextControlModel textControlModel2 = it$iv;
            map2.put(textControlId, textControlModel2);
            object = it$iv;
        }
    }

    private final void sendSelection(Editor editor, TextControlModel textControl) {
        SelectionRange model2 = TextControlUtilsKt.toModel(editor.getSelectionModel());
        if (this.holdUpState || this.syncingFromBackend) {
            Logger $receiver$iv = TextControlHost.Companion.getLogger();
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string2 = "HoldUpState = " + this.holdUpState + " , syncingFromBackend = " + this.syncingFromBackend + ", so queueing " + model2 + " for " + editor.getDocument();
                logger.trace(string2);
            }
        } else {
            if (PropertyExKt.getHasValue((IReadonlyProperty)textControl.getSelection()) && Intrinsics.areEqual((Object)model2, (Object)textControl.getSelection().getValue())) {
                return;
            }
            this.performSend(model2, textControl);
        }
    }

    private final void performSend(SelectionRange model2, TextControlModel textControl) {
        Logger $receiver$iv = TextControlHost.Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Sending selection for " + textControl.getContent() + " to anchor: " + model2.getSelectionAnchor() + " end:" + model2.getActivePosition();
            logger.trace(string2);
        }
        PropertyExKt.set(textControl.getSelection(), model2);
    }

    public final void sendVisibleRange$rider(@NotNull Editor editor, @NotNull TextControlModel textControl) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)textControl, (String)"textControl");
        VisibleRange value2 = this.calculateVisibleRange(editor);
        Logger $receiver$iv = TextControlHost.Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Sending viewport for: " + editor + " to start: " + value2.getStartOffset() + " end:" + value2.getEndOffset();
            logger.trace(string2);
        }
        PropertyExKt.set(textControl.getVisibleRange(), value2);
    }

    private final VisibleRange calculateVisibleRange(Editor editor) {
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        VisibleRange value2 = new VisibleRange(visibleRange.getStartOffset(), visibleRange.getEndOffset());
        return value2;
    }

    private final void subscribeForTextControlChanges(TextControlId textControlId, TextControlModel textControl, Lifetime textControlLifetime, Editor editor, EditableEntity editableEntity) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        FocusChangeListener focusChangeListener2 = new FocusChangeListener(this, textControlId, textControlLifetime){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ TextControlId $textControlId;
            final /* synthetic */ Lifetime $textControlLifetime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(@Nullable Editor editor) {
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger $receiver$iv = com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion);
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string2 = "SelectionChanged callback for editor " + editor + "." + "\n" + "Sending focusedTCValue to " + this.$textControlId;
                    logger.trace(string2);
                }
                IDisposable disposable$iv = new ListeningFrontendFocusCookie(this.this$0);
                try {
                    SessionKt.refreshOnNew(this.this$0.getFocusedTextControl(), this.$textControlId, this.$textControlLifetime);
                }
                finally {
                    disposable$iv.dispose();
                }
                com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion).trace("Current focusedTextControl model id is " + this.this$0.getFocusedTextControl().getCurrentValue());
            }

            public void focusLost(@Nullable Editor editor) {
                this.this$0.getFocusedTextControl().clear();
            }
            {
                this.this$0 = $outer;
                this.$textControlId = $captured_local_variable$1;
                this.$textControlLifetime = $captured_local_variable$2;
            }
        };
        Editor editor2 = editor;
        if (editor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        }
        ((EditorImpl)editor2).addFocusListener(focusChangeListener2, DisposableExKt.toDisposable(textControlLifetime, "Disposable for lifetime of a model textControl with id: " + textControlId));
        CaretListener caretListener2 = new CaretListener(this, textControl){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ TextControlModel $textControl;

            public void caretAdded(@Nullable CaretEvent e2) {
            }

            public void caretPositionChanged(@NotNull CaretEvent e2) {
                String string2;
                Logger logger;
                Logger $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                Caret caret = e2.getCaret();
                if (caret == null) {
                    Intrinsics.throwNpe();
                }
                if (caret.getOffset() == 0 && ($receiver$iv = com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion)).isTraceEnabled()) {
                    logger = $receiver$iv;
                    string2 = "Caret position changed from frontend to " + TextControlUtilsKt.toModel(e2.getEditor().getSelectionModel()) + ". updatingFromBackend = " + this.this$0.getUpdatingFromBackend();
                    logger.trace(string2);
                }
                if (($receiver$iv = com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion)).isTraceEnabled()) {
                    logger = $receiver$iv;
                    string2 = "Caret position changed from frontend to " + TextControlUtilsKt.toModel(e2.getEditor().getSelectionModel()) + ". updatingFromBackend = " + this.this$0.getUpdatingFromBackend();
                    logger.trace(string2);
                }
                if (!this.this$0.getUpdatingFromBackend()) {
                    Editor editor = e2.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"e.editor");
                    TextControlHost.access$sendSelection(this.this$0, editor, this.$textControl);
                }
            }

            public void caretRemoved(@NotNull CaretEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                if (e2.getEditor().getCaretModel().getCaretCount() == 1) {
                    Editor editor = e2.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"e.editor");
                    TextControlHost.access$sendSelection(this.this$0, editor, this.$textControl);
                }
            }
            {
                this.this$0 = $outer;
                this.$textControl = $captured_local_variable$1;
            }
        };
        SelectionListener selectionListener2 = new SelectionListener(this, textControl){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ TextControlModel $textControl;

            public final void selectionChanged(SelectionEvent e2) {
                Logger $receiver$iv = com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion);
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    StringBuilder stringBuilder = new StringBuilder().append("Selection changed from frontend to ");
                    SelectionEvent selectionEvent = e2;
                    if (selectionEvent == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = stringBuilder.append(TextControlUtilsKt.toModel(selectionEvent.getEditor().getSelectionModel())).append(". updatingFromBackend = ").append(this.this$0.getUpdatingFromBackend()).toString();
                    logger.trace(string2);
                }
                if (!this.this$0.getUpdatingFromBackend()) {
                    Editor editor = e2.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"e.editor");
                    TextControlHost.access$sendSelection(this.this$0, editor, this.$textControl);
                }
            }
            {
                this.this$0 = textControlHost;
                this.$textControl = textControlModel;
            }
        };
        MyVisibleAreaListener visibleAreaListener2 = new MyVisibleAreaListener(this, editor, textControl);
        ((EditorImpl)editor).getCaretModel().addCaretListener(caretListener2);
        ((EditorImpl)editor).getSelectionModel().addSelectionListener(selectionListener2);
        ((EditorImpl)editor).getScrollingModel().addVisibleAreaListener(visibleAreaListener2);
        textControl.getSelection().advise(textControlLifetime, (Function1<SelectionRange, Unit>)((Function1)new Function1<SelectionRange, Unit>(this, editor){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ Editor $editor;

            public final void invoke(@NotNull SelectionRange backendSelection) {
                Intrinsics.checkParameterIsNotNull((Object)backendSelection, (String)"backendSelection");
                if (TextControlUtilsKt.toModel(((EditorImpl)this.$editor).getSelectionModel()).equals(backendSelection)) {
                    return;
                }
                TextControlHost.access$applySelectionFromBackend(this.this$0, backendSelection, this.$editor);
            }
            {
                this.this$0 = textControlHost;
                this.$editor = editor;
                super(1);
            }
        }));
        textControl.getScrolling().advise(textControlLifetime, (Function1<ScrollingInfo, Unit>)((Function1)new Function1<ScrollingInfo, Unit>(this, editor){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ Editor $editor;

            public final void invoke(@NotNull ScrollingInfo scrollingInfo) {
                Intrinsics.checkParameterIsNotNull((Object)scrollingInfo, (String)"scrollingInfo");
                this.this$0.applyScrollingFromBackend(scrollingInfo, this.$editor);
            }
            {
                this.this$0 = textControlHost;
                this.$editor = editor;
                super(1);
            }
        }));
        textControlLifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this, editor, selectionListener2, caretListener2, visibleAreaListener2){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ SelectionListener $selectionListener;
            final /* synthetic */ subscribeForTextControlChanges.caretListener.1 $caretListener;
            final /* synthetic */ MyVisibleAreaListener $visibleAreaListener;

            public final void invoke() {
                TextControlHost.access$onEditorClosed(this.this$0, this.$editor);
                ((EditorImpl)this.$editor).getSelectionModel().removeSelectionListener(this.$selectionListener);
                ((EditorImpl)this.$editor).getCaretModel().removeCaretListener(this.$caretListener);
                ((EditorImpl)this.$editor).getScrollingModel().removeVisibleAreaListener(this.$visibleAreaListener);
                this.$visibleAreaListener.dispose();
            }
            {
                this.this$0 = textControlHost;
                this.$editor = editor;
                this.$selectionListener = selectionListener2;
                this.$caretListener = var4_4;
                this.$visibleAreaListener = myVisibleAreaListener;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applySelectionFromBackend(SelectionRange backendSelection, Editor editor) {
        try {
            Logger $receiver$iv = TextControlHost.Companion.getLogger();
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string2 = "applying backend caret change to (" + backendSelection.getActivePosition() + " - " + backendSelection.getSelectionAnchor() + ")";
                logger.trace(string2);
            }
            this.updatingFromBackend = true;
            if (backendSelection.getActivePosition() == backendSelection.getSelectionAnchor()) {
                editor.getCaretModel().moveToOffset(backendSelection.getActivePosition());
                editor.getSelectionModel().removeSelection();
            } else {
                editor.getSelectionModel().setSelection(backendSelection.getSelectionAnchor(), backendSelection.getActivePosition());
                editor.getCaretModel().moveToOffset(backendSelection.getActivePosition());
            }
        }
        finally {
            this.updatingFromBackend = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyScrollingFromBackend(@NotNull ScrollingInfo backendScrolling, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)backendScrolling, (String)"backendScrolling");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        try {
            Logger $receiver$iv = TextControlHost.Companion.getLogger();
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string2 = "applying backend scrolling to (" + backendScrolling + ")";
                logger.trace(string2);
            }
            this.updatingFromBackend = true;
            Integer offset = backendScrolling.getDocOffset();
            ScrollType scrollType = TextControlUtilsKt.ToScrollType(backendScrolling.getKind());
            if (offset != null) {
                LogicalPosition pos = editor.offsetToLogicalPosition(((Number)offset).intValue());
                editor.getScrollingModel().scrollTo(pos, scrollType);
            } else {
                editor.getScrollingModel().scrollToCaret(scrollType);
            }
        }
        finally {
            this.updatingFromBackend = false;
        }
    }

    public final void unbindEditor$rider(@NotNull TextControlId textControlId) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)textControlId, (String)"textControlId");
            Object object = (EditableEntity)this.getEditableEntities().getDocuments().get(textControlId.getDocumentId());
            if (object == null || (object = ((EditableEntity)object).getTabsForDocument()) == null || (object = ((TextControlsCollection)object).getTextControls()) == null) break block0;
            TextControlModel cfr_ignored_0 = (TextControlModel)object.remove(textControlId);
        }
    }

    private final void onEditorClosed(Editor editor) {
        Boolean noTabsLeft;
        Object object;
        if (!RiderDocumnetUtilKt.isRealDocument(editor)) {
            return;
        }
        if (editor.equals(this.getFocusedEditor())) {
            this.getFocusedTextControl().clear();
            Editor lastFocusedEditor = this.getLastFocusedEditor();
            boolean bl = editor.equals(lastFocusedEditor);
            if (!bl) {
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            this.getLastFocusedTextControl().clear();
        }
        if ((object = editor.getUserData(Companion.getTextControlIdKey())) == null) {
            String string3 = "Closing TextControl without editor key";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        TextControlId textControlId = (TextControlId)object;
        TextControlHost.Companion.getLogger().info("Closing " + textControlId + " ...");
        this._openedEditors.remove(textControlId);
        editor.putUserData(Companion.getTextControlKey(), null);
        editor.putUserData(Companion.getTextControlIdKey(), null);
        EditableEntityId documentId = textControlId.getDocumentId();
        Object object2 = (EditableEntity)this.getEditableEntities().getDocuments().get(documentId);
        Boolean bl = object2 != null && (object2 = ((EditableEntity)object2).getTabsForDocument()) != null && (object2 = ((TextControlsCollection)object2).getTextControls()) != null ? Boolean.valueOf(object2.isEmpty()) : (noTabsLeft = null);
        if (noTabsLeft != null && noTabsLeft.booleanValue()) {
            this.documentHost.unregisterDocument(documentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void holdUpFrontendState(boolean close) {
        try {
            if (this.holdUpState && !close) {
                void $receiver$iv$iv;
                Iterable $receiver$iv = this.getEditableEntities().getDocuments().values();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    EditableEntity ee = (EditableEntity)element$iv$iv;
                    Iterable list$iv$iv = ee.getTabsForDocument().getTextControls().keySet();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List allIds = (List)destination$iv$iv;
                for (TextControlId textControlId : allIds) {
                    Editor editor;
                    TextControlModel textControlModel;
                    if (this._openedEditors.get(textControlId) == null) {
                        continue;
                    }
                    if (this.getTextControlModel(textControlId) == null) {
                        continue;
                    }
                    if (!PropertyExKt.getHasValue((IReadonlyProperty)textControlModel.getSelection())) continue;
                    this.performSend(TextControlUtilsKt.toModel(editor.getSelectionModel()), textControlModel);
                }
            }
        }
        finally {
            if (close) {
                TextControlHost.Companion.getLogger().trace("sending the caret state to backend before the gate is closed...");
                this.sendFocusedTextControlState();
            }
            this.holdUpState = close;
        }
    }

    public final void syncFromBackend(@NotNull Lifetime lifetime) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        boolean bl2 = bl = !this.holdUpState;
        if (!bl) {
            String string2 = "cannot syncingFromBackend while still holding up frontend state";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        TextControlHost.Companion.getLogger().trace("Start syncing from backend...");
        this.syncingFromBackend = true;
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TextControlHost this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv = this.this$0.getEditableEntities().getDocuments().values();
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        EditableEntity ee = (EditableEntity)element$iv$iv;
                        Iterable list$iv$iv = ee.getTabsForDocument().getTextControls().entrySet();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List allTextControls = (List)destination$iv$iv;
                    for (Map.Entry pair : allTextControls) {
                        TextControlId id = (TextControlId)pair.getKey();
                        Editor editor = (Editor)TextControlHost.access$get_openedEditors$p(this.this$0).get(id);
                        if (editor == null) {
                            StringBuilder sb2 = new StringBuilder("Cannot find editor." + "\n" + "Id:" + id + "\n" + "List of opened editors:" + "\n");
                            Object object = TextControlHost.access$get_openedEditors$p(this.this$0);
                            for (Map.Entry<K, V> openedEditor : object.entrySet()) {
                                object = sb2;
                                K k2 = openedEditor.getKey();
                                StringsKt.appendln((StringBuilder)((StringBuilder)object).append(k2));
                            }
                            com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion).info(sb2.toString());
                            continue;
                        }
                        if (!PropertyExKt.getHasValue((IReadonlyProperty)((TextControlModel)pair.getValue()).getSelection())) continue;
                        TextControlHost.access$applySelectionFromBackend(this.this$0, ((TextControlModel)pair.getValue()).getSelection().getValue(), editor);
                    }
                }
                finally {
                    com.jetbrains.resharper.editors.TextControlHost$Companion.access$getLogger$p(TextControlHost.Companion).trace("Syncing from backend has finished");
                    TextControlHost.access$setSyncingFromBackend$p(this.this$0, false);
                }
            }
            {
                this.this$0 = textControlHost;
                super(0);
            }
        }));
    }

    private final void sendFocusedTextControlState() {
        TextControlId textControlId = this.getFocusedTextControl().getCurrentValue();
        if (textControlId == null) {
            return;
        }
        TextControlId textControlId2 = textControlId;
        Editor editor = this._openedEditors.get(textControlId2);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TextControlModel textControlModel = this.getTextControlModel(textControlId2);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        this.performSend(TextControlUtilsKt.toModel(editor2.getSelectionModel()), textControlModel2);
    }

    private final TextControlModel getTextControlModel(TextControlId textControlId) {
        RdBindableBase rdBindableBase = (EditableEntity)this.getEditableEntities().getDocuments().get(textControlId.getDocumentId());
        if (rdBindableBase == null || (rdBindableBase = ((EditableEntity)rdBindableBase).getTabsForDocument()) == null) {
            return null;
        }
        RdBindableBase tabsForDocument = rdBindableBase;
        return (TextControlModel)((TextControlsCollection)tabsForDocument).getTextControls().get(textControlId);
    }

    public final void withLastFocusedTextControl(@NotNull Lifetime lifetime, @NotNull Function3<? super Lifetime, ? super TextControlId, ? super LastFocusedTextControl, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        PropertyExKt.viewNotNull((IViewable)this.getEditableEntities().getLastFocusedTextControlSession(), lifetime, (Function2)new Function2<Lifetime, TextControlTuple, Unit>(handler2){
            final /* synthetic */ Function3 $handler;

            public final void invoke(@NotNull Lifetime lt, @NotNull TextControlTuple v2) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
                this.$handler.invoke((Object)lt, (Object)v2.getId(), (Object)v2.getTextControl());
            }
            {
                this.$handler = function3;
                super(2);
            }
        });
    }

    @Nullable
    public final Editor getFocusedEditor() {
        Editor editor;
        TextControlId textControlId = this.getFocusedTextControlId();
        if (textControlId != null) {
            TextControlId textControlId2;
            TextControlId it = textControlId2 = textControlId;
            editor = this._openedEditors.get(it);
        } else {
            editor = null;
        }
        return editor;
    }

    @Nullable
    public final Editor getLastFocusedEditor() {
        Map map2;
        TextControlId textControlId;
        TextControlTuple textControlTuple = this.getLastFocusedTextControl().getCurrentValue();
        TextControlId it = textControlId = textControlTuple != null ? textControlTuple.getId() : null;
        Map map3 = map2 = (Map)this._openedEditors;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return (Editor)map3.get(it);
    }

    @Nullable
    public final TextControlId getFocusedTextControlId() {
        return this.getFocusedTextControl().getCurrentValue();
    }

    @NotNull
    public final String dumpBackendEditors(boolean precisePaths) {
        String result2 = ExtensionsKt.syncFromBackend(this.getEditableEntities().getDumpBackendTextControls(), precisePaths, this.project, this.getComponentLifetime());
        String string2 = result2;
        if (string2 == null) {
            string2 = "Lifetime of dumpBackendTextControls task has been terminated";
        }
        return string2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String dumpBackendEditors$default(TextControlHost textControlHost, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dumpBackendEditors");
        }
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return textControlHost.dumpBackendEditors(bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Editor> getAllIdeaEditors() {
        void var3_3;
        TextEditor element$iv$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = FileEditorManager.getInstance((Project)this.project).getAllEditors();
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv$iv).length; ++i2) {
            TextEditor textEditor;
            element$iv$iv$iv = $receiver$iv$iv$iv[i2];
            TextEditor element$iv$iv = element$iv$iv$iv;
            FileEditor it = (FileEditor)element$iv$iv;
            FileEditor fileEditor = it;
            if (!(fileEditor instanceof TextEditor)) {
                fileEditor = null;
            }
            if ((TextEditor)fileEditor == null) continue;
            TextEditor it$iv$iv = textEditor;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            element$iv$iv$iv = (TextEditor)item$iv$iv;
            Collection collection = destination$iv$iv;
            Editor editor = it.getEditor();
            collection.add(editor);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncFocusedEditor$rider() {
        Object object = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (object == null || (object = (TextControlId)object.getUserData(Companion.getTextControlIdKey())) == null) {
            return;
        }
        Object textControlId = object;
        IDisposable disposable$iv = new ListeningFrontendFocusCookie(this);
        try {
            Session<TextControlId> session2 = this.getFocusedTextControl();
            Object object2 = textControlId;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"textControlId");
            SessionKt.refreshOnNew(session2, object2, Lifetime.Companion.getEternal());
        }
        finally {
            disposable$iv.dispose();
        }
    }

    @Override
    public void ensureIdForEditor(@NotNull Editor editor, int projectModelId) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId != null) {
            if (textControlId.getDocumentId().getProjectModelElementId() != projectModelId) {
                this.documentHost.unregisterDocument(textControlId.getDocumentId());
            } else {
                return;
            }
        }
        RiderOpenFileDescriptorKt.withProjectModelIdUpdateFocus(projectModelId, (Function0<Unit>)((Function0)new Function0<Unit>(this, editor){
            final /* synthetic */ TextControlHost this$0;
            final /* synthetic */ Editor $editor;

            public final void invoke() {
                this.this$0.bindEditor$rider(this.$editor);
            }
            {
                this.this$0 = textControlHost;
                this.$editor = editor;
                super(0);
            }
        }));
        this.syncFocusedEditor$rider();
        ProjectContextWidget.Companion.updateSelf(this.project);
        TargetFrameworkIdWidget.Companion.updateSelf(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FileEditorManager getFileEditorManager() {
        return this.fileEditorManager;
    }

    @NotNull
    public final DocumentHost getDocumentHost() {
        return this.documentHost;
    }

    @NotNull
    public final ProjectModelViewHost getProjectModelViewHost() {
        return this.projectModelViewHost;
    }

    @NotNull
    public final VirtualFileIndex getVirtualFileIndex() {
        return this.virtualFileIndex;
    }

    public TextControlHost(@NotNull Project project2, @NotNull FileEditorManager fileEditorManager, @NotNull EditorFactory editorFactory, @NotNull DocumentHost documentHost, @NotNull ProjectModelViewHost projectModelViewHost, @NotNull VirtualFileIndex virtualFileIndex) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileEditorManager, (String)"fileEditorManager");
        Intrinsics.checkParameterIsNotNull((Object)editorFactory, (String)"editorFactory");
        Intrinsics.checkParameterIsNotNull((Object)documentHost, (String)"documentHost");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFileIndex), (String)"virtualFileIndex");
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.fileEditorManager = fileEditorManager;
        this.documentHost = documentHost;
        this.projectModelViewHost = projectModelViewHost;
        this.virtualFileIndex = virtualFileIndex;
        this._openedEditors = new ViewableMap();
        this.openedEditors = this._openedEditors;
        this.visibleEditorsChange = new Property<VisibleEditorsChange>(new VisibleEditorsChange(CollectionsKt.emptyList(), CollectionsKt.emptyList()));
        editorFactory.addEditorFactoryListener((EditorFactoryListener)this, (Disposable)this.project);
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)this.project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        this.getEditableEntities().getDocuments().view(this.getComponentLifetime(), (Function3<Lifetime, EditableEntityId, EditableEntity, Unit>)((Function3)new Function3<Lifetime, EditableEntityId, EditableEntity, Unit>(){

            public final void invoke(@NotNull Lifetime editableEntityLifetime, final @NotNull EditableEntityId editableEntityId, final @NotNull EditableEntity editableEntity) {
                Intrinsics.checkParameterIsNotNull((Object)editableEntityLifetime, (String)"editableEntityLifetime");
                Intrinsics.checkParameterIsNotNull((Object)editableEntityId, (String)"editableEntityId");
                Intrinsics.checkParameterIsNotNull((Object)editableEntity, (String)"editableEntity");
                editableEntity.getTabsForDocument().getTextControls().view(editableEntityLifetime, (Function3<Lifetime, TextControlId, TextControlModel, Unit>)((Function3)new Function3<Lifetime, TextControlId, TextControlModel, Unit>(){

                    public final void invoke(@NotNull Lifetime textControlLifetime, @NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel) {
                        Intrinsics.checkParameterIsNotNull((Object)textControlLifetime, (String)"textControlLifetime");
                        Intrinsics.checkParameterIsNotNull((Object)textControlId, (String)"textControlId");
                        Intrinsics.checkParameterIsNotNull((Object)textControlModel, (String)"textControlModel");
                        try {
                            Editor editor = this.ensureEditorOpened(editableEntityId, false);
                            if (editor == null) {
                                return;
                            }
                            Editor editor2 = editor;
                            this.subscribeForEditor(textControlLifetime, textControlId, textControlModel, editableEntity, editor2);
                            this.syncFocusedEditor$rider();
                        }
                        catch (Throwable e2) {
                            Companion.getLogger().error(e2.getMessage());
                        }
                    }
                }));
            }
        }));
        this.visibleEditorsChange.advise(this.getComponentLifetime(), (Function1<VisibleEditorsChange, Unit>)((Function1)2.INSTANCE));
        PropertyExKt.viewNotNull((IViewable)this.getFocusedTextControl().getProperty(), (Function2)new Function2<Lifetime, TextControlId, Unit>(){

            public final void invoke(@NotNull Lifetime focusedTextControlLifetime, @NotNull TextControlId textControlId) {
                TextControlTuple currentValue;
                Intrinsics.checkParameterIsNotNull((Object)focusedTextControlLifetime, (String)"focusedTextControlLifetime");
                Intrinsics.checkParameterIsNotNull((Object)textControlId, (String)"textControlId");
                if (!isListeningToFrontendFocus) {
                    Editor editor = this.ensureEditorOpened(textControlId.getDocumentId(), true);
                    if (editor == null) {
                        return;
                    }
                    Editor editor2 = editor;
                    this.ensureIdForEditor(editor2, textControlId.getDocumentId().getProjectModelElementId());
                }
                if ((currentValue = this.getLastFocusedTextControl().getCurrentValue()) != null && currentValue.getId().equals(textControlId)) {
                    return;
                }
                this.getLastFocusedTextControl().refresh(new TextControlTuple(textControlId, new LastFocusedTextControl()), Lifetime.Companion.getEternal());
            }
        });
        RiderInternalTools.Companion.getInstance(this.project).register("TextControls", "TextControlsDump", AllIcons.RunConfigurations.Tomcat, (Function1<? super Lifetime, ? extends RiderInternalWidget>)((Function1)new Function1<Lifetime, 1>(){

            @NotNull
            public final 1 invoke(final @NotNull Lifetime lifetime) {
                Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
                return new RiderInternalDumpWidget(lifetime, this.getProject(), false){

                    @Override
                    @NotNull
                    public String dump() {
                        return "*************Idea Editors************* " + "\n" + " " + TextControlUtilsKt.dumpIdeaEditors(this.getProject(), true) + " " + "\n" + " *****************Backend Editors******************* " + "\n" + " " + this.dumpBackendEditors(true);
                    }
                };
            }
        }));
    }

    static {
        Companion = new Companion(null);
        textControlIdKey = new Key("TextControlModelIdKey");
        textControlKey = new Key("TextControlModelKey");
        projectModelIdKey = new Key("ProjectModelIdKey");
        Logger logger = Logger.getInstance(TextControlHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        TextControlHost.logger = logger;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @NotNull
    public static final /* synthetic */ ViewableMap access$get_openedEditors$p(TextControlHost $this) {
        return $this._openedEditors;
    }

    public static final /* synthetic */ void access$sendSelection(TextControlHost $this, @NotNull Editor editor, @NotNull TextControlModel textControl) {
        $this.sendSelection(editor, textControl);
    }

    public static final /* synthetic */ void access$applySelectionFromBackend(TextControlHost $this, @NotNull SelectionRange backendSelection, @NotNull Editor editor) {
        $this.applySelectionFromBackend(backendSelection, editor);
    }

    public static final /* synthetic */ void access$onEditorClosed(TextControlHost $this, @NotNull Editor editor) {
        $this.onEditorClosed(editor);
    }

    public static final /* synthetic */ boolean access$getSyncingFromBackend$p(TextControlHost $this) {
        return $this.syncingFromBackend;
    }

    public static final /* synthetic */ void access$setSyncingFromBackend$p(TextControlHost $this, boolean bl) {
        $this.syncingFromBackend = bl;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/editors/TextControlHost$ListeningFrontendFocusCookie;", "Lcom/jetbrains/rider/util/IDisposable;", "owner", "Lcom/jetbrains/resharper/editors/TextControlHost;", "(Lcom/jetbrains/resharper/editors/TextControlHost;)V", "getOwner", "()Lcom/jetbrains/resharper/editors/TextControlHost;", "dispose", "", "rider"})
    protected static final class ListeningFrontendFocusCookie
    implements IDisposable {
        @NotNull
        private final TextControlHost owner;

        @Override
        public void dispose() {
            this.owner.isListeningToFrontendFocus = false;
        }

        @NotNull
        public final TextControlHost getOwner() {
            return this.owner;
        }

        public ListeningFrontendFocusCookie(@NotNull TextControlHost owner) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.owner = owner;
            this.owner.isListeningToFrontendFocus = true;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/resharper/editors/TextControlHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "projectModelIdKey", "Lcom/intellij/openapi/util/Key;", "", "getProjectModelIdKey", "()Lcom/intellij/openapi/util/Key;", "textControlIdKey", "Lcom/jetbrains/rider/model/TextControlId;", "getTextControlIdKey", "textControlKey", "Lcom/jetbrains/rider/model/TextControlModel;", "getTextControlKey", "getInstance", "Lcom/jetbrains/resharper/editors/ITextControlHost;", "project", "Lcom/intellij/openapi/project/Project;", "rider"})
    public static final class Companion {
        @NotNull
        public final Key<TextControlId> getTextControlIdKey() {
            return textControlIdKey;
        }

        @NotNull
        public final Key<TextControlModel> getTextControlKey() {
            return textControlKey;
        }

        @NotNull
        public final Key<Integer> getProjectModelIdKey() {
            return projectModelIdKey;
        }

        private final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final ITextControlHost getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            ComponentManager $receiver$iv = (ComponentManager)project2;
            Object object = $receiver$iv.getComponent(ITextControlHost.class);
            if (object == null) {
                throw (Throwable)new IllegalStateException("Component " + ITextControlHost.class + " not found in container " + $receiver$iv);
            }
            return (ITextControlHost)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

