/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.editors.DocCoordinates;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.editors.TextControlUtilsKt$WhenMappings;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.util.idea.ComponentContainerUtilKt;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.ScrollKind;
import com.jetbrains.rider.model.SelectionRange;
import com.jetbrains.rider.model.TextControlId;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015\u00a8\u0006\u0016"}, d2={"dumpIdeaEditors", "", "project", "Lcom/intellij/openapi/project/Project;", "precisePath", "", "ToScrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Lcom/jetbrains/rider/model/ScrollKind;", "getProjectModelId", "", "Lcom/intellij/openapi/editor/Editor;", "getProjectName", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "offsetToDocCoordinates", "Lcom/jetbrains/resharper/editors/DocCoordinates;", "Lcom/intellij/openapi/editor/Document;", "offset", "toModel", "Lcom/jetbrains/rider/model/SelectionRange;", "Lcom/intellij/openapi/editor/SelectionModel;", "rider"})
public final class TextControlUtilsKt {
    @NotNull
    public static final String dumpIdeaEditors(@NotNull Project project2, boolean precisePath) {
        Object $receiver$iv;
        StringBuilder result2;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        StringBuilder stringBuilder = result2 = new StringBuilder();
        String string2 = "Idea editors:";
        StringsKt.appendln((StringBuilder)stringBuilder.append(string2));
        FileEditor[] fileEditors = FileEditorManager.getInstance((Project)project2).getAllEditors();
        int i2 = 1;
        Object object = $receiver$iv = (Object[])fileEditors;
        Object object2 = new Comparator<FileEditor>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b2) {
                Object object;
                FileEditor fileEditor = (FileEditor)a;
                FileEditor fileEditor2 = fileEditor;
                if (!(fileEditor2 instanceof TextEditor)) {
                    fileEditor2 = null;
                }
                fileEditor = (FileEditor)b2;
                Object object2 = (TextEditor)fileEditor2;
                Comparable comparable = (Comparable)((Object)(object2 != null && (object2 = object2.getEditor()) != null && (object2 = DocumentExKt.getTextControlId((Editor)object2)) != null && (object2 = ((TextControlId)object2).getDocumentId()) != null ? ((EditableEntityId)object2).getFilePath() : null));
                FileEditor fileEditor3 = fileEditor;
                if (!(fileEditor3 instanceof TextEditor)) {
                    fileEditor3 = null;
                }
                String string2 = (object = (TextEditor)fileEditor3) != null && (object = object.getEditor()) != null && (object = DocumentExKt.getTextControlId((Editor)object)) != null && (object = ((TextControlId)object).getDocumentId()) != null ? ((EditableEntityId)object).getFilePath() : null;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        };
        for (FileEditor fileEditor : ArraysKt.sortedWith((Object[])object, (Comparator)object2)) {
            String string3;
            CharSequence pmIdState;
            Editor editor;
            $receiver$iv = result2;
            object = "Editor #" + i2;
            StringsKt.appendln((StringBuilder)((StringBuilder)$receiver$iv).append((String)object));
            $receiver$iv = result2;
            object = "Name: " + fileEditor.getName();
            StringsKt.appendln((StringBuilder)((StringBuilder)$receiver$iv).append((String)object));
            FileEditor fileEditor2 = fileEditor;
            if (!(fileEditor2 instanceof TextEditor)) {
                fileEditor2 = null;
            }
            TextEditor textEditor = (TextEditor)fileEditor2;
            Object object3 = editor = textEditor != null ? textEditor.getEditor() : null;
            if (editor == null) {
                object = result2;
                object2 = "no Editor associated with this FileEditor";
                StringsKt.appendln((StringBuilder)((StringBuilder)object).append((String)object2));
                continue;
            }
            TextControlId textControlId = DocumentExKt.getTextControlId(editor);
            if (textControlId != null) {
                pmIdState = String.valueOf(textControlId.getDocumentId().getProjectModelElementId());
                if (!precisePath) {
                    pmIdState = textControlId.getDocumentId().getProjectModelElementId() != 0 ? "!=0" : "=0(Misc Files)";
                }
                VirtualFile virtualFile = ComponentContainerUtilKt.toVirtualFile(textControlId.getDocumentId().getFilePath());
                string3 = "file=" + (virtualFile != null ? virtualFile.getName() : null) + " projectModelId" + (String)pmIdState;
            } else {
                string3 = "null";
            }
            String textControlIdDump = string3;
            pmIdState = result2;
            CharSequence charSequence = "Model id: " + textControlIdDump;
            StringsKt.appendln((StringBuilder)((StringBuilder)pmIdState).append((String)charSequence));
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            charSequence = result2;
            StringBuilder stringBuilder2 = new StringBuilder().append("Virtual file: ");
            Object object4 = virtualFile;
            if (object4 == null || (object4 = object4.getName()) == null) {
                object4 = "null file";
            }
            String string4 = stringBuilder2.append((String)object4).toString();
            StringsKt.appendln((StringBuilder)((StringBuilder)charSequence).append(string4));
            Document document = editor.getDocument();
            DocCoordinates pos = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getCaretModel().getCurrentCaret().getOffset());
            StringBuilder stringBuilder3 = result2;
            String string5 = "Current caret: (" + pos.getLine() + ", " + pos.getColumn() + ")";
            StringsKt.appendln((StringBuilder)stringBuilder3.append(string5));
            DocCoordinates selectionStart = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getSelectionModel().getSelectionStart());
            DocCoordinates selectionEnd = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getSelectionModel().getSelectionEnd());
            StringBuilder stringBuilder4 = result2;
            String string6 = "Current selection:  startPosition = (" + selectionStart.getLine() + ", " + selectionStart.getColumn() + ") endPosition = (" + selectionEnd.getLine() + ", " + selectionEnd.getColumn() + ")";
            StringsKt.appendln((StringBuilder)stringBuilder4.append(string6));
            ++i2;
        }
        String string7 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"result.toString()");
        return string7;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String dumpIdeaEditors$default(Project project2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return TextControlUtilsKt.dumpIdeaEditors(project2, bl);
    }

    @NotNull
    public static final ScrollType ToScrollType(@NotNull ScrollKind $receiver) {
        ScrollType scrollType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        switch (TextControlUtilsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                scrollType = ScrollType.MAKE_VISIBLE;
                break;
            }
            case 2: {
                scrollType = ScrollType.RELATIVE;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("this");
            }
        }
        return scrollType;
    }

    @NotNull
    public static final SelectionRange toModel(@NotNull SelectionModel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int anchor = $receiver.getLeadSelectionOffset();
        int activePosition = $receiver.getSelectionStart() == anchor ? $receiver.getSelectionEnd() : $receiver.getSelectionStart();
        return new SelectionRange(anchor, activePosition);
    }

    @NotNull
    public static final DocCoordinates offsetToDocCoordinates(@NotNull Document $receiver, int offset) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl2 = bl = offset >= 0 && offset <= $receiver.getTextLength();
        if (!bl) {
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        int line = $receiver.getLineNumber(offset);
        int lineStartOffset = $receiver.getLineStartOffset(line);
        int column = offset - lineStartOffset;
        return new DocCoordinates(line, column);
    }

    public static final int getProjectModelId(@NotNull Editor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Integer n2 = (Integer)$receiver.getUserData(TextControlHost.Companion.getProjectModelIdKey());
        return n2 != null ? n2 : 0;
    }

    @NotNull
    public static final String getProjectName(@NotNull Editor $receiver, @NotNull ProjectModelViewHost projectModelViewHost) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        Integer n2 = (Integer)$receiver.getUserData(TextControlHost.Companion.getProjectModelIdKey());
        if (n2 == null) {
            return "Misc Files";
        }
        Integer projectModelId = n2;
        if (Intrinsics.areEqual((Object)projectModelId, (Object)0)) {
            return "Misc Files";
        }
        Integer n3 = projectModelId;
        Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"projectModelId");
        ProjectModelNode projectModelNode = projectModelViewHost.getItemById(n3);
        if (projectModelNode == null) {
            return "Misc Files";
        }
        ProjectModelNode projectModelNode2 = projectModelNode;
        ProjectModelNode containingProjectNode = ProjectModelNodeExtensionKt.containingProject(projectModelNode2);
        return containingProjectNode == null ? "Misc Files" : containingProjectNode.getName();
    }
}

