/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.document.DocumentHost;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.editors.TextEditingGatewayKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.GatewayState;
import com.jetbrains.rider.model.RdTextEditingGateway;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001:B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020$H\u0002J\u0016\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020$2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u00100\u001a\u00020$2\u0006\u0010,\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020$02J\u000e\u00103\u001a\u00020$2\u0006\u0010-\u001a\u00020.J\u0010\u00104\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00105\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00106\u001a\u00020$H\u0016J\u000e\u00107\u001a\u00020$2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u00108\u001a\u00020$2\u0006\u0010-\u001a\u00020.J\u000e\u00109\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u000fR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006;"}, d2={"Lcom/jetbrains/resharper/editors/TextEditingGateway;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener$Before;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "documentHost", "Lcom/jetbrains/resharper/document/DocumentHost;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/document/DocumentHost;Lcom/jetbrains/resharper/editors/TextControlHost;)V", "_gatewayState", "Lcom/jetbrains/rider/util/reactive/IProperty;", "Lcom/jetbrains/rider/model/GatewayState;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getDocumentHost", "()Lcom/jetbrains/resharper/document/DocumentHost;", "gatewayState", "Lcom/jetbrains/rider/util/reactive/IReadonlyProperty;", "getGatewayState", "()Lcom/jetbrains/rider/util/reactive/IReadonlyProperty;", "isInAfterFinishedCallback", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "pendingGateways", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/util/lifetime/LifetimeDefinition;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTextControlHost", "()Lcom/jetbrains/resharper/editors/TextControlHost;", "beforeFileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "beforeFileOpened", "clearHistory", "closeToBackend", "lifetime", "reason", "", "closeToBackendInternal", "doAfterSyncFinished", "action", "Lkotlin/Function0;", "forceOpenGateToBackend", "forceOpenToBackendInternal", "openGateToBackendInternal", "projectClosed", "syncFromBackend", "tryOpenGateToBackend", "trySyncFromBackend", "Companion", "rider"})
public final class TextEditingGateway
extends AbstractProjectComponent
implements FileEditorManagerListener.Before,
ILifetimedComponent {
    private final IProperty<GatewayState> _gatewayState;
    private final Logger logger;
    private boolean isInAfterFinishedCallback;
    private final ArrayList<LifetimeDefinition> pendingGateways;
    @NotNull
    private final Project project;
    @NotNull
    private final DocumentHost documentHost;
    @NotNull
    private final TextControlHost textControlHost;
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final IReadonlyProperty<GatewayState> getGatewayState() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        return this._gatewayState;
    }

    public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
    }

    public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (Intrinsics.areEqual((Object)source.getProject(), (Object)this.project) && Intrinsics.areEqual((Object)((Object)this._gatewayState.getValue()), (Object)((Object)GatewayState.ClosedToBackend))) {
            this.forceOpenToBackendInternal("Editor is about to be closed");
        }
    }

    public final boolean trySyncFromBackend(@NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        if (TextEditingGatewayKt.getIsSyncFromBackend(this)) {
            return false;
        }
        this.syncFromBackend(lifetime);
        return true;
    }

    public final void syncFromBackend(@NotNull Lifetime lifetime) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        boolean bl2 = bl = !TextEditingGatewayKt.getIsSyncFromBackend(this);
        if (!bl) {
            String string2 = "Nested syncFromBackend session is forbidden. You should use trySyncFromBackend instead of syncFromBackend.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean bl3 = bl = !this.isInAfterFinishedCallback;
        if (!bl) {
            String string3 = "Cannot use this api while executing afterFinished callback. Try to use 'syncFromBackendWithoutGateway'";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.logger.trace("Begin syncing from backend...");
        this.tryOpenGateToBackend("Release all frontend changes before syncing the backend");
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TextEditingGateway this$0;

            public final void invoke() {
                TextEditingGateway.access$get_gatewayState$p(this.this$0).setValue(GatewayState.BothSides);
                TextEditingGateway.access$getLogger$p(this.this$0).trace("Syncing from backend has finished.");
            }
            {
                this.this$0 = textEditingGateway;
                super(0);
            }
        }));
        this._gatewayState.setValue(GatewayState.SyncFromBackend);
        this.textControlHost.syncFromBackend(lifetime);
    }

    public final void doAfterSyncFinished(@NotNull Lifetime lifetime, @NotNull Function0<Unit> action2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        boolean bl = Intrinsics.areEqual((Object)((Object)this._gatewayState.getValue()), (Object)((Object)GatewayState.SyncFromBackend));
        if (!bl) {
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        LifetimeDefinition definition = Lifetime.Companion.create(lifetime);
        this._gatewayState.advise(definition.getLifetime(), (Function1<GatewayState, Unit>)((Function1)new Function1<GatewayState, Unit>(this, definition, action2){
            final /* synthetic */ TextEditingGateway this$0;
            final /* synthetic */ LifetimeDefinition $definition;
            final /* synthetic */ Function0 $action;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull GatewayState changedState) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)changedState), (String)"changedState");
                if (Intrinsics.areEqual((Object)((Object)changedState), (Object)((Object)GatewayState.SyncFromBackend)) ^ true) {
                    this.$definition.terminate();
                    try {
                        TextEditingGateway.access$isInAfterFinishedCallback$p(this.this$0);
                        this.$action.invoke();
                    }
                    finally {
                        TextEditingGateway.access$setInAfterFinishedCallback$p(this.this$0, false);
                    }
                }
            }
            {
                this.this$0 = textEditingGateway;
                this.$definition = lifetimeDefinition;
                this.$action = function0;
                super(1);
            }
        }));
    }

    public final void closeToBackend(@NotNull Lifetime lifetime, @NotNull String reason) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        ApplicationKt.getApplication().assertIsDispatchThread();
        boolean bl2 = Intrinsics.areEqual((Object)((Object)this._gatewayState.getValue()), (Object)((Object)GatewayState.SyncFromBackend)) ^ true;
        if (!bl2) {
            String string2 = "cannot hold up frontend while syncing backend";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Collection collection = this.pendingGateways;
        boolean bl3 = bl = collection.size() >= 0;
        if (!bl) {
            String string3 = "aliveGateways number cannot be negative";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        this.closeToBackendInternal(lifetime, reason);
    }

    private final void closeToBackendInternal(Lifetime lifetime, String reason) {
        boolean bl;
        ApplicationKt.getApplication().assertIsDispatchThread();
        boolean bl2 = bl = !this.isInAfterFinishedCallback;
        if (!bl) {
            String string2 = "Cannot use this api while executing afterFinished callback. Try to use 'syncFromBackendWithoutGateway'";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean bl3 = bl = !lifetime.isTerminated();
        if (!bl) {
            String string3 = "TextEditingGateway: lifetime is already terminated";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        Collection collection = this.pendingGateways;
        if (collection.size() == 0) {
            Logger $receiver$iv = this.logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string4 = "Closing the gateway to backend... Reason: |" + reason + "|";
                logger.trace(string4);
            }
            this._gatewayState.setValue(GatewayState.ClosedToBackend);
            this.documentHost.holdUpState$rider(true);
            this.textControlHost.holdUpFrontendState(true);
        }
        LifetimeDefinition gatewayLifetime = Lifetime.Companion.create(lifetime);
        this.pendingGateways.add(gatewayLifetime);
        gatewayLifetime.getLifetime().add((Function0<Unit>)((Function0)new Function0<Unit>(this, gatewayLifetime, reason){
            final /* synthetic */ TextEditingGateway this$0;
            final /* synthetic */ LifetimeDefinition $gatewayLifetime;
            final /* synthetic */ String $reason;

            public final void invoke() {
                Collection collection = TextEditingGateway.access$getPendingGateways$p(this.this$0);
                if (collection.size() == 0) {
                    return;
                }
                TextEditingGateway.access$getPendingGateways$p(this.this$0).remove(this.$gatewayLifetime);
                collection = TextEditingGateway.access$getPendingGateways$p(this.this$0);
                if (collection.size() > 0) {
                    return;
                }
                TextEditingGateway.access$getLogger$p(this.this$0).trace("Opening the gateway to backend due to lifetime termination...");
                TextEditingGateway.access$forceOpenToBackendInternal(this.this$0, "Lifetime of |" + this.$reason + "| was terminated");
            }
            {
                this.this$0 = textEditingGateway;
                this.$gatewayLifetime = lifetimeDefinition;
                this.$reason = string2;
                super(0);
            }
        }));
    }

    public void projectClosed() {
        this.forceOpenToBackendInternal("project is being closed");
    }

    public final void forceOpenGateToBackend(@NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        boolean bl = Intrinsics.areEqual((Object)((Object)this._gatewayState.getValue()), (Object)((Object)GatewayState.SyncFromBackend)) ^ true;
        if (!bl) {
            String string2 = "Cannot open the changes to backend while syncing from ti";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.forceOpenToBackendInternal(reason);
    }

    public final void tryOpenGateToBackend(@NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        if (Intrinsics.areEqual((Object)((Object)this._gatewayState.getValue()), (Object)((Object)GatewayState.ClosedToBackend))) {
            this.forceOpenToBackendInternal(reason);
        }
    }

    private final void forceOpenToBackendInternal(String reason) {
        Logger $receiver$iv = this.logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "tryOpenGateToBackend. Reason: " + reason + ". Is UI thread: " + ApplicationKt.getApplication().isDispatchThread();
            logger.trace(string2);
        }
        if (ApplicationKt.getApplication().isDispatchThread()) {
            this.openGateToBackendInternal(reason);
        } else {
            ApplicationKt.getApplication().invokeLater(new Runnable(this, reason){
                final /* synthetic */ TextEditingGateway this$0;
                final /* synthetic */ String $reason;

                public final void run() {
                    TextEditingGateway.access$openGateToBackendInternal(this.this$0, this.$reason);
                }
                {
                    this.this$0 = textEditingGateway;
                    this.$reason = string2;
                }
            });
        }
    }

    private final void openGateToBackendInternal(String reason) {
        boolean bl;
        ApplicationKt.getApplication().assertIsDispatchThread();
        boolean bl2 = bl = !this.isInAfterFinishedCallback;
        if (!bl) {
            String string2 = "Cannot use this api while executing afterFinished callback. Try to use 'syncFromBackendWithoutGateway'";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.documentHost.holdUpState$rider(false);
        this.textControlHost.holdUpFrontendState(false);
        this._gatewayState.setValue(GatewayState.BothSides);
        this.clearHistory();
        Logger $receiver$iv = this.logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string3 = "Finished opening gateway to backend cause of |" + reason + "|";
            logger.trace(string3);
        }
    }

    private final void clearHistory() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        ArrayList defsToTerminate = new ArrayList(this.pendingGateways);
        this.pendingGateways.clear();
        for (LifetimeDefinition def : defsToTerminate) {
            def.terminate();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DocumentHost getDocumentHost() {
        return this.documentHost;
    }

    @NotNull
    public final TextControlHost getTextControlHost() {
        return this.textControlHost;
    }

    public TextEditingGateway(@NotNull Project project2, @NotNull DocumentHost documentHost, @NotNull TextControlHost textControlHost) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)documentHost, (String)"documentHost");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.documentHost = documentHost;
        this.textControlHost = textControlHost;
        TextEditingGateway textEditingGateway = this;
        Logger logger = Logger.getInstance(TextEditingGateway.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        textEditingGateway.logger = object = logger;
        RdTextEditingGateway gatewayModel = SolutionHostExtensionsKt.getSolution(this.project).getTextEditingGateway();
        IProperty<GatewayState> iProperty = gatewayModel.getGatewayState();
        textEditingGateway = this;
        IProperty<GatewayState> $receiver = iProperty;
        $receiver.setValue(GatewayState.BothSides);
        object = iProperty;
        textEditingGateway._gatewayState = (IProperty)object;
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)this.project).subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)this);
        textEditingGateway = this;
        textEditingGateway.pendingGateways = object = new ArrayList();
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @NotNull
    public static final /* synthetic */ IProperty access$get_gatewayState$p(TextEditingGateway $this) {
        return $this._gatewayState;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(TextEditingGateway $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$isInAfterFinishedCallback$p(TextEditingGateway $this) {
        return $this.isInAfterFinishedCallback;
    }

    public static final /* synthetic */ void access$setInAfterFinishedCallback$p(TextEditingGateway $this, boolean bl) {
        $this.isInAfterFinishedCallback = bl;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getPendingGateways$p(TextEditingGateway $this) {
        return $this.pendingGateways;
    }

    public static final /* synthetic */ void access$forceOpenToBackendInternal(TextEditingGateway $this, @NotNull String reason) {
        $this.forceOpenToBackendInternal(reason);
    }

    public static final /* synthetic */ void access$openGateToBackendInternal(TextEditingGateway $this, @NotNull String reason) {
        $this.openGateToBackendInternal(reason);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/editors/TextEditingGateway$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/resharper/editors/TextEditingGateway;", "project", "Lcom/intellij/openapi/project/Project;", "rider"})
    public static final class Companion {
        @NotNull
        public final TextEditingGateway getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            ComponentManager $receiver$iv = (ComponentManager)project2;
            Object object = $receiver$iv.getComponent(TextEditingGateway.class);
            if (object == null) {
                throw (Throwable)new IllegalStateException("Component " + TextEditingGateway.class + " not found in container " + $receiver$iv);
            }
            return (TextEditingGateway)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

