/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.hyperlinks;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.resharper.actions.RiderActionsSupport;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.hyperlinks.BrowsingData;
import com.jetbrains.resharper.hyperlinks.RiderCtrlClickHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.resharper.util.idea.RangeUtilKt;
import com.jetbrains.rider.framework.base.IPrintable;
import com.jetbrains.rider.framework.impl.IRdCall;
import com.jetbrains.rider.framework.impl.IRdTask;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.HyperlinkHighlightingArgs;
import com.jetbrains.rider.model.HyperlinkHighlightingResult;
import com.jetbrains.rider.model.RdPsiElementRangeProvider;
import com.jetbrains.rider.model.RdTextRange;
import com.jetbrains.rider.model.RiderBrowseMode;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.Property;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0002\u0016\u0019\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\u0018\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u000207H\u0002J\u0010\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u0002002\u0006\u0010+\u001a\u00020,2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010>\u001a\u0002002\u0006\u00109\u001a\u000207H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/jetbrains/resharper/hyperlinks/RiderCtrlClickHost;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "editorColorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/colors/EditorColorsManager;Lcom/intellij/openapi/editor/EditorFactory;)V", "browsingSession", "Lcom/jetbrains/rider/util/reactive/Property;", "Lcom/jetbrains/resharper/hyperlinks/BrowsingData;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "currentBrowseMode", "Lcom/jetbrains/rider/model/RiderBrowseMode;", "getEditorColorsManager", "()Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "editorKeyListener", "com/jetbrains/resharper/hyperlinks/RiderCtrlClickHost$editorKeyListener$1", "Lcom/jetbrains/resharper/hyperlinks/RiderCtrlClickHost$editorKeyListener$1;", "editorMouseAdapter", "com/jetbrains/resharper/hyperlinks/RiderCtrlClickHost$editorMouseAdapter$1", "Lcom/jetbrains/resharper/hyperlinks/RiderCtrlClickHost$editorMouseAdapter$1;", "hyperlinkAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getHyperlinkAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rdCtrlClickModel", "Lcom/jetbrains/rider/model/RdPsiElementRangeProvider;", "requested", "", "sequentialLifetimes", "Lcom/jetbrains/rider/util/lifetime/SequentialLifetimes;", "visibleAreaListener", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "addHyperlink", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/util/TextRange;", "dropBrowsingSession", "", "dropHyperlinkRequest", "enterBrowseMode", "lifetime", "data", "insideCurrentHyperlink", "offset", "", "modifiersToBrowseMode", "modifiers", "mouseMoved", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "requestHyperlink", "updateBrowsingMode", "Companion", "rider"})
public final class RiderCtrlClickHost
extends EditorMouseMotionAdapter
implements ILifetimedComponent {
    private final SequentialLifetimes sequentialLifetimes;
    private final RdPsiElementRangeProvider rdCtrlClickModel;
    private final Property<BrowsingData> browsingSession;
    private final Property<RiderBrowseMode> currentBrowseMode;
    private boolean requested;
    private final VisibleAreaListener visibleAreaListener;
    private final editorMouseAdapter.1 editorMouseAdapter;
    private final editorKeyListener.1 editorKeyListener;
    @NotNull
    private final Project project;
    @NotNull
    private final EditorColorsManager editorColorsManager;
    private static final Logger logger;
    private static final Cursor hand;
    private static final BrowsingData EMPTY_DATA;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    public void mouseMoved(@NotNull EditorMouseEvent e2) {
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        if (e2.isConsumed() || !this.project.isInitialized() || this.project.isDisposed()) {
            return;
        }
        IReadonlyProperty<Boolean> loaded = SolutionHostExtensionsKt.getSolution(this.project).isLoaded();
        if (PropertyExKt.getHasValue(loaded) && !loaded.getValue().booleanValue()) {
            return;
        }
        MouseEvent mouseEvent = e2.getMouseEvent();
        Editor editor = e2.getEditor();
        this.updateBrowsingMode(mouseEvent.getModifiers());
        if (Intrinsics.areEqual((Object)((Object)this.currentBrowseMode.getValue()), (Object)((Object)RiderBrowseMode.None)) || e2.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        LogicalPosition pos = editor.xyToLogicalPosition(mouseEvent.getPoint());
        if (EditorUtil.inVirtualSpace(editor, pos)) {
            this.dropBrowsingSession();
            return;
        }
        int offset = editor.logicalPositionToOffset(pos);
        Editor editor2 = editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        if (!RiderActionsSupport.Companion.backendActionsSupportedByLanguage(editor2, "CtrlClick", offset)) {
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selStart = selectionModel.getSelectionStart();
        int selEnd = selectionModel.getSelectionEnd();
        int n2 = offset;
        if (selStart <= n2 && n2 <= selEnd - 1) {
            this.dropBrowsingSession();
            return;
        }
        if (this.insideCurrentHyperlink(offset)) {
            editor.getContentComponent().setCursor(RiderCtrlClickHost.Companion.getHand());
            return;
        }
        if (!this.browsingSession.getValue().getRange().isEmpty()) {
            this.dropBrowsingSession();
            return;
        }
        Editor editor3 = editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor");
        this.requestHyperlink(editor3, offset);
    }

    private final void requestHyperlink(Editor editor, int offset) {
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId == null) {
            Intrinsics.throwNpe();
        }
        TextControlId id = textControlId;
        Logger $receiver$iv = RiderCtrlClickHost.Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "send hyperlink request for " + offset;
            logger.trace(string2);
        }
        HyperlinkHighlightingArgs args = new HyperlinkHighlightingArgs(id, offset, this.currentBrowseMode.getValue());
        if (this.requested) {
            return;
        }
        IRdTask result2 = IRdCall.DefaultImpls.start$default(this.rdCtrlClickModel.getGetElementRange(), args, null, 2, null);
        this.requested = true;
        result2.getResult().advise(this.sequentialLifetimes.next(), (Function1)new Function1<RdTaskResult<? extends HyperlinkHighlightingResult>, Unit>(this, editor){
            final /* synthetic */ RiderCtrlClickHost this$0;
            final /* synthetic */ Editor $editor;

            public final void invoke(@NotNull RdTaskResult<HyperlinkHighlightingResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RiderCtrlClickHost.access$setRequested$p(this.this$0, false);
                IPrintable iPrintable = it.unwrap();
                if (iPrintable == null || (iPrintable = iPrintable.getTextRange()) == null || (iPrintable = RangeUtilKt.toIdeaRange((RdTextRange)iPrintable)) == null) {
                    return;
                }
                IPrintable range = iPrintable;
                if (range.isEmpty()) {
                    return;
                }
                com.jetbrains.resharper.hyperlinks.RiderCtrlClickHost$Companion.access$getLogger$p(RiderCtrlClickHost.Companion).debug("got hyperlink for range " + range);
                RiderCtrlClickHost.access$getBrowsingSession$p(this.this$0).setValue(new BrowsingData(this.$editor, (TextRange)range));
            }
            {
                this.this$0 = riderCtrlClickHost;
                this.$editor = editor;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void enterBrowseMode(Lifetime lifetime, BrowsingData data) {
        void range;
        void editor;
        BrowsingData browsingData = data;
        Editor editor2 = browsingData.component1();
        TextRange textRange = browsingData.component2();
        browsingData = null;
        if (editor == null) {
            return;
        }
        if (range.isEmpty()) {
            return;
        }
        RangeHighlighter hyperlink = this.addHyperlink((Editor)editor, (TextRange)range);
        JComponent contentComponent = editor.getContentComponent();
        Cursor cursor = contentComponent.getCursor();
        editor.getContentComponent().setCursor(RiderCtrlClickHost.Companion.getHand());
        contentComponent.addKeyListener(this.editorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.visibleAreaListener);
        LifetimeExKt.plusAssign(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(this, (Editor)editor, contentComponent, cursor, hyperlink){
            final /* synthetic */ RiderCtrlClickHost this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ JComponent $contentComponent;
            final /* synthetic */ Cursor $cursor;
            final /* synthetic */ RangeHighlighter $hyperlink;

            public final void invoke() {
                this.$editor.getScrollingModel().removeVisibleAreaListener(RiderCtrlClickHost.access$getVisibleAreaListener$p(this.this$0));
                this.$contentComponent.removeKeyListener(RiderCtrlClickHost.access$getEditorKeyListener$p(this.this$0));
                this.$contentComponent.setCursor(this.$cursor);
                this.$editor.getMarkupModel().removeHighlighter(this.$hyperlink);
                HintManager.getInstance().hideAllHints();
            }
            {
                this.this$0 = riderCtrlClickHost;
                this.$editor = editor;
                this.$contentComponent = jComponent;
                this.$cursor = cursor;
                this.$hyperlink = rangeHighlighter;
                super(0);
            }
        }));
    }

    private final TextAttributes getHyperlinkAttributes() {
        TextAttributes textAttributes = this.editorColorsManager.getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"editorColorsManager.glob\u2026EFERENCE_HYPERLINK_COLOR)");
        return textAttributes;
    }

    private final RangeHighlighter addHyperlink(Editor editor, TextRange range) {
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 6001, this.getHyperlinkAttributes(), HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter, (String)"editor.markupModel.addRa\u2026erTargetArea.EXACT_RANGE)");
        return rangeHighlighter;
    }

    private final boolean insideCurrentHyperlink(int offset) {
        TextRange range = this.browsingSession.getValue().getRange();
        return range.getStartOffset() <= offset && offset <= range.getEndOffset();
    }

    private final void dropBrowsingSession() {
        this.browsingSession.setValue(RiderCtrlClickHost.Companion.getEMPTY_DATA());
    }

    private final void dropHyperlinkRequest() {
        this.sequentialLifetimes.next();
        this.requested = false;
    }

    private final void updateBrowsingMode(int modifiers) {
        this.currentBrowseMode.setValue(this.modifiersToBrowseMode(modifiers));
    }

    private final RiderBrowseMode modifiersToBrowseMode(int modifiers) {
        if (modifiers == 0) {
            return RiderBrowseMode.None;
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoDeclaration")) {
            return RiderBrowseMode.Declaration;
        }
        if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoTypeDeclaration")) {
            return RiderBrowseMode.TypeDeclaration;
        }
        if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoImplementation")) {
            return RiderBrowseMode.Implementation;
        }
        return RiderBrowseMode.None;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final EditorColorsManager getEditorColorsManager() {
        return this.editorColorsManager;
    }

    public RiderCtrlClickHost(@NotNull Project project2, @NotNull EditorColorsManager editorColorsManager, @NotNull EditorFactory editorFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editorColorsManager, (String)"editorColorsManager");
        Intrinsics.checkParameterIsNotNull((Object)editorFactory, (String)"editorFactory");
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.editorColorsManager = editorColorsManager;
        this.sequentialLifetimes = new SequentialLifetimes(this.getComponentLifetime());
        this.rdCtrlClickModel = SolutionHostExtensionsKt.getSolution(this.project).getPsiElementRangeProvider();
        this.browsingSession = new Property<BrowsingData>(RiderCtrlClickHost.Companion.getEMPTY_DATA());
        this.currentBrowseMode = new Property<RiderBrowseMode>(RiderBrowseMode.None);
        this.visibleAreaListener = new VisibleAreaListener(this){
            final /* synthetic */ RiderCtrlClickHost this$0;

            public final void visibleAreaChanged(VisibleAreaEvent it) {
                RiderCtrlClickHost.access$dropBrowsingSession(this.this$0);
            }
            {
                this.this$0 = riderCtrlClickHost;
            }
        };
        this.editorMouseAdapter = new EditorMouseAdapter(this){
            final /* synthetic */ RiderCtrlClickHost this$0;

            public void mouseReleased(@NotNull EditorMouseEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                RiderCtrlClickHost.access$dropBrowsingSession(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.editorKeyListener = new KeyAdapter(this){
            final /* synthetic */ RiderCtrlClickHost this$0;

            public void keyPressed(@NotNull KeyEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                RiderCtrlClickHost.access$updateBrowsingMode(this.this$0, e2.getModifiers());
            }

            public void keyReleased(@NotNull KeyEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                RiderCtrlClickHost.access$updateBrowsingMode(this.this$0, e2.getModifiers());
            }
            {
                this.this$0 = $outer;
            }
        };
        ApplicationKt.getApplication().assertIsDispatchThread();
        EditorEventMulticaster eventMulticaster = editorFactory.getEventMulticaster();
        eventMulticaster.addEditorMouseListener((EditorMouseListener)this.editorMouseAdapter, (Disposable)this.project);
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.project);
        this.browsingSession.view(this.getComponentLifetime(), (Function2<Lifetime, BrowsingData, Unit>)((Function2)new Function2<Lifetime, BrowsingData, Unit>(){

            public final void invoke(@NotNull Lifetime lf, @NotNull BrowsingData data) {
                Intrinsics.checkParameterIsNotNull((Object)lf, (String)"lf");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                this.enterBrowseMode(lf, data);
            }
        }));
        this.currentBrowseMode.advise(this.getComponentLifetime(), (Function1<RiderBrowseMode, Unit>)((Function1)new Function1<RiderBrowseMode, Unit>(){

            public final void invoke(@NotNull RiderBrowseMode it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                this.dropHyperlinkRequest();
                this.dropBrowsingSession();
            }
        }));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderCtrlClickHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderCtrlClickHost.logger = logger;
        hand = Cursor.getPredefinedCursor(12);
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.EMPTY_RANGE");
        EMPTY_DATA = new BrowsingData(null, textRange);
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public static final /* synthetic */ boolean access$getRequested$p(RiderCtrlClickHost $this) {
        return $this.requested;
    }

    public static final /* synthetic */ void access$setRequested$p(RiderCtrlClickHost $this, boolean bl) {
        $this.requested = bl;
    }

    @NotNull
    public static final /* synthetic */ Property access$getBrowsingSession$p(RiderCtrlClickHost $this) {
        return $this.browsingSession;
    }

    @NotNull
    public static final /* synthetic */ VisibleAreaListener access$getVisibleAreaListener$p(RiderCtrlClickHost $this) {
        return $this.visibleAreaListener;
    }

    @NotNull
    public static final /* synthetic */ editorKeyListener.1 access$getEditorKeyListener$p(RiderCtrlClickHost $this) {
        return $this.editorKeyListener;
    }

    public static final /* synthetic */ void access$updateBrowsingMode(RiderCtrlClickHost $this, int modifiers) {
        $this.updateBrowsingMode(modifiers);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/hyperlinks/RiderCtrlClickHost$Companion;", "", "()V", "EMPTY_DATA", "Lcom/jetbrains/resharper/hyperlinks/BrowsingData;", "getEMPTY_DATA", "()Lcom/jetbrains/resharper/hyperlinks/BrowsingData;", "hand", "Ljava/awt/Cursor;", "kotlin.jvm.PlatformType", "getHand", "()Ljava/awt/Cursor;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private final Cursor getHand() {
            return hand;
        }

        private final BrowsingData getEMPTY_DATA() {
            return EMPTY_DATA;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

