/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.icons;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.Function;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.resharper.icons.ColorIconWrapper;
import com.jetbrains.resharper.icons.CompositionIconWrapper;
import com.jetbrains.resharper.icons.IconHost$WhenMappings;
import com.jetbrains.resharper.icons.IconWrapper;
import com.jetbrains.resharper.icons.PngIconWrapper;
import com.jetbrains.resharper.icons.RiderIconDeferrer;
import com.jetbrains.resharper.icons.RotatedIconWrapper;
import com.jetbrains.resharper.icons.ShellIconWrapper;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.IconNode;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J%\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/jetbrains/resharper/icons/IconHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "iconDeferrer", "Lcom/jetbrains/resharper/icons/RiderIconDeferrer;", "pngIconCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Ljavax/swing/Icon;", "getPngIconCache$rider", "()Ljava/util/concurrent/ConcurrentHashMap;", "createWrapper", "Lcom/jetbrains/resharper/icons/IconWrapper;", "iconNode", "Lcom/jetbrains/rider/model/IconNode;", "deferIconIfNotOnDispatchThread", "ideaCacheKey", "", "evaluator", "Lkotlin/Function0;", "deferIconIfNotOnDispatchThread$rider", "getIconString", "", "id", "toIdeaIcon", "iconId", "Lcom/jetbrains/rider/model/Icon;", "rider"})
public final class IconHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final RiderIconDeferrer iconDeferrer;
    @NotNull
    private final ConcurrentHashMap<Pair<Integer, Integer>, Icon> pngIconCache;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final Icon deferIconIfNotOnDispatchThread$rider(@Nullable Object ideaCacheKey, @NotNull Function0<? extends Icon> evaluator2) {
        Intrinsics.checkParameterIsNotNull(evaluator2, (String)"evaluator");
        if (ApplicationKt.getApplication().isDispatchThread()) {
            return (Icon)evaluator2.invoke();
        }
        Icon icon = this.iconDeferrer.defer(EmptyIcon.ICON_16, ideaCacheKey, (Function)new Function<Object, Icon>(evaluator2){
            final /* synthetic */ Function0 $evaluator;

            @NotNull
            public final Icon fun(@Nullable Object it) {
                return (Icon)this.$evaluator.invoke();
            }
            {
                this.$evaluator = function0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"iconDeferrer.defer(Empty\u2026acheKey, { evaluator() })");
        return icon;
    }

    @NotNull
    public final ConcurrentHashMap<Pair<Integer, Integer>, Icon> getPngIconCache$rider() {
        return this.pngIconCache;
    }

    @NotNull
    public final String getIconString(int id) {
        String string2 = (String)SolutionHostExtensionsKt.getSolution(this.myProject).getIconStrings().get(id);
        if (string2 == null) {
            throw (Throwable)new InvalidDataException("Icon String with id=" + id + " is not found");
        }
        return string2;
    }

    @NotNull
    public final IconWrapper createWrapper(@NotNull IconNode iconNode) {
        IconWrapper iconWrapper;
        Intrinsics.checkParameterIsNotNull((Object)iconNode, (String)"iconNode");
        switch (IconHost$WhenMappings.$EnumSwitchMapping$0[iconNode.getType().ordinal()]) {
            case 1: {
                iconWrapper = new CompositionIconWrapper();
                break;
            }
            case 2: {
                iconWrapper = new PngIconWrapper(iconNode, this);
                break;
            }
            case 3: {
                iconWrapper = new ShellIconWrapper(iconNode, this);
                break;
            }
            case 4: {
                iconWrapper = new RotatedIconWrapper();
                break;
            }
            case 5: {
                iconWrapper = new ColorIconWrapper(iconNode);
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("Unsupported node type! " + iconNode);
            }
        }
        return iconWrapper;
    }

    @NotNull
    public final Icon toIdeaIcon(@NotNull com.jetbrains.rider.model.Icon iconId) {
        Intrinsics.checkParameterIsNotNull((Object)iconId, (String)"iconId");
        IconWrapper root = null;
        Map parentsMap = new HashMap();
        for (IconNode iconNode : iconId.getIconNodes()) {
            boolean bl;
            IconWrapper iconWrapper = this.createWrapper(iconNode);
            if (root == null) {
                root = iconWrapper;
            }
            Map map2 = parentsMap;
            Integer n2 = iconNode.getNodeId();
            IconWrapper iconWrapper2 = iconWrapper;
            map2.put(n2, iconWrapper2);
            Integer parentNodeId = iconNode.getParentNodeId();
            if (parentNodeId == null) continue;
            IconWrapper parent = (IconWrapper)parentsMap.get(parentNodeId);
            if (parent == null) {
                String string2 = "cannot find parent by id " + parentNodeId;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            IconWrapper iconWrapper3 = parent;
            if (iconWrapper3 == null) {
                Intrinsics.throwNpe();
            }
            if (!(bl = Intrinsics.areEqual((Object)iconWrapper3, (Object)iconWrapper) ^ true)) {
                String string3 = "parent == self";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            parent.getChildren$rider().add(iconWrapper);
        }
        if (root == null) {
            String string4 = "Could not initialize root from model icon " + iconId;
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        IconWrapper iconWrapper = root;
        if (iconWrapper == null) {
            Intrinsics.throwNpe();
        }
        return iconWrapper.Construct();
    }

    public IconHost(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.iconDeferrer = new RiderIconDeferrer();
        this.pngIconCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }
}

