/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.icons;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.jetbrains.resharper.icons.IconWrapper;
import com.jetbrains.resharper.icons.RotatedIconWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/resharper/icons/RotatedIconWrapper;", "Lcom/jetbrains/resharper/icons/IconWrapper;", "()V", "Construct", "Ljavax/swing/Icon;", "RotatedIcon", "rider"})
public final class RotatedIconWrapper
extends IconWrapper {
    @Override
    @NotNull
    public Icon Construct() {
        IconWrapper staticIconWrapper = (IconWrapper)CollectionsKt.firstOrNull((List)this.getChildren$rider());
        if (staticIconWrapper == null) {
            String string2 = "There is no static icon for rotated icon";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        IconWrapper iconWrapper = staticIconWrapper;
        if (iconWrapper == null) {
            Intrinsics.throwNpe();
        }
        Icon staticIcon = iconWrapper.Construct();
        return new RotatedIcon(staticIcon, 0, 2, null);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon;", "Ljavax/swing/Icon;", "staticIcon", "speedFactor", "", "(Ljavax/swing/Icon;I)V", "getSpeedFactor", "()I", "getStaticIcon", "()Ljavax/swing/Icon;", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "requestRepaint", "Companion", "RepaintRequest", "RepaintScheduler", "rider"})
    public static final class RotatedIcon
    implements Icon {
        @NotNull
        private final Icon staticIcon;
        private final int speedFactor;
        private static final RepaintScheduler ourRepaintScheduler;
        private static final ExecutorService ourIconsCalculatingExecutor;
        private static final TransferToEDTQueue<Runnable> ourLaterInvocator;
        public static final Companion Companion;

        @Override
        public void paintIcon(@NotNull Component c2, @NotNull Graphics g2, int x2, int y2) {
            Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)g2, (String)"g");
            long time = System.nanoTime() / (long)1000 / (long)1000 / (long)this.speedFactor;
            double angle = Math.toRadians(time % (long)360);
            RotatedIcon.Companion.paintRotatedIcon(this.staticIcon, c2, g2, x2, y2, angle);
            this.requestRepaint(c2, x2, y2);
        }

        private final void requestRepaint(Component c2, int x2, int y2) {
            Rectangle rectangle;
            Component target = RotatedIcon.Companion.getTarget(c2);
            Container paintingParent = SwingUtilities.getAncestorOfClass(PaintingParent.class, c2);
            if (paintingParent == null) {
                rectangle = null;
            } else {
                Container container = paintingParent;
                if (container == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.PaintingParent");
                }
                rectangle = ((PaintingParent)container).getChildRec(c2);
            }
            Rectangle paintingParentRec = rectangle;
            RotatedIcon.Companion.getOurIconsCalculatingExecutor().execute(new Runnable(this, target, paintingParent, c2, x2, y2, paintingParentRec){
                final /* synthetic */ RotatedIcon this$0;
                final /* synthetic */ Component $target;
                final /* synthetic */ Container $paintingParent;
                final /* synthetic */ Component $c;
                final /* synthetic */ int $x;
                final /* synthetic */ int $y;
                final /* synthetic */ Rectangle $paintingParentRec;

                public final void run() {
                    Companion.access$getOurLaterInvocator$p(RotatedIcon.Companion).offer((Object)new Runnable(this){
                        final /* synthetic */ requestRepaint.1 this$0;

                        public final void run() {
                            Component actualTarget = this.this$0.$target;
                            if (actualTarget != null && SwingUtilities.getWindowAncestor(actualTarget) == null && ((actualTarget = (Component)this.this$0.$paintingParent) == null || SwingUtilities.getWindowAncestor(actualTarget) == null)) {
                                actualTarget = null;
                            }
                            if (actualTarget == null) {
                                return;
                            }
                            if (this.this$0.$c == actualTarget) {
                                this.this$0.$c.repaint(this.this$0.$x, this.this$0.$y, this.this$0.this$0.getIconWidth(), this.this$0.this$0.getIconHeight());
                            } else {
                                Companion.access$getOurRepaintScheduler$p(RotatedIcon.Companion).pushDirtyComponent$rider(actualTarget, this.this$0.$paintingParentRec);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = rotatedIcon;
                    this.$target = component;
                    this.$paintingParent = container;
                    this.$c = component2;
                    this.$x = n2;
                    this.$y = n3;
                    this.$paintingParentRec = rectangle;
                }
            });
        }

        @Override
        public int getIconWidth() {
            return this.staticIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.staticIcon.getIconHeight();
        }

        @NotNull
        public final Icon getStaticIcon() {
            return this.staticIcon;
        }

        public final int getSpeedFactor() {
            return this.speedFactor;
        }

        public RotatedIcon(@NotNull Icon staticIcon, int speedFactor) {
            Intrinsics.checkParameterIsNotNull((Object)staticIcon, (String)"staticIcon");
            this.staticIcon = staticIcon;
            this.speedFactor = speedFactor;
        }

        public /* synthetic */ RotatedIcon(Icon icon, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n2 = 5;
            }
            this(icon, n2);
        }

        static {
            Companion = new Companion(null);
            ourRepaintScheduler = new RepaintScheduler();
            ourIconsCalculatingExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IconsCalculatingExecutor", (int)1);
            ourLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"Rotated icon later invocator", (int)200);
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon$RepaintScheduler;", "", "()V", "myAlarm", "Lcom/intellij/util/Alarm;", "myQueue", "Ljava/util/LinkedHashSet;", "Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon$RepaintRequest;", "pushDirtyComponent", "", "c", "Ljava/awt/Component;", "rec", "Ljava/awt/Rectangle;", "pushDirtyComponent$rider", "rider"})
        private static final class RepaintScheduler {
            private final Alarm myAlarm = new Alarm();
            private final LinkedHashSet<RepaintRequest> myQueue = new LinkedHashSet();

            public final void pushDirtyComponent$rider(@NotNull Component c2, @Nullable Rectangle rec) {
                Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(new Runnable(this){
                    final /* synthetic */ RepaintScheduler this$0;

                    public final void run() {
                        for (RepaintRequest request2 : RepaintScheduler.access$getMyQueue$p(this.this$0)) {
                            Rectangle r2 = request2.getRectangle();
                            if (r2 == null) {
                                request2.getComponent().repaint();
                                continue;
                            }
                            request2.getComponent().repaint(r2.x, r2.y, r2.width, r2.height);
                        }
                        RepaintScheduler.access$getMyQueue$p(this.this$0).clear();
                    }
                    {
                        this.this$0 = repaintScheduler;
                    }
                }, 50);
                this.myQueue.add(new RepaintRequest(c2, rec));
            }

            @NotNull
            public static final /* synthetic */ LinkedHashSet access$getMyQueue$p(RepaintScheduler $this) {
                return $this.myQueue;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon$RepaintRequest;", "", "component", "Ljava/awt/Component;", "rectangle", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ljava/awt/Rectangle;)V", "getComponent", "()Ljava/awt/Component;", "getRectangle", "()Ljava/awt/Rectangle;", "rider"})
        private static final class RepaintRequest {
            @NotNull
            private final Component component;
            @Nullable
            private final Rectangle rectangle;

            @NotNull
            public final Component getComponent() {
                return this.component;
            }

            @Nullable
            public final Rectangle getRectangle() {
                return this.rectangle;
            }

            public RepaintRequest(@NotNull Component component, @Nullable Rectangle rectangle) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                this.component = component;
                this.rectangle = rectangle;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J4\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R8\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon$Companion;", "", "()V", "ourIconsCalculatingExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getOurIconsCalculatingExecutor", "()Ljava/util/concurrent/ExecutorService;", "ourLaterInvocator", "Lcom/intellij/util/containers/TransferToEDTQueue;", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "getOurLaterInvocator", "()Lcom/intellij/util/containers/TransferToEDTQueue;", "ourRepaintScheduler", "Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon$RepaintScheduler;", "getOurRepaintScheduler", "()Lcom/jetbrains/resharper/icons/RotatedIconWrapper$RotatedIcon$RepaintScheduler;", "getTarget", "Ljava/awt/Component;", "c", "paintRotatedIcon", "", "Ljavax/swing/Icon;", "g", "Ljava/awt/Graphics;", "x", "", "y", "angle", "", "rider"})
        public static final class Companion {
            private final RepaintScheduler getOurRepaintScheduler() {
                return ourRepaintScheduler;
            }

            private final ExecutorService getOurIconsCalculatingExecutor() {
                return ourIconsCalculatingExecutor;
            }

            private final TransferToEDTQueue<Runnable> getOurLaterInvocator() {
                return ourLaterInvocator;
            }

            private final Component getTarget(Component c2) {
                Container list2 = SwingUtilities.getAncestorOfClass(JList.class, c2);
                if (list2 != null) {
                    return list2;
                }
                Container tree2 = SwingUtilities.getAncestorOfClass(JTree.class, c2);
                if (tree2 != null) {
                    return tree2;
                }
                Container table2 = SwingUtilities.getAncestorOfClass(JTable.class, c2);
                if (table2 != null) {
                    return table2;
                }
                Container box = SwingUtilities.getAncestorOfClass(JComboBox.class, c2);
                if (box != null) {
                    return box;
                }
                Container tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c2);
                if (tabLabel != null) {
                    return tabLabel;
                }
                return c2;
            }

            private final void paintRotatedIcon(@NotNull Icon $receiver, Component c2, Graphics g2, int x2, int y2, double angle) {
                double cx = (double)x2 + (double)$receiver.getIconWidth() / 2.0;
                double cy = (double)y2 + (double)$receiver.getIconHeight() / 2.0;
                Graphics graphics = g2.create();
                if (graphics == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D gg = (Graphics2D)graphics;
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gg.rotate(angle, cx, cy);
                $receiver.paintIcon(c2, gg, x2, y2);
                gg.dispose();
            }

            private Companion() {
            }

            public static final /* synthetic */ TransferToEDTQueue access$getOurLaterInvocator$p(Companion $this) {
                return $this.getOurLaterInvocator();
            }

            @NotNull
            public static final /* synthetic */ RepaintScheduler access$getOurRepaintScheduler$p(Companion $this) {
                return $this.getOurRepaintScheduler();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

