/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.find;

import com.intellij.find.FindModel;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.resharper.ideaInterop.find.scopes.RiderProjectScope;
import com.jetbrains.resharper.ideaInterop.find.scopes.RiderSolutionExplorerScope;
import com.jetbrains.resharper.ideaInterop.find.scopes.RiderSolutionScope;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeRider;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerViewPane;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/ideaInterop/find/RiderFindInProjectManager;", "Lcom/intellij/find/findInProject/FindInProjectManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "Lcom/intellij/psi/search/SearchScope;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "initModel", "", "findModel", "Lcom/intellij/find/FindModel;", "rider"})
public final class RiderFindInProjectManager
extends FindInProjectManager {
    @NotNull
    private final Project project;

    @Override
    protected void initModel(@NotNull FindModel findModel, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)findModel, (String)"findModel");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        super.initModel(findModel, dataContext);
        SearchScope scope = this.getScope(dataContext);
        if (scope != null) {
            findModel.setCustomScope(true);
            findModel.setCustomScope(scope);
        }
    }

    private final SearchScope getScope(DataContext dataContext) {
        SolutionExplorerNodeRider singleNode;
        ProjectView projectView = ProjectView.getInstance(this.project);
        AbstractProjectViewPane abstractProjectViewPane = projectView.getProjectViewPaneById(SolutionExplorerViewPane.Companion.getID());
        if (!(abstractProjectViewPane instanceof SolutionExplorerViewPane)) {
            abstractProjectViewPane = null;
        }
        SolutionExplorerViewPane solutionExplorerViewPane = (SolutionExplorerViewPane)abstractProjectViewPane;
        if (solutionExplorerViewPane == null) {
            return null;
        }
        SolutionExplorerViewPane solutionExplorerViewPane2 = solutionExplorerViewPane;
        boolean withExternalItems = solutionExplorerViewPane2.getMyShowFileSystem();
        ISolutionExplorerNode[] nodes = SolutionExplorerExtensionsKt.getSolutionExplorerNodes(dataContext);
        Object[] objectArray = nodes;
        if (objectArray.length == 0) {
            return null;
        }
        Object object = ArraysKt.singleOrNull((Object[])nodes);
        if (!(object instanceof SolutionExplorerNodeRider)) {
            object = null;
        }
        if ((singleNode = (SolutionExplorerNodeRider)object) != null) {
            if (ProjectModelNodeExtensionKt.isSolution(singleNode.getNode())) {
                return (SearchScope)new RiderSolutionScope(this.project, withExternalItems);
            }
            if (ProjectModelNodeExtensionKt.isProject(singleNode.getNode())) {
                return (SearchScope)new RiderProjectScope(this.project, singleNode.getNode(), withExternalItems);
            }
        }
        return (SearchScope)new RiderSolutionExplorerScope(this.project, nodes, withExternalItems);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RiderFindInProjectManager(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
    }
}

