/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.find.scopes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.ideaInterop.find.scopes.RiderScopeBase;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u0011\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\nH$J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\nH$\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/ideaInterop/find/scopes/RiderProjectModelScopeBase;", "Lcom/jetbrains/resharper/ideaInterop/find/scopes/RiderScopeBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "checkParents", "", "currentNode", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "nodes", "Ljava/util/HashSet;", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAffectedNodes", "getAffectedVirtualFiles", "rider"})
public abstract class RiderProjectModelScopeBase
extends RiderScopeBase {
    @NotNull
    protected abstract HashSet<ProjectModelNode> getAffectedNodes();

    @NotNull
    protected abstract HashSet<VirtualFile> getAffectedVirtualFiles();

    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFileIndexEntry entry = this.getIndex().get(file2);
        if (entry != null) {
            HashSet<ProjectModelNode> nodes = this.getAffectedNodes();
            for (Integer id : entry.getProjectModelIds()) {
                ProjectModelNode currentNode;
                ProjectModelViewHost projectModelViewHost = this.getViewHost();
                Integer n2 = id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"id");
                if (projectModelViewHost.getItemById(n2) == null) {
                    continue;
                }
                if (!this.checkParents(currentNode, nodes)) continue;
                return true;
            }
        }
        HashSet<VirtualFile> virtualFiles = this.getAffectedVirtualFiles();
        for (VirtualFile root : virtualFiles) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private final boolean checkParents(ProjectModelNode currentNode, HashSet<ProjectModelNode> nodes) {
        if (currentNode == null) {
            return false;
        }
        if (nodes.contains(currentNode)) {
            return true;
        }
        return this.checkParents(currentNode.getParent(), nodes);
    }

    public RiderProjectModelScopeBase(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
    }
}

