/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.find.scopes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.ideaInterop.find.scopes.RiderProjectModelScopeBase;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/resharper/ideaInterop/find/scopes/RiderProjectScope;", "Lcom/jetbrains/resharper/ideaInterop/find/scopes/RiderProjectModelScopeBase;", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "withExternalItems", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;Z)V", "getNode", "()Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "getWithExternalItems", "()Z", "getAffectedNodes", "Ljava/util/HashSet;", "getAffectedVirtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDisplayName", "", "rider"})
public final class RiderProjectScope
extends RiderProjectModelScopeBase {
    @NotNull
    private final ProjectModelNode node;
    private final boolean withExternalItems;

    @NotNull
    public String getDisplayName() {
        return "Project " + this.node.getPresentableName();
    }

    @Override
    @NotNull
    protected HashSet<ProjectModelNode> getAffectedNodes() {
        return SetsKt.hashSetOf((Object[])new ProjectModelNode[]{this.node});
    }

    @Override
    @NotNull
    protected HashSet<VirtualFile> getAffectedVirtualFiles() {
        VirtualFile root;
        if (this.withExternalItems && (root = ProjectModelNodeExtensionKt.getVirtualFileAsContentRoot(this.node)) != null) {
            return SetsKt.hashSetOf((Object[])new VirtualFile[]{root});
        }
        return new HashSet<VirtualFile>();
    }

    @NotNull
    public final ProjectModelNode getNode() {
        return this.node;
    }

    public final boolean getWithExternalItems() {
        return this.withExternalItems;
    }

    public RiderProjectScope(@NotNull Project project2, @NotNull ProjectModelNode node, boolean withExternalItems) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(project2);
        this.node = node;
        this.withExternalItems = withExternalItems;
        boolean bl = ProjectModelNodeExtensionKt.isProject(this.node);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }
}

