/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.jetbrains.resharper.ideaInterop.vfs.VfsDeltaCollector$WhenMappings;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.rider.model.RdDeltaType;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0003J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020$H\u0016R-\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/VfsDeltaCollector;", "Lcom/intellij/openapi/vfs/VirtualFileAdapter;", "index", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;Lcom/intellij/openapi/diagnostic/Logger;)V", "deltas", "Ljava/util/HashMap;", "", "Lcom/jetbrains/rider/model/RdDeltaType;", "Lkotlin/collections/HashMap;", "getDeltas", "()Ljava/util/HashMap;", "getIndex", "()Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "add", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "type", "addInternal", "addRecursively", "beforeFileDeletion", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileMovement", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "contentsChanged", "fileCopied", "Lcom/intellij/openapi/vfs/VirtualFileCopyEvent;", "fileCreated", "fileMoved", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "rider"})
public final class VfsDeltaCollector
extends VirtualFileAdapter {
    @NotNull
    private final HashMap<String, RdDeltaType> deltas;
    @NotNull
    private final VirtualFileIndex index;
    @NotNull
    private final Logger logger;

    @NotNull
    public final HashMap<String, RdDeltaType> getDeltas() {
        return this.deltas;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.addRecursively(virtualFile, RdDeltaType.Created);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.addRecursively(virtualFile, RdDeltaType.Deleted);
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.addRecursively(virtualFile, RdDeltaType.Deleted);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.addRecursively(virtualFile, RdDeltaType.Created);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.addRecursively(virtualFile, RdDeltaType.Created);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.add(virtualFile, RdDeltaType.Changed);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.add(virtualFile, RdDeltaType.Changed);
    }

    private final void add(VirtualFile file2, RdDeltaType type) {
        Logger $receiver$iv = this.logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Process " + file2;
            logger.trace(string2);
        }
        if (this.index.isInProjectModel(file2) || this.index.isUnderExternalRoot(file2)) {
            this.addInternal(file2, type);
        }
    }

    private final void addRecursively(VirtualFile file2, RdDeltaType type) {
        Logger $receiver$iv = this.logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Recursively process " + file2;
            logger.trace(string2);
        }
        long startTimeMs = System.currentTimeMillis();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(this, type, new VirtualFileVisitor.Option[0]){
            final /* synthetic */ VfsDeltaCollector this$0;
            final /* synthetic */ RdDeltaType $type;

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile child) {
                boolean shouldProcess;
                Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                VirtualFileIndexEntry entry = this.this$0.getIndex().get(child);
                boolean isUnderExternalRoot = this.this$0.getIndex().isUnderExternalRoot(child);
                boolean bl = shouldProcess = entry != null || isUnderExternalRoot;
                if (entry != null && CollectionsKt.any((Iterable)entry.getProjectModelIds()) || isUnderExternalRoot) {
                    VfsDeltaCollector.access$addInternal(this.this$0, child, this.$type);
                }
                if (shouldProcess) {
                    VirtualFileVisitor.Result result2 = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)result2, (String)"VirtualFileVisitor.CONTINUE");
                    return result2;
                }
                VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
                Intrinsics.checkExpressionValueIsNotNull((Object)result3, (String)"VirtualFileVisitor.SKIP_CHILDREN");
                return result3;
            }
            {
                this.this$0 = $outer;
                this.$type = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }));
        int threshold = 200;
        long totalTimeMs = System.currentTimeMillis() - startTimeMs;
        if (totalTimeMs > (long)threshold) {
            this.logger.warn("Recursively process " + file2 + " took " + totalTimeMs + " ms, threshold " + threshold + " ms");
        }
    }

    private final void addInternal(VirtualFile file2, RdDeltaType type) {
        String path = file2.getPath();
        RdDeltaType existingType = this.deltas.get(path);
        if (Intrinsics.areEqual((Object)((Object)existingType), (Object)((Object)RdDeltaType.Created))) {
            switch (VfsDeltaCollector$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    this.deltas.remove(path);
                }
            }
            return;
        }
        if (Intrinsics.areEqual((Object)((Object)existingType), (Object)((Object)RdDeltaType.Deleted))) {
            switch (VfsDeltaCollector$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    Map map2 = this.deltas;
                    String string2 = path;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
                    String string3 = string2;
                    RdDeltaType rdDeltaType = RdDeltaType.Changed;
                    map2.put(string3, rdDeltaType);
                }
            }
            return;
        }
        if (Intrinsics.areEqual((Object)((Object)existingType), (Object)((Object)RdDeltaType.Changed))) {
            switch (VfsDeltaCollector$WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    Map map3 = this.deltas;
                    String string4 = path;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"path");
                    String string5 = string4;
                    RdDeltaType rdDeltaType = RdDeltaType.Deleted;
                    map3.put(string5, rdDeltaType);
                }
            }
            return;
        }
        Map map4 = this.deltas;
        String string6 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"path");
        String string7 = string6;
        RdDeltaType rdDeltaType = type;
        map4.put(string7, rdDeltaType);
    }

    @NotNull
    public final VirtualFileIndex getIndex() {
        return this.index;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public VfsDeltaCollector(@NotNull VirtualFileIndex index, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)index), (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.index = index;
        this.logger = logger;
        VfsDeltaCollector vfsDeltaCollector = this;
        HashMap hashMap = new HashMap();
        vfsDeltaCollector.deltas = hashMap;
    }

    public static final /* synthetic */ void access$addInternal(VfsDeltaCollector $this, @NotNull VirtualFile file2, @NotNull RdDeltaType type) {
        $this.addInternal(file2, type);
    }
}

