/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.vfs;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.resharper.ideaInterop.vfs.VfsDeltaCollector;
import com.jetbrains.resharper.projectView.ProjectModelViewTransactions;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.index.ExternalRootType;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.resharper.util.idea.TimeLogger;
import com.jetbrains.rider.model.RdDelta;
import com.jetbrains.rider.model.RdDeltaBatch;
import com.jetbrains.rider.model.RdDeltaType;
import com.jetbrains.rider.model.RdExternalRoot;
import com.jetbrains.rider.model.RdFileSystemModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.ISignal;
import com.jetbrains.rider.util.reactive.Signal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002@AB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000202H\u0016J\u0006\u00109\u001a\u00020\u0012J\b\u0010:\u001a\u000202H\u0016J\u0010\u0010 \u001a\u0002022\u0006\u0010;\u001a\u00020\u0012H\u0002J\b\u0010<\u001a\u000202H\u0002J\u0018\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020\u001aH\u0002R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!j\u0002`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010%\u001a\u001e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&j\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006B"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/VfsNotificationHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "index", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "transactions", "Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "externalRootSignal", "Lcom/jetbrains/rider/util/reactive/ISignal;", "", "getExternalRootSignal", "()Lcom/jetbrains/rider/util/reactive/ISignal;", "fileSystemModel", "Lcom/jetbrains/rider/model/RdFileSystemModel;", "getFileSystemModel", "()Lcom/jetbrains/rider/model/RdFileSystemModel;", "hasChanges", "", "getIndex", "()Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "localFileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "kotlin.jvm.PlatformType", "log", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "mapping", "Ljava/util/HashMap;", "Ljava/io/File;", "Lcom/jetbrains/resharper/ideaInterop/vfs/VfsNotificationHost$WatchRequestInfo;", "Lkotlin/collections/HashMap;", "getProject", "()Lcom/intellij/openapi/project/Project;", "requestUpdater", "Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions$RequestUpdater;", "tempDirectory", "getTransactions", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions;", "ViewRoots", "", "lifetime", "id", "", "root", "Lcom/jetbrains/rider/model/RdExternalRoot;", "disposeComponent", "dump", "initComponent", "message", "performUpdate", "warmVirtualFileSystem", "warmFrom", "warmRecursive", "VfsBulkListener", "WatchRequestInfo", "rider"})
public final class VfsNotificationHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final MessageBusConnection connection;
    private final LocalFileSystem localFileSystem;
    private final Logger logger;
    private final File tempDirectory;
    private final HashMap<File, WatchRequestInfo> mapping;
    private final StringBuilder log;
    @NotNull
    private final RdFileSystemModel fileSystemModel;
    @NotNull
    private final ISignal<String> externalRootSignal;
    private final ProjectModelViewTransactions.RequestUpdater requestUpdater;
    private boolean hasChanges;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFileIndex index;
    @NotNull
    private final ProjectModelViewTransactions transactions;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final RdFileSystemModel getFileSystemModel() {
        return this.fileSystemModel;
    }

    @NotNull
    public final ISignal<String> getExternalRootSignal() {
        return this.externalRootSignal;
    }

    public void initComponent() {
        this.fileSystemModel.getExternalRoots().view(this.getComponentLifetime(), (Function3<Lifetime, Integer, RdExternalRoot, Unit>)((Function3)new Function3<Lifetime, Integer, RdExternalRoot, Unit>(this){
            final /* synthetic */ VfsNotificationHost this$0;

            public final void invoke(@NotNull Lifetime lifetime, int id, @NotNull RdExternalRoot root) {
                Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                VfsNotificationHost.access$ViewRoots(this.this$0, lifetime, id, root);
            }
            {
                this.this$0 = vfsNotificationHost;
                super(3);
            }
        }));
        VfsBulkListener listener2 = new VfsBulkListener(this.fileSystemModel, this.index, this.logger);
        this.connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener2);
    }

    /*
     * WARNING - void declaration
     */
    public void disposeComponent() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        this.connection.disconnect();
        Iterable iterable = $receiver$iv = (Iterable)this.mapping.values();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            WatchRequestInfo watchRequestInfo = (WatchRequestInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            LocalFileSystem.WatchRequest watchRequest = it.getRequest();
            collection.add(watchRequest);
        }
        List watchRequests = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        this.mapping.clear();
        this.localFileSystem.removeWatchedRoots((Collection)watchRequests);
    }

    private final void ViewRoots(Lifetime lifetime, int id, RdExternalRoot root) {
        File rootFile = new File(root.getPath());
        boolean isRecursive = root.isRecursive();
        if (rootFile.getParentFile() == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.tempDirectory, (Object)rootFile) || Intrinsics.areEqual((Object)this.tempDirectory, (Object)rootFile.getParentFile())) {
            return;
        }
        this.logger.trace("External root: " + root.getPath());
        this.externalRootSignal.fire(root.getPath());
        Map $receiver$iv = this.mapping;
        Object object = $receiver$iv.get(rootFile);
        if (object == null) {
            WatchRequestInfo watchRequestInfo;
            File it = rootFile;
            WatchRequestInfo it$iv = watchRequestInfo = new WatchRequestInfo(it, null);
            Map map2 = $receiver$iv;
            File file2 = rootFile;
            WatchRequestInfo watchRequestInfo2 = it$iv;
            map2.put(file2, watchRequestInfo2);
            object = it$iv;
        }
        WatchRequestInfo info = (WatchRequestInfo)object;
        if (info.isEmpty()) {
            boolean warmRecursive;
            File warmFrom;
            this.hasChanges = true;
            if (rootFile.isDirectory()) {
                warmFrom = rootFile;
                warmRecursive = isRecursive;
            } else {
                File file3 = rootFile.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"rootFile.parentFile");
                warmFrom = file3;
                warmRecursive = false;
            }
            if (ApplicationKt.getApplication().isUnitTestMode()) {
                VfsRootAccess.allowRootAccess(warmFrom.getPath());
            }
            this.warmVirtualFileSystem(warmFrom, warmRecursive);
        } else {
            this.hasChanges = this.hasChanges || info.isRecursive() != isRecursive;
        }
        Map map3 = info.getHandles();
        Integer n2 = id;
        RdExternalRoot rdExternalRoot = root;
        map3.put(n2, rdExternalRoot);
        this.requestUpdater.requestUpdate();
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this, rootFile, id){
            final /* synthetic */ VfsNotificationHost this$0;
            final /* synthetic */ File $rootFile;
            final /* synthetic */ int $id;

            public final void invoke() {
                WatchRequestInfo watchRequestInfo = (WatchRequestInfo)VfsNotificationHost.access$getMapping$p(this.this$0).get(this.$rootFile);
                if (watchRequestInfo == null) {
                    return;
                }
                WatchRequestInfo infoToRemove = watchRequestInfo;
                infoToRemove.getHandles().remove(this.$id);
                VfsNotificationHost.access$setHasChanges$p(this.this$0, true);
                VfsNotificationHost.access$getRequestUpdater$p(this.this$0).requestUpdate();
            }
            {
                this.this$0 = vfsNotificationHost;
                this.$rootFile = file2;
                this.$id = n2;
                super(0);
            }
        }));
    }

    private final void warmVirtualFileSystem(File warmFrom, boolean warmRecursive) {
        if (this.index.isUnderExternalRoot(warmFrom, true)) {
            return;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)warmFrom, (boolean)true);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFileToWarm = virtualFile;
        ApplicationKt.getApplication().executeOnPooledThread(new Runnable(warmRecursive, virtualFileToWarm){
            final /* synthetic */ boolean $warmRecursive;
            final /* synthetic */ VirtualFile $virtualFileToWarm;

            public final void run() {
                if (this.$warmRecursive) {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)this.$virtualFileToWarm, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){}));
                } else {
                    this.$virtualFileToWarm.getChildren();
                }
            }
            {
                this.$warmRecursive = bl;
                this.$virtualFileToWarm = virtualFile;
            }
        });
    }

    private final void performUpdate() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.hasChanges) {
            return;
        }
        this.hasChanges = false;
        this.logger.trace("PerformUpdate...");
        TimeLogger timeLogger = new TimeLogger();
        HashSet watchRequests = new HashSet();
        HashSet flatRoots = new HashSet();
        HashSet recursiveRoots = new HashSet();
        timeLogger.section("Visit all infos and collect data", (Function0)new Function0<Unit>(this, watchRequests, recursiveRoots, flatRoots){
            final /* synthetic */ VfsNotificationHost this$0;
            final /* synthetic */ HashSet $watchRequests;
            final /* synthetic */ HashSet $recursiveRoots;
            final /* synthetic */ HashSet $flatRoots;

            public final void invoke() {
                for (WatchRequestInfo info : VfsNotificationHost.access$getMapping$p(this.this$0).values()) {
                    LocalFileSystem.WatchRequest watchRequest = info.getRequest();
                    if (watchRequest != null) {
                        this.$watchRequests.add(watchRequest);
                    }
                    info.setRequest(null);
                    File rootFile = info.getRootFile();
                    if (info.isEmpty()) {
                        this.this$0.getIndex().setExternalRoot(rootFile, ExternalRootType.None);
                        continue;
                    }
                    if (info.isRecursive()) {
                        this.this$0.getIndex().setExternalRoot(rootFile, ExternalRootType.Recursive);
                        this.$recursiveRoots.add(rootFile.getPath());
                        continue;
                    }
                    this.this$0.getIndex().setExternalRoot(rootFile, ExternalRootType.Flat);
                    this.$flatRoots.add(rootFile.getPath());
                }
            }
            {
                this.this$0 = vfsNotificationHost;
                this.$watchRequests = hashSet;
                this.$recursiveRoots = hashSet2;
                this.$flatRoots = hashSet3;
                super(0);
            }
        });
        timeLogger.section("Remove all roots under other recursive roots", (Function0)new Function0<Unit>(this, recursiveRoots, flatRoots){
            final /* synthetic */ VfsNotificationHost this$0;
            final /* synthetic */ HashSet $recursiveRoots;
            final /* synthetic */ HashSet $flatRoots;

            public final void invoke() {
                for (WatchRequestInfo info : VfsNotificationHost.access$getMapping$p(this.this$0).values()) {
                    File rootFile = info.getRootFile();
                    VirtualFileIndex virtualFileIndex = this.this$0.getIndex();
                    File file2 = rootFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootFile.parentFile");
                    if (!virtualFileIndex.isUnderExternalRoot(file2, true)) continue;
                    this.this$0.getIndex().setExternalRoot(rootFile, ExternalRootType.None);
                    this.$recursiveRoots.remove(rootFile.getPath());
                    this.$flatRoots.remove(rootFile.getPath());
                }
            }
            {
                this.this$0 = vfsNotificationHost;
                this.$recursiveRoots = hashSet;
                this.$flatRoots = hashSet2;
                super(0);
            }
        });
        Set result2 = (Set)timeLogger.section("Replace watched roots in VFS", (Function0)new Function0<Set<LocalFileSystem.WatchRequest>>(this, watchRequests, recursiveRoots, flatRoots){
            final /* synthetic */ VfsNotificationHost this$0;
            final /* synthetic */ HashSet $watchRequests;
            final /* synthetic */ HashSet $recursiveRoots;
            final /* synthetic */ HashSet $flatRoots;

            @NotNull
            public final Set<LocalFileSystem.WatchRequest> invoke() {
                return VfsNotificationHost.access$getLocalFileSystem$p(this.this$0).replaceWatchedRoots((Collection)this.$watchRequests, (Collection)this.$recursiveRoots, (Collection)this.$flatRoots);
            }
            {
                this.this$0 = vfsNotificationHost;
                this.$watchRequests = hashSet;
                this.$recursiveRoots = hashSet2;
                this.$flatRoots = hashSet3;
                super(0);
            }
        });
        timeLogger.section("Update infos", (Function0)new Function0<Unit>(this, result2){
            final /* synthetic */ VfsNotificationHost this$0;
            final /* synthetic */ Set $result;

            public final void invoke() {
                for (LocalFileSystem.WatchRequest watchRequest : this.$result) {
                    File file2 = new File(watchRequest.getRootPath());
                    WatchRequestInfo watchRequestInfo = (WatchRequestInfo)VfsNotificationHost.access$getMapping$p(this.this$0).get(file2);
                    if (watchRequestInfo == null) continue;
                    watchRequestInfo.setRequest(watchRequest);
                }
            }
            {
                this.this$0 = vfsNotificationHost;
                this.$result = set2;
                super(0);
            }
        });
        timeLogger.section("Cleanup infos", (Function0)new Function0<Unit>(this){
            final /* synthetic */ VfsNotificationHost this$0;

            public final void invoke() {
                Map.Entry<K, V> it;
                Map $receiver$iv$iv;
                Object[] $receiver$iv = VfsNotificationHost.access$getMapping$p(this.this$0);
                Map map2 = $receiver$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>();
                Map map3 = $receiver$iv$iv;
                for (Map.Entry<K, V> element$iv$iv : map3.entrySet()) {
                    it = element$iv$iv;
                    if (!((WatchRequestInfo)it.getValue()).getHandles().isEmpty()) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $receiver$iv = destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>($receiver$iv.size());
                map3 = $receiver$iv$iv;
                for (Map.Entry<K, V> item$iv$iv : map3.entrySet()) {
                    it = item$iv$iv;
                    Object object = destination$iv$iv;
                    File file2 = (File)it.getKey();
                    object.add(file2);
                }
                $receiver$iv = (List)destination$iv$iv;
                Collection thisCollection$iv = (Collection)$receiver$iv;
                File[] fileArray = thisCollection$iv.toArray(new File[thisCollection$iv.size()]);
                if (fileArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                File[] pathsToRemove = (File[])((Object[])fileArray);
                $receiver$iv = pathsToRemove;
                for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                    Object element$iv = $receiver$iv[i2];
                    File it2 = (File)element$iv;
                    VfsNotificationHost.access$getMapping$p(this.this$0).remove(it2);
                }
            }
            {
                this.this$0 = vfsNotificationHost;
                super(0);
            }
        });
        String message2 = timeLogger.complete(recursiveRoots.size() + " recursive and " + flatRoots.size() + " flat roots updated");
        this.log(message2);
    }

    private final void log(String message2) {
        this.logger.trace(message2);
        if (ApplicationKt.getApplication().isInternal()) {
            StringBuilder stringBuilder = this.log;
            StringsKt.appendln((StringBuilder)stringBuilder.append(message2));
        }
    }

    @NotNull
    public final String dump() {
        Iterable $receiver$iv;
        StringBuilder result2 = new StringBuilder();
        Object object = result2;
        Object object2 = "External roots: ";
        StringsKt.appendln((StringBuilder)((StringBuilder)object).append((String)object2));
        Map map2 = this.mapping;
        Iterable iterable = $receiver$iv = (Iterable)map2.entrySet();
        Object object3 = new Comparator<Map.Entry<? extends File, ? extends WatchRequestInfo>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b2) {
                Map.Entry it = (Map.Entry)a;
                Comparable comparable = (Comparable)((Object)((File)it.getKey()).getPath());
                it = (Map.Entry)b2;
                Comparable comparable2 = comparable;
                String string2 = ((File)it.getKey()).getPath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        };
        object2 = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object3).iterator();
        while (object2.hasNext()) {
            Object object4;
            Object object5;
            object3 = object = (Map.Entry)object2.next();
            File path = (File)object3.getKey();
            object3 = object;
            WatchRequestInfo info = (WatchRequestInfo)object3.getValue();
            String requestMessage = info.getRequest() == null ? "<NO REQUEST>" : "";
            result2.append(path + " " + requestMessage + ", Recursive: " + info.isRecursive() + ", Handles: " + info.getHandles().size());
            if (info.getHandles().size() == 1 && Intrinsics.areEqual((Object)((RdExternalRoot)CollectionsKt.single((Iterable)info.getHandles().values())).getPath(), (Object)path.getPath())) {
                object5 = result2;
                object4 = " <Self>";
                StringsKt.appendln((StringBuilder)((StringBuilder)object5).append((String)object4));
                continue;
            }
            object5 = result2;
            object4 = ":";
            StringsKt.appendln((StringBuilder)((StringBuilder)object5).append((String)object4));
            Map map3 = info.getHandles();
            object4 = map3.entrySet().iterator();
            while (object4.hasNext()) {
                Object object6 = object5 = (Map.Entry)object4.next();
                int handleId = ((Number)object6.getKey()).intValue();
                object6 = object5;
                RdExternalRoot handleData = (RdExternalRoot)object6.getValue();
                File relativeHandle = FilesKt.relativeTo((File)new File(handleData.getPath()), (File)path);
                CharSequence charSequence = relativeHandle.getPath();
                String relativePath = charSequence.length() == 0 ? "<DIRECTORY>" : relativeHandle.getPath();
                result2.append("\t" + handleId + " " + relativePath);
                if (handleData.isRecursive()) {
                    result2.append(" Recursive");
                }
                StringsKt.appendln((StringBuilder)result2);
            }
        }
        StringsKt.appendln((StringBuilder)result2);
        object = result2;
        object2 = "Log: ";
        StringsKt.appendln((StringBuilder)((StringBuilder)object).append((String)object2));
        result2.append((CharSequence)this.log);
        String string2 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFileIndex getIndex() {
        return this.index;
    }

    @NotNull
    public final ProjectModelViewTransactions getTransactions() {
        return this.transactions;
    }

    public VfsNotificationHost(@NotNull Project project2, @NotNull VirtualFileIndex index, @NotNull ProjectModelViewTransactions transactions) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)index), (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)((Object)transactions), (String)"transactions");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.index = index;
        this.transactions = transactions;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect()");
        this.connection = messageBusConnection;
        this.localFileSystem = LocalFileSystem.getInstance();
        VfsNotificationHost vfsNotificationHost = this;
        Logger logger = Logger.getInstance(VfsNotificationHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        vfsNotificationHost.logger = object = logger;
        this.tempDirectory = new File(FileUtil.getTempDirectory());
        vfsNotificationHost = this;
        vfsNotificationHost.mapping = object = new HashMap();
        this.log = new StringBuilder();
        this.fileSystemModel = SolutionHostExtensionsKt.getSolution(this.project).getFileSystemModel();
        this.externalRootSignal = new Signal();
        this.requestUpdater = this.transactions.createRequestUpdater("VfsNotificationHost", (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.performUpdate();
            }
        }));
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public static final /* synthetic */ void access$ViewRoots(VfsNotificationHost $this, @NotNull Lifetime lifetime, int id, @NotNull RdExternalRoot root) {
        $this.ViewRoots(lifetime, id, root);
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getMapping$p(VfsNotificationHost $this) {
        return $this.mapping;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(VfsNotificationHost $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(VfsNotificationHost $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @NotNull
    public static final /* synthetic */ ProjectModelViewTransactions.RequestUpdater access$getRequestUpdater$p(VfsNotificationHost $this) {
        return $this.requestUpdater;
    }

    public static final /* synthetic */ LocalFileSystem access$getLocalFileSystem$p(VfsNotificationHost $this) {
        return $this.localFileSystem;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R-\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/VfsNotificationHost$WatchRequestInfo;", "", "rootFile", "Ljava/io/File;", "request", "Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "(Ljava/io/File;Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;)V", "handles", "Ljava/util/HashMap;", "", "Lcom/jetbrains/rider/model/RdExternalRoot;", "Lkotlin/collections/HashMap;", "getHandles", "()Ljava/util/HashMap;", "isEmpty", "", "()Z", "isRecursive", "getRequest", "()Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "setRequest", "(Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;)V", "getRootFile", "()Ljava/io/File;", "rider"})
    public static final class WatchRequestInfo {
        @NotNull
        private final HashMap<Integer, RdExternalRoot> handles;
        @NotNull
        private final File rootFile;
        @Nullable
        private LocalFileSystem.WatchRequest request;

        @NotNull
        public final HashMap<Integer, RdExternalRoot> getHandles() {
            return this.handles;
        }

        public final boolean isEmpty() {
            return this.handles.isEmpty();
        }

        public final boolean isRecursive() {
            boolean bl;
            block1: {
                Iterable $receiver$iv = this.handles.values();
                for (Object element$iv : $receiver$iv) {
                    RdExternalRoot it = (RdExternalRoot)element$iv;
                    if (!it.isRecursive()) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final File getRootFile() {
            return this.rootFile;
        }

        @Nullable
        public final LocalFileSystem.WatchRequest getRequest() {
            return this.request;
        }

        public final void setRequest(@Nullable LocalFileSystem.WatchRequest watchRequest) {
            this.request = watchRequest;
        }

        public WatchRequestInfo(@NotNull File rootFile, @Nullable LocalFileSystem.WatchRequest request2) {
            Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"rootFile");
            this.rootFile = rootFile;
            this.request = request2;
            WatchRequestInfo watchRequestInfo = this;
            HashMap hashMap = new HashMap();
            watchRequestInfo.handles = hashMap;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/VfsNotificationHost$VfsBulkListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "fileSystemModel", "Lcom/jetbrains/rider/model/RdFileSystemModel;", "index", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/jetbrains/rider/model/RdFileSystemModel;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;Lcom/intellij/openapi/diagnostic/Logger;)V", "getFileSystemModel", "()Lcom/jetbrains/rider/model/RdFileSystemModel;", "getIndex", "()Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "listeners", "Ljava/util/HashMap;", "", "Lcom/jetbrains/resharper/ideaInterop/vfs/VfsDeltaCollector;", "Lkotlin/collections/HashMap;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "rider"})
    public static final class VfsBulkListener
    implements BulkFileListener {
        private final HashMap<Integer, VfsDeltaCollector> listeners;
        @NotNull
        private final RdFileSystemModel fileSystemModel;
        @NotNull
        private final VirtualFileIndex index;
        @NotNull
        private final Logger logger;

        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkParameterIsNotNull(events, (String)"events");
            VfsDeltaCollector listener2 = new VfsDeltaCollector(this.index, this.logger);
            this.listeners.put(((Object)events).hashCode(), listener2);
            BulkVirtualFileListenerAdapter bulkListener = new BulkVirtualFileListenerAdapter((VirtualFileListener)listener2);
            bulkListener.before(events);
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkParameterIsNotNull(events, (String)"events");
            int key = ((Object)events).hashCode();
            VfsDeltaCollector vfsDeltaCollector = this.listeners.get(key);
            if (vfsDeltaCollector == null) {
                String string2 = "Can't find existing listener for VFS events";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            VfsDeltaCollector listener2 = vfsDeltaCollector;
            this.listeners.remove(key);
            BulkVirtualFileListenerAdapter bulkListener = new BulkVirtualFileListenerAdapter((VirtualFileListener)listener2);
            bulkListener.after(events);
            List batchChanges = new ArrayList();
            Map map2 = listener2.getDeltas();
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                String path = (String)entry2.getKey();
                entry2 = entry;
                RdDeltaType type = (RdDeltaType)((Object)entry2.getValue());
                batchChanges.add(new RdDelta(path, type));
            }
            if (CollectionsKt.any((Iterable)batchChanges)) {
                RdDeltaBatch batch = new RdDeltaBatch(batchChanges);
                this.fileSystemModel.getChange().fire(batch);
            }
        }

        @NotNull
        public final RdFileSystemModel getFileSystemModel() {
            return this.fileSystemModel;
        }

        @NotNull
        public final VirtualFileIndex getIndex() {
            return this.index;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public VfsBulkListener(@NotNull RdFileSystemModel fileSystemModel, @NotNull VirtualFileIndex index, @NotNull Logger logger) {
            Intrinsics.checkParameterIsNotNull((Object)fileSystemModel, (String)"fileSystemModel");
            Intrinsics.checkParameterIsNotNull((Object)((Object)index), (String)"index");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            this.fileSystemModel = fileSystemModel;
            this.index = index;
            this.logger = logger;
            VfsBulkListener vfsBulkListener = this;
            HashMap hashMap = new HashMap();
            vfsBulkListener.listeners = hashMap;
        }
    }
}

