/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.undo.ForceUndo;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.resharper.ideaInterop.vfs.VfsWriteOperationsHost;
import com.jetbrains.resharper.ideaInterop.vfs.actions.CopyAction;
import com.jetbrains.resharper.ideaInterop.vfs.actions.MoveAction;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ComponentContainerUtilKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.framework.RdVoid;
import com.jetbrains.rider.model.FileToSave;
import com.jetbrains.rider.model.FilesToSave;
import com.jetbrains.rider.model.RdFileSystemModel;
import com.jetbrains.rider.model.RdFromTo;
import com.jetbrains.rider.model.RdOperationResult;
import com.jetbrains.rider.model.RdRefreshRequest;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J*\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0018H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020&H\u0007R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/VfsWriteOperationsHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "commandProcessor", "Lcom/intellij/openapi/command/CommandProcessorEx;", "getCommandProcessor", "()Lcom/intellij/openapi/command/CommandProcessorEx;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "copyAction", "Lcom/jetbrains/resharper/ideaInterop/vfs/actions/CopyAction;", "fileSystemModel", "Lcom/jetbrains/rider/model/RdFileSystemModel;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "moveAction", "Lcom/jetbrains/resharper/ideaInterop/vfs/actions/MoveAction;", "refreshQueue", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/HashSet;", "refreshVfsGroupingEvent", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "copy", "Lcom/jetbrains/rider/model/RdOperationResult;", "fromTo", "Lcom/jetbrains/rider/model/RdFromTo;", "create", "fullPath", "", "action", "Lkotlin/Function2;", "", "createDirectory", "createFile", "delete", "move", "refreshBom", "file", "save", "", "fileToSave", "Lcom/jetbrains/rider/model/FilesToSave;", "waitRefreshIsFinished", "Companion", "rider"})
public final class VfsWriteOperationsHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final Logger logger;
    private final RdFileSystemModel fileSystemModel;
    private final MergingUpdateQueue refreshVfsGroupingEvent;
    private final HashSet<VirtualFile> refreshQueue;
    private final MoveAction moveAction;
    private final CopyAction copyAction;
    @NotNull
    private final CommandProcessorEx commandProcessor;
    private static final int groupingTimeSpan = 200;
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final CommandProcessorEx getCommandProcessor() {
        return this.commandProcessor;
    }

    private final void refreshBom(VirtualFile file2) {
        if (!file2.isDirectory()) {
            byte[] content2 = null;
            try {
                content2 = VfsUtilCore.loadBytes((VirtualFile)file2);
            }
            catch (Throwable t2) {
                this.logger.warn(t2);
            }
            if (content2 != null) {
                byte[] byArray = content2;
                if (byArray.length == 0) {
                    content2 = FileUtil.loadFileBytes((File)VfsUtil.virtualToIoFile((VirtualFile)file2));
                }
                LoadTextUtil.detectCharsetAndSetBOM(file2, content2);
            }
        }
    }

    public final void waitRefreshIsFinished() {
        Object isFinished;
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.refreshVfsGroupingEvent.isEmpty()) {
            return;
        }
        if (this.refreshQueue.isEmpty()) {
            return;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        this.refreshVfsGroupingEvent.queue(new Update(isFinished, "LastUpdate", 99999){
            final /* synthetic */ Ref.BooleanRef $isFinished;

            public void run() {
                this.$isFinished.element = true;
            }
            {
                this.$isFinished = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2);
            }
        });
        ExtensionsKt.waitAndPump$default(this.getComponentLifetime(), (Function0)new Function0<Boolean>((Ref.BooleanRef)isFinished){
            final /* synthetic */ Ref.BooleanRef $isFinished;

            public final boolean invoke() {
                return this.$isFinished.element;
            }
            {
                this.$isFinished = booleanRef;
                super(0);
            }
        }, VfsWriteOperationsHost.Companion.getGroupingTimeSpan() + 1000, null, 8, null);
        isFinished = null;
    }

    private final RdOperationResult createDirectory(String fullPath) {
        this.logger.info("'Create directory' command received. Create |" + fullPath + "|");
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(fullPath), (boolean)true);
        if (virtualFile != null && virtualFile.isDirectory()) {
            this.logger.debug("Directory |" + fullPath + "| already exists");
            return new RdOperationResult(true, null);
        }
        return this.create(fullPath, (Function2<? super VirtualFile, ? super String, Unit>)((Function2)new Function2<VirtualFile, String, Unit>(this){
            final /* synthetic */ VfsWriteOperationsHost this$0;

            public final void invoke(@NotNull VirtualFile parent, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                parent.createChildDirectory((Object)this.this$0, name);
            }
            {
                this.this$0 = vfsWriteOperationsHost;
                super(2);
            }
        }));
    }

    private final RdOperationResult createFile(String fullPath) {
        this.logger.info("'Create file' command received. Create |" + fullPath + "|");
        return this.create(fullPath, (Function2<? super VirtualFile, ? super String, Unit>)((Function2)new Function2<VirtualFile, String, Unit>(this){
            final /* synthetic */ VfsWriteOperationsHost this$0;

            public final void invoke(@NotNull VirtualFile parent, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                parent.createChildData((Object)this.this$0, name);
            }
            {
                this.this$0 = vfsWriteOperationsHost;
                super(2);
            }
        }));
    }

    private final RdOperationResult create(String fullPath, Function2<? super VirtualFile, ? super String, Unit> action2) {
        File target = new File(fullPath);
        VirtualFile parentVirtualFile = VfsUtil.findFileByIoFile((File)target.getParentFile(), (boolean)true);
        if (parentVirtualFile == null) {
            this.logger.info("Cannot get parent virtual file. Cancelling...");
            return new RdOperationResult(false, "Cannot get parent virtual file");
        }
        try {
            ApplicationKt.getApplication().runWriteAction(new Runnable(action2, parentVirtualFile, target){
                final /* synthetic */ Function2 $action;
                final /* synthetic */ VirtualFile $parentVirtualFile;
                final /* synthetic */ File $target;

                public final void run() {
                    String string2 = this.$target.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.name");
                    this.$action.invoke((Object)this.$parentVirtualFile, (Object)string2);
                }
                {
                    this.$action = function2;
                    this.$parentVirtualFile = virtualFile;
                    this.$target = file2;
                }
            });
        }
        catch (Throwable t2) {
            this.logger.error(t2);
            return new RdOperationResult(false, t2.getMessage());
        }
        return new RdOperationResult(true, null);
    }

    private final RdOperationResult delete(String fullPath) {
        this.logger.info("'Delete' command received. Delete |" + fullPath + "|");
        VirtualFile targetVirtualFile = ComponentContainerUtilKt.toVirtualFile(fullPath);
        if (targetVirtualFile == null) {
            this.logger.info("There is no virtual file.");
            return new RdOperationResult(true, null);
        }
        if (!targetVirtualFile.exists()) {
            this.logger.info("Virtual file doesn't exists.");
            return new RdOperationResult(true, null);
        }
        try {
            ApplicationKt.getApplication().runWriteAction(new Runnable(this, targetVirtualFile){
                final /* synthetic */ VfsWriteOperationsHost this$0;
                final /* synthetic */ VirtualFile $targetVirtualFile;

                public final void run() {
                    this.$targetVirtualFile.delete((Object)this.this$0);
                }
                {
                    this.this$0 = vfsWriteOperationsHost;
                    this.$targetVirtualFile = virtualFile;
                }
            });
        }
        catch (Throwable t2) {
            this.logger.error(t2);
            return new RdOperationResult(false, t2.getMessage());
        }
        return new RdOperationResult(true, null);
    }

    private final RdOperationResult move(RdFromTo fromTo) {
        this.logger.info("'Move' command received. Copy from |" + fromTo.getFrom() + "| to |" + fromTo.getTo() + "| override " + fromTo.getOverwrite());
        return this.moveAction.execute(fromTo);
    }

    private final RdOperationResult copy(RdFromTo fromTo) {
        this.logger.info("'Copy' command received. Copy from |" + fromTo.getFrom() + "| to |" + fromTo.getTo() + "| override " + fromTo.getOverwrite());
        return this.copyAction.execute(fromTo);
    }

    private final boolean save(FilesToSave fileToSave) {
        this.logger.info("'SaveFiles' command received.");
        for (FileToSave file2 : fileToSave.getFiles()) {
            VirtualFile vf;
            if (ComponentContainerUtilKt.toVirtualFile(file2.getPath()) == null) {
                return false;
            }
            File ioFile = ComponentContainerUtilKt.toIOFile(file2.getPath());
            FileUtil.writeToFile((File)ioFile, (String)file2.getFullText());
            vf.refresh(false, false);
        }
        return true;
    }

    public VfsWriteOperationsHost(@NotNull Project project2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        VfsWriteOperationsHost vfsWriteOperationsHost = this;
        Logger logger = Logger.getInstance(VfsWriteOperationsHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        vfsWriteOperationsHost.logger = object = logger;
        this.fileSystemModel = SolutionHostExtensionsKt.getSolution(project2).getFileSystemModel();
        this.refreshVfsGroupingEvent = new MergingUpdateQueue("refreshGroupingEvent", VfsWriteOperationsHost.Companion.getGroupingTimeSpan(), true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project2, null, true).setRestartTimerOnAdd(false);
        vfsWriteOperationsHost = this;
        vfsWriteOperationsHost.refreshQueue = object = new HashSet();
        this.moveAction = new MoveAction(this.logger);
        this.copyAction = new CopyAction(this.logger);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (commandProcessor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.command.CommandProcessorEx");
        }
        this.commandProcessor = (CommandProcessorEx)commandProcessor;
        this.refreshVfsGroupingEvent.setPassThrough(false);
        ApplicationKt.getApplication().invokeLater(new Runnable(){

            @Override
            public final void run() {
                this.getCommandProcessor().addCommandListener((CommandListener)new CommandAdapter(){
                    private final boolean asyncRefresh = !ApplicationKt.getApplication().isUnitTestMode();

                    public final boolean getAsyncRefresh() {
                        return this.asyncRefresh;
                    }

                    public void commandFinished(@Nullable CommandEvent event) {
                        refreshVfsGroupingEvent.queue(new Update(this, event, "UpdateVfs"){
                            final /* synthetic */ 1 this$0;
                            final /* synthetic */ CommandEvent $event;

                            public void run() {
                                ApplicationKt.getApplication().assertIsDispatchThread();
                                if (VfsWriteOperationsHost.access$getRefreshQueue$p(this).isEmpty()) {
                                    return;
                                }
                                Logger logger = VfsWriteOperationsHost.access$getLogger$p(this);
                                StringBuilder stringBuilder = new StringBuilder().append("refreshing queued files after ");
                                CommandEvent commandEvent = this.$event;
                                if (commandEvent == null) {
                                    Intrinsics.throwNpe();
                                }
                                logger.trace(stringBuilder.append(commandEvent.getCommandName()).append(" command has finished...").toString());
                                ForceUndo.ignoreVirtualFileContentChanges((Runnable)new Runnable(this){
                                    final /* synthetic */ commandFinished.1 this$0;

                                    public final void run() {
                                        ArrayList<E> copy = new ArrayList<E>(VfsWriteOperationsHost.access$getRefreshQueue$p(this));
                                        VfsWriteOperationsHost.access$getRefreshQueue$p(this).clear();
                                        Iterable $receiver$iv = copy;
                                        for (T element$iv : $receiver$iv) {
                                            VirtualFile it = (VirtualFile)element$iv;
                                            it.refresh(this.this$0.this$0.getAsyncRefresh(), true);
                                            VfsWriteOperationsHost.access$refreshBom(this, it);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                VfsWriteOperationsHost.access$getLogger$p(this).trace("finished refreshing queued files...");
                            }
                            {
                                this.this$0 = $outer;
                                this.$event = $captured_local_variable$1;
                                super($super_call_param$2);
                            }
                        });
                    }
                });
                fileSystemModel.getCreateDirectory().set((Function1<String, RdOperationResult>)((Function1)new Function1<String, RdOperationResult>(){

                    @NotNull
                    public final RdOperationResult invoke(@NotNull String path) {
                        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                        return this.createDirectory(path);
                    }
                }));
                fileSystemModel.getCreateFile().set((Function1<String, RdOperationResult>)((Function1)new Function1<String, RdOperationResult>(){

                    @NotNull
                    public final RdOperationResult invoke(@NotNull String path) {
                        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                        return this.createFile(path);
                    }
                }));
                fileSystemModel.getDelete().set((Function1<String, RdOperationResult>)((Function1)new Function1<String, RdOperationResult>(){

                    @NotNull
                    public final RdOperationResult invoke(@NotNull String fullPath) {
                        Intrinsics.checkParameterIsNotNull((Object)fullPath, (String)"fullPath");
                        return this.delete(fullPath);
                    }
                }));
                fileSystemModel.getMove().set((Function1<RdFromTo, RdOperationResult>)((Function1)new Function1<RdFromTo, RdOperationResult>(){

                    @NotNull
                    public final RdOperationResult invoke(@NotNull RdFromTo fromTo) {
                        Intrinsics.checkParameterIsNotNull((Object)fromTo, (String)"fromTo");
                        return this.move(fromTo);
                    }
                }));
                fileSystemModel.getCopy().set((Function1<RdFromTo, RdOperationResult>)((Function1)new Function1<RdFromTo, RdOperationResult>(){

                    @NotNull
                    public final RdOperationResult invoke(@NotNull RdFromTo fromTo) {
                        Intrinsics.checkParameterIsNotNull((Object)fromTo, (String)"fromTo");
                        return this.copy(fromTo);
                    }
                }));
                fileSystemModel.getRefreshFiles().set((Function1<FilesToSave, Boolean>)((Function1)new Function1<FilesToSave, Boolean>(){

                    public final boolean invoke(@NotNull FilesToSave filesList) {
                        Intrinsics.checkParameterIsNotNull((Object)filesList, (String)"filesList");
                        return this.save(filesList);
                    }
                }));
                fileSystemModel.getRefreshPaths().set((Function1<RdRefreshRequest, RdVoid>)((Function1)new Function1<RdRefreshRequest, RdVoid>(){

                    @NotNull
                    public final RdVoid invoke(final @NotNull RdRefreshRequest request2) {
                        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
                        ApplicationKt.getApplication().assertIsDispatchThread();
                        ApplicationKt.getApplication().runReadAction(new Runnable(){

                            @Override
                            public final void run() {
                                boolean isUnderCommand = this.getCommandProcessor().getCurrentCommand() != null;
                                Iterable $receiver$iv = request2.getPaths();
                                for (Object element$iv : $receiver$iv) {
                                    VirtualFile virtualFile;
                                    String file2 = (String)element$iv;
                                    if (ComponentContainerUtilKt.toVirtualFile(file2) == null) {
                                        continue;
                                    }
                                    logger.trace("refresh command received. File: " + virtualFile.getPath() + " IsUnderCommand : " + isUnderCommand);
                                    if (isUnderCommand) {
                                        refreshQueue.add(virtualFile);
                                    } else {
                                        virtualFile.refresh(true, true);
                                    }
                                    this.refreshBom(virtualFile);
                                }
                            }
                        });
                        return RdVoid.INSTANCE;
                    }
                }));
            }
        });
    }

    static {
        groupingTimeSpan = 200;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/VfsWriteOperationsHost$Companion;", "", "()V", "groupingTimeSpan", "", "getGroupingTimeSpan", "()I", "rider"})
    public static final class Companion {
        private final int getGroupingTimeSpan() {
            return groupingTimeSpan;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

