/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.vfs.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ComponentContainerUtilKt;
import com.jetbrains.rider.model.RdFromTo;
import com.jetbrains.rider.model.RdOperationResult;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H$J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/resharper/ideaInterop/vfs/actions/FromToAction;", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "execute", "Lcom/jetbrains/rider/model/RdOperationResult;", "fromTo", "Lcom/jetbrains/rider/model/RdFromTo;", "perform", "", "fromVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "destinationParent", "name", "", "skipExisting", "", "existingFile", "rider"})
public abstract class FromToAction {
    @NotNull
    private final Logger logger;

    @NotNull
    public final RdOperationResult execute(@NotNull RdFromTo fromTo) {
        Intrinsics.checkParameterIsNotNull((Object)fromTo, (String)"fromTo");
        VirtualFile fromVirtualFile = ComponentContainerUtilKt.toVirtualFile(fromTo.getFrom());
        if (fromVirtualFile == null) {
            this.logger.info("Cannot get 'From' virtual file. Cancelling...");
            return new RdOperationResult(false, "Cannot get 'From' virtual file");
        }
        File ioFile = new File(fromTo.getTo());
        VirtualFile destinationParent = ComponentContainerUtilKt.toVirtualFile(ioFile.getParent());
        if (destinationParent == null) {
            this.logger.info("Cannot get destination parent " + ioFile.getParent());
            return new RdOperationResult(false, "Cannot get destination parent " + ioFile.getParent());
        }
        VirtualFile existingFile = destinationParent.findChild(ioFile.getName());
        if (existingFile != null) {
            String string2 = ioFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ioFile.name");
            if (!this.skipExisting(existingFile, destinationParent, string2)) {
                if (fromTo.getOverwrite()) {
                    try {
                        ApplicationKt.getApplication().runWriteAction(new Runnable(this, existingFile){
                            final /* synthetic */ FromToAction this$0;
                            final /* synthetic */ VirtualFile $existingFile;

                            public final void run() {
                                this.$existingFile.delete((Object)this.this$0);
                            }
                            {
                                this.this$0 = fromToAction;
                                this.$existingFile = virtualFile;
                            }
                        });
                    }
                    catch (Throwable t2) {
                        this.logger.error(t2);
                        return new RdOperationResult(false, t2.getMessage());
                    }
                } else {
                    this.logger.info("Destination file " + existingFile + " already exists");
                    return new RdOperationResult(false, "Destination file " + existingFile + " already exists");
                }
            }
        }
        try {
            ApplicationKt.getApplication().runWriteAction(new Runnable(this, fromVirtualFile, destinationParent, ioFile){
                final /* synthetic */ FromToAction this$0;
                final /* synthetic */ VirtualFile $fromVirtualFile;
                final /* synthetic */ VirtualFile $destinationParent;
                final /* synthetic */ File $ioFile;

                public final void run() {
                    String string2 = this.$ioFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ioFile.name");
                    this.this$0.perform(this.$fromVirtualFile, this.$destinationParent, string2);
                }
                {
                    this.this$0 = fromToAction;
                    this.$fromVirtualFile = virtualFile;
                    this.$destinationParent = virtualFile2;
                    this.$ioFile = file2;
                }
            });
        }
        catch (Throwable t3) {
            this.logger.error(t3);
            return new RdOperationResult(false, t3.getMessage());
        }
        return new RdOperationResult(true, null);
    }

    protected abstract boolean skipExisting(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @NotNull String var3);

    protected abstract void perform(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @NotNull String var3);

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public FromToAction(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
    }
}

