/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.ideaInterop.welcomeWizard.editosScheme;

import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.resharper.colorSchemes.EditorSchemeInfo;
import com.jetbrains.resharper.utils.StringUtilKt;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/ideaInterop/welcomeWizard/editosScheme/WizardEditorScreenshotUtil;", "", "()V", "IMG_FORMAT", "", "convertName", "info", "Lcom/jetbrains/resharper/colorSchemes/EditorSchemeInfo;", "imageFileName", "saveImage", "", "path", "image", "Ljava/awt/image/BufferedImage;", "scaleFactorSuffix", "rider"})
public final class WizardEditorScreenshotUtil {
    private static final String IMG_FORMAT = "png";
    public static final WizardEditorScreenshotUtil INSTANCE;

    public final void saveImage(@NotNull String path, @NotNull BufferedImage image, @NotNull EditorSchemeInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        File file2 = new File(path, this.imageFileName(info));
        ImageIO.write((RenderedImage)image, IMG_FORMAT, file2);
    }

    @NotNull
    public final String imageFileName(@NotNull EditorSchemeInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        return this.convertName(info) + this.scaleFactorSuffix() + "." + IMG_FORMAT;
    }

    private final String convertName(EditorSchemeInfo info) {
        String string2;
        String string3 = string2 = info.getName();
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return StringUtilKt.toValidIdentifier(string4);
    }

    private final String scaleFactorSuffix() {
        boolean bl;
        int scale = JBUI.scale((int)1);
        boolean bl2 = bl = scale == 1 || scale == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "You should use EditorPreviewScreenshotGenerator only on machine with 100% or 200% DPI";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return scale == 2 || UIUtil.isAppleRetina() ? "@2x" : "";
    }

    private WizardEditorScreenshotUtil() {
        INSTANCE = this;
        IMG_FORMAT = IMG_FORMAT;
    }

    static {
        new WizardEditorScreenshotUtil();
    }
}

