/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.internal.flags;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.resharper.internal.flags.IRiderInternalFlag;
import com.jetbrains.resharper.internal.flags.RiderInternalFlags;
import com.jetbrains.resharper.internal.flags.RiderInternalFlagsUi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi;", "Lcom/intellij/openapi/Disposable;", "()V", "myContent", "Ljavax/swing/JPanel;", "myDescriptionLabel", "Ljavax/swing/JTextArea;", "myModel", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$MyTableModel;", "myRestoreDefaultsAction", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$RestoreDefaultsAction;", "myTable", "Lcom/intellij/ui/table/JBTable;", "dispose", "", "processClose", "restoreDefaults", "revalidateActions", "show", "", "Companion", "Index", "MyEditor", "MyRenderer", "MyTableModel", "RestoreDefaultsAction", "rider"})
public class RiderInternalFlagsUi
implements Disposable {
    private final JTextArea myDescriptionLabel;
    private final JPanel myContent;
    private final RestoreDefaultsAction myRestoreDefaultsAction;
    private final MyTableModel myModel;
    private final JBTable myTable;
    private static final String RECENT_PROPERTIES_KEY = "RiderInternalFlagsRecentKeys";
    private static final HashMap<Color, Icon> icons_cache;
    public static final Companion Companion;

    public final boolean show() {
        DialogWrapper dialog2 = new DialogWrapper(this, true){
            private AbstractAction myCloseAction;
            final /* synthetic */ RiderInternalFlagsUi this$0;

            @Nullable
            protected JComponent createNorthPanel() {
                if (!ApplicationManager.getApplication().isInternal()) {
                    JLabel jLabel;
                    String warningText = "<b>Changing these values may cause unwanted behavior of " + ApplicationNamesInfo.getInstance().getFullProductName() + ". Please do not change these unless you have been asked.</b>";
                    JLabel $receiver = jLabel = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)warningText));
                    $receiver.setIcon(UIUtil.getWarningIcon());
                    $receiver.setForeground((Color)JBColor.RED);
                    JLabel warningLabel = jLabel;
                    return warningLabel;
                }
                return null;
            }

            protected void dispose() {
                super.dispose();
                this.this$0.dispose();
            }

            @NotNull
            protected JPanel createCenterPanel() {
                return RiderInternalFlagsUi.access$getMyContent$p(this.this$0);
            }

            @NotNull
            protected String getDimensionServiceKey() {
                return "RiderInternalFlags";
            }

            @NotNull
            public JBTable getPreferredFocusedComponent() {
                return RiderInternalFlagsUi.access$getMyTable$p(this.this$0);
            }

            @NotNull
            protected Action[] createActions() {
                Action[] elements$iv = new Action[]{RiderInternalFlagsUi.access$getMyRestoreDefaultsAction$p(this.this$0), this.myCloseAction};
                return (Action[])((Object[])elements$iv);
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                AbstractAction abstractAction = this.myCloseAction = (AbstractAction)new AbstractAction(this, "Close"){
                    final /* synthetic */ show.dialog.1 this$0;

                    public void actionPerformed(@NotNull ActionEvent e2) {
                        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                        TableCellEditor tableCellEditor = RiderInternalFlagsUi.access$getMyTable$p(this.this$0.this$0).getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                        }
                        RiderInternalFlagsUi.access$processClose(this.this$0.this$0);
                        show.dialog.1.access$doOKAction(this.this$0);
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1);
                    }
                };
                if (abstractAction == null) {
                    Intrinsics.throwNpe();
                }
                abstractAction.putValue("DefaultAction", true);
            }

            public void doCancelAction() {
                TableCellEditor cellEditor;
                TableCellEditor tableCellEditor = cellEditor = RiderInternalFlagsUi.access$getMyTable$p(this.this$0).getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                RiderInternalFlagsUi.access$processClose(this.this$0);
                super.doCancelAction();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
                this.setTitle("Rider Internal Flags");
                this.setModal(true);
                this.init();
                RiderInternalFlagsUi.access$revalidateActions($outer);
            }

            public static final /* synthetic */ void access$doOKAction(show.dialog.1 $this) {
                $this.doOKAction();
            }
        };
        return dialog2.showAndGet();
    }

    private final void processClose() {
        if (RiderInternalFlags.Companion.getInstance().isRestartNeeded()) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
            }
            ApplicationEx app = (ApplicationEx)application;
            ApplicationInfo info = ApplicationInfo.getInstance();
            int r2 = Messages.showOkCancelDialog((Component)this.myContent, (String)("You need to restart " + info.getVersionName() + " for the changes to take effect"), (String)"Restart Required", (String)(app.isRestartCapable() ? "Restart Now" : "Shutdown Now"), (String)(app.isRestartCapable() ? "Restart Later" : "Shutdown Later"), (Icon)Messages.getQuestionIcon());
            if (r2 == 0) {
                ApplicationManager.getApplication().invokeLater(new Runnable(app){
                    final /* synthetic */ ApplicationEx $app;

                    public final void run() {
                        this.$app.restart(true);
                    }
                    {
                        this.$app = applicationEx;
                    }
                }, ModalityState.NON_MODAL);
            }
        }
    }

    private final void restoreDefaults() {
        int r2 = Messages.showYesNoDialog((Component)this.myContent, (String)"Are you sure you want to revert Rider Internal Flags settings to default values?", (String)"Revert To Defaults", (Icon)Messages.getQuestionIcon());
        if (r2 == 0) {
            RiderInternalFlags.Companion.getInstance().restoreDefaults();
            this.myModel.fireChanged();
            this.revalidateActions();
        }
    }

    private final void revalidateActions() {
        this.myRestoreDefaultsAction.setEnabled(!RiderInternalFlags.Companion.getInstance().isInDefaultState());
    }

    public void dispose() {
    }

    public RiderInternalFlagsUi() {
        TableColumn tableColumn;
        JTextArea jTextArea;
        JComponent jComponent = new JTextArea(4, 50);
        RiderInternalFlagsUi riderInternalFlagsUi = this;
        JComponent $receiver = jComponent;
        ((JTextArea)$receiver).setWrapStyleWord(true);
        ((JTextArea)$receiver).setLineWrap(true);
        ((JTextComponent)$receiver).setEditable(false);
        riderInternalFlagsUi.myDescriptionLabel = jTextArea = jComponent;
        jComponent = new JPanel();
        riderInternalFlagsUi = this;
        $receiver = (JPanel)jComponent;
        $receiver.setLayout(new BorderLayout(10, 4));
        jTextArea = jComponent;
        riderInternalFlagsUi.myContent = (JPanel)((Object)jTextArea);
        this.myModel = new MyTableModel();
        jComponent = new JBTable((TableModel)this.myModel);
        riderInternalFlagsUi = this;
        $receiver = (JBTable)jComponent;
        MyRenderer renderer = new MyRenderer();
        $receiver.setCellSelectionEnabled(true);
        $receiver.setEnableAntialiasing(true);
        Object object = $receiver.getColumnModel();
        Object $receiver2 = object;
        TableColumn $receiver3 = tableColumn = $receiver2.getColumn(Index.Companion.getKey());
        $receiver3.setCellRenderer(renderer);
        $receiver3.setHeaderValue("Key");
        $receiver3 = tableColumn = $receiver2.getColumn(Index.Companion.getValue());
        $receiver3.setCellRenderer(renderer);
        $receiver3.setHeaderValue("Value");
        $receiver3.setCellEditor(new MyEditor());
        $receiver.setStriped(true);
        jTextArea = jComponent;
        riderInternalFlagsUi.myTable = (JBTable)jTextArea;
        JScrollPane label = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionLabel);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)label, "Center");
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Description", (boolean)false));
        this.myContent.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.myTable)), "Center");
        this.myContent.add((Component)descriptionPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                int selected = myTable.getSelectedRow();
                if (selected != -1) {
                    IRiderInternalFlag value2 = myModel.getRiderInternalFlagsValue(selected);
                    String requiredText = value2.isRestartRequired() ? "\nRequires IDE restart." : "";
                    String defaultText = "\nDefault value: " + value2.defaultValueAsString();
                    myDescriptionLabel.setText(value2.getDesc() + requiredText + defaultText);
                } else {
                    myDescriptionLabel.setText(null);
                }
            }
        });
        this.myRestoreDefaultsAction = new RestoreDefaultsAction();
        object = new TableSpeedSearch((JTable)this.myTable);
        $receiver2 = (TableSpeedSearch)((Object)object);
        ((SpeedSearchBase)((Object)$receiver2)).setComparator(new SpeedSearchComparator(false));
        final TableSpeedSearch search = (TableSpeedSearch)((Object)object);
        this.myTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e2) {
                IRiderInternalFlag rv;
                int row;
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                if (e2.getKeyCode() == 32 && (row = myTable.getSelectedRow()) != -1 && (rv = myModel.getRiderInternalFlagsValue(row)).isBoolean()) {
                    rv.setAnyValue(!rv.asBoolean());
                    Companion.keyChanged(rv.getKey());
                    int[] nArray = new int[]{Index.Companion.getKey(), Index.Companion.getValue()};
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        int i3 = nArray[i2];
                        myModel.fireTableCellUpdated(row, i3);
                    }
                    this.revalidateActions();
                    if (search.isPopupActive()) {
                        search.hidePopup();
                    }
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        RECENT_PROPERTIES_KEY = RECENT_PROPERTIES_KEY;
        icons_cache = new HashMap();
    }

    @NotNull
    public static final /* synthetic */ JPanel access$getMyContent$p(RiderInternalFlagsUi $this) {
        return $this.myContent;
    }

    @NotNull
    public static final /* synthetic */ RestoreDefaultsAction access$getMyRestoreDefaultsAction$p(RiderInternalFlagsUi $this) {
        return $this.myRestoreDefaultsAction;
    }

    public static final /* synthetic */ void access$processClose(RiderInternalFlagsUi $this) {
        $this.processClose();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$Index;", "", "()V", "Companion", "rider"})
    private static final class Index {
        private static final int key = 0;
        private static final int value = 1;
        public static final Companion Companion = new Companion(null);

        static {
            value = 1;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$Index$Companion;", "", "()V", "key", "", "getKey", "()I", "value", "getValue", "rider"})
        public static final class Companion {
            public final int getKey() {
                return key;
            }

            public final int getValue() {
                return value;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tJ\b\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$MyTableModel;", "Ljavax/swing/table/AbstractTableModel;", "()V", "myAll", "", "Lcom/jetbrains/resharper/internal/flags/IRiderInternalFlag;", "fireChanged", "", "getColumnCount", "", "getRiderInternalFlagsValue", "rowIndex", "getRowCount", "getValueAt", "", "columnIndex", "isCellEditable", "", "rider"})
    private static final class MyTableModel
    extends AbstractTableModel {
        private final List<IRiderInternalFlag> myAll = RiderInternalFlags.Companion.getInstance().getAll();

        @Override
        public int getRowCount() {
            return this.myAll.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == Index.Companion.getValue();
        }

        public final void fireChanged() {
            this.fireTableDataChanged();
        }

        @NotNull
        public final IRiderInternalFlag getRiderInternalFlagsValue(int rowIndex) {
            return this.myAll.get(rowIndex);
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            IRiderInternalFlag value2 = this.getRiderInternalFlagsValue(rowIndex);
            int n2 = columnIndex;
            return n2 == Index.Companion.getKey() ? value2.getKey() : (n2 == Index.Companion.getValue() ? value2.asString() : value2);
        }

        public MyTableModel() {
            final List recent = Companion.getRecent();
            Collections.sort(this.myAll, new Comparator<T>(){

                @Override
                public final int compare(IRiderInternalFlag o1, IRiderInternalFlag o2) {
                    boolean c2;
                    String key1 = o1.getKey();
                    boolean changed1 = o1.isChangedFromDefault();
                    boolean changed2 = o2.isChangedFromDefault();
                    if (changed1 && !changed2) {
                        return -1;
                    }
                    if (!changed1 && changed2) {
                        return 1;
                    }
                    String key2 = o2.getKey();
                    int i1 = recent.indexOf(key1);
                    int i2 = recent.indexOf(key2);
                    boolean c1 = i1 != -1;
                    boolean bl = c2 = i2 != -1;
                    if (c1 && !c2) {
                        return -1;
                    }
                    if (!c1 && c2) {
                        return 1;
                    }
                    if (c1 && c2) {
                        return i1 - i2;
                    }
                    return StringsKt.compareTo((String)key1, (String)key2, (boolean)true);
                }
            });
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$MyRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "myLabel", "Ljavax/swing/JLabel;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "rider"})
    private static final class MyRenderer
    implements TableCellRenderer {
        private final JLabel myLabel = new JLabel();

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel jLabel;
            Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            TableModel tableModel2 = table2.getModel();
            if (tableModel2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.internal.flags.RiderInternalFlagsUi.MyTableModel");
            }
            IRiderInternalFlag v2 = ((MyTableModel)tableModel2).getRiderInternalFlagsValue(row);
            this.myLabel.setIcon(null);
            this.myLabel.setText(null);
            this.myLabel.setHorizontalAlignment(2);
            Color fg = isSelected ? table2.getSelectionForeground() : (v2.isChangedFromDefault() ? (Color)JBColor.blue : table2.getForeground());
            Color bg = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            int n2 = column;
            if (n2 == Index.Companion.getKey()) {
                this.myLabel.setText(v2.getKey());
            } else if (n2 == Index.Companion.getValue()) {
                if (v2.isColor()) {
                    this.myLabel.setIcon(Companion.createColoredIcon(v2.asColor()));
                } else {
                    if (v2.isBoolean()) {
                        JCheckBox box = new JCheckBox();
                        box.setSelected(v2.asBoolean());
                        box.setBackground(bg);
                        return box;
                    }
                    this.myLabel.setText(v2.asString());
                }
            }
            JLabel $receiver = jLabel = this.myLabel;
            $receiver.setOpaque(true);
            $receiver.setFont(this.myLabel.getFont().deriveFont(v2.isChangedFromDefault() ? 1 : 0));
            $receiver.setForeground(fg);
            $receiver.setBackground(bg);
            return this.myLabel;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\tH\u0016J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$MyEditor;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellEditor;", "(Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi;)V", "myCheckBox", "Ljavax/swing/JCheckBox;", "myField", "Ljavax/swing/JTextField;", "myValue", "Lcom/jetbrains/resharper/internal/flags/IRiderInternalFlag;", "getCellEditorValue", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "row", "", "column", "stopCellEditing", "rider"})
    private final class MyEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JTextField myField = new JTextField();
        private final JCheckBox myCheckBox = new JCheckBox();
        private IRiderInternalFlag myValue;

        @Override
        @Nullable
        public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, int row, int column) {
            IRiderInternalFlag iRiderInternalFlag;
            IRiderInternalFlag value3;
            Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            TableModel tableModel2 = table2.getModel();
            if (tableModel2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.internal.flags.RiderInternalFlagsUi.MyTableModel");
            }
            IRiderInternalFlag iRiderInternalFlag2 = this.myValue = ((MyTableModel)tableModel2).getRiderInternalFlagsValue(row);
            if (iRiderInternalFlag2 == null) {
                Intrinsics.throwNpe();
            }
            if ((value3 = (iRiderInternalFlag = iRiderInternalFlag2)).isColor()) {
                Color color = ColorChooser.chooseColor((Component)table2, (String)"Choose color", (Color)(value3.isColor() ? value3.asColor() : Color.WHITE));
                if (color != null) {
                    IRiderInternalFlag iRiderInternalFlag3 = this.myValue;
                    if (iRiderInternalFlag3 == null) {
                        Intrinsics.throwNpe();
                    }
                    iRiderInternalFlag3.setAnyValue(color);
                    Companion.keyChanged(value3.getKey());
                }
                return null;
            }
            if (value3.isBoolean()) {
                this.myCheckBox.setSelected(value3.asBoolean());
                this.myCheckBox.setBackground(table2.getBackground());
                return this.myCheckBox;
            }
            this.myField.setText(value3.asString());
            this.myField.setBorder(null);
            this.myField.selectAll();
            return this.myField;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean stopCellEditing() {
            IRiderInternalFlag iRiderInternalFlag = this.myValue;
            if (iRiderInternalFlag != null) {
                IRiderInternalFlag iRiderInternalFlag2 = iRiderInternalFlag;
                IRiderInternalFlag value2 = iRiderInternalFlag2;
                if (value2.isBoolean()) {
                    value2.setAnyValue(this.myCheckBox.isSelected());
                } else {
                    void $receiver$iv;
                    String string2 = this.myField.getText();
                    IRiderInternalFlag iRiderInternalFlag3 = value2;
                    void v1 = $receiver$iv;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    CharSequence $receiver$iv$iv = (CharSequence)v1;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    String string3 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    iRiderInternalFlag3.setAnyValue(string3);
                }
                Companion.keyChanged(value2.getKey());
            }
            RiderInternalFlagsUi.this.revalidateActions();
            return super.stopCellEditing();
        }

        @Override
        @NotNull
        public IRiderInternalFlag getCellEditorValue() {
            IRiderInternalFlag iRiderInternalFlag = this.myValue;
            if (iRiderInternalFlag == null) {
                Intrinsics.throwNpe();
            }
            return iRiderInternalFlag;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$RestoreDefaultsAction;", "Ljavax/swing/AbstractAction;", "(Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "rider"})
    private final class RestoreDefaultsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(@NotNull ActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            RiderInternalFlagsUi.this.restoreDefaults();
        }

        public RestoreDefaultsAction() {
            super("Restore Defaults");
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/resharper/internal/flags/RiderInternalFlagsUi$Companion;", "", "()V", "RECENT_PROPERTIES_KEY", "", "getRECENT_PROPERTIES_KEY", "()Ljava/lang/String;", "icons_cache", "Ljava/util/HashMap;", "Ljava/awt/Color;", "Ljavax/swing/Icon;", "getIcons_cache", "()Ljava/util/HashMap;", "recent", "", "getRecent", "()Ljava/util/List;", "createColoredIcon", "color", "keyChanged", "", "key", "rider"})
    public static final class Companion {
        private final String getRECENT_PROPERTIES_KEY() {
            return RECENT_PROPERTIES_KEY;
        }

        private final List<String> getRecent() {
            List list2;
            String value2 = PropertiesComponent.getInstance().getValue(Companion.getRECENT_PROPERTIES_KEY());
            if (StringUtil.isEmpty((String)value2)) {
                list2 = new ArrayList(0);
            } else {
                String string2 = value2;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                List list3 = StringUtil.split((String)string2, (String)"=");
                list2 = list3;
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"StringUtil.split(value!!, \"=\")");
            }
            return list2;
        }

        private final void keyChanged(String key) {
            List<String> list2;
            List<String> $receiver = list2 = this.getRecent();
            $receiver.remove(key);
            $receiver.add(0, key);
            List<String> recent = list2;
            PropertiesComponent.getInstance().setValue(this.getRECENT_PROPERTIES_KEY(), StringUtil.join((Collection)recent, (String)"="), "");
        }

        private final HashMap<Color, Icon> getIcons_cache() {
            return icons_cache;
        }

        private final Icon createColoredIcon(Color color) {
            Icon icon = this.getIcons_cache().get(color);
            if (icon != null) {
                return icon;
            }
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(16, 16, 3);
            Graphics g2 = image.getGraphics();
            g2.setColor(color);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            icon = new ImageIcon(image);
            this.getIcons_cache().put(color, icon);
            return icon;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

