/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.internal.markup;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.daemon.util.HighlightersTestUtilKt;
import com.jetbrains.resharper.internal.RiderInternalShowTextDiffManager;
import com.jetbrains.resharper.internal.TextDiffPresentationData;
import com.jetbrains.resharper.internal.dump.DumpAction;
import com.jetbrains.resharper.util.idea.DataContextExKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/internal/markup/CompareBackendAndFrontendHighlighterTrees;", "Lcom/jetbrains/resharper/internal/dump/DumpAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "rider"})
public final class CompareBackendAndFrontendHighlighterTrees
extends DumpAction {
    public void actionPerformed(@Nullable AnActionEvent e2) {
        if (e2 == null) {
            return;
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Editor editor = DataContextExKt.getEditor(e2.getDataContext());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Project project4 = project3;
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Document document = editor2.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        String frontendTree = HighlightersTestUtilKt.getFrontendDump(project4, document);
        Project project5 = project3;
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        Document document2 = editor2.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"editor.document");
        String backendTree = HighlightersTestUtilKt.getBackendDumpSync(project5, document2);
        TextDiffPresentationData highlighters = new TextDiffPresentationData("Backend Tree", backendTree);
        TextDiffPresentationData foldings = new TextDiffPresentationData("Frontend Tree", frontendTree);
        RiderInternalShowTextDiffManager.INSTANCE.showDiff("Compare Backend vs Frontend Trees", highlighters, foldings);
    }

    public CompareBackendAndFrontendHighlighterTrees() {
        super("Compare Backend & Frontend Trees");
    }
}

