/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.internal.markup;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Segment;
import com.jetbrains.resharper.daemon.components.HighlighterRegistrationHostImpl;
import com.jetbrains.resharper.daemon.util.HighlighterTextAnnotator;
import com.jetbrains.resharper.daemon.util.HighlightersDumpUtilKt;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.resharper.daemon.util.SegmentComparator;
import com.jetbrains.resharper.internal.RiderInternalShowTextDiffManager;
import com.jetbrains.resharper.internal.TextDiffPresentationData;
import com.jetbrains.resharper.internal.dump.DumpAction;
import com.jetbrains.resharper.internal.markup.DumpRiderFoldingsAction;
import com.jetbrains.resharper.util.idea.DataContextExKt;
import com.jetbrains.rider.model.highlighterRegistration.RiderHighlighterModelKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/resharper/internal/markup/DumpRiderFoldingsAction;", "Lcom/jetbrains/resharper/internal/dump/DumpAction;", "()V", "registrationHost", "Lcom/jetbrains/resharper/daemon/components/HighlighterRegistrationHostImpl;", "getRegistrationHost", "()Lcom/jetbrains/resharper/daemon/components/HighlighterRegistrationHostImpl;", "registrationHost$delegate", "Lkotlin/Lazy;", "tagName", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/Segment;", "", "getTagName", "()Lkotlin/jvm/functions/Function1;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "highlighterFilter", "", "h", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "rider"})
public final class DumpRiderFoldingsAction
extends DumpAction {
    @NotNull
    private final Lazy registrationHost$delegate = LazyKt.lazy((Function0)registrationHost.2.INSTANCE);
    @NotNull
    private final Function1<Segment, String> tagName = tagName.1.INSTANCE;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@Nullable AnActionEvent e2) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        void $receiver$iv$iv2;
        Object[] $receiver$iv2;
        AnActionEvent anActionEvent = e2;
        if (anActionEvent == null || (anActionEvent = anActionEvent.getDataContext()) == null) {
            return;
        }
        AnActionEvent dataContext = anActionEvent;
        Editor editor = DataContextExKt.getEditor((DataContext)dataContext);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        MarkupModel markup = DocumentMarkupModel.forDocument(editor2.getDocument(), editor2.getProject(), true);
        Object[] objectArray = $receiver$iv2 = (Object[])markup.getAllHighlighters();
        Object[] destination$iv$iv = (Object[])new ArrayList();
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv2).length; ++i2) {
            RangeHighlighter it;
            void element$iv$iv = $receiver$iv$iv2[i2];
            RangeHighlighter rangeHighlighter = it = (RangeHighlighter)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter, (String)"it");
            if (!this.highlighterFilter(rangeHighlighter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List foldingHighlighters = (List)destination$iv$iv;
        destination$iv$iv = $receiver$iv = (Object[])editor2.getFoldingModel().getAllFoldRegions();
        Collection destination$iv$iv2 = new ArrayList();
        for (int element$iv$iv = 0; element$iv$iv < ((void)$receiver$iv$iv).length; ++element$iv$iv) {
            void element$iv$iv2 = $receiver$iv$iv[element$iv$iv];
            FoldRegion it = (FoldRegion)element$iv$iv2;
            if (!it.isValid()) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List foldRegions = (List)destination$iv$iv2;
        String string2 = editor2.getDocument().getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"editor.document.text");
        String highlightersDump = HighlightersDumpUtilKt.annotateTextWithRangeHighlighters(string2, foldingHighlighters, this.tagName);
        String string3 = editor2.getDocument().getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"editor.document.text");
        String foldingsDump = HighlighterTextAnnotator.INSTANCE.annotateWithTags(string3, foldRegions, SegmentComparator.INSTANCE, this.tagName);
        TextDiffPresentationData highlighters = new TextDiffPresentationData("Document Highlighter Tree Version", highlightersDump);
        TextDiffPresentationData foldings = new TextDiffPresentationData("Editor Folding Model Version", foldingsDump);
        RiderInternalShowTextDiffManager.INSTANCE.showDiff("Foldings Models", highlighters, foldings);
    }

    @NotNull
    public final HighlighterRegistrationHostImpl getRegistrationHost() {
        Lazy lazy = this.registrationHost$delegate;
        DumpRiderFoldingsAction dumpRiderFoldingsAction = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (HighlighterRegistrationHostImpl)lazy.getValue();
    }

    public final boolean highlighterFilter(@NotNull RangeHighlighter h2) {
        Intrinsics.checkParameterIsNotNull((Object)h2, (String)"h");
        Integer n2 = HighlightersUtilKt.getTryGetRegistryKey(h2);
        if (n2 == null) {
            return false;
        }
        int registryKey = n2;
        return Intrinsics.areEqual((Object)((Object)this.getRegistrationHost().getHighlighterKind(registryKey)), (Object)((Object)RiderHighlighterModelKind.FOLDING));
    }

    @NotNull
    public final Function1<Segment, String> getTagName() {
        return this.tagName;
    }

    public DumpRiderFoldingsAction() {
        super("Dump Code Foldings");
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DumpRiderFoldingsAction.class), "registrationHost", "getRegistrationHost()Lcom/jetbrains/resharper/daemon/components/HighlighterRegistrationHostImpl;"))};
    }
}

