/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.navigation;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.navigation.NavigationHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.ProjectModelKey;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerSelectInTarget;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.Navigation;
import com.jetbrains.rider.model.ToolWindowNavigation;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/navigation/NavigationHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileEditorManager;Lcom/jetbrains/resharper/editors/TextControlHost;)V", "lifetime", "Lcom/jetbrains/rider/util/lifetime/LifetimeDefinition;", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTextControlHost", "()Lcom/jetbrains/resharper/editors/TextControlHost;", "disposeComponent", "", "initComponent", "navigateToToolWindow", "navigation", "Lcom/jetbrains/rider/model/ToolWindowNavigation;", "performNavigation", "Lcom/jetbrains/rider/model/Navigation;", "rider"})
public class NavigationHost
extends AbstractProjectComponent
implements DumbAware {
    private final LifetimeDefinition lifetime;
    private final Logger myLogger;
    @NotNull
    private final Project project;
    private final FileEditorManager fileEditorManager;
    @NotNull
    private final TextControlHost textControlHost;

    public void initComponent() {
        ApplicationKt.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ NavigationHost this$0;

            public final void run() {
                SolutionHostExtensionsKt.getSolution(this.this$0.getProject()).getNavigate().advise(NavigationHost.access$getLifetime$p(this.this$0).getLifetime(), (Function1<Navigation, Unit>)((Function1)new Function1<Navigation, Unit>(this){
                    final /* synthetic */ initComponent.1 this$0;

                    public final void invoke(@NotNull Navigation navigation) {
                        Intrinsics.checkParameterIsNotNull((Object)navigation, (String)"navigation");
                        ApplicationKt.getApplication().assertIsDispatchThread();
                        NavigationHost.access$performNavigation(this.this$0.this$0, navigation);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = navigationHost;
            }
        });
    }

    public void disposeComponent() {
        this.lifetime.terminate();
    }

    private final void performNavigation(Navigation navigation) {
        this.myLogger.info("Performing navigation... " + navigation);
        CommandProcessor.getInstance().executeCommand(this.project, new Runnable(this, navigation){
            final /* synthetic */ NavigationHost this$0;
            final /* synthetic */ Navigation $navigation;

            public final void run() {
                Navigation navigation = this.$navigation;
                if (!(navigation instanceof ToolWindowNavigation)) {
                    throw (Throwable)new IllegalArgumentException("Navigation type: " + this.$navigation.getClass().getSimpleName());
                }
                NavigationHost.access$navigateToToolWindow(this.this$0, (ToolWindowNavigation)this.$navigation);
            }
            {
                this.this$0 = navigationHost;
                this.$navigation = navigation;
            }
        }, "", null);
    }

    private final void navigateToToolWindow(ToolWindowNavigation navigation) {
        if (Intrinsics.areEqual((Object)navigation.getToolWindowId(), (Object)"SolutionExplorer")) {
            EditableEntityId documentId = navigation.getTextControlId().getDocumentId();
            int projectModelId = documentId.getProjectModelElementId();
            if (projectModelId != 0) {
                ProjectModelKey key = new ProjectModelKey(projectModelId);
                SolutionExplorerExtensionsKt.navigate(this.project, key, true);
            } else {
                VirtualFile virtualFile;
                String filePath = documentId.getFilePath();
                VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)true);
                if (virtualFile2 == null) {
                    throw (Throwable)new Exception("Can't create virtual file for path " + filePath);
                }
                VirtualFile virtualFile3 = virtualFile = virtualFile2;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                SolutionExplorerSelectInTarget.Companion.navigate(this.project, virtualFile3, true);
            }
            return;
        }
        throw (Throwable)new UnsupportedOperationException("not implemented");
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TextControlHost getTextControlHost() {
        return this.textControlHost;
    }

    public NavigationHost(@NotNull Project project2, @NotNull FileEditorManager fileEditorManager, @NotNull TextControlHost textControlHost) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileEditorManager, (String)"fileEditorManager");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        super(project2);
        this.project = project2;
        this.fileEditorManager = fileEditorManager;
        this.textControlHost = textControlHost;
        this.lifetime = Lifetime.Companion.create(Lifetime.Companion.getEternal());
        NavigationHost navigationHost = this;
        Logger logger2 = Logger.getInstance(NavigationHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        navigationHost.myLogger = logger = logger2;
    }

    @NotNull
    public static final /* synthetic */ LifetimeDefinition access$getLifetime$p(NavigationHost $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ void access$performNavigation(NavigationHost $this, @NotNull Navigation navigation) {
        $this.performNavigation(navigation);
    }

    public static final /* synthetic */ void access$navigateToToolWindow(NavigationHost $this, @NotNull ToolWindowNavigation navigation) {
        $this.navigateToToolWindow(navigation);
    }
}

