/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.resharper.icons.ReSharperAssemblyExplorerIcons;
import com.jetbrains.resharper.icons.ReSharperCommonIcons;
import com.jetbrains.resharper.nuget.RiderNuGetCacheManager;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.RdNuGetCacheFolder;
import com.jetbrains.rider.util.reactive.IViewableMap;
import com.jetbrains.rider.util.reactive.Signal;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r*\u0001/\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020(2\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010+J&\u0010,\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010+J5\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0+H\u0002\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\u0002072\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0+J\u0016\u00109\u001a\u0002072\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0+J\u0006\u0010:\u001a\u000207J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0012H\u0002J\u000e\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010?\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u000bJ\u0010\u0010@\u001a\u00020(2\b\u0010>\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010A\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010B\u001a\u00020(2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR/\u0010\u000e\u001a#\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u00120\u000f\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n \u0011*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\u00020\u0010*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006D"}, d2={"Lcom/jetbrains/resharper/nuget/RiderNuGetCacheManager;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "AutoClearModeOff", "", "AutoClearModeOn", "AutoClearModeUndef", "allFolders", "", "Lcom/jetbrains/rider/model/RdNuGetCacheFolder;", "getAllFolders", "()Ljava/util/List;", "folderSizes", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "isBusy", "", "()Z", "setBusy", "(Z)V", "lock", "Ljava/lang/Object;", "getProject", "()Lcom/intellij/openapi/project/Project;", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "propertiesPrefix", "update", "Lcom/jetbrains/rider/util/reactive/Signal$Void;", "getUpdate", "()Lcom/jetbrains/rider/util/reactive/Signal$Void;", "propertiesKey", "getPropertiesKey", "(Lcom/jetbrains/rider/model/RdNuGetCacheFolder;)Ljava/lang/String;", "autoClear", "", "autoClearAll", "callback", "Lkotlin/Function0;", "clear", "targets", "createAction", "com/jetbrains/resharper/nuget/RiderNuGetCacheManager$createAction$1", "title", "icon", "Ljavax/swing/Icon;", "useBusyFlag", "action", "(Ljava/lang/String;Ljavax/swing/Icon;ZLkotlin/jvm/functions/Function0;)Lcom/jetbrains/resharper/nuget/RiderNuGetCacheManager$createAction$1;", "createClearAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getFolder", "createOpenFolderAction", "createRecalculateAction", "formatFileSize", "size", "getAutoClearMode", "folder", "getFolderSize", "openFolder", "recalculate", "setAutoClearMode", "value", "rider"})
public final class RiderNuGetCacheManager
extends AbstractProjectComponent {
    private final PropertiesComponent properties;
    private final String propertiesPrefix = "RiderNuGetCacheManager.AutoClear.";
    private final int AutoClearModeUndef = 0;
    private final int AutoClearModeOn = 1;
    private final int AutoClearModeOff = 2;
    private final ConcurrentMap<String, Long> folderSizes;
    private final Object lock;
    private boolean isBusy;
    @NotNull
    private final Signal.Void update;
    @NotNull
    private final Project project;

    private final String getPropertiesKey(@NotNull RdNuGetCacheFolder $receiver) {
        return this.propertiesPrefix + $receiver.getId();
    }

    @NotNull
    public final List<RdNuGetCacheFolder> getAllFolders() {
        return CollectionsKt.toList((Iterable)SolutionHostExtensionsKt.getSolution(this.project).getNuGetHost().getCaches().getFolders().values());
    }

    public final boolean isBusy() {
        return this.isBusy;
    }

    public final void setBusy(boolean bl) {
        this.isBusy = bl;
    }

    @NotNull
    public final Signal.Void getUpdate() {
        return this.update;
    }

    public final boolean getAutoClearMode(@NotNull RdNuGetCacheFolder folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        if (!this.properties.isValueSet(this.getPropertiesKey(folder))) {
            int initialMode = Intrinsics.areEqual((Object)folder.getId(), (Object)"temp") ? this.AutoClearModeOn : this.AutoClearModeOff;
            this.properties.setValue(this.getPropertiesKey(folder), initialMode, this.AutoClearModeUndef);
        }
        return this.properties.getInt(this.getPropertiesKey(folder), this.AutoClearModeUndef) == this.AutoClearModeOn;
    }

    public final void setAutoClearMode(@NotNull RdNuGetCacheFolder folder, boolean value2) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        int mode = value2 ? this.AutoClearModeOn : this.AutoClearModeOff;
        this.properties.setValue(this.getPropertiesKey(folder), mode, this.AutoClearModeUndef);
        this.update.fire();
    }

    @NotNull
    public final String getFolderSize(@NotNull RdNuGetCacheFolder folder) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Long size = this.folderSizes.getOrDefault(folder.getId(), -1L);
        if (Intrinsics.compare((long)size, (long)0) < 0) {
            string2 = "?";
        } else {
            Long l2 = size;
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"size");
            string2 = this.formatFileSize(l2);
        }
        return string2;
    }

    private final String formatFileSize(long size) {
        return new DecimalFormat("#0.00").format((double)size / 1024.0 / 1024.0) + " MB";
    }

    @NotNull
    public final AnAction createRecalculateAction() {
        return RiderNuGetCacheManager.createAction$default(this, "Recalculate Folder Sizes", ReSharperCommonIcons.Companion.getRefresh(), false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderNuGetCacheManager this$0;

            public final void invoke() {
                this.this$0.recalculate(this.this$0.getAllFolders());
            }
            {
                this.this$0 = riderNuGetCacheManager;
                super(0);
            }
        }, 4, null);
    }

    @NotNull
    public final AnAction createClearAction(@NotNull Function0<RdNuGetCacheFolder> getFolder) {
        Intrinsics.checkParameterIsNotNull(getFolder, (String)"getFolder");
        Icon icon = AllIcons.Actions.GC;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Actions.GC");
        return RiderNuGetCacheManager.createAction$default(this, "Clear Selected Caches", icon, false, (Function0)new Function0<Unit>(this, getFolder){
            final /* synthetic */ RiderNuGetCacheManager this$0;
            final /* synthetic */ Function0 $getFolder;

            public final void invoke() {
                block0: {
                    RdNuGetCacheFolder rdNuGetCacheFolder;
                    RdNuGetCacheFolder rdNuGetCacheFolder2 = (RdNuGetCacheFolder)this.$getFolder.invoke();
                    if (rdNuGetCacheFolder2 == null) break block0;
                    RdNuGetCacheFolder it = rdNuGetCacheFolder = rdNuGetCacheFolder2;
                    RiderNuGetCacheManager.clear$default(this.this$0, CollectionsKt.listOf((Object)it), null, 2, null);
                }
            }
            {
                this.this$0 = riderNuGetCacheManager;
                this.$getFolder = function0;
                super(0);
            }
        }, 4, null);
    }

    @NotNull
    public final AnAction createOpenFolderAction(@NotNull Function0<RdNuGetCacheFolder> getFolder) {
        Intrinsics.checkParameterIsNotNull(getFolder, (String)"getFolder");
        return this.createAction("Open Folder", ReSharperAssemblyExplorerIcons.Companion.getFolderOpened(), false, (Function0<Unit>)((Function0)new Function0<Unit>(this, getFolder){
            final /* synthetic */ RiderNuGetCacheManager this$0;
            final /* synthetic */ Function0 $getFolder;

            public final void invoke() {
                this.this$0.openFolder((RdNuGetCacheFolder)this.$getFolder.invoke());
            }
            {
                this.this$0 = riderNuGetCacheManager;
                this.$getFolder = function0;
                super(0);
            }
        }));
    }

    public final void openFolder(@Nullable RdNuGetCacheFolder folder) {
        File file2;
        File file3;
        RdNuGetCacheFolder rdNuGetCacheFolder = folder;
        if (rdNuGetCacheFolder != null) {
            RdNuGetCacheFolder rdNuGetCacheFolder2;
            RdNuGetCacheFolder it = rdNuGetCacheFolder2 = rdNuGetCacheFolder;
            file3 = new File(it.getPath());
        } else {
            file3 = file2 = null;
        }
        if (file2 != null && file2.isDirectory() && file2.exists()) {
            ShowFilePathAction.openDirectory(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recalculate(@NotNull List<RdNuGetCacheFolder> targets) {
        Object object;
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.isBusy) {
                return;
            }
            this.isBusy = true;
            object = Unit.INSTANCE;
        }
        for (RdNuGetCacheFolder folder : targets) {
            object = this.folderSizes;
            String string2 = folder.getId();
            Long l2 = -1L;
            object.put(string2, l2);
        }
        this.update.fire();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, targets, this.project, "Recalculating NuGet folder sizes", true){
            final /* synthetic */ RiderNuGetCacheManager this$0;
            final /* synthetic */ List $targets;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                for (RdNuGetCacheFolder folder : this.$targets) {
                    Map map2 = RiderNuGetCacheManager.access$getFolderSizes$p(this.this$0);
                    String string2 = folder.getId();
                    Long l2 = 0L;
                    map2.put(string2, l2);
                    this.updateFolderSize(folder.getId(), folder.getTitle(), new File(folder.getPath()), new File(folder.getPath()), indicator, 0);
                    if (!indicator.isCanceled()) continue;
                    map2 = RiderNuGetCacheManager.access$getFolderSizes$p(this.this$0);
                    string2 = folder.getId();
                    l2 = -1L;
                    map2.put(string2, l2);
                    break;
                }
                ApplicationKt.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ recalculate.2 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        Object object = RiderNuGetCacheManager.access$getLock$p(this.this$0.this$0);
                        synchronized (object) {
                            this.this$0.this$0.setBusy(false);
                            Unit unit = Unit.INSTANCE;
                        }
                        this.this$0.this$0.getUpdate().fire();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            private final void updateFolderSize(String id, String title, File root, File directory, ProgressIndicator indicator, int level) {
                if (!directory.exists()) {
                    return;
                }
                File[] files2 = directory.listFiles();
                for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])files2)) {
                    int index = indexedValue.component1();
                    File file2 = (File)indexedValue.component2();
                    if (indicator.isCanceled()) break;
                    if (level == 0) {
                        StringBuilder stringBuilder = new StringBuilder().append(title + " (" + root.getPath() + "): ");
                        V v2 = RiderNuGetCacheManager.access$getFolderSizes$p(this.this$0).get(id);
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        indicator.setText(stringBuilder.append(StringUtil.formatFileSize((long)((Number)v2).longValue())).toString());
                        indicator.setText2(file2.getName());
                        indicator.setFraction((double)index * 1.0 / (double)((Object[])files2).length);
                    }
                    if (file2.isFile()) {
                        try {
                            Map map2 = RiderNuGetCacheManager.access$getFolderSizes$p(this.this$0);
                            V v3 = RiderNuGetCacheManager.access$getFolderSizes$p(this.this$0).get(id);
                            if (v3 == null) {
                                Intrinsics.throwNpe();
                            }
                            Long l2 = ((Number)v3).longValue() + file2.length();
                            map2.put(id, l2);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    File file3 = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
                    this.updateFolderSize(id, title, root, file3, indicator, level + 1);
                }
            }
            {
                this.this$0 = $outer;
                this.$targets = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(@NotNull List<RdNuGetCacheFolder> targets, @Nullable Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        Object object = this.lock;
        synchronized (object) {
            if (this.isBusy) {
                return;
            }
            this.isBusy = true;
            Unit unit = Unit.INSTANCE;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, targets, callback, this.project, "Clearing NuGet Cache", true){
            final /* synthetic */ RiderNuGetCacheManager this$0;
            final /* synthetic */ List $targets;
            final /* synthetic */ Function0 $callback;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Map map2;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                block5: for (RdNuGetCacheFolder folder : this.$targets) {
                    map2 = RiderNuGetCacheManager.access$getFolderSizes$p(this.this$0);
                    String string2 = folder.getId();
                    Long l22 = -1L;
                    map2.put(string2, l22);
                    File root = new File(folder.getPath());
                    if (!root.exists() || !root.isDirectory()) continue;
                    File[] files2 = root.listFiles();
                    for (Long l22 : ArraysKt.withIndex((Object[])files2)) {
                        int index = l22.component1();
                        File file2 = (File)l22.component2();
                        if (indicator.isCanceled()) continue block5;
                        indicator.setText(this.getTitle() + " (" + root.getPath() + ")");
                        indicator.setText2(file2.getName());
                        indicator.setFraction((double)index * 1.0 / (double)((Object[])files2).length);
                        try {
                            if (file2.isFile()) {
                                file2.delete();
                                continue;
                            }
                            FilesKt.deleteRecursively((File)file2);
                        }
                        catch (Exception exception) {}
                    }
                }
                Object object = RiderNuGetCacheManager.access$getLock$p(this.this$0);
                synchronized (object) {
                    this.this$0.setBusy(false);
                    map2 = Unit.INSTANCE;
                }
                ApplicationKt.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ clear.2 this$0;

                    public final void run() {
                        if (!this.this$0.getProject().isDisposed()) {
                            this.this$0.this$0.recalculate(this.this$0.$targets);
                            if (this.this$0.$callback != null) {
                                this.this$0.$callback.invoke();
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$targets = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    public static /* bridge */ /* synthetic */ void clear$default(RiderNuGetCacheManager riderNuGetCacheManager, List list2, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function0 = null;
        }
        riderNuGetCacheManager.clear(list2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    public final void autoClear() {
        void var3_4;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.getAllFolders();
        RiderNuGetCacheManager riderNuGetCacheManager = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            RdNuGetCacheFolder it = (RdNuGetCacheFolder)element$iv$iv;
            if (!this.getAutoClearMode(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)var3_4;
        RiderNuGetCacheManager.clear$default(riderNuGetCacheManager, list2, null, 2, null);
    }

    public final void autoClearAll(@Nullable Function0<Unit> callback) {
        this.clear(this.getAllFolders(), callback);
    }

    public static /* bridge */ /* synthetic */ void autoClearAll$default(RiderNuGetCacheManager riderNuGetCacheManager, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            function0 = null;
        }
        riderNuGetCacheManager.autoClearAll((Function0<Unit>)function0);
    }

    private final createAction.1 createAction(String title, Icon icon, boolean useBusyFlag, Function0<Unit> action2) {
        return new AnAction(this, action2, useBusyFlag, title, icon, title, title, icon){
            final /* synthetic */ RiderNuGetCacheManager this$0;
            final /* synthetic */ Function0 $action;
            final /* synthetic */ boolean $useBusyFlag;
            final /* synthetic */ String $title;
            final /* synthetic */ Icon $icon;

            public void actionPerformed(@Nullable AnActionEvent e2) {
                this.$action.invoke();
            }

            public void update(@Nullable AnActionEvent e2) {
                block0: {
                    AnActionEvent anActionEvent = e2;
                    if (anActionEvent == null || (anActionEvent = anActionEvent.getPresentation()) == null) break block0;
                    anActionEvent.setEnabled(!this.$useBusyFlag || !this.this$0.isBusy());
                }
            }
            {
                this.this$0 = $outer;
                this.$action = $captured_local_variable$1;
                this.$useBusyFlag = $captured_local_variable$2;
                this.$title = $captured_local_variable$3;
                this.$icon = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    static /* bridge */ /* synthetic */ createAction.1 createAction$default(RiderNuGetCacheManager riderNuGetCacheManager, String string2, Icon icon, boolean bl, Function0 function0, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return riderNuGetCacheManager.createAction(string2, icon, bl, (Function0<Unit>)function0);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RiderNuGetCacheManager(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
        this.properties = PropertiesComponent.getInstance((Project)this.project);
        this.propertiesPrefix = "RiderNuGetCacheManager.AutoClear.";
        this.AutoClearModeOn = 1;
        this.AutoClearModeOff = 2;
        this.folderSizes = ContainerUtil.newConcurrentMap();
        this.lock = new Object();
        this.update = new Signal.Void();
        SolutionHostExtensionsKt.getSolution(this.project).getNuGetHost().getCaches().getFolders().advise(ApplicationKt.attachLifetime((Disposable)this.project), (Function1)new Function1<IViewableMap.Event<String, RdNuGetCacheFolder>, Unit>(){

            public final void invoke(@NotNull IViewableMap.Event<String, RdNuGetCacheFolder> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.getUpdate().fire();
            }
        });
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getFolderSizes$p(RiderNuGetCacheManager $this) {
        return $this.folderSizes;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(RiderNuGetCacheManager $this) {
        return $this.lock;
    }
}

