/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.configs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.jetbrains.resharper.nuget.RiderNuGetFacade;
import com.jetbrains.resharper.nuget.configs.RiderNuGetConfigListState;
import com.jetbrains.resharper.nuget.configs.RiderNuGetConfigRenderer;
import com.jetbrains.rider.model.RdNuGetConfigFile;
import com.jetbrains.rider.util.reactive.Signal;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/resharper/nuget/configs/RiderNuGetConfigList;", "Lcom/intellij/ui/components/JBList;", "Lcom/jetbrains/rider/model/RdNuGetConfigFile;", "facade", "Lcom/jetbrains/resharper/nuget/RiderNuGetFacade;", "(Lcom/jetbrains/resharper/nuget/RiderNuGetFacade;)V", "getFacade", "()Lcom/jetbrains/resharper/nuget/RiderNuGetFacade;", "onConfigSelection", "Lcom/jetbrains/rider/util/reactive/Signal;", "getOnConfigSelection", "()Lcom/jetbrains/rider/util/reactive/Signal;", "riderModel", "Ljavax/swing/DefaultListModel;", "getRiderModel", "()Ljavax/swing/DefaultListModel;", "applyState", "", "state", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetConfigListState;", "getState", "openFile", "config", "rider"})
public final class RiderNuGetConfigList
extends JBList<RdNuGetConfigFile> {
    @NotNull
    private final Signal<RdNuGetConfigFile> onConfigSelection;
    @NotNull
    private final RiderNuGetFacade facade;

    @NotNull
    public final DefaultListModel<RdNuGetConfigFile> getRiderModel() {
        ListModel listModel2 = this.getModel();
        if (listModel2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.DefaultListModel<com.jetbrains.rider.model.RdNuGetConfigFile>");
        }
        return (DefaultListModel)listModel2;
    }

    @NotNull
    public final Signal<RdNuGetConfigFile> getOnConfigSelection() {
        return this.onConfigSelection;
    }

    public final void applyState(@NotNull RiderNuGetConfigListState state) {
        int n2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Enumeration<RdNuGetConfigFile> enumeration = this.getRiderModel().elements();
            ArrayList<RdNuGetConfigFile> arrayList = Collections.list(enumeration);
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
            List $receiver$iv = arrayList;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                RdNuGetConfigFile it = (RdNuGetConfigFile)item$iv;
                if (Intrinsics.areEqual((Object)it.getConfigFilePath(), (Object)state.getSelectedConfigFilePath())) {
                    n2 = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n2 = -1;
        }
        int index = n2;
        this.setSelectedIndex(Math.max(index, 0));
    }

    @NotNull
    public final RiderNuGetConfigListState getState() {
        RdNuGetConfigFile rdNuGetConfigFile = (RdNuGetConfigFile)this.getSelectedValue();
        return new RiderNuGetConfigListState(rdNuGetConfigFile != null ? rdNuGetConfigFile.getConfigFilePath() : null);
    }

    private final void openFile(RdNuGetConfigFile config) {
        String string2 = config.getConfigFilePath();
        if (string2 == null) {
            return;
        }
        String path = string2;
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
        if (file2 == null) {
            Notifications.Bus.notify((Notification)new Notification("System Messages", "Error", "There is no such file: " + path, NotificationType.ERROR));
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)FileEditorManager.getInstance((Project)this.facade.getProject()).openFile(file2, true, true), (String)"FileEditorManager.getIns\u2026penFile(file, true, true)");
        }
    }

    @NotNull
    public final RiderNuGetFacade getFacade() {
        return this.facade;
    }

    public RiderNuGetConfigList(@NotNull RiderNuGetFacade facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super((Collection)CollectionsKt.emptyList());
        this.facade = facade;
        this.onConfigSelection = new Signal();
        this.setCellRenderer((ListCellRenderer)((Object)new RiderNuGetConfigRenderer(this.facade)));
        this.setSelectionMode(0);
        this.getEmptyText().setText("There are no config files");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@Nullable MouseEvent e2) {
                int index;
                if (e2 != null && e2.getClickCount() >= 1 && (index = this.locationToIndex(e2.getPoint())) >= 0) {
                    RdNuGetConfigFile config;
                    RdNuGetConfigFile rdNuGetConfigFile = config = this.getRiderModel().get(index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)rdNuGetConfigFile, (String)"config");
                    this.openFile(rdNuGetConfigFile);
                    Signal<RdNuGetConfigFile> signal = this.getOnConfigSelection();
                    RdNuGetConfigFile rdNuGetConfigFile2 = config;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rdNuGetConfigFile2, (String)"config");
                    signal.fire(rdNuGetConfigFile2);
                }
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                if (this.getSelectedIndex() >= 0) {
                    RdNuGetConfigFile config;
                    RdNuGetConfigFile rdNuGetConfigFile = config = (RdNuGetConfigFile)this.getSelectedValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)rdNuGetConfigFile, (String)"config");
                    this.openFile(rdNuGetConfigFile);
                    Signal<RdNuGetConfigFile> signal = this.getOnConfigSelection();
                    RdNuGetConfigFile rdNuGetConfigFile2 = config;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rdNuGetConfigFile2, (String)"config");
                    signal.fire(rdNuGetConfigFile2);
                }
            }
        });
        TreeUIHelper.getInstance().installListSpeedSearch((JList)((Object)this));
    }
}

