/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.configs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedManager;
import com.jetbrains.rider.model.RdNuGetFeed;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\rR/\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedColorManager;", "", "feedManager", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;", "(Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;)V", "colorMap", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "feeds", "", "Lcom/jetbrains/rider/model/RdNuGetFeed;", "getFeeds", "()Ljava/util/List;", "generatePalette", "", "getColor", "feed", "Companion", "rider"})
public final class RiderNuGetFeedColorManager {
    private final HashMap<String, Color> colorMap;
    private final RiderNuGetFeedManager feedManager;
    private static final Logger logger;
    private static final Color[] sourceColors;
    public static final Companion Companion;

    private final List<RdNuGetFeed> getFeeds() {
        return this.feedManager.getAllFeeds();
    }

    private final void generatePalette() {
        this.colorMap.clear();
        int i2 = 0;
        for (RdNuGetFeed feed : this.getFeeds()) {
            Color color;
            if (i2 >= ((Object[])RiderNuGetFeedColorManager.Companion.getSourceColors()).length) {
                double balance = (double)(i2 / ((Object[])RiderNuGetFeedColorManager.Companion.getSourceColors()).length) / (double)(this.getFeeds().size() / ((Object[])RiderNuGetFeedColorManager.Companion.getSourceColors()).length);
                Color mix = ColorUtil.mix((Color)RiderNuGetFeedColorManager.Companion.getSourceColors()[i2 % ((Object[])RiderNuGetFeedColorManager.Companion.getSourceColors()).length], (Color)RiderNuGetFeedColorManager.Companion.getSourceColors()[(i2 + 1) % ((Object[])RiderNuGetFeedColorManager.Companion.getSourceColors()).length], (double)balance);
                int tones = (int)(Math.abs(balance - 0.5) * 2.0 * (double)(this.getFeeds().size() / ((Object[])RiderNuGetFeedColorManager.Companion.getSourceColors()).length) + 1.0);
                color = (Color)new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)RiderNuGetFeedColorManager.Companion.getSourceColors()[i2], (String)"sourceColors[i]");
            }
            ++i2;
            this.colorMap.put(feed.getFeedId(), color);
        }
    }

    @NotNull
    public final Color getColor(@NotNull RdNuGetFeed feed) {
        Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
        Color color = this.colorMap.get(feed.getFeedId());
        if (color == null) {
            RiderNuGetFeedColorManager.Companion.getLogger().error("No color record for source " + feed.getName() + ". All sources: " + this.colorMap);
            color = RiderNuGetFeedColorManager.Companion.getDefaultRootColor();
        }
        return color;
    }

    public RiderNuGetFeedColorManager(@NotNull RiderNuGetFeedManager feedManager) {
        Intrinsics.checkParameterIsNotNull((Object)feedManager, (String)"feedManager");
        this.feedManager = feedManager;
        this.colorMap = ContainerUtil.newHashMap();
        this.generatePalette();
        this.feedManager.addListChangesListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.generatePalette();
            }
        }));
    }

    static {
        Companion = new Companion(null);
        logger = Logger.getInstance(RiderNuGetFeedColorManager.class);
        Color[] elements$iv = new Color[]{(Color)JBColor.RED, (Color)JBColor.GREEN, (Color)JBColor.BLUE, (Color)JBColor.ORANGE, JBColor.CYAN, (Color)JBColor.YELLOW, JBColor.MAGENTA, (Color)JBColor.PINK};
        sourceColors = (Color[])((Object[])elements$iv);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040\rX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedColorManager$Companion;", "", "()V", "defaultRootColor", "Ljava/awt/Color;", "getDefaultRootColor", "()Ljava/awt/Color;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "sourceColors", "", "kotlin.jvm.PlatformType", "getSourceColors", "()[Ljava/awt/Color;", "[Ljava/awt/Color;", "getBackgroundColor", "Lcom/intellij/ui/JBColor;", "baseRootColor", "getIndicatorColor", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private final Color[] getSourceColors() {
            return sourceColors;
        }

        private final Color getDefaultRootColor() {
            Color color = UIUtil.getTableBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"UIUtil.getTableBackground()");
            return color;
        }

        @NotNull
        public final JBColor getBackgroundColor(@NotNull Color baseRootColor) {
            Intrinsics.checkParameterIsNotNull((Object)baseRootColor, (String)"baseRootColor");
            return new JBColor((NotNullProducer)new NotNullProducer<Color>(baseRootColor){
                final /* synthetic */ Color $baseRootColor;

                @NotNull
                public final Color produce() {
                    return ColorUtil.mix((Color)this.$baseRootColor, (Color)UIUtil.getTableBackground(), (double)0.75);
                }
                {
                    this.$baseRootColor = color;
                }
            });
        }

        @NotNull
        public final JBColor getIndicatorColor(@NotNull Color baseRootColor) {
            Intrinsics.checkParameterIsNotNull((Object)baseRootColor, (String)"baseRootColor");
            return new JBColor((NotNullProducer)new NotNullProducer<Color>(baseRootColor){
                final /* synthetic */ Color $baseRootColor;

                @NotNull
                public final Color produce() {
                    return UIUtil.isUnderDarcula() ? this.$baseRootColor : ColorUtil.darker((Color)ColorUtil.softer((Color)this.$baseRootColor), (int)2);
                }
                {
                    this.$baseRootColor = color;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

