/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.configs;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.JBColor;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedColorIcon;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedColorManager;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedManager;
import com.jetbrains.rider.model.RdNuGetFeed;
import java.awt.Color;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0018B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ui/popup/KeepingPopupOpenAction;", "feedManager", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;", "feed", "Lcom/jetbrains/rider/model/RdNuGetFeed;", "(Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;Lcom/jetbrains/rider/model/RdNuGetFeed;)V", "isEnabled", "", "()Z", "myIcon", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedColorIcon;", "getBackgroundColor", "Lcom/intellij/ui/JBColor;", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "updateIcon", "Companion", "rider"})
public final class RiderNuGetFeedToggleAction
extends ToggleAction
implements DumbAware,
KeepingPopupOpenAction {
    private final RiderNuGetFeedColorIcon myIcon;
    private final RiderNuGetFeedManager feedManager;
    private final RdNuGetFeed feed;
    private static final int CheckboxIconSize;
    public static final Companion Companion;

    @NotNull
    public final JBColor getBackgroundColor() {
        Color baseRootColor = this.feedManager.getColorManager().getColor(this.feed);
        return RiderNuGetFeedColorManager.Companion.getBackgroundColor(baseRootColor);
    }

    public boolean isSelected(@NotNull AnActionEvent e2) {
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        return this.feedManager.isSelected(this.feed);
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state) {
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        if (!this.isEnabled()) {
            this.feedManager.setVisibleOnly(this.feed);
        } else if ((e2.getModifiers() & Companion.getModifierMask()) != 0) {
            this.feedManager.setVisible(this.feed, state);
        } else {
            this.feedManager.setVisibleOnly(this.feed);
        }
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        super.update(e2);
        String tooltip = KeyEvent.getKeyModifiersText(Companion.getModifierMask()) + "+Click to toggle only \"" + e2.getPresentation().getText() + "\"";
        this.updateIcon();
        e2.getPresentation().setIcon((Icon)((Object)this.myIcon));
        e2.getPresentation().putClientProperty("ToolTipText", (Object)tooltip);
    }

    private final void updateIcon() {
        this.myIcon.prepare(this.feedManager.isSelected(this.feed) && this.isEnabled());
    }

    private final boolean isEnabled() {
        return true;
    }

    public RiderNuGetFeedToggleAction(@NotNull RiderNuGetFeedManager feedManager, @NotNull RdNuGetFeed feed) {
        Intrinsics.checkParameterIsNotNull((Object)feedManager, (String)"feedManager");
        Intrinsics.checkParameterIsNotNull((Object)feed, (String)"feed");
        super(feed.getName(), feed.getUrl(), null);
        this.feedManager = feedManager;
        this.feed = feed;
        this.myIcon = new RiderNuGetFeedColorIcon(RiderNuGetFeedToggleAction.Companion.getCheckboxIconSize(), (Color)this.getBackgroundColor());
        this.getTemplatePresentation().setIcon((Icon)EmptyIcon.create((int)RiderNuGetFeedToggleAction.Companion.getCheckboxIconSize()));
    }

    static {
        Companion = new Companion(null);
        CheckboxIconSize = JBUI.scale((int)15);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedToggleAction$Companion;", "", "()V", "CheckboxIconSize", "", "getCheckboxIconSize", "()I", "modifierMask", "getModifierMask", "rider"})
    public static final class Companion {
        private final int getCheckboxIconSize() {
            return CheckboxIconSize;
        }

        @JdkConstants.InputEventMask
        public final int getModifierMask() {
            return 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

