/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.helpers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.resharper.nuget.helpers.RiderNuGetIcons;
import com.jetbrains.resharper.nuget.helpers.RiderNuGetLicenseLoader;
import com.jetbrains.resharper.ui.RiderUI;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.RdNuGetPackageMetadata;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import com.jetbrains.rider.util.reactive.Signal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetLink;", "", "title", "", "url", "toolTip", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "getToolTip", "setToolTip", "updated", "Lcom/jetbrains/rider/util/reactive/Signal$Void;", "getUpdated", "()Lcom/jetbrains/rider/util/reactive/Signal$Void;", "getUrl", "setUrl", "toHyperlinkLabel", "Lcom/intellij/ui/HyperlinkLabel;", "toMenuItem", "Ljavax/swing/JMenuItem;", "Companion", "rider"})
public final class RiderNuGetLink {
    @NotNull
    private final Signal.Void updated;
    @NotNull
    private String title;
    @NotNull
    private String url;
    @NotNull
    private String toolTip;
    @NotNull
    private final Icon icon;
    private static final RiderNuGetLicenseLoader licenseLoader;
    public static final Companion Companion;

    @NotNull
    public final Signal.Void getUpdated() {
        return this.updated;
    }

    @NotNull
    public final JMenuItem toMenuItem() {
        return RiderUI.Companion.menuItem(this.title + ": " + this.toolTip, this.icon, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderNuGetLink this$0;

            public final void invoke() {
                BrowserUtil.browse((String)this.this$0.getUrl());
            }
            {
                this.this$0 = riderNuGetLink;
                super(0);
            }
        }));
    }

    @NotNull
    public final HyperlinkLabel toHyperlinkLabel() {
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel $receiver = hyperlinkLabel = new HyperlinkLabel(this.title);
        $receiver.setHyperlinkTarget(this.url);
        $receiver.setToolTipText(this.toolTip);
        return hyperlinkLabel;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.title = string2;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.url = string2;
    }

    @NotNull
    public final String getToolTip() {
        return this.toolTip;
    }

    public final void setToolTip(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.toolTip = string2;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    public RiderNuGetLink(@NotNull String title, @NotNull String url, @NotNull String toolTip, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)toolTip, (String)"toolTip");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        this.title = title;
        this.url = url;
        this.toolTip = toolTip;
        this.icon = icon;
        this.updated = new Signal.Void();
    }

    static {
        Companion = new Companion(null);
        licenseLoader = RiderNuGetLicenseLoader.Companion.getInstance();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0017\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetLink$Companion;", "", "()V", "licenseLoader", "Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetLicenseLoader;", "getLicenseLoader", "()Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetLicenseLoader;", "createTagHyperlinks", "", "Lcom/intellij/ui/HyperlinkLabel;", "tags", "", "delim", "", "urlPrefix", "encode", "kotlin.jvm.PlatformType", "url", "getGoogleLink", "Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetLink;", "id", "sourceName", "getLicenseUrlLink", "meta", "Lcom/jetbrains/rider/model/RdNuGetPackageMetadata;", "getLinks", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "getNuGetOrgLink", "getProjectUrlLink", "rider"})
    public static final class Companion {
        private final RiderNuGetLicenseLoader getLicenseLoader() {
            return licenseLoader;
        }

        @NotNull
        public final List<RiderNuGetLink> getLinks(@NotNull RdNuGetSmartMetadata meta) {
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            return CollectionsKt.filterNotNull((Iterable)CollectionsKt.emptyList());
        }

        @NotNull
        public final List<RiderNuGetLink> getLinks(@NotNull RdNuGetPackageMetadata meta) {
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new RiderNuGetLink[]{this.getNuGetOrgLink(meta.getIdentity().getId(), ""), this.getProjectUrlLink(meta), this.getLicenseUrlLink(meta), this.getGoogleLink(meta.getIdentity().getId(), "")}));
        }

        @Nullable
        public final RiderNuGetLink getNuGetOrgLink(@NotNull String id, @NotNull String sourceName) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)sourceName, (String)"sourceName");
            String string2 = "https://www.nuget.org/packages/" + this.encode(id);
            Icon icon = RiderNuGetIcons.Companion.getMain();
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"RiderNuGetIcons.Main");
            return new RiderNuGetLink("NuGet.org", string2, "Show package on NuGet.org", icon);
        }

        @Nullable
        public final RiderNuGetLink getProjectUrlLink(@NotNull RdNuGetPackageMetadata meta) {
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            if (meta.getProjectUrl() != null) {
                String url = String.valueOf(meta.getProjectUrl());
                String title = StringsKt.startsWith$default((String)url, (String)"https://github.com/", (boolean)false, (int)2, null) ? "GitHub" : "Project Site";
                Icon icon = RiderNuGetIcons.Companion.getMain();
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"RiderNuGetIcons.Main");
                return new RiderNuGetLink(title, url, url, icon);
            }
            return null;
        }

        @Nullable
        public final RiderNuGetLink getLicenseUrlLink(@NotNull RdNuGetPackageMetadata meta) {
            Intrinsics.checkParameterIsNotNull((Object)meta, (String)"meta");
            if (meta.getLicenseUrl() != null) {
                String url = String.valueOf(meta.getLicenseUrl());
                String string2 = RiderNuGetLicenseLoader.Companion.getDefaultTitle();
                Icon icon = RiderNuGetIcons.Companion.getMain();
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"RiderNuGetIcons.Main");
                RiderNuGetLink link = new RiderNuGetLink(string2, url, url, icon);
                if (this.getLicenseLoader().hasLoadedLicense(meta.getLicenseUrl())) {
                    link.setTitle(this.getLicenseLoader().getLicenseTitle(meta.getLicenseUrl()));
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)ApplicationKt.getApplication().executeOnPooledThread(new Runnable(link, url){
                        final /* synthetic */ RiderNuGetLink $link;
                        final /* synthetic */ String $url;

                        public final void run() {
                            this.$link.setTitle(com.jetbrains.resharper.nuget.helpers.RiderNuGetLink$Companion.access$getLicenseLoader$p(RiderNuGetLink.Companion).updateLicense(this.$url));
                            this.$link.getUpdated().fire();
                        }
                        {
                            this.$link = riderNuGetLink;
                            this.$url = string2;
                        }
                    }), (String)"application.executeOnPoo\u2026e()\n                    }");
                }
                return link;
            }
            return null;
        }

        @Nullable
        public final RiderNuGetLink getGoogleLink(@NotNull String id, @NotNull String sourceName) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)sourceName, (String)"sourceName");
            String string2 = "http://www.google.com/search?q=" + this.encode(id);
            Icon icon = AllIcons.General.Web;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.Web");
            return new RiderNuGetLink("Google", string2, "Search with Google", icon);
        }

        private final String encode(String url) {
            return URLEncoder.encode(url, Charsets.UTF_8.name());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<HyperlinkLabel> createTagHyperlinks(@NotNull String tags, char delim, @NotNull String urlPrefix) {
            String string2;
            CharSequence charSequence;
            String p1;
            Collection collection;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)tags, (String)"tags");
            Intrinsics.checkParameterIsNotNull((Object)urlPrefix, (String)"urlPrefix");
            Iterable iterable = StringsKt.split$default((CharSequence)tags, (char[])new char[]{delim}, (boolean)false, (int)0, (int)6, null);
            void var5_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string3 = (String)item$iv$iv;
                collection = destination$iv$iv;
                charSequence = p1;
                void v0 = charSequence;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                collection.add(string2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                p1 = (String)element$iv$iv;
                charSequence = p1;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                p1 = (String)item$iv$iv;
                collection = destination$iv$iv;
                charSequence = new HyperlinkLabel((String)it);
                HyperlinkLabel $receiver = (HyperlinkLabel)charSequence;
                $receiver.setHyperlinkTarget(urlPrefix + Companion.encode((String)it));
                string2 = (HyperlinkLabel)charSequence;
                collection.add(string2);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ List createTagHyperlinks$default(Companion companion, String string2, char c2, String string3, int n2, Object object) {
            if ((n2 & 2) != 0) {
                c2 = (char)32;
            }
            if ((n2 & 4) != 0) {
                string3 = "https://www.nuget.org/packages?q=Tags%3A";
            }
            return companion.createTagHyperlinks(string2, c2, string3);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ RiderNuGetLicenseLoader access$getLicenseLoader$p(Companion $this) {
            return $this.getLicenseLoader();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

