/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.management.chosen;

import com.jetbrains.resharper.nuget.helpers.RiderNuGetOperation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/nuget/management/chosen/RiderNuGetTargetProject;", "", "projectId", "", "title", "", "version", "(ILjava/lang/String;Ljava/lang/String;)V", "getProjectId", "()I", "getTitle", "()Ljava/lang/String;", "getVersion", "getAllOperations", "", "Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetOperation;", "targetVersion", "getApplyOperation", "getRemoveOperation", "toString", "rider"})
public final class RiderNuGetTargetProject {
    private final int projectId;
    @NotNull
    private final String title;
    @NotNull
    private final String version;

    @Nullable
    public final RiderNuGetOperation getApplyOperation(@NotNull String targetVersion) {
        Intrinsics.checkParameterIsNotNull((Object)targetVersion, (String)"targetVersion");
        return Intrinsics.areEqual((Object)this.version, (Object)targetVersion) ^ true && Intrinsics.areEqual((Object)targetVersion, (Object)"") ^ true ? RiderNuGetOperation.Companion.resolve(this.version, targetVersion) : null;
    }

    @Nullable
    public final RiderNuGetOperation getRemoveOperation() {
        RiderNuGetOperation riderNuGetOperation;
        String string2 = this.version;
        switch (string2.hashCode()) {
            case 0: {
                if (string2.equals("")) {
                    riderNuGetOperation = null;
                    break;
                }
            }
            default: {
                riderNuGetOperation = RiderNuGetOperation.Companion.getRemove();
            }
        }
        return riderNuGetOperation;
    }

    @NotNull
    public final List<RiderNuGetOperation> getAllOperations(@NotNull String targetVersion) {
        Intrinsics.checkParameterIsNotNull((Object)targetVersion, (String)"targetVersion");
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new RiderNuGetOperation[]{this.getApplyOperation(targetVersion), this.getRemoveOperation()}));
    }

    @NotNull
    public String toString() {
        return this.title + " v" + this.version;
    }

    public final int getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public RiderNuGetTargetProject(int projectId, @NotNull String title, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.projectId = projectId;
        this.title = title;
        this.version = version;
    }
}

