/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.management.smart;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.resharper.nuget.RiderNuGetExtensionsKt;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedColorManager;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedManager;
import com.jetbrains.resharper.nuget.helpers.RiderNuGetIconLoader;
import com.jetbrains.resharper.nuget.helpers.RiderNuGetPrereleaseHelper;
import com.jetbrains.resharper.nuget.management.smart.RiderNuGetSmartItem;
import com.jetbrains.resharper.nuget.management.smart.RiderNuGetSmartRenderer;
import com.jetbrains.resharper.ui.RiderColor;
import com.jetbrains.resharper.ui.RiderUI;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.model.RdNuGetRemoteVersion;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J<\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcom/jetbrains/resharper/nuget/management/smart/RiderNuGetSmartRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/jetbrains/resharper/nuget/management/smart/RiderNuGetSmartItem;", "feedManager", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;", "(Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;)V", "colorManager", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedColorManager;", "getFeedManager", "()Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedManager;", "colored", "", "text", "color", "Lcom/jetbrains/resharper/ui/RiderColor;", "createPackagePanel", "Ljavax/swing/JPanel;", "rdPackage", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "isSelected", "", "list", "Ljavax/swing/JList;", "iconLabel", "Ljavax/swing/JLabel;", "getListCellRendererComponent", "Ljava/awt/Component;", "item", "index", "", "cellHasFocus", "lazyUpdateIcon", "", "packagePanel", "Companion", "rider"})
public final class RiderNuGetSmartRenderer
implements ListCellRenderer<RiderNuGetSmartItem> {
    private final RiderNuGetFeedColorManager colorManager;
    @NotNull
    private final RiderNuGetFeedManager feedManager;
    private static final int iconSize;
    private static final RiderNuGetIconLoader iconLoader;
    public static final Companion Companion;

    @Override
    @Nullable
    public Component getListCellRendererComponent(@NotNull JList<? extends RiderNuGetSmartItem> list2, @Nullable RiderNuGetSmartItem item, int index, boolean isSelected, boolean cellHasFocus) {
        Component component;
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        RiderNuGetSmartItem riderNuGetSmartItem = item;
        if (riderNuGetSmartItem instanceof RiderNuGetSmartItem.Package) {
            JLabel jLabel;
            URI uRI = ((RiderNuGetSmartItem.Package)item).getMeta().getIconUrl();
            JLabel $receiver = jLabel = new JLabel(RiderNuGetSmartRenderer.Companion.getIconLoader().getIcon(((RiderNuGetSmartItem.Package)item).getMeta().getId(), uRI != null ? uRI.toString() : null, RiderNuGetSmartRenderer.Companion.getIconSize()));
            $receiver.setMinimumSize(new Dimension(RiderNuGetSmartRenderer.Companion.getIconSize(), RiderNuGetSmartRenderer.Companion.getIconSize()));
            $receiver.setPreferredSize(new Dimension(RiderNuGetSmartRenderer.Companion.getIconSize(), RiderNuGetSmartRenderer.Companion.getIconSize()));
            $receiver.setMaximumSize(new Dimension(RiderNuGetSmartRenderer.Companion.getIconSize(), RiderNuGetSmartRenderer.Companion.getIconSize()));
            JLabel iconLabel = jLabel;
            JPanel packagePanel = this.createPackagePanel(((RiderNuGetSmartItem.Package)item).getMeta(), isSelected, list2, iconLabel);
            if (!RiderNuGetSmartRenderer.Companion.getIconLoader().hasLoadedIcon(((RiderNuGetSmartItem.Package)item).getMeta())) {
                this.lazyUpdateIcon(((RiderNuGetSmartItem.Package)item).getMeta(), iconLabel, packagePanel);
            }
            component = packagePanel;
        } else if (riderNuGetSmartItem instanceof RiderNuGetSmartItem.Header) {
            component = (Component)((RiderNuGetSmartItem.Header)item).getPanel();
        } else if (riderNuGetSmartItem instanceof RiderNuGetSmartItem.Fake) {
            component = new JPanel(new BorderLayout());
        } else if (Intrinsics.areEqual((Object)riderNuGetSmartItem, null)) {
            component = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return component;
    }

    private final void lazyUpdateIcon(RdNuGetSmartMetadata rdPackage, JLabel iconLabel, JPanel packagePanel) {
        ApplicationKt.getApplication().executeOnPooledThread(new Runnable(rdPackage, iconLabel, packagePanel){
            final /* synthetic */ RdNuGetSmartMetadata $rdPackage;
            final /* synthetic */ JLabel $iconLabel;
            final /* synthetic */ JPanel $packagePanel;

            public final void run() {
                Icon icon = com.jetbrains.resharper.nuget.management.smart.RiderNuGetSmartRenderer$Companion.access$getIconLoader$p(RiderNuGetSmartRenderer.Companion).updateIcon(this.$rdPackage);
                ApplicationKt.getApplication().invokeLater(new Runnable(this, icon){
                    final /* synthetic */ lazyUpdateIcon.1 this$0;
                    final /* synthetic */ Icon $icon;

                    public final void run() {
                        this.this$0.$iconLabel.setIcon(this.$icon);
                        this.this$0.$iconLabel.updateUI();
                        this.this$0.$packagePanel.updateUI();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$icon = icon;
                    }
                });
            }
            {
                this.$rdPackage = rdNuGetSmartMetadata;
                this.$iconLabel = jLabel;
                this.$packagePanel = jPanel;
            }
        });
    }

    private final JPanel createPackagePanel(RdNuGetSmartMetadata rdPackage, boolean isSelected, JList<? extends RiderNuGetSmartItem> list2, JLabel iconLabel) {
        JPanel jPanel;
        Object object;
        String installedMessage;
        RiderColor textColor = RiderUI.Companion.getTextColor(isSelected);
        RiderColor textColor2 = RiderUI.Companion.getTextColor2(isSelected);
        String installedVersion = CollectionsKt.joinToString$default((Iterable)rdPackage.getInstalledVersions(), (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        RiderColor installedColor = textColor2;
        String string2 = installedMessage = Intrinsics.areEqual((Object)installedVersion, (Object)"") ? "" : " " + this.colored("\u2022", textColor) + " " + this.colored(installedVersion, installedColor);
        if (rdPackage.getCanBeUpdated() || !RiderNuGetExtensionsKt.isInstalled(rdPackage)) {
            Object object2;
            RdNuGetRemoteVersion it;
            object = (RdNuGetRemoteVersion)CollectionsKt.lastOrNull(rdPackage.getAvailableVersions());
            if (object == null || (object = (it = (RdNuGetRemoteVersion)(object2 = object)).getVersion()) == null) {
                object = "";
            }
        } else {
            object = "";
        }
        String latestVersion = object;
        RiderColor latestColor = isSelected ? RiderUI.CommonPalette.Companion.getWhite() : RiderUI.VsPalette.Companion.getStatusBlue();
        String latestMessage = StringsKt.contains$default((CharSequence)latestVersion, (CharSequence)"-", (boolean)false, (int)2, null) ? RiderNuGetPrereleaseHelper.Companion.createHtmlItemText(latestVersion, isSelected) : this.colored(latestVersion, latestColor);
        String idMessage = this.colored(rdPackage.getId(), textColor);
        StringBuilder feedMessageBuilder = new StringBuilder();
        if (this.feedManager.isMultipleSelectedSources()) {
            for (RdNuGetRemoteVersion remoteVersion : rdPackage.getAvailableVersions()) {
                RdNuGetFeed feed = this.feedManager.getFeedById(remoteVersion.getFeedId());
                if (feed == null) continue;
                Object object3 = this.colorManager.getColor(feed);
                Color it = object3;
                JBColor feedColor = RiderNuGetFeedColorManager.Companion.getIndicatorColor(it);
                object3 = feedMessageBuilder;
                if (object3.length() == 0) {
                    feedMessageBuilder.append(" \u2022");
                }
                feedMessageBuilder.append(this.colored(" " + feed.getAlias(), isSelected ? RiderUI.CommonPalette.Companion.getWhite() : new RiderColor((Color)feedColor)));
            }
        }
        String feedMessage = feedMessageBuilder.toString();
        String htmlHeader = idMessage + installedMessage + feedMessage;
        Color itemBackground = isSelected ? list2.getSelectionBackground() : list2.getBackground();
        Color itemForeground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
        Function1 applyColors2 = (Function1)new Function1<JComponent, Unit>(itemBackground, itemForeground){
            final /* synthetic */ Color $itemBackground;
            final /* synthetic */ Color $itemForeground;

            public final void invoke(@NotNull JComponent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.setBackground(this.$itemBackground);
                it.setForeground(this.$itemForeground);
            }
            {
                this.$itemBackground = color;
                this.$itemForeground = color2;
                super(1);
            }
        };
        JPanel $receiver = jPanel = new JPanel(new BorderLayout());
        Object object4 = rdPackage.getId();
        if (!StringsKt.isBlank((CharSequence)object4)) {
            applyColors2.invoke((Object)$receiver);
            $receiver.setBorder((Border)new JBEmptyBorder(0, 0, 0, 8));
            object4 = new JPanel();
            JPanel jPanel2 = $receiver;
            JComponent $receiver2 = (JPanel)object4;
            applyColors2.invoke((Object)$receiver2);
            $receiver2.setLayout(new BoxLayout($receiver2, 1));
            $receiver2.setBorder((Border)new JBEmptyBorder(2, 8, 2, 4));
            $receiver2.add(iconLabel);
            Object object5 = object4;
            jPanel2.add((Component)object5, "West");
            object4 = new JPanel();
            jPanel2 = $receiver;
            $receiver2 = (JPanel)object4;
            applyColors2.invoke((Object)$receiver2);
            $receiver2.setLayout(new BoxLayout($receiver2, 1));
            $receiver2.add(new JLabel("<html>" + htmlHeader + "</html>"));
            object5 = object4;
            jPanel2.add((Component)object5, "Center");
            object4 = new JLabel("<html>" + latestMessage + "</html>");
            jPanel2 = $receiver;
            $receiver2 = (JLabel)object4;
            applyColors2.invoke((Object)$receiver2);
            object5 = object4;
            jPanel2.add((Component)object5, "East");
        }
        return jPanel;
    }

    private final String colored(String text2, RiderColor color) {
        return "<font color=" + color.toHtml() + ">" + text2 + "</font>";
    }

    @NotNull
    public final RiderNuGetFeedManager getFeedManager() {
        return this.feedManager;
    }

    public RiderNuGetSmartRenderer(@NotNull RiderNuGetFeedManager feedManager) {
        Intrinsics.checkParameterIsNotNull((Object)feedManager, (String)"feedManager");
        this.feedManager = feedManager;
        this.colorManager = this.feedManager.getColorManager();
    }

    static {
        Companion = new Companion(null);
        iconSize = JBUI.scale((int)16);
        iconLoader = RiderNuGetIconLoader.Companion.getInstance();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/nuget/management/smart/RiderNuGetSmartRenderer$Companion;", "", "()V", "iconLoader", "Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetIconLoader;", "getIconLoader", "()Lcom/jetbrains/resharper/nuget/helpers/RiderNuGetIconLoader;", "iconSize", "", "getIconSize", "()I", "rider"})
    public static final class Companion {
        private final int getIconSize() {
            return iconSize;
        }

        private final RiderNuGetIconLoader getIconLoader() {
            return iconLoader;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

