/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.nuget.panels;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.resharper.icons.ReSharperCommonIcons;
import com.jetbrains.resharper.nuget.RiderNuGetFacade;
import com.jetbrains.resharper.nuget.configs.RiderNuGetConfigList;
import com.jetbrains.resharper.nuget.configs.RiderNuGetConfigListState;
import com.jetbrains.resharper.nuget.configs.RiderNuGetFeedTable;
import com.jetbrains.resharper.nuget.helpers.RiderNuGetConsoleHelper;
import com.jetbrains.resharper.nuget.panels.RiderNuGetPanelBase;
import com.jetbrains.resharper.nuget.panels.RiderNuGetSourcesPanel;
import com.jetbrains.resharper.ui.RiderColor;
import com.jetbrains.resharper.ui.RiderUI;
import com.jetbrains.rider.model.RdNuGetConfigFile;
import com.jetbrains.rider.model.RdNuGetFeedDetails;
import com.jetbrains.rider.model.RdNuGetUltraConfig;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0006\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\"\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\rH\u0014J\b\u0010\"\u001a\u00020\rH\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lcom/jetbrains/resharper/nuget/panels/RiderNuGetSourcesPanel;", "Lcom/jetbrains/resharper/nuget/panels/RiderNuGetPanelBase;", "model", "Lcom/jetbrains/resharper/nuget/RiderNuGetFacade;", "(Lcom/jetbrains/resharper/nuget/RiderNuGetFacade;)V", "configDetailedView", "com/jetbrains/resharper/nuget/panels/RiderNuGetSourcesPanel$configDetailedView$1", "Lcom/jetbrains/resharper/nuget/panels/RiderNuGetSourcesPanel$configDetailedView$1;", "configList", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetConfigList;", "errorConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "errorPane", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "feedTable", "Lcom/jetbrains/resharper/nuget/configs/RiderNuGetFeedTable;", "mainPanel", "mainPanelSync", "Ljava/lang/Object;", "mainSplitter", "Lcom/intellij/ui/JBSplitter;", "getModel", "()Lcom/jetbrains/resharper/nuget/RiderNuGetFacade;", "addLine", "", "line", "", "textPane", "Ljavax/swing/JTextPane;", "addText", "text", "console", "prefix", "build", "buildConfigFileDetails", "buildToolbar", "Ljavax/swing/JComponent;", "fillInfoPane", "config", "Lcom/jetbrains/rider/model/RdNuGetConfigFile;", "ConsoleType", "rider"})
public final class RiderNuGetSourcesPanel
extends RiderNuGetPanelBase {
    private final RiderNuGetConfigList configList;
    private final configDetailedView.1 configDetailedView;
    private final RiderNuGetFeedTable feedTable;
    private final ConsoleViewImpl errorConsole;
    private final BorderLayoutPanel errorPane;
    private final JBSplitter mainSplitter;
    private final BorderLayoutPanel mainPanel;
    private final Object mainPanelSync;
    @NotNull
    private final RiderNuGetFacade model;

    private final void addText(String text2, JTextPane textPane, String prefix) {
        String string2;
        String string3 = string2 = text2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        List lines = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (String)"\r", (String)"", (boolean)false, (int)4, null), (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        for (String line : lines) {
            this.addLine(prefix + line, textPane);
        }
    }

    static /* bridge */ /* synthetic */ void addText$default(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string2, JTextPane jTextPane, String string3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        riderNuGetSourcesPanel.addText(string2, jTextPane, string3);
    }

    private final void addText(String text2, ConsoleViewImpl console) {
        String string2;
        String string3 = string2 = text2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        List lines = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (String)"\r", (String)"", (boolean)false, (int)4, null), (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        for (String line : lines) {
            console.print(line + "\n", ConsoleType.Companion.getError());
        }
    }

    private final void addLine(String line, JTextPane textPane) {
        JTextPane jTextPane;
        Object attributes;
        Color color;
        if (StringsKt.startsWith$default((String)line, (String)"###", (boolean)false, (int)2, null)) {
            color = (Color)((Object)RiderUI.VsPalette.Companion.getModifierBlue());
        } else if (StringsKt.startsWith$default((String)line, (String)"*", (boolean)false, (int)2, null)) {
            color = (Color)((Object)RiderUI.CommonPalette.Companion.getLightGreen());
        } else if (StringsKt.startsWith$default((String)line, (String)"!", (boolean)false, (int)2, null)) {
            color = (Color)((Object)RiderUI.CommonPalette.Companion.getRed());
        } else {
            Color color2 = Color.GRAY;
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.GRAY");
        }
        Color color3 = color;
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color3);
        attributes.element = sc.addAttribute((AttributeSet)attributes.element, StyleConstants.FontFamily, "Lucida Console");
        attributes.element = sc.addAttribute((AttributeSet)attributes.element, StyleConstants.Alignment, 3);
        JTextPane $receiver = jTextPane = textPane;
        $receiver.setCaretPosition($receiver.getDocument().getLength());
        $receiver.setCharacterAttributes((AttributeSet)attributes.element, false);
        $receiver.replaceSelection(line + "\n");
        attributes = null;
    }

    private final void fillInfoPane(RdNuGetConfigFile config) {
        configDetailedView.1 var4_4;
        Function1<String, Unit> addInfoText$ = new Function1<String, Unit>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;

            public final void invoke(@NotNull String text2) {
                Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
                RiderNuGetSourcesPanel.addText$default(this.this$0, text2, RiderNuGetSourcesPanel.access$getConfigDetailedView$p(this.this$0), null, 4, null);
            }
            {
                this.this$0 = riderNuGetSourcesPanel;
                super(1);
            }
        };
        Function1<String, Unit> addInfoLine$ = new Function1<String, Unit>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;

            public final void invoke(@NotNull String line) {
                Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                RiderNuGetSourcesPanel.access$addLine(this.this$0, line, RiderNuGetSourcesPanel.access$getConfigDetailedView$p(this.this$0));
            }
            {
                this.this$0 = riderNuGetSourcesPanel;
                super(1);
            }
        };
        configDetailedView.1 $receiver = var4_4 = this.configDetailedView;
        $receiver.setEditable(true);
        $receiver.setText("");
        addInfoText$.invoke(config.getDetailedInfoHeader());
        addInfoLine$.invoke("");
        addInfoLine$.invoke("### Restore consent");
        addInfoLine$.invoke("    IsGranted = " + config.getRestoreConsent().isGranted() + ", IsGrantedInSettings = " + config.getRestoreConsent().isGrantedInSettings() + ", IsAutomatic = " + config.getRestoreConsent().isAutomatic());
        addInfoLine$.invoke("");
        addInfoLine$.invoke("### Feeds");
        Iterator<RdNuGetFeedDetails> iterator2 = config.getFeeds().iterator();
        while (iterator2.hasNext()) {
            RdNuGetFeedDetails feed;
            RdNuGetFeedDetails rdNuGetFeedDetails;
            RdNuGetFeedDetails $receiver2 = rdNuGetFeedDetails = (feed = iterator2.next());
            CharSequence charSequence = $receiver2.getDescription();
            StringBuilder stringBuilder = new StringBuilder().append("* " + $receiver2.getDisplayName());
            Function1<String, Unit> function1 = addInfoLine$;
            boolean bl = charSequence == null || charSequence.length() == 0;
            function1.invoke(stringBuilder.append(bl ? "" : " (" + $receiver2.getDescription() + ")").toString());
            addInfoText$.invoke($receiver2.getDetailedInfo());
            addInfoLine$.invoke("");
        }
        $receiver.setEditable(false);
    }

    @NotNull
    protected BorderLayoutPanel build() {
        return this.mainPanel;
    }

    private final BorderLayoutPanel buildConfigFileDetails() {
        return RiderUI.Companion.borderPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;

            public final void invoke(@NotNull BorderLayoutPanel $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                JBScrollPane jBScrollPane = new JBScrollPane((Component)RiderUI.Companion.borderPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(this){
                    final /* synthetic */ buildConfigFileDetails.1 this$0;

                    public final void invoke(@NotNull BorderLayoutPanel $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        $receiver.add((Component)RiderNuGetSourcesPanel.access$getConfigDetailedView$p(this.this$0.this$0), (Object)"North");
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })), JBScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JBScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
                BorderLayoutPanel borderLayoutPanel = $receiver;
                JBScrollPane $receiver2 = jBScrollPane;
                $receiver2.getVerticalScrollBar().setUnitIncrement(16);
                JBScrollPane jBScrollPane2 = jBScrollPane;
                borderLayoutPanel.add((Component)jBScrollPane2);
            }
            {
                this.this$0 = riderNuGetSourcesPanel;
                super(1);
            }
        }));
    }

    @Override
    @Nullable
    protected JComponent buildToolbar() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $receiver = defaultActionGroup = new DefaultActionGroup();
        $receiver.add(new AnAction("Reload", "Reload full NuGet settings data", ReSharperCommonIcons.Companion.getRefresh(), this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;
            {
                this.this$0 = riderNuGetSourcesPanel;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(AnActionEvent e2) {
                this.this$0.getModel().getHost().getConfigManager().getReload().fire();
            }
        });
        DefaultActionGroup actionGroup = defaultActionGroup;
        return ActionManager.getInstance().createActionToolbar("", (ActionGroup)actionGroup, false).getComponent();
    }

    @NotNull
    public final RiderNuGetFacade getModel() {
        return this.model;
    }

    public RiderNuGetSourcesPanel(@NotNull RiderNuGetFacade model2) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        super("Sources");
        this.model = model2;
        this.configList = new RiderNuGetConfigList(this.model);
        this.configDetailedView = new JTextPane(){

            @NotNull
            public RiderColor getBackground() {
                return RiderUI.Companion.getUsualBackgroundColor();
            }
            {
                this.setText("Loading...");
                this.setEditable(false);
            }
        };
        this.feedTable = new RiderNuGetFeedTable(this.model.getHost().getConfigManager());
        this.errorConsole = RiderNuGetConsoleHelper.Companion.createConsole(this.model.getProject());
        BorderLayoutPanel borderLayoutPanel2 = new BorderLayoutPanel();
        RiderNuGetSourcesPanel riderNuGetSourcesPanel = this;
        BorderLayoutPanel $receiver = borderLayoutPanel2;
        $receiver.setVisible(false);
        $receiver.addToCenter((Component)this.errorConsole.getComponent());
        this.errorConsole.getEditor().getSettings().setCaretRowShown(true);
        riderNuGetSourcesPanel.errorPane = borderLayoutPanel = borderLayoutPanel2;
        borderLayoutPanel2 = new JBSplitter();
        riderNuGetSourcesPanel = this;
        $receiver = (JBSplitter)borderLayoutPanel2;
        $receiver.setProportion(0.33333334f);
        $receiver.setFirstComponent((JComponent)RiderUI.Companion.borderPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;
            {
                this.this$0 = riderNuGetSourcesPanel;
                super(1);
            }

            public final void invoke(BorderLayoutPanel $receiver) {
                $receiver.add((Component)((Object)RiderNuGetSourcesPanel.access$getConfigList$p(this.this$0)));
            }
        })));
        JBTabbedPane $i$a$1$apply = new JBTabbedPane();
        BorderLayoutPanel borderLayoutPanel3 = $receiver;
        JBTabbedPane $receiver2 = $i$a$1$apply;
        $receiver2.add("Feeds", (Component)RiderUI.Companion.borderPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;
            {
                this.this$0 = riderNuGetSourcesPanel;
                super(1);
            }

            public final void invoke(BorderLayoutPanel $receiver) {
                $receiver.add((Component)new JBScrollPane((Component)((Object)RiderNuGetSourcesPanel.access$getFeedTable$p(this.this$0))));
            }
        })));
        $receiver2.add("Summary", (Component)RiderUI.Companion.borderPanel((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;
            {
                this.this$0 = riderNuGetSourcesPanel;
                super(1);
            }

            public final void invoke(BorderLayoutPanel $receiver) {
                $receiver.add((Component)RiderNuGetSourcesPanel.access$buildConfigFileDetails(this.this$0));
            }
        })));
        JBTabbedPane jBTabbedPane = $i$a$1$apply;
        borderLayoutPanel3.setSecondComponent((JComponent)jBTabbedPane);
        borderLayoutPanel = borderLayoutPanel2;
        riderNuGetSourcesPanel.mainSplitter = (JBSplitter)borderLayoutPanel;
        borderLayoutPanel2 = new BorderLayoutPanel();
        riderNuGetSourcesPanel = this;
        $receiver = borderLayoutPanel2;
        $receiver.addToCenter((Component)this.mainSplitter);
        riderNuGetSourcesPanel.mainPanel = borderLayoutPanel = borderLayoutPanel2;
        this.mainPanelSync = new Object();
        Disposer.register((Disposable)((Disposable)this.model.getProject()), (Disposable)((Disposable)this.errorConsole));
        this.model.getHost().getConfigManager().getConfigFiles().advise(this.model.getLifetime(), (Function1<List<RdNuGetConfigFile>, Unit>)((Function1)new Function1<List<? extends RdNuGetConfigFile>, Unit>(){

            public final void invoke(@NotNull List<RdNuGetConfigFile> newFiles) {
                RiderNuGetConfigList riderNuGetConfigList;
                Intrinsics.checkParameterIsNotNull(newFiles, (String)"newFiles");
                RiderNuGetConfigList $receiver = riderNuGetConfigList = configList;
                RiderNuGetConfigListState state = $receiver.getState();
                $receiver.getRiderModel().removeAllElements();
                for (RdNuGetConfigFile file2 : newFiles) {
                    $receiver.getRiderModel().addElement(file2);
                }
                $receiver.applyState(state);
            }
        }));
        this.model.getHost().getConfigManager().getUltraConfig().advise(this.model.getLifetime(), (Function1<RdNuGetUltraConfig, Unit>)((Function1)new Function1<RdNuGetUltraConfig, Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull RdNuGetUltraConfig ultra) {
                Intrinsics.checkParameterIsNotNull((Object)ultra, (String)"ultra");
                Object object = mainPanelSync;
                synchronized (object) {
                    CharSequence charSequence = ultra.getErrorMessage();
                    boolean isError = !(charSequence == null || charSequence.length() == 0);
                    boolean errorChanged = errorPane.isVisible() ^ isError;
                    if (errorPane.isVisible() && !isError) {
                        mainPanel.remove((Component)errorPane);
                        mainPanel.addToCenter((Component)mainSplitter);
                    }
                    if (!errorPane.isVisible() && isError) {
                        mainPanel.remove((Component)mainSplitter);
                        mainPanel.addToCenter((Component)errorPane);
                    }
                    errorConsole.clear();
                    String string2 = ultra.getErrorMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    String message2 = string2;
                    this.addText(message2, errorConsole);
                    errorPane.setVisible(isError);
                    if (errorChanged) {
                        mainPanel.invalidate();
                        mainPanel.repaint();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
        this.configList.getOnConfigSelection().advise(this.model.getLifetime(), (Function1<RdNuGetConfigFile, Unit>)((Function1)new Function1<RdNuGetConfigFile, Unit>(){

            public final void invoke(@NotNull RdNuGetConfigFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.fillInfoPane(it);
                feedTable.displayConfig(it);
            }
        }));
        this.model.getHost().getConfigManager().getReload().fire();
    }

    @NotNull
    public static final /* synthetic */ configDetailedView.1 access$getConfigDetailedView$p(RiderNuGetSourcesPanel $this) {
        return $this.configDetailedView;
    }

    public static final /* synthetic */ void access$addLine(RiderNuGetSourcesPanel $this, @NotNull String line, @NotNull JTextPane textPane) {
        $this.addLine(line, textPane);
    }

    @NotNull
    public static final /* synthetic */ BorderLayoutPanel access$buildConfigFileDetails(RiderNuGetSourcesPanel $this) {
        return $this.buildConfigFileDetails();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/resharper/nuget/panels/RiderNuGetSourcesPanel$ConsoleType;", "", "()V", "Companion", "rider"})
    private static final class ConsoleType {
        @NotNull
        private static final ConsoleViewContentType error;
        public static final Companion Companion;

        static {
            Companion = new Companion(null);
            error = new ConsoleViewContentType("NUGET_ERROR", ConsoleHighlighter.RED);
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/nuget/panels/RiderNuGetSourcesPanel$ConsoleType$Companion;", "", "()V", "error", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getError", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "rider"})
        public static final class Companion {
            @NotNull
            public final ConsoleViewContentType getError() {
                return error;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

