/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.SolutionErrorsNotification;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeVisitor;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectState;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionState;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/resharper/projectView/SolutionErrorsNotification;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/util/PropertiesComponent;)V", "firstRun", "", "showNotificationIfNeeded", "", "Companion", "rider"})
public final class SolutionErrorsNotification
extends AbstractProjectComponent {
    private boolean firstRun;
    private final PropertiesComponent propertiesComponent;
    private static final String settingName = "do_not_show_solution_notification";
    private static final NotificationGroup notificationGroupId;
    public static final Companion Companion;

    public final void showNotificationIfNeeded() {
        if (!this.firstRun) {
            return;
        }
        this.firstRun = false;
        if (this.propertiesComponent.getBoolean(SolutionErrorsNotification.Companion.getSettingName())) {
            return;
        }
        ComponentManager $receiver$iv = (ComponentManager)this.myProject;
        Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
        }
        ProjectModelViewHost host = (ProjectModelViewHost)object;
        ProjectModelNode solutionNode = host.getSolutionNode();
        ProjectModelNodeVisitor visitor2 = new ProjectModelNodeVisitor(){
            private int projectsWithErrors;
            private int projectsWithWarnings;

            public final int getProjectsWithErrors() {
                return this.projectsWithErrors;
            }

            public final void setProjectsWithErrors(int n2) {
                this.projectsWithErrors = n2;
            }

            public final int getProjectsWithWarnings() {
                return this.projectsWithWarnings;
            }

            public final void setProjectsWithWarnings(int n2) {
                this.projectsWithWarnings = n2;
            }

            @NotNull
            protected ProjectModelNodeVisitor.Result visitProject(@NotNull ProjectModelNode node) {
                int n2;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = node.getDescriptor();
                if (rdProjectModelItemDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectDescriptor");
                }
                RdProjectState state = ((RdProjectDescriptor)rdProjectModelItemDescriptor).getState();
                if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)RdProjectState.WithErrors))) {
                    n2 = this.projectsWithErrors;
                    this.projectsWithErrors = n2 + 1;
                }
                if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)RdProjectState.WithWarnings))) {
                    n2 = this.projectsWithWarnings;
                    this.projectsWithWarnings = n2 + 1;
                }
                if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)RdProjectState.WithInvalidConfiguration))) {
                    n2 = this.projectsWithWarnings;
                    this.projectsWithWarnings = n2 + 1;
                }
                return ProjectModelNodeVisitor.Result.Stop;
            }

            @NotNull
            protected ProjectModelNodeVisitor.Result visitUnloadedProject(@NotNull ProjectModelNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = node.getDescriptor();
                if (rdProjectModelItemDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.RdUnloadProjectDescriptor");
                }
                RdUnloadProjectState state = ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getState();
                if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)RdUnloadProjectState.LoadFailed))) {
                    int n2 = this.projectsWithErrors;
                    this.projectsWithErrors = n2 + 1;
                }
                return ProjectModelNodeVisitor.Result.Stop;
            }
        };
        visitor2.visit(solutionNode);
        int errors = visitor2.getProjectsWithErrors();
        int warnings = visitor2.getProjectsWithWarnings();
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = solutionNode.getDescriptor();
        if (rdProjectModelItemDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.RdSolutionDescriptor");
        }
        RdSolutionState state = ((RdSolutionDescriptor)rdProjectModelItemDescriptor).getState();
        if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)RdSolutionState.ReadyWithErrors))) {
            ++errors;
        }
        if (Intrinsics.areEqual((Object)((Object)state), (Object)((Object)RdSolutionState.ReadyWithWarnings))) {
            ++warnings;
        }
        if (errors == 0 && warnings == 0) {
            return;
        }
        String errorSuffix = StringUtil.pluralize((String)"error", (int)errors);
        String warningSuffix = StringUtil.pluralize((String)"warning", (int)warnings);
        StringBuilder title = new StringBuilder("Solution was loaded with ");
        if (errors > 0 && warnings > 0) {
            title.append(errors + " " + errorSuffix + " and " + warnings + " " + warningSuffix);
        } else {
            if (errors > 0) {
                title.append(errors + " " + errorSuffix);
            }
            if (warnings > 0) {
                title.append(warnings + " " + warningSuffix);
            }
        }
        String message2 = "<a href=\"open\">Open Event Log</a> for more information. <a href=\"disable\">Do not show</a> this notification for the solution";
        Notification notification = new Notification(SolutionErrorsNotification.Companion.getNotificationGroupId().getDisplayId(), title.toString(), message2, NotificationType.WARNING);
        notification.setListener(new NotificationListener(this){
            final /* synthetic */ SolutionErrorsNotification this$0;

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)hyperlinkEvent, (String)"hyperlinkEvent");
                if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) ^ true) {
                    return;
                }
                if (Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)"open")) {
                    ToolWindowManager.getInstance((Project)SolutionErrorsNotification.access$getMyProject$p(this.this$0)).getToolWindow("Event Log").activate((Runnable)showNotificationIfNeeded.1.INSTANCE);
                }
                if (Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)"disable")) {
                    SolutionErrorsNotification.access$getPropertiesComponent$p(this.this$0).setValue(com.jetbrains.resharper.projectView.SolutionErrorsNotification$Companion.access$getSettingName$p(SolutionErrorsNotification.Companion), true);
                }
            }
            {
                this.this$0 = solutionErrorsNotification;
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }

    public SolutionErrorsNotification(@NotNull Project project2, @NotNull PropertiesComponent propertiesComponent) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)propertiesComponent, (String)"propertiesComponent");
        super(project2);
        this.propertiesComponent = propertiesComponent;
        this.firstRun = true;
    }

    static {
        Companion = new Companion(null);
        settingName = settingName;
        notificationGroupId = NotificationGroup.toolWindowGroup((String)"SolutionErrorsNotification", (String)"Event Log", (boolean)false);
    }

    public static final /* synthetic */ Project access$getMyProject$p(SolutionErrorsNotification $this) {
        return $this.myProject;
    }

    @NotNull
    public static final /* synthetic */ PropertiesComponent access$getPropertiesComponent$p(SolutionErrorsNotification $this) {
        return $this.propertiesComponent;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/resharper/projectView/SolutionErrorsNotification$Companion;", "", "()V", "notificationGroupId", "Lcom/intellij/notification/NotificationGroup;", "Lorg/jetbrains/annotations/NotNull;", "getNotificationGroupId", "()Lcom/intellij/notification/NotificationGroup;", "settingName", "", "getSettingName", "()Ljava/lang/String;", "rider"})
    public static final class Companion {
        private final String getSettingName() {
            return settingName;
        }

        private final NotificationGroup getNotificationGroupId() {
            return notificationGroupId;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

