/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeKey;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeRider;
import com.jetbrains.resharper.util.idea.DataContextExKt;
import com.jetbrains.rider.model.ProjectModelTaskResultContent;
import com.jetbrains.rider.model.RdCreatedItemResult;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0003\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a8\u0006\u0014"}, d2={"findNode", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "project", "Lcom/intellij/openapi/project/Project;", "psiDirectory", "Lcom/intellij/psi/PsiDirectory;", "getCreatedItemNodeKey", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNodeKey;", "Lcom/jetbrains/rider/model/ProjectModelTaskResultContent;", "getProjectModelNode", "Lcom/intellij/openapi/actionSystem/DataContext;", "isProjectModelReady", "", "openEditor", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestChildName", "", "baseName", "baseExtension", "rider"})
public final class ExtensionsKt {
    public static final boolean isProjectModelReady(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IReadonlyProperty<Boolean> ready = SolutionHostExtensionsKt.getSolution($receiver).getSolutionLifecycle().isProjectModelReady();
        return PropertyExKt.getHasValue(ready) && ready.getValue() != false;
    }

    @Nullable
    public static final ProjectModelNode getProjectModelNode(@NotNull DataContext $receiver) {
        SolutionExplorerNodeRider solutionExplorerNode;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Project project2 = DataContextExKt.getProject($receiver);
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        if (!ExtensionsKt.isProjectModelReady(project3)) {
            return null;
        }
        ISolutionExplorerNode iSolutionExplorerNode = SolutionExplorerExtensionsKt.getSolutionExplorerNode($receiver);
        if (!(iSolutionExplorerNode instanceof SolutionExplorerNodeRider)) {
            iSolutionExplorerNode = null;
        }
        if ((solutionExplorerNode = (SolutionExplorerNodeRider)iSolutionExplorerNode) != null) {
            return solutionExplorerNode.getNode();
        }
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData($receiver);
        if (ideView == null) {
            return null;
        }
        IdeView view2 = ideView;
        PsiDirectory psiDirectory = (PsiDirectory)ArraysKt.singleOrNull((Object[])view2.getDirectories());
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        return ExtensionsKt.findNode(project3, psiDirectory2);
    }

    @Nullable
    public static final ProjectModelNode findNode(@NotNull Project project2, @NotNull PsiDirectory psiDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)psiDirectory, (String)"psiDirectory");
        ComponentManager $receiver$iv = (ComponentManager)project2;
        Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
        }
        ProjectModelViewHost projectModelViewHost = (ProjectModelViewHost)object;
        VirtualFileIndex virtualFileIndex = projectModelViewHost.getVirtualFileIndex();
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"psiDirectory.virtualFile");
        VirtualFileIndexEntry virtualFileIndexEntry = virtualFileIndex.get(virtualFile);
        if (virtualFileIndexEntry == null) {
            return null;
        }
        VirtualFileIndexEntry entry = virtualFileIndexEntry;
        Integer n2 = (Integer)CollectionsKt.singleOrNull((Iterable)entry.getProjectModelIds());
        if (n2 == null) {
            return null;
        }
        int nodeId = n2;
        return projectModelViewHost.getItemById(nodeId);
    }

    @NotNull
    public static final String suggestChildName(@NotNull ProjectModelNode $receiver, @NotNull String baseName, @NotNull String baseExtension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        Intrinsics.checkParameterIsNotNull((Object)baseExtension, (String)"baseExtension");
        VirtualFile virtualFile = ProjectModelNodeExtensionKt.getVirtualFileAsContentRoot($receiver);
        if (virtualFile == null) {
            return baseName + "." + baseExtension;
        }
        VirtualFile virtualFile2 = virtualFile;
        return ExtensionsKt.suggestChildName(virtualFile2, baseName, baseExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String suggestChildName(@NotNull VirtualFile $receiver, @NotNull String baseName, @NotNull String baseExtension) {
        void defaultFileName;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        Intrinsics.checkParameterIsNotNull((Object)baseExtension, (String)"baseExtension");
        CharSequence charSequence = baseExtension;
        String extension = charSequence.length() > 0 ? "." + baseExtension : "";
        int index = 1;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = baseName + index + extension;
        while (true) {
            boolean bl;
            block2: {
                Object[] $receiver$iv = $receiver.getChildren();
                for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                    Object element$iv = $receiver$iv[i2];
                    VirtualFile p2 = (VirtualFile)element$iv;
                    if (!StringsKt.equals((String)p2.getName(), (String)((String)defaultFileName.element), (boolean)true)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) break;
            defaultFileName.element = baseName + ++index + extension;
        }
        return (String)defaultFileName.element;
    }

    public static final void openEditor(@NotNull VirtualFile $receiver, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if ($receiver.isDirectory()) {
            return;
        }
        CharSequence charSequence = $receiver.getExtension();
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        FileEditorManager.getInstance((Project)project2).openFile($receiver, true);
    }

    @Nullable
    public static final ProjectModelNodeKey getCreatedItemNodeKey(@Nullable ProjectModelTaskResultContent $receiver) {
        ProjectModelTaskResultContent projectModelTaskResultContent = $receiver;
        if (!(projectModelTaskResultContent instanceof RdCreatedItemResult)) {
            projectModelTaskResultContent = null;
        }
        RdCreatedItemResult rdCreatedItemResult = (RdCreatedItemResult)projectModelTaskResultContent;
        if (rdCreatedItemResult == null) {
            return null;
        }
        RdCreatedItemResult createdItemResult = rdCreatedItemResult;
        if (createdItemResult.getItemId() > 0) {
            return new ProjectModelNodeKey(createdItemResult.getItemId());
        }
        return null;
    }
}

