/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.actions.ProjectViewActionBase;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.RdExecuteCustomToolCommand;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdSingleFileCustomTool;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J#\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/projectView/actions/RiderExecuteCustomToolAction;", "Lcom/jetbrains/resharper/projectView/actions/ProjectViewActionBase;", "()V", "actionPerformedInternal", "", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "project", "Lcom/intellij/openapi/project/Project;", "getItemInternal", "getTool", "Lcom/jetbrains/rider/model/RdSingleFileCustomTool;", "updatePresentation", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "items", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;[Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;)V", "rider"})
public final class RiderExecuteCustomToolAction
extends ProjectViewActionBase {
    @Override
    @Nullable
    protected ProjectModelNode getItemInternal(@NotNull ProjectModelNode item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (this.getTool(item) != null) {
            return item;
        }
        return null;
    }

    @Override
    protected void updatePresentation(@NotNull AnActionEvent e2, @NotNull ProjectModelNode[] items2) {
        Icon icon;
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)items2, (String)"items");
        if (((Object[])items2).length != 1) {
            return;
        }
        RdSingleFileCustomTool rdSingleFileCustomTool = this.getTool((ProjectModelNode)ArraysKt.single((Object[])items2));
        if (rdSingleFileCustomTool == null) {
            return;
        }
        RdSingleFileCustomTool tool = rdSingleFileCustomTool;
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        e2.getPresentation().setText(tool.getActionName());
        Presentation presentation = e2.getPresentation();
        com.jetbrains.rider.model.Icon icon2 = tool.getIcon();
        if (icon2 != null) {
            Project project4 = project3;
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            icon = IconHostKt.toIdeaIcon(icon2, project4);
        } else {
            icon = null;
        }
        presentation.setIcon(icon);
    }

    @Override
    protected void actionPerformedInternal(@NotNull ProjectModelNode item, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        RdSingleFileCustomTool rdSingleFileCustomTool = this.getTool(item);
        if (rdSingleFileCustomTool == null) {
            return;
        }
        RdSingleFileCustomTool tool = rdSingleFileCustomTool;
        RdExecuteCustomToolCommand command = new RdExecuteCustomToolCommand(item.getId(), tool);
        ExtensionsKt.syncFromBackend$default(SolutionHostExtensionsKt.getSolution(project2).getProjectModelTasks().getExecuteCustomTool(), command, project2, null, 4, null);
    }

    private final RdSingleFileCustomTool getTool(ProjectModelNode item) {
        RdProjectModelItemDescriptor descriptor2 = item.getDescriptor();
        if (descriptor2 instanceof RdProjectFileDescriptor) {
            List<RdSingleFileCustomTool> list2 = ((RdProjectFileDescriptor)descriptor2).getCustomTools();
            return list2 != null ? (RdSingleFileCustomTool)CollectionsKt.firstOrNull(list2) : null;
        }
        return null;
    }

    public RiderExecuteCustomToolAction() {
        super("Run Custom Tool", "", null, 4, null);
    }
}

