/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.newFile;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/projectView/actions/newFile/RiderInputValidator;", "Lcom/intellij/openapi/ui/InputValidatorEx;", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "myErrorText", "", "getParent", "()Lcom/intellij/openapi/vfs/VirtualFile;", "canClose", "", "inputString", "checkInput", "checkPossibleFile", "file", "token", "getErrorText", "rider"})
public class RiderInputValidator
implements InputValidatorEx {
    private String myErrorText;
    @NotNull
    private final VirtualFile parent;

    public boolean checkInput(@NotNull String inputString) {
        Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
        if (StringsKt.isBlank((CharSequence)inputString)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)inputString, (String)"\\", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)inputString, (String)"/", (boolean)false, (int)2, null)) {
            this.myErrorText = "Name should not start with '" + inputString.charAt(0) + "'";
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\\/");
        VirtualFile vFile = this.parent;
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ((Intrinsics.areEqual((Object)token, (Object)".") || Intrinsics.areEqual((Object)token, (Object)"..")) && !tokenizer.hasMoreTokens()) {
                this.myErrorText = "Cannot create file with name '" + token + "'";
                return false;
            }
            if (vFile != null) {
                if (firstToken && Intrinsics.areEqual((Object)"~", (Object)token)) {
                    VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                    if (userHomeDir == null) {
                        this.myErrorText = "User home directory not found";
                        return false;
                    }
                    vFile = userHomeDir;
                } else if (Intrinsics.areEqual((Object)"..", (Object)token)) {
                    if ((vFile = vFile.getParent()) == null) {
                        this.myErrorText = "Not a valid directory";
                        return false;
                    }
                } else if (Intrinsics.areEqual((Object)".", (Object)token) ^ true) {
                    VirtualFile child = vFile.findChild(token);
                    if (child != null) {
                        if (!child.isDirectory()) {
                            String string2 = token;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"token");
                            if (!this.checkPossibleFile(child, string2)) {
                                this.myErrorText = "A file with name '" + token + "' already exists";
                                return false;
                            }
                        }
                        if (!tokenizer.hasMoreTokens()) {
                            String string3 = token;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"token");
                            if (!this.checkPossibleFile(child, string3)) {
                                this.myErrorText = "A directory with name '" + token + "' already exists";
                                return false;
                            }
                        }
                    }
                    vFile = child;
                }
            }
            if (FileTypeManager.getInstance().isFileIgnored(token)) {
                this.myErrorText = "'" + token + "' is an ignored name (Settings | Editor | File Types | Ignore files and folders)";
                return true;
            }
            firstToken = false;
        }
        if (firstToken) {
            this.myErrorText = "Cannot create file with empty name";
            return false;
        }
        this.myErrorText = null;
        return true;
    }

    protected boolean checkPossibleFile(@NotNull VirtualFile file2, @NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return false;
    }

    @Nullable
    public String getErrorText(@NotNull String inputString) {
        Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
        return this.myErrorText;
    }

    public boolean canClose(@NotNull String inputString) {
        Intrinsics.checkParameterIsNotNull((Object)inputString, (String)"inputString");
        return true;
    }

    @NotNull
    public final VirtualFile getParent() {
        return this.parent;
    }

    public RiderInputValidator(@NotNull VirtualFile parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        this.parent = parent;
    }
}

