/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.newFile;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.actions.ExtensionsKt;
import com.jetbrains.resharper.projectView.actions.newFile.RiderNewActionBase;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.model.ProjectModelTaskResult;
import com.jetbrains.rider.model.RdCreateFromTemplateCommand;
import com.jetbrains.rider.model.RdFileTemplate;
import com.jetbrains.rider.model.RdFileTemplateModel;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/projectView/actions/newFile/RiderNewFileFromTemplateAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "node", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "template", "Lcom/jetbrains/rider/model/RdFileTemplate;", "(Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;Lcom/jetbrains/rider/model/RdFileTemplate;)V", "getNode", "()Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "getTemplate", "()Lcom/jetbrains/rider/model/RdFileTemplate;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "execute", "", "name", "rider"})
public final class RiderNewFileFromTemplateAction
extends AnAction {
    @NotNull
    private final ProjectModelNode node;
    @NotNull
    private final RdFileTemplate template;

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        VirtualFile virtualFile = ProjectModelNodeExtensionKt.getVirtualFileAsContentRoot(this.node);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String defaultName = ExtensionsKt.suggestChildName(this.node, this.template.getDefaultFileName(), this.template.getDefaultFileExtension());
        String string2 = RiderNewActionBase.Companion.chooseFileName(this.node.getProject(), virtualFile2, this.template.getName(), defaultName);
        if (string2 == null) {
            return;
        }
        String name = string2;
        String itemName = this.execute(name);
        File createdFile = new File(virtualFile2.getPath(), itemName);
        VirtualFile createdVirtualFile = VfsUtil.findFileByIoFile((File)createdFile, (boolean)true);
        if (createdVirtualFile != null) {
            RiderNewActionBase.Companion.postProcess(this.node.getProject(), createdVirtualFile);
        }
    }

    @NotNull
    public final String execute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Project project2 = this.node.getProject();
        RdFileTemplateModel fileTemplateModel = SolutionHostExtensionsKt.getSolution(project2).getFileTemplateModel();
        String extension = "." + this.template.getDefaultFileExtension();
        String itemName = StringsKt.endsWith$default((String)name, (String)extension, (boolean)false, (int)2, null) ? name : name + extension;
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(this, itemName, fileTemplateModel, project2){
            final /* synthetic */ RiderNewFileFromTemplateAction this$0;
            final /* synthetic */ String $itemName;
            final /* synthetic */ RdFileTemplateModel $fileTemplateModel;
            final /* synthetic */ Project $project;

            public final void run() {
                block0: {
                    RdCreateFromTemplateCommand command = new RdCreateFromTemplateCommand(this.$itemName, this.this$0.getTemplate(), this.this$0.getNode().getId());
                    ProjectModelTaskResult projectModelTaskResult = (ProjectModelTaskResult)com.jetbrains.resharper.util.idea.ExtensionsKt.syncFromBackend$default(this.$fileTemplateModel.getCreateFromTemplate(), command, this.$project, null, 4, null);
                    if (projectModelTaskResult == null) break block0;
                    SolutionHostExtensionsKt.processTaskResult(projectModelTaskResult);
                }
            }
            {
                this.this$0 = riderNewFileFromTemplateAction;
                this.$itemName = string2;
                this.$fileTemplateModel = rdFileTemplateModel;
                this.$project = project2;
            }
        }, this.template.getName() + " '" + name + "'", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return itemName;
    }

    @NotNull
    public final ProjectModelNode getNode() {
        return this.node;
    }

    @NotNull
    public final RdFileTemplate getTemplate() {
        return this.template;
    }

    public RiderNewFileFromTemplateAction(@NotNull ProjectModelNode node, @NotNull RdFileTemplate template) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        super(template.getName(), template.getDescription(), IconHostKt.toIdeaIcon(template.getIcon(), node.getProject()));
        this.node = node;
        this.template = template;
    }
}

