/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.newProject;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.resharper.ideaInterop.fileTypes.sln.SolutionFileType;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.actions.newProject.RiderNewProjectStep;
import com.jetbrains.resharper.projectView.ideaInterop.RiderProjectOpenProcessor;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.projectGenerators.RiderProjectGeneratorBase;
import com.jetbrains.resharper.projectView.projectGenerators.RiderZipProjectGenerator;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.AddProjectCommand;
import com.jetbrains.rider.model.FileToOpen;
import com.jetbrains.rider.model.OpenExistingSolutionAndReformat;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a=\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a.\u0010\f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001a-\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\u001a\u001a.\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013\u001a=\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020 2\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010$\u001a*\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020 \u001a0\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00072\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010,\u00a8\u0006-"}, d2={"applyProperties", "", "file", "Ljava/io/File;", "properties", "", "Lkotlin/Pair;", "", "filesToOpen", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/model/FileToOpen;", "(Ljava/io/File;[Lkotlin/Pair;Ljava/util/ArrayList;)V", "calculateNewProjectFile", "projectName", "directory", "generator", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderProjectGeneratorBase;", "solutionName", "sameDirectory", "", "calculateNewSolutionFile", "findDirectoryForNewProject", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "modifyContent", "content", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "unpackProjectAndAdd", "parentNode", "projectFile", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderZipProjectGenerator;", "restore", "unpackProjectInternal", "", "(Ljava/io/File;Lcom/jetbrains/resharper/projectView/projectGenerators/RiderZipProjectGenerator;[Lkotlin/Pair;)Ljava/util/List;", "unpackSolutionAndOpen", "solutionFile", "withResource", "name", "javaClass", "Ljava/lang/Class;", "action", "Lkotlin/Function1;", "rider"})
public final class RiderNewProjectManagerKt {
    @Nullable
    public static final Project unpackSolutionAndOpen(@NotNull File solutionFile, @NotNull File projectFile, @Nullable Project project2, @NotNull RiderZipProjectGenerator generator) {
        String projectFilePath;
        Intrinsics.checkParameterIsNotNull((Object)solutionFile, (String)"solutionFile");
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        String projectName = FilesKt.getNameWithoutExtension((File)projectFile);
        String string2 = projectFilePath = FilesKt.relativeTo((File)projectFile, (File)new File(solutionFile.getParent())).getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"projectFilePath");
        String string3 = solutionFile.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"solutionFile.parent");
        Pair<String, String>[] properties = generator.getProperties(projectName, string2, string3);
        FileUtil.createDirectory((File)solutionFile.getParentFile());
        String solutionName = generator.getSolutionName();
        RiderNewProjectManagerKt.withResource(solutionName, null, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(solutionFile){
            final /* synthetic */ File $solutionFile;

            public final void invoke(@NotNull File solutionTemplate) {
                Intrinsics.checkParameterIsNotNull((Object)solutionTemplate, (String)"solutionTemplate");
                FilesKt.copyTo$default((File)solutionTemplate, (File)this.$solutionFile, (boolean)false, (int)0, (int)6, null);
            }
            {
                this.$solutionFile = file2;
                super(1);
            }
        }));
        String content2 = FilesKt.readText$default((File)solutionFile, null, (int)1, null);
        String modifiedContent = RiderNewProjectManagerKt.modifyContent(content2, properties);
        FilesKt.writeText$default((File)solutionFile, (String)modifiedContent, null, (int)2, null);
        List<FileToOpen> filesToOpen = RiderNewProjectManagerKt.unpackProjectInternal(projectFile, generator, properties);
        String string4 = solutionFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"solutionFile.path");
        OpenExistingSolutionAndReformat solutionOpenStrategy = new OpenExistingSolutionAndReformat(filesToOpen, string4, true);
        return RiderProjectOpenProcessor.Companion.doOpenSolution(project2, false, solutionOpenStrategy);
    }

    public static final void unpackProjectAndAdd(@NotNull ProjectModelNode parentNode, @NotNull File projectFile, @NotNull Project project2, @NotNull RiderZipProjectGenerator generator, boolean restore) {
        String projectFilePath;
        Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        String projectName = FilesKt.getNameWithoutExtension((File)projectFile);
        String string2 = projectFilePath = FilesKt.relativeTo((File)projectFile, (File)new File(project2.getBasePath())).getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"projectFilePath");
        String string3 = project2.getBasePath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"project.basePath!!");
        Pair<String, String>[] properties = generator.getProperties(projectName, string2, string3);
        List<FileToOpen> filesToOpen = RiderNewProjectManagerKt.unpackProjectInternal(projectFile, generator, properties);
        String string4 = projectFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"projectFile.path");
        AddProjectCommand request2 = new AddProjectCommand(string4, parentNode.getId(), true, restore, UUID.fromString(generator.getProjectTypeMainGuid()), filesToOpen);
        ExtensionsKt.syncFromBackend$default(SolutionHostExtensionsKt.getSolution(project2).getProjectModelTasks().getAddProject(), request2, project2, null, 4, null);
    }

    @NotNull
    public static final File calculateNewSolutionFile(@NotNull String solutionName, @NotNull String directory) {
        Intrinsics.checkParameterIsNotNull((Object)solutionName, (String)"solutionName");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        return new File(new File(directory, solutionName), solutionName + "." + SolutionFileType.INSTANCE.getDefaultExtension());
    }

    @NotNull
    public static final File calculateNewProjectFile(@NotNull String solutionName, @NotNull String projectName, @NotNull String directory, @NotNull RiderProjectGeneratorBase generator, boolean sameDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)solutionName, (String)"solutionName");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        String projectExtension = "." + generator.getDefaultProjectExtension();
        File solutionFile = RiderNewProjectManagerKt.calculateNewSolutionFile(solutionName, directory);
        if (sameDirectory) {
            return new File(solutionFile.getParent(), projectName + projectExtension);
        }
        return new File(new File(solutionFile.getParent(), projectName), projectName + projectExtension);
    }

    @NotNull
    public static final File calculateNewProjectFile(@NotNull String projectName, @NotNull String directory, @NotNull RiderProjectGeneratorBase generator) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        String projectExtension = "." + generator.getDefaultProjectExtension();
        return new File(new File(directory, projectName), projectName + projectExtension);
    }

    @Nullable
    public static final String findDirectoryForNewProject(@Nullable ProjectModelNode item) {
        if (item == null) {
            return null;
        }
        VirtualFile virtualFile = item.getVirtualFile();
        if (virtualFile != null) {
            if (virtualFile.isDirectory()) {
                return virtualFile.getPath();
            }
            return virtualFile.getParent().getPath();
        }
        return RiderNewProjectManagerKt.findDirectoryForNewProject(item.getParent());
    }

    private static final List<FileToOpen> unpackProjectInternal(File projectFile, RiderZipProjectGenerator generator, Pair<String, String>[] properties) {
        RiderNewProjectManagerKt.withResource(generator.getTemplateName() + ".zip", generator.getClass(), (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(projectFile){
            final /* synthetic */ File $projectFile;

            public final void invoke(@NotNull File projectTemplate) {
                Intrinsics.checkParameterIsNotNull((Object)projectTemplate, (String)"projectTemplate");
                ZipUtil.extract((File)projectTemplate, (File)new File(this.$projectFile.getParent()), null);
            }
            {
                this.$projectFile = file2;
                super(1);
            }
        }));
        Pair<File, File>[] pairArray = generator.getFilesToRename(projectFile);
        for (int i2 = 0; i2 < pairArray.length; ++i2) {
            Pair<File, File> renames = pairArray[i2];
            ((File)renames.getFirst()).renameTo((File)renames.getSecond());
        }
        ArrayList<FileToOpen> filesToOpen = new ArrayList<FileToOpen>();
        RiderNewProjectManagerKt.applyProperties(new File(projectFile.getParent()), properties, filesToOpen);
        return filesToOpen;
    }

    private static final void applyProperties(File file2, Pair<String, String>[] properties, ArrayList<FileToOpen> filesToOpen) {
        String templateCaretPlaceholder = "$caret$";
        String templateLineSeparator = "\r\n";
        String memoryLineSeparator = "\n";
        MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
        File[] fileArray = file2.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String lineSeparator;
            String content2;
            String modifiedContent;
            String modifiedContentInMemory;
            CharSequence charSequence;
            File child = fileArray[i2];
            if (child.isDirectory()) {
                File file3 = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"child");
                RiderNewProjectManagerKt.applyProperties(file3, properties, filesToOpen);
                continue;
            }
            try {
                String type = mimetypesFileTypeMap.getContentType(child);
                if (!StringsKt.equals((String)((String)StringsKt.split$default((CharSequence)type, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null).get(0)), (String)"application", (boolean)true)) {
                    continue;
                }
            }
            catch (Exception type) {
                // empty catch block
            }
            int shift = (charSequence = (CharSequence)(modifiedContentInMemory = StringsKt.replace$default((String)(modifiedContent = RiderNewProjectManagerKt.modifyContent(content2 = FilesKt.readText$default((File)child, null, (int)1, null), properties)), (String)templateLineSeparator, (String)memoryLineSeparator, (boolean)false, (int)4, null))).length() > 0 && modifiedContentInMemory.charAt(0) == '\ufeff' ? 1 : 0;
            int caret = StringsKt.indexOf$default((CharSequence)modifiedContentInMemory, (String)templateCaretPlaceholder, (int)0, (boolean)false, (int)6, null) - shift;
            if (caret > -1) {
                String string2 = child.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"child.name");
                filesToOpen.add(new FileToOpen(string2, caret));
            }
            String string3 = lineSeparator = CodeStyleSettingsManager.getInstance().getCurrentSettings().getLineSeparator();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"lineSeparator");
            modifiedContent = StringsKt.replace$default((String)modifiedContent, (String)templateLineSeparator, (String)string3, (boolean)false, (int)4, null);
            modifiedContent = StringsKt.replace$default((String)modifiedContent, (String)templateCaretPlaceholder, (String)"", (boolean)false, (int)4, null);
            if (!(Intrinsics.areEqual((Object)content2, (Object)modifiedContent) ^ true)) continue;
            FilesKt.writeText$default((File)child, (String)modifiedContent, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String modifyContent(@NotNull String content2, @NotNull Pair<String, String>[] properties) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Object[] $receiver$iv = properties;
        String accumulator$iv = content2;
        for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
            void property;
            Object element$iv = $receiver$iv[i2];
            Pair pair = (Pair)element$iv;
            String contentText = accumulator$iv;
            accumulator$iv = StringsKt.replace((String)contentText, (String)((String)property.getFirst()), (String)((String)property.getSecond()), (boolean)true);
        }
        return (String)var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withResource(@NotNull String name, @Nullable Class<?> javaClass, @NotNull Function1<? super File, Unit> action2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        String resourceName = "/projects/" + name;
        Class<Object> clazz = javaClass;
        if (clazz == null) {
            clazz = RiderNewProjectStep.class;
        }
        Class<?> javaClassResource = clazz;
        InputStream inputStream = javaClassResource.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw (Throwable)new Exception("Cannot find resource '" + resourceName);
        }
        InputStream resourceStream = inputStream;
        File file2 = File.createTempFile(name, "tmp");
        try {
            Object object = file2;
            object = new FileOutputStream((File)object);
            boolean bl = false;
            try {
                long l2;
                FileOutputStream out = (FileOutputStream)object;
                Closeable closeable = resourceStream;
                boolean bl2 = false;
                try {
                    InputStream it = (InputStream)closeable;
                    l2 = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)out, (int)0, (int)2, null);
                }
                catch (Exception exception) {
                    bl2 = true;
                    try {
                        Closeable closeable2 = closeable;
                        if (closeable2 != null) {
                            closeable2.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                finally {
                    if (!bl2) {
                        Closeable closeable3 = closeable;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                }
                long l3 = l2;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    object.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    object.close();
                }
            }
            File file3 = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
            action2.invoke((Object)file3);
        }
        finally {
            file2.delete();
        }
    }
}

