/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.newProject;

import com.intellij.BundleBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.NullableConsumer;
import com.jetbrains.resharper.projectView.actions.newProject.RiderNewProjectManagerKt;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.projectGenerators.RiderProjectGeneratorBase;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010(\u001a\u00020#H\u0002J\u0006\u0010*\u001a\u00020#J\b\u0010+\u001a\u0004\u0018\u00010#J\b\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u0004\u0018\u00010#J\b\u0010/\u001a\u00020-H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/resharper/projectView/actions/newProject/RiderProjectSettingsStep;", "Lcom/intellij/ide/util/projectWizard/ProjectSettingsStepBase;", "project", "Lcom/intellij/openapi/project/Project;", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "generator", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderProjectGeneratorBase;", "callback", "Lcom/intellij/util/NullableConsumer;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;Lcom/jetbrains/resharper/projectView/projectGenerators/RiderProjectGeneratorBase;Lcom/intellij/util/NullableConsumer;)V", "getGenerator", "()Lcom/jetbrains/resharper/projectView/projectGenerators/RiderProjectGeneratorBase;", "getItem", "()Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "myDirectoryField", "Ljavax/swing/JTextField;", "myInfoLabel", "Ljavax/swing/JLabel;", "myProjectNameField", "mySameDirectoryCheckBox", "Ljavax/swing/JCheckBox;", "mySolutionNameField", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectNameSetByUser", "", "solutionNameSetByUser", "checkValid", "createBasePanel", "Ljavax/swing/JPanel;", "createDirectoryComponent", "Lcom/intellij/openapi/ui/LabeledComponent;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "defaultDirectory", "Ljava/io/File;", "createHintComponent", "Ljavax/swing/JComponent;", "createInfoComponent", "createProjectNameComponent", "defaultName", "createSolutionNameComponent", "directoryPath", "projectPath", "registerValidators", "", "solutionPath", "updateInfo", "rider"})
public final class RiderProjectSettingsStep
extends ProjectSettingsStepBase {
    private JTextField mySolutionNameField;
    private JTextField myProjectNameField;
    private JTextField myDirectoryField;
    private JCheckBox mySameDirectoryCheckBox;
    private JLabel myInfoLabel;
    private boolean solutionNameSetByUser;
    private boolean projectNameSetByUser;
    @Nullable
    private final Project project;
    @Nullable
    private final ProjectModelNode item;
    @NotNull
    private final RiderProjectGeneratorBase generator;

    @NotNull
    public final File directoryPath() {
        JTextField jTextField = this.myDirectoryField;
        if (jTextField == null) {
            Intrinsics.throwNpe();
        }
        return new File(jTextField.getText());
    }

    @Nullable
    public final File solutionPath() {
        JTextField solutionNameField = this.mySolutionNameField;
        if (solutionNameField != null) {
            String string2 = solutionNameField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"solutionNameField.text");
            JTextField jTextField = this.myDirectoryField;
            if (jTextField == null) {
                Intrinsics.throwNpe();
            }
            String string3 = jTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"myDirectoryField!!.text");
            return RiderNewProjectManagerKt.calculateNewSolutionFile(string2, string3);
        }
        return null;
    }

    @Nullable
    public final File projectPath() {
        JTextField projectNameField = this.myProjectNameField;
        if (projectNameField != null) {
            JTextField solutionNameField = this.mySolutionNameField;
            if (solutionNameField != null) {
                String string2 = solutionNameField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"solutionNameField.text");
                String string3 = projectNameField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"projectNameField.text");
                JTextField jTextField = this.myDirectoryField;
                if (jTextField == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = jTextField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"myDirectoryField!!.text");
                JCheckBox jCheckBox = this.mySameDirectoryCheckBox;
                if (jCheckBox == null) {
                    Intrinsics.throwNpe();
                }
                return RiderNewProjectManagerKt.calculateNewProjectFile(string2, string3, string4, this.generator, jCheckBox.isSelected());
            }
            String string5 = projectNameField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"projectNameField.text");
            JTextField jTextField = this.myDirectoryField;
            if (jTextField == null) {
                Intrinsics.throwNpe();
            }
            String string6 = jTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"myDirectoryField!!.text");
            return RiderNewProjectManagerKt.calculateNewProjectFile(string5, string6, this.generator);
        }
        return null;
    }

    @Override
    @NotNull
    protected JPanel createBasePanel() {
        this.createLocationComponent();
        DirectoryProjectGenerator directoryProjectGenerator = super.getProjectGenerator();
        if (directoryProjectGenerator == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.projectView.projectGenerators.RiderProjectGeneratorBase");
        }
        RiderProjectGeneratorBase riderGenerator = (RiderProjectGeneratorBase)directoryProjectGenerator;
        String string2 = RiderNewProjectManagerKt.findDirectoryForNewProject(this.item);
        if (string2 == null) {
            string2 = ProjectUtil.getBaseDir();
        }
        String defaultDirectoryRaw = string2;
        File defaultDirectory = new File(defaultDirectoryRaw);
        File defaultName = FileUtil.findSequentNonexistentFile((File)defaultDirectory, (String)riderGenerator.getDefaultProjectName(), (String)"");
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
        if (this.item == null) {
            File file2 = defaultName;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"defaultName");
            panel2.add(this.createSolutionNameComponent(file2));
        }
        File file3 = defaultName;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"defaultName");
        panel2.add(this.createProjectNameComponent(file3));
        panel2.add((Component)this.createDirectoryComponent(defaultDirectory));
        if (this.item == null) {
            panel2.add(this.createHintComponent());
        }
        panel2.add(this.createInfoComponent());
        this.updateInfo();
        return panel2;
    }

    @Override
    protected void registerValidators() {
    }

    @Override
    public boolean checkValid() {
        File solutionFile;
        JTextField directoryField;
        JTextField projectNameField;
        String fileNamePattern = "^[a-zA-Z_][\\w.\\- ]*$";
        JTextField solutionNameField = this.mySolutionNameField;
        if (solutionNameField != null) {
            CharSequence charSequence = solutionNameField.getText();
            if (charSequence == null || charSequence.length() == 0) {
                this.setErrorText("Solution name cannot be empty");
                return false;
            }
            if (!Pattern.matches(fileNamePattern, solutionNameField.getText())) {
                this.setErrorText("Solution name contains invalid characters");
                return false;
            }
        }
        if ((projectNameField = this.myProjectNameField) != null) {
            CharSequence charSequence = projectNameField.getText();
            if (charSequence == null || charSequence.length() == 0) {
                this.setErrorText("Project name cannot be empty");
                return false;
            }
            if (!Pattern.matches(fileNamePattern, projectNameField.getText())) {
                this.setErrorText("Project name contains invalid characters");
                return false;
            }
        }
        if ((directoryField = this.myDirectoryField) != null) {
            CharSequence charSequence = directoryField.getText();
            if (charSequence == null || charSequence.length() == 0) {
                this.setErrorText("Directory cannot be empty");
                return false;
            }
            File file2 = new File(directoryField.getText());
            if (!file2.isAbsolute()) {
                this.setErrorText("Please specify an absolute path");
                return false;
            }
        }
        if ((solutionFile = this.solutionPath()) != null && FileUtil.exists((String)solutionFile.getParent())) {
            this.setErrorText("Solution directory already exists");
            return false;
        }
        File projectFile = this.projectPath();
        if (projectFile != null && FileUtil.exists((String)projectFile.getParent())) {
            this.setErrorText("Project directory already exists");
            return false;
        }
        this.setErrorText(null);
        return true;
    }

    private final void updateInfo() {
        block2: {
            String string2;
            File projectFilePath;
            CharSequence charSequence;
            StringBuilder builder;
            StringBuilder stringBuilder = builder = new StringBuilder();
            CharSequence charSequence2 = "<html>";
            StringsKt.appendln((StringBuilder)stringBuilder.append((String)charSequence2));
            stringBuilder = builder;
            charSequence2 = "<p><b>Project Structure:</b></p>";
            StringsKt.appendln((StringBuilder)stringBuilder.append((String)charSequence2));
            File solutionFilePath = this.solutionPath();
            if (solutionFilePath != null) {
                charSequence2 = builder;
                charSequence = "<p><i>" + solutionFilePath.getPath() + "</i></p>";
                StringsKt.appendln((StringBuilder)((StringBuilder)charSequence2).append((String)charSequence));
            }
            if ((projectFilePath = this.projectPath()) != null) {
                charSequence = builder;
                string2 = "<p><i>" + projectFilePath.getPath() + "</i></p>";
                StringsKt.appendln((StringBuilder)((StringBuilder)charSequence).append(string2));
            }
            charSequence = builder;
            string2 = "</html>";
            StringsKt.appendln((StringBuilder)((StringBuilder)charSequence).append(string2));
            JLabel jLabel = this.myInfoLabel;
            if (jLabel == null) break block2;
            jLabel.setText(builder.toString());
        }
    }

    private final JComponent createSolutionNameComponent(File defaultName) {
        JTextField solutionNameField = new JTextField(defaultName.getName());
        solutionNameField.addKeyListener(new KeyAdapter(this, solutionNameField){
            final /* synthetic */ RiderProjectSettingsStep this$0;
            final /* synthetic */ JTextField $solutionNameField;

            public void keyReleased(@Nullable KeyEvent e2) {
                RiderProjectSettingsStep.access$setSolutionNameSetByUser$p(this.this$0, true);
                if (!RiderProjectSettingsStep.access$getProjectNameSetByUser$p(this.this$0)) {
                    JTextField jTextField = RiderProjectSettingsStep.access$getMyProjectNameField$p(this.this$0);
                    if (jTextField != null) {
                        jTextField.setText(this.$solutionNameField.getText());
                    }
                }
                this.this$0.checkValid();
                RiderProjectSettingsStep.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = $outer;
                this.$solutionNameField = $captured_local_variable$1;
            }
        });
        this.mySolutionNameField = solutionNameField;
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)solutionNameField, (String)BundleBase.replaceMnemonicAmpersand((String)"&Solution name:"));
        Intrinsics.checkExpressionValueIsNotNull((Object)labeledComponent, (String)"LabeledComponent.create(\u2026rsand(\"&Solution name:\"))");
        return (JComponent)labeledComponent;
    }

    private final JComponent createProjectNameComponent(File defaultName) {
        JTextField projectNameField = new JTextField(defaultName.getName());
        projectNameField.addKeyListener(new KeyAdapter(this, projectNameField){
            final /* synthetic */ RiderProjectSettingsStep this$0;
            final /* synthetic */ JTextField $projectNameField;

            public void keyReleased(@Nullable KeyEvent e2) {
                RiderProjectSettingsStep.access$setProjectNameSetByUser$p(this.this$0, true);
                if (!RiderProjectSettingsStep.access$getSolutionNameSetByUser$p(this.this$0)) {
                    JTextField jTextField = RiderProjectSettingsStep.access$getMySolutionNameField$p(this.this$0);
                    if (jTextField != null) {
                        jTextField.setText(this.$projectNameField.getText());
                    }
                }
                this.this$0.checkValid();
                RiderProjectSettingsStep.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = $outer;
                this.$projectNameField = $captured_local_variable$1;
            }
        });
        this.myProjectNameField = projectNameField;
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)projectNameField, (String)BundleBase.replaceMnemonicAmpersand((String)"&Project name:"));
        Intrinsics.checkExpressionValueIsNotNull((Object)labeledComponent, (String)"LabeledComponent.create(\u2026ersand(\"&Project name:\"))");
        return (JComponent)labeledComponent;
    }

    private final LabeledComponent<TextFieldWithBrowseButton> createDirectoryComponent(File defaultDirectory) {
        String caption;
        TextFieldWithBrowseButton directoryField = new TextFieldWithBrowseButton();
        directoryField.setText(defaultDirectory.getPath());
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        if (this.item == null) {
            String string2 = BundleBase.replaceMnemonicAmpersand((String)"Solution &directory");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"BundleBase.replaceMnemon\u2026nd(\"Solution &directory\")");
            caption = string2;
            directoryField.addBrowseFolderListener("Select Solution Directory", "Select base directory for the solution", null, descriptor2);
        } else {
            String string3 = BundleBase.replaceMnemonicAmpersand((String)"Project &directory");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"BundleBase.replaceMnemon\u2026and(\"Project &directory\")");
            caption = string3;
            directoryField.addBrowseFolderListener("Select Project Directory", "Select directory for the project", null, descriptor2);
        }
        directoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ RiderProjectSettingsStep this$0;

            protected void textChanged(@NotNull DocumentEvent e2) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                this.this$0.checkValid();
                RiderProjectSettingsStep.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.myDirectoryField = directoryField.getTextField();
        LabeledComponent component = LabeledComponent.create((JComponent)((JComponent)directoryField), (String)caption);
        component.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        LabeledComponent labeledComponent = component;
        Intrinsics.checkExpressionValueIsNotNull((Object)labeledComponent, (String)"component");
        return labeledComponent;
    }

    private final JComponent createHintComponent() {
        JCheckBox sameDirectoryCheckBox = new JCheckBox("Put solution and project in the same directory", false);
        sameDirectoryCheckBox.addItemListener(new ItemListener(this){
            final /* synthetic */ RiderProjectSettingsStep this$0;

            public final void itemStateChanged(ItemEvent it) {
                RiderProjectSettingsStep.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = riderProjectSettingsStep;
            }
        });
        this.mySameDirectoryCheckBox = sameDirectoryCheckBox;
        return sameDirectoryCheckBox;
    }

    private final JComponent createInfoComponent() {
        JLabel component;
        this.myInfoLabel = component = new JLabel();
        component.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        return component;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final ProjectModelNode getItem() {
        return this.item;
    }

    @NotNull
    public final RiderProjectGeneratorBase getGenerator() {
        return this.generator;
    }

    public RiderProjectSettingsStep(@Nullable Project project2, @Nullable ProjectModelNode item, @NotNull RiderProjectGeneratorBase generator, @NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        super(generator, callback);
        this.project = project2;
        this.item = item;
        this.generator = generator;
    }

    public static final /* synthetic */ boolean access$getSolutionNameSetByUser$p(RiderProjectSettingsStep $this) {
        return $this.solutionNameSetByUser;
    }

    public static final /* synthetic */ void access$setSolutionNameSetByUser$p(RiderProjectSettingsStep $this, boolean bl) {
        $this.solutionNameSetByUser = bl;
    }

    public static final /* synthetic */ boolean access$getProjectNameSetByUser$p(RiderProjectSettingsStep $this) {
        return $this.projectNameSetByUser;
    }

    public static final /* synthetic */ void access$setProjectNameSetByUser$p(RiderProjectSettingsStep $this, boolean bl) {
        $this.projectNameSetByUser = bl;
    }

    @Nullable
    public static final /* synthetic */ JTextField access$getMyProjectNameField$p(RiderProjectSettingsStep $this) {
        return $this.myProjectNameField;
    }

    public static final /* synthetic */ void access$setMyProjectNameField$p(RiderProjectSettingsStep $this, @Nullable JTextField jTextField) {
        $this.myProjectNameField = jTextField;
    }

    public static final /* synthetic */ void access$updateInfo(RiderProjectSettingsStep $this) {
        $this.updateInfo();
    }

    @Nullable
    public static final /* synthetic */ JTextField access$getMySolutionNameField$p(RiderProjectSettingsStep $this) {
        return $this.mySolutionNameField;
    }

    public static final /* synthetic */ void access$setMySolutionNameField$p(RiderProjectSettingsStep $this, @Nullable JTextField jTextField) {
        $this.mySolutionNameField = jTextField;
    }
}

