/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.properties.configurations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.resharper.projectView.actions.properties.configurations.ContentEditorKt;
import com.jetbrains.resharper.projectView.actions.properties.configurations.DiagnosticPanel;
import com.jetbrains.resharper.projectView.actions.properties.configurations.DiagnosticPanelKt$sam$Runnable$61ad16b1;
import com.jetbrains.resharper.projectView.actions.properties.configurations.ExtensionsKt;
import com.jetbrains.resharper.projectView.actions.properties.configurations.SelectConfigurationAndPlatformAction;
import com.jetbrains.rider.model.RdConfigurationAndPlatform;
import com.jetbrains.rider.model.RdEditConfigurationProject;
import com.jetbrains.rider.model.RdEditConfigurationTable;
import com.jetbrains.rider.model.RdEditConfigurationTableRow;
import com.jetbrains.rider.model.RdEditSolutionPropertiesContent;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u0010\u001a\u00020\u000b2\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00160\u00122\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002J$\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00160\u0012H\u0002J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ.\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001H\u0002J\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/resharper/projectView/actions/properties/configurations/DiagnosticPanel;", "Ljavax/swing/JPanel;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/jetbrains/rider/model/RdEditSolutionPropertiesContent;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/RdEditSolutionPropertiesContent;)V", "onChange", "Lkotlin/Function0;", "", "getOnChange", "()Lkotlin/jvm/functions/Function0;", "setOnChange", "(Lkotlin/jvm/functions/Function0;)V", "FixInvalidConfigurationsLabel", "invalidConfigurations", "", "Lcom/jetbrains/rider/model/RdConfigurationAndPlatform;", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/model/RdEditConfigurationTableRow;", "Lkotlin/collections/ArrayList;", "activeSolutionConfiguration", "FixMissingConfigurationsLabel", "createDefaultSolutionConfigurations", "fixAll", "fixCurrent", "getInvalidConfigurations", "getPossibleSolutionConfigurations", "", "()[Lcom/jetbrains/rider/model/RdConfigurationAndPlatform;", "makeLinkLabel", "text", "", "parent", "row", "", "action", "makeMainLabel", "update", "", "rider"})
public final class DiagnosticPanel
extends JPanel {
    @NotNull
    private Function0<Unit> onChange;
    private final Lifetime lifetime;
    private final Project project;
    private final RdEditSolutionPropertiesContent content;

    @NotNull
    public final Function0<Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@NotNull Function0<Unit> function0) {
        Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
        this.onChange = function0;
    }

    public final boolean update() {
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> invalidConfigurations;
        RdConfigurationAndPlatform[] possibleSolutionConfigurations;
        boolean wasChange = this.getComponentCount() > 0;
        this.removeAll();
        if (this.content.getConfigurationAndPlatforms().isEmpty() && ArraysKt.any((Object[])(possibleSolutionConfigurations = this.getPossibleSolutionConfigurations()))) {
            this.FixMissingConfigurationsLabel();
            return true;
        }
        RdConfigurationAndPlatform activeSolutionConfiguration = this.content.getConfigurationAndPlatform().getValue();
        if (activeSolutionConfiguration != null && MapsKt.any(invalidConfigurations = this.getInvalidConfigurations())) {
            this.FixInvalidConfigurationsLabel(invalidConfigurations, activeSolutionConfiguration);
            return true;
        }
        return wasChange;
    }

    private final void FixMissingConfigurationsLabel() {
        this.makeMainLabel("<html>There are <b>no</b> configurations. Create at least one solution configuration to build projects. Rider can create solution configurations automatically based on existing project configurations.</html>", this);
        this.makeLinkLabel("Create solution configurations automatically", this, 1, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DiagnosticPanel this$0;

            public final void invoke() {
                DiagnosticPanel.access$createDefaultSolutionConfigurations(this.this$0);
            }
            {
                this.this$0 = diagnosticPanel;
                super(0);
            }
        }));
        this.makeLinkLabel("Edit solution configurations manually", this, 2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DiagnosticPanel this$0;

            public final void invoke() {
                SelectConfigurationAndPlatformAction.Companion.showEditDialog(DiagnosticPanel.access$getLifetime$p(this.this$0), DiagnosticPanel.access$getProject$p(this.this$0), DiagnosticPanel.access$getContent$p(this.this$0));
            }
            {
                this.this$0 = diagnosticPanel;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void FixInvalidConfigurationsLabel(Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> invalidConfigurations, RdConfigurationAndPlatform activeSolutionConfiguration) {
        boolean isApplicableForOther;
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> map2;
        int n2;
        Iterable $receiver$iv = invalidConfigurations.values();
        int sum$iv2 = 0;
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> map3 = $receiver$iv.iterator();
        while (map3.hasNext()) {
            void it;
            Object element$iv = map3.next();
            ArrayList arrayList = (ArrayList)element$iv;
            int n3 = sum$iv2;
            int n4 = it.size();
            sum$iv2 = n3 + n4;
        }
        int totalCount = sum$iv2;
        ArrayList<RdEditConfigurationTableRow> arrayList = invalidConfigurations.get(activeSolutionConfiguration);
        if (arrayList != null) {
            Collection sum$iv2 = arrayList;
            n2 = sum$iv2.size();
        } else {
            n2 = 0;
        }
        int activeCount = n2;
        this.makeMainLabel("<html>There " + StringUtil.pluralize((String)"is", (int)totalCount) + " " + totalCount + " invalid project configuration " + StringUtil.pluralize((String)"mapping", (int)totalCount) + ". " + "If you do <b>not</b> want to build these projects, remove invalid project configurations from a mapping.</html>", this);
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> map4 = map2 = (map3 = invalidConfigurations);
        if (map4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        boolean isApplicableForActive = ((Map)map4).containsKey(activeSolutionConfiguration);
        boolean bl = isApplicableForOther = !isApplicableForActive || (map2 = invalidConfigurations).size() > 1;
        if (isApplicableForOther) {
            this.makeLinkLabel("Remove " + totalCount + " invalid " + StringUtil.pluralize((String)"mapping", (int)totalCount) + " in all configurations", this, 2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DiagnosticPanel this$0;

                public final void invoke() {
                    DiagnosticPanel.access$fixAll(this.this$0);
                }
                {
                    this.this$0 = diagnosticPanel;
                    super(0);
                }
            }));
        }
        if (isApplicableForActive) {
            this.makeLinkLabel("Remove " + activeCount + " invalid " + StringUtil.pluralize((String)"mapping", (int)activeCount) + " in current configuration", this, 1, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DiagnosticPanel this$0;

                public final void invoke() {
                    DiagnosticPanel.access$fixCurrent(this.this$0);
                }
                {
                    this.this$0 = diagnosticPanel;
                    super(0);
                }
            }));
        }
    }

    private final void makeMainLabel(String text2, JPanel parent) {
        JLabel jLabel;
        JLabel $receiver = jLabel = new JLabel(text2);
        $receiver.setIcon(Messages.getWarningIcon());
        $receiver.setIconTextGap(6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Component component = $receiver;
        JPanel jPanel = parent;
        GridBagConstraints $receiver2 = gridBagConstraints;
        $receiver2.gridy = 0;
        $receiver2.weightx = 1.0;
        $receiver2.fill = 2;
        $receiver2.anchor = 21;
        $receiver2.insets = new Insets(0, 0, JBUI.scale((int)3), 0);
        GridBagConstraints gridBagConstraints2 = gridBagConstraints;
        jPanel.add(component, gridBagConstraints2);
    }

    private final void makeLinkLabel(String text2, JPanel parent, int row, Function0<Unit> action2) {
        LinkLabel linkLabel;
        Function0<Unit> function0 = action2;
        LinkLabel $receiver = linkLabel = LinkLabel.create((String)("<html><a href=" + "\"" + "fixAll" + "\"" + ">" + text2 + "</a></html>"), (Runnable)((Runnable)(function0 == null ? null : new DiagnosticPanelKt$sam$Runnable$61ad16b1(function0))));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Component component = (Component)$receiver;
        JPanel jPanel = parent;
        GridBagConstraints $receiver2 = gridBagConstraints;
        $receiver2.gridy = row;
        $receiver2.weightx = 1.0;
        $receiver2.fill = 2;
        $receiver2.anchor = 21;
        $receiver2.insets = new Insets(0, 0, JBUI.scale((int)3), 0);
        GridBagConstraints gridBagConstraints2 = gridBagConstraints;
        jPanel.add(component, gridBagConstraints2);
    }

    private final Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> getInvalidConfigurations() {
        Map invalidConfigurations = new LinkedHashMap();
        Map map2 = this.content.getView().getTables();
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            RdConfigurationAndPlatform solutionConfiguration = (RdConfigurationAndPlatform)entry2.getKey();
            entry2 = entry;
            RdEditConfigurationTable table2 = (RdEditConfigurationTable)entry2.getValue();
            Map map3 = table2.getRows();
            Iterator iterator3 = map3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Object object;
                RdConfigurationAndPlatform projectConfiguration;
                Map.Entry entry3 = entry2 = iterator3.next();
                int projectId = ((Number)entry3.getKey()).intValue();
                entry3 = entry2;
                RdEditConfigurationTableRow row = (RdEditConfigurationTableRow)entry3.getValue();
                if (!PropertyExKt.getHasValue((IReadonlyProperty)row.getConfigurationAndPlatform()) || (projectConfiguration = row.getConfigurationAndPlatform().getValue()) == null || ExtensionsKt.getProjectConfigurations(this.content, projectId).contains(projectConfiguration)) continue;
                Map $receiver$iv = invalidConfigurations;
                Object value$iv = $receiver$iv.get(solutionConfiguration);
                if (value$iv == null) {
                    ArrayList answer$iv = new ArrayList();
                    $receiver$iv.put(solutionConfiguration, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ArrayList list2 = (ArrayList)object;
                list2.add(row);
            }
        }
        return invalidConfigurations;
    }

    private final RdConfigurationAndPlatform[] getPossibleSolutionConfigurations() {
        Collection $receiver$iv;
        Object value$iv;
        Object configuration;
        Iterator<Object> iterator2;
        Map allProjectConfigurations = new LinkedHashMap();
        for (RdEditConfigurationProject configurationProject : this.content.getView().getProjects().values()) {
            iterator2 = configurationProject.getProjectConfigurationsAndPlatforms().keySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Map $receiver$iv2 = allProjectConfigurations;
                configuration = (RdConfigurationAndPlatform)iterator2.next();
                value$iv = $receiver$iv2.get(configuration);
                if (value$iv == null) {
                    Integer answer$iv = 0;
                    $receiver$iv2.put(configuration, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                int count = ((Number)object).intValue();
                $receiver$iv2 = allProjectConfigurations;
                value$iv = count + 1;
                $receiver$iv2.put(configuration, value$iv);
            }
        }
        int projectsCount = this.content.getView().getProjects().size();
        HashSet<RdConfigurationAndPlatform> possibleSolutionConfigurations = new HashSet<RdConfigurationAndPlatform>();
        Map count = allProjectConfigurations;
        iterator2 = count.entrySet().iterator();
        while (iterator2.hasNext()) {
            value$iv = configuration = (Map.Entry)iterator2.next();
            RdConfigurationAndPlatform configuration2 = (RdConfigurationAndPlatform)value$iv.getKey();
            value$iv = configuration;
            int inProjects = ((Number)value$iv.getValue()).intValue();
            if (!((double)inProjects / (double)projectsCount > 0.7)) continue;
            RdConfigurationAndPlatform solutionConfiguration = ExtensionsKt.toSolutionStyleConfiguration(configuration2);
            possibleSolutionConfigurations.add(solutionConfiguration);
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)possibleSolutionConfigurations;
        RdConfigurationAndPlatform[] rdConfigurationAndPlatformArray = thisCollection$iv.toArray(new RdConfigurationAndPlatform[thisCollection$iv.size()]);
        if (rdConfigurationAndPlatformArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (RdConfigurationAndPlatform[])((Object[])rdConfigurationAndPlatformArray);
    }

    private final void fixCurrent() {
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> map2;
        RdConfigurationAndPlatform activeSolutionConfiguration = this.content.getConfigurationAndPlatform().getValue();
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> map3 = map2 = this.getInvalidConfigurations();
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        ArrayList<RdEditConfigurationTableRow> arrayList = map3.get(activeSolutionConfiguration);
        if (arrayList == null) {
            return;
        }
        ArrayList<RdEditConfigurationTableRow> list2 = arrayList;
        for (RdEditConfigurationTableRow row : list2) {
            PropertyExKt.set(row.getConfigurationAndPlatform(), null);
        }
        this.onChange.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final void fixAll() {
        void $receiver$iv$iv;
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> $receiver$iv = this.getInvalidConfigurations();
        Map<RdConfigurationAndPlatform, ArrayList<RdEditConfigurationTableRow>> map2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void var5_4 = $receiver$iv$iv;
        Iterator iterator2 = var5_4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = (ArrayList)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        for (RdEditConfigurationTableRow row : list2) {
            PropertyExKt.set(row.getConfigurationAndPlatform(), null);
        }
        this.onChange.invoke();
    }

    private final void createDefaultSolutionConfigurations() {
        RdConfigurationAndPlatform[] possibleSolutionConfigurations = this.getPossibleSolutionConfigurations();
        Object[] objectArray = possibleSolutionConfigurations;
        if (objectArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < possibleSolutionConfigurations.length; ++i2) {
            RdConfigurationAndPlatform configuration = possibleSolutionConfigurations[i2];
            ContentEditorKt.addSolutionConfiguration(this.content, configuration, null, false);
        }
        RdConfigurationAndPlatform first = (RdConfigurationAndPlatform)CollectionsKt.firstOrNull((Iterable)this.content.getConfigurationAndPlatforms().values());
        if (first != null) {
            PropertyExKt.set(this.content.getConfigurationAndPlatform(), first);
        }
        this.onChange.invoke();
    }

    public DiagnosticPanel(@NotNull Lifetime lifetime, @NotNull Project project2, @NotNull RdEditSolutionPropertiesContent content2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        super(new GridBagLayout());
        this.lifetime = lifetime;
        this.project = project2;
        this.content = content2;
        this.onChange = onChange.1.INSTANCE;
        this.update();
    }

    public static final /* synthetic */ void access$createDefaultSolutionConfigurations(DiagnosticPanel $this) {
        $this.createDefaultSolutionConfigurations();
    }

    @NotNull
    public static final /* synthetic */ Lifetime access$getLifetime$p(DiagnosticPanel $this) {
        return $this.lifetime;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(DiagnosticPanel $this) {
        return $this.project;
    }

    @NotNull
    public static final /* synthetic */ RdEditSolutionPropertiesContent access$getContent$p(DiagnosticPanel $this) {
        return $this.content;
    }

    public static final /* synthetic */ void access$fixAll(DiagnosticPanel $this) {
        $this.fixAll();
    }

    public static final /* synthetic */ void access$fixCurrent(DiagnosticPanel $this) {
        $this.fixCurrent();
    }
}

