/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.properties.configurations.table;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.jetbrains.resharper.projectView.actions.properties.configurations.EditConfigurationsAndPlatformsDialog;
import com.jetbrains.resharper.projectView.actions.properties.configurations.EditConfigurationsAndPlatformsViewModel;
import com.jetbrains.resharper.projectView.actions.properties.configurations.ExtensionsKt;
import com.jetbrains.resharper.projectView.actions.properties.configurations.table.ConfigurationAndPlatformRenderer;
import com.jetbrains.resharper.projectView.actions.properties.configurations.table.ConfigurationRowModel;
import com.jetbrains.rider.model.RdConfigurationAndPlatform;
import com.jetbrains.rider.model.RdEditConfigurationProjectInfo;
import com.jetbrains.rider.model.RdEditConfigurationTableRow;
import com.jetbrains.rider.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor;", "Lcom/intellij/util/ui/AbstractTableCellEditor;", "()V", "getCellEditorValue", "", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "row", "", "column", "EditAction", "RemoveAction", "SelectAction", "rider"})
public final class ConfigurationAndPlatformEditor
extends AbstractTableCellEditor {
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, int row, int column) {
        ListPopup listPopup;
        Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
        Object object = value2;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.projectView.actions.properties.configurations.table.ConfigurationRowModel");
        }
        ConfigurationRowModel model2 = (ConfigurationRowModel)object;
        Rectangle rect = table2.getCellRect(row, column, true);
        Point point = new Point(rect.x, rect.y + table2.getRowHeight());
        RelativePoint relativePoint = new RelativePoint((Component)table2, point);
        int minWidth = table2.getColumnModel().getColumn(column).getWidth();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new EditAction(model2, table2));
        actionGroup.addSeparator();
        Set<RdConfigurationAndPlatform> projectConfigurations = model2.getProjectConfigurations();
        for (RdConfigurationAndPlatform projectConfiguration : projectConfigurations) {
            actionGroup.add((AnAction)new SelectAction(projectConfiguration, model2, table2));
        }
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new RemoveAction(model2, table2));
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)table2);
        ListPopup $receiver = listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext, false, null, 100);
        $receiver.setMinimumSize(new Dimension(minWidth, 10));
        $receiver.addListener((JBPopupListener)new JBPopupListener.Adapter(this, minWidth){
            final /* synthetic */ ConfigurationAndPlatformEditor this$0;
            final /* synthetic */ int $minWidth$inlined;
            {
                this.this$0 = configurationAndPlatformEditor;
                this.$minWidth$inlined = n2;
            }

            public void onClosed(LightweightWindowEvent event) {
                this.this$0.stopCellEditing();
            }
        });
        ListPopup popup2 = listPopup;
        popup2.show(relativePoint);
        return (Component)ConfigurationAndPlatformRenderer.Companion.createComboBoxLabel(model2);
    }

    @Nullable
    public Void getCellEditorValue() {
        return null;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$SelectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "projectConfiguration", "Lcom/jetbrains/rider/model/RdConfigurationAndPlatform;", "model", "Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/rider/model/RdConfigurationAndPlatform;Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getProjectConfiguration", "()Lcom/jetbrains/rider/model/RdConfigurationAndPlatform;", "getTable", "()Ljavax/swing/JTable;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "rider"})
    public static final class SelectAction
    extends AnAction {
        @NotNull
        private final RdConfigurationAndPlatform projectConfiguration;
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            Presentation presentation = e2.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            ExtensionsKt.present(this.projectConfiguration, presentation);
        }

        public void actionPerformed(@Nullable AnActionEvent e2) {
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            if (rdEditConfigurationTableRow == null) {
                Intrinsics.throwNpe();
            }
            PropertyExKt.set(rdEditConfigurationTableRow.getConfigurationAndPlatform(), this.projectConfiguration);
            TableModel tableModel2 = this.table.getModel();
            if (tableModel2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
            }
            ((AbstractTableModel)tableModel2).fireTableDataChanged();
        }

        @NotNull
        public final RdConfigurationAndPlatform getProjectConfiguration() {
            return this.projectConfiguration;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        public SelectAction(@NotNull RdConfigurationAndPlatform projectConfiguration, @NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
            Intrinsics.checkParameterIsNotNull((Object)projectConfiguration, (String)"projectConfiguration");
            Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
            Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
            this.projectConfiguration = projectConfiguration;
            this.model = model2;
            this.table = table2;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$RemoveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "model", "Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "rider"})
    public static final class RemoveAction
    extends AnAction {
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            Presentation presentation = e2.getPresentation();
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            if (rdEditConfigurationTableRow == null) {
                Intrinsics.throwNpe();
            }
            presentation.setEnabledAndVisible(rdEditConfigurationTableRow.getConfigurationAndPlatform().getValue() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            if (rdEditConfigurationTableRow == null) {
                Intrinsics.throwNpe();
            }
            PropertyExKt.set(rdEditConfigurationTableRow.getConfigurationAndPlatform(), null);
            TableModel tableModel2 = this.table.getModel();
            if (tableModel2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
            }
            ((AbstractTableModel)tableModel2).fireTableDataChanged();
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        public RemoveAction(@NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
            Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
            Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
            super("Remove", "Do not specify project configuration for the '" + ExtensionsKt.present(model2.getContent().getConfigurationAndPlatform().getValue()) + "' solution configuration. Project will be excluded from build.", AllIcons.General.Remove);
            this.model = model2;
            this.table = table2;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$EditAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "model", "Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "MyViewModel", "rider"})
    public static final class EditAction
    extends AnAction {
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public void actionPerformed(@Nullable AnActionEvent e2) {
            AnActionEvent project2;
            AnActionEvent anActionEvent = e2;
            if (anActionEvent == null || (anActionEvent = anActionEvent.getProject()) == null) {
                return;
            }
            AnActionEvent anActionEvent2 = project2 = anActionEvent;
            Intrinsics.checkExpressionValueIsNotNull((Object)anActionEvent2, (String)"project");
            EditConfigurationsAndPlatformsDialog dialog2 = new EditConfigurationsAndPlatformsDialog((Project)anActionEvent2, this.model.getLifetime(), new MyViewModel(this.model, this.table));
            dialog2.show();
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        public EditAction(@NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
            Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
            Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
            super("Edit..", "Edit project configurations and platforms", AllIcons.Actions.Edit);
            this.model = model2;
            this.table = table2;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\bH\u0014J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020\bH\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$EditAction$MyViewModel;", "Lcom/jetbrains/resharper/projectView/actions/properties/configurations/EditConfigurationsAndPlatformsViewModel;", "model", "Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "affectAllProjects", "", "getAffectAllProjects", "()Z", "allValues", "", "Lcom/jetbrains/rider/model/RdConfigurationAndPlatform;", "getAllValues", "()Ljava/util/Set;", "getModel", "()Lcom/jetbrains/resharper/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "predefinedPlatforms", "", "", "getPredefinedPlatforms", "()Ljava/lang/Iterable;", "getTable", "()Ljavax/swing/JTable;", "title", "getTitle", "()Ljava/lang/String;", "addInternal", "", "new", "base", "forProjects", "removeInternal", "old", "rider"})
        private static final class MyViewModel
        extends EditConfigurationsAndPlatformsViewModel {
            @NotNull
            private final ConfigurationRowModel model;
            @NotNull
            private final JTable table;

            @Override
            public boolean getAffectAllProjects() {
                return false;
            }

            @Override
            @NotNull
            public String getTitle() {
                return this.model.getProjectName() + " - Edit Configurations and Platforms";
            }

            @Override
            @NotNull
            public Set<RdConfigurationAndPlatform> getAllValues() {
                return this.model.getProjectConfigurations();
            }

            @Override
            @NotNull
            public Iterable<String> getPredefinedPlatforms() {
                return CollectionsKt.arrayListOf((Object[])new String[]{"AnyCPU"});
            }

            @Override
            protected void addInternal(@NotNull RdConfigurationAndPlatform rdConfigurationAndPlatform, @Nullable RdConfigurationAndPlatform base, boolean forProjects) {
                RdEditConfigurationTableRow row;
                Intrinsics.checkParameterIsNotNull((Object)rdConfigurationAndPlatform, (String)"new");
                IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> projectConfigurationsMap = this.model.getProjectConfigurationsMap();
                projectConfigurationsMap.put(rdConfigurationAndPlatform, new RdEditConfigurationProjectInfo(base));
                RdEditConfigurationTableRow rdEditConfigurationTableRow = row = this.model.getRow();
                if (rdEditConfigurationTableRow == null) {
                    Intrinsics.throwNpe();
                }
                PropertyExKt.set(rdEditConfigurationTableRow.getConfigurationAndPlatform(), rdConfigurationAndPlatform);
            }

            @Override
            protected void removeInternal(@NotNull RdConfigurationAndPlatform old, boolean forProjects) {
                RdEditConfigurationTableRow row;
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> projectConfigurationsMap = this.model.getProjectConfigurationsMap();
                projectConfigurationsMap.remove(old);
                RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
                if (rdEditConfigurationTableRow == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(row = rdEditConfigurationTableRow).getConfigurationAndPlatform().getValue(), (Object)old)) {
                    PropertyExKt.set(row.getConfigurationAndPlatform(), CollectionsKt.firstOrNull((Iterable)projectConfigurationsMap.keySet()));
                }
            }

            @NotNull
            public final ConfigurationRowModel getModel() {
                return this.model;
            }

            @NotNull
            public final JTable getTable() {
                return this.table;
            }

            public MyViewModel(@NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
                Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
                Intrinsics.checkParameterIsNotNull((Object)table2, (String)"table");
                this.model = model2;
                this.table = table2;
                this.getChanged().advise(this.model.getLifetime(), (Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        TableModel tableModel2 = this.getTable().getModel();
                        if (tableModel2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
                        }
                        ((AbstractTableModel)tableModel2).fireTableDataChanged();
                    }
                }));
            }
        }
    }
}

