/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.actions.renameAction;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.PathUtil;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.actions.ProjectViewActionBase;
import com.jetbrains.resharper.projectView.actions.renameAction.RiderRenameInputValidator;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.ProjectModelTaskResult;
import com.jetbrains.rider.model.RenameItemCommand;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J/\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/resharper/projectView/actions/renameAction/RiderRenameItemHandler;", "Lcom/jetbrains/resharper/projectView/actions/ProjectViewActionBase;", "Lcom/intellij/refactoring/rename/RenameHandler;", "()V", "actionPerformedInternal", "", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "project", "Lcom/intellij/openapi/project/Project;", "execute", "name", "", "getItemInternal", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableOnDataContext", "", "isRenaming", "rider"})
public final class RiderRenameItemHandler
extends ProjectViewActionBase
implements RenameHandler {
    public void invoke(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file2, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Presentation presentation = this.getTemplatePresentation();
        DataContext dataContext2 = dataContext;
        if (dataContext2 == null) {
            Intrinsics.throwNpe();
        }
        this.actionPerformed(AnActionEvent.createFromDataContext((String)"Rename", (Presentation)presentation, (DataContext)dataContext2));
    }

    @Override
    protected void actionPerformedInternal(@NotNull ProjectModelNode item, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        String originalName = item.getName();
        VirtualFile virtualFile = item.getVirtualFile();
        VirtualFile parentVirtualFile = virtualFile != null ? virtualFile.getParent() : null;
        RiderRenameInputValidator validator = parentVirtualFile != null ? new RiderRenameInputValidator(parentVirtualFile, originalName) : null;
        String inputName = Messages.showInputDialog((Project)project2, (String)"Enter a new name:", (String)("Rename " + originalName), null, (String)originalName, (InputValidator)((InputValidator)validator));
        CharSequence charSequence = inputName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Intrinsics.areEqual((Object)inputName, (Object)originalName) ^ true) {
            String name;
            String string2 = inputName;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (PathUtil.getFileExtension((String)(name = string2)) == null && PathUtil.getFileExtension((String)originalName) != null) {
                name = name + "." + PathUtil.getFileExtension((String)originalName);
            }
            String string3 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
            this.execute(item, string3);
        }
    }

    public final void execute(@NotNull ProjectModelNode item, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        SolutionHostExtensionsKt.processTaskResult((ProjectModelTaskResult)ExtensionsKt.syncFromBackend$default(this.getProjectModelTasks(item.getProject()).getRename(), new RenameItemCommand(item.getId(), name), item.getProject(), null, 4, null));
    }

    @Override
    @Nullable
    protected ProjectModelNode getItemInternal(@NotNull ProjectModelNode item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (ProjectModelNodeExtensionKt.isProjectFile(item) || ProjectModelNodeExtensionKt.isProjectFolder(item)) {
            return item;
        }
        return null;
    }

    public boolean isRenaming(@Nullable DataContext dataContext) {
        DataContext dataContext2 = dataContext;
        if (dataContext2 == null) {
            Intrinsics.throwNpe();
        }
        return this.getItem(dataContext2) != null;
    }

    public boolean isAvailableOnDataContext(@Nullable DataContext dataContext) {
        return this.isRenaming(dataContext);
    }

    public RiderRenameItemHandler() {
        super("Rename", "Rename", null, 4, null);
    }
}

