/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.contentModel;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtil;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.ProjectModelViewTransactions;
import com.jetbrains.resharper.projectView.contentModel.RiderContentModel;
import com.jetbrains.resharper.projectView.contentModel.RiderContentModelChange;
import com.jetbrains.resharper.projectView.contentModel.RiderContentModelStore;
import com.jetbrains.resharper.projectView.ideaInterop.RiderProjectOpenProcessor;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexVisitor;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeChange;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.TimeLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000b2\b\b\u0002\u0010$\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020\u001bH\u0002J\b\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020\u001bH\u0016J\u0006\u0010,\u001a\u00020\u001bJ\u0014\u0010-\u001a\u00020\u001b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"Lcom/jetbrains/resharper/projectView/contentModel/RiderContentModel;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "store", "Lcom/jetbrains/resharper/projectView/contentModel/RiderContentModelStore;", "transactions", "Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/contentModel/RiderContentModelStore;Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions;)V", "allExcludedPaths", "", "", "log", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "requestUpdater", "Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions$RequestUpdater;", "shouldUpdateContentModel", "", "shouldUpdateEditors", "getStore", "()Lcom/jetbrains/resharper/projectView/contentModel/RiderContentModelStore;", "getTransactions", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewTransactions;", "afterAdd", "", "node", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "afterUpdate", "nodeChange", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNodeChange;", "beforeRemove", "dump", "message", "globalLog", "onChange", "change", "Lcom/jetbrains/resharper/projectView/contentModel/RiderContentModelChange;", "performUpdate", "performUpdateContentModel", "performUpdateEditors", "projectOpened", "refresh", "updateExcludedPaths", "excludedPaths", "urlToPath", "url", "Context", "rider"})
public final class RiderContentModel
extends AbstractProjectComponent {
    private final Logger logger;
    private final StringBuilder log;
    private List<String> allExcludedPaths;
    private boolean shouldUpdateEditors;
    private boolean shouldUpdateContentModel;
    private final ProjectModelViewTransactions.RequestUpdater requestUpdater;
    @NotNull
    private final RiderContentModelStore store;
    @NotNull
    private final ProjectModelViewTransactions transactions;

    public void projectOpened() {
        VirtualFile solutionDir = this.myProject.getBaseDir();
        File moduleDir = new File(ProjectKt.getStateStore(this.myProject).getStateStorageManager().expandMacros("$PROJECT_CONFIG_DIR$")).getParentFile();
        ApplicationKt.getApplication().executeOnPooledThread(new Runnable(solutionDir){
            final /* synthetic */ VirtualFile $solutionDir;

            public final void run() {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)this.$solutionDir, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){}));
            }
            {
                this.$solutionDir = virtualFile;
            }
        });
        VirtualFile moduleDirVirtualFile = VfsUtil.findFileByIoFile((File)moduleDir, (boolean)true);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{moduleDirVirtualFile});
        ApplicationKt.getApplication().runWriteAction(new Runnable(this, moduleDir, solutionDir){
            final /* synthetic */ RiderContentModel this$0;
            final /* synthetic */ File $moduleDir;
            final /* synthetic */ VirtualFile $solutionDir;

            public final void run() {
                Module module2;
                int n2;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)RiderContentModel.access$getMyProject$p(this.this$0));
                File moduleFile = new File(this.$moduleDir, RiderProjectOpenProcessor.Companion.getModuleName() + ".iml");
                RiderContentModel.log$default(this.this$0, "Module file = '" + moduleFile + "' [Exists = " + moduleFile.exists() + "]", false, 2, null);
                Module existingModule = moduleManager.findModuleByName(RiderProjectOpenProcessor.Companion.getModuleName());
                RiderContentModel.log$default(this.this$0, "Existing module = " + existingModule, false, 2, null);
                Module[] moduleArray = (Module[])((Object[])moduleManager.getModules()).clone();
                for (n2 = 0; n2 < moduleArray.length; ++n2) {
                    module2 = moduleArray[n2];
                    if (!(Intrinsics.areEqual((Object)module2, (Object)existingModule) ^ true)) continue;
                    RiderContentModel.log$default(this.this$0, "Cleanup module " + module2.getName(), false, 2, null);
                    moduleManager.disposeModule(module2);
                }
                if (existingModule != null && Intrinsics.areEqual((Object)PathUtil.toSystemIndependentName((String)existingModule.getModuleFilePath()), (Object)PathUtil.toSystemIndependentName((String)moduleFile.getPath())) ^ true) {
                    RiderContentModel.log$default(this.this$0, "Cleanup module " + existingModule.getName() + ", actual module path " + existingModule.getModuleFilePath() + " doesn't match expected module path " + moduleFile.getPath(), false, 2, null);
                    moduleManager.disposeModule(existingModule);
                    existingModule = null;
                }
                if (existingModule == null) {
                    existingModule = moduleManager.newModule(moduleFile.getPath(), RiderProjectOpenProcessor.Companion.getModuleId());
                    RiderContentModel.log$default(this.this$0, "New module " + existingModule.getName() + " was created", false, 2, null);
                    ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)existingModule).getModifiableModel();
                    model2.addContentEntry(this.$solutionDir);
                    model2.commit();
                    RiderContentModel.log$default(this.this$0, "Solution directory " + this.$solutionDir + " was added as a content root", false, 2, null);
                }
                RiderContentModel.log$default(this.this$0, "Modules: ", false, 2, null);
                moduleArray = moduleManager.getModules();
                for (n2 = 0; n2 < moduleArray.length; ++n2) {
                    module2 = moduleArray[n2];
                    RiderContentModel.log$default(this.this$0, "-> " + module2.getName(), false, 2, null);
                    ContentEntry[] contentEntryArray = ModuleRootManager.getInstance((Module)module2).getContentEntries();
                    for (int i2 = 0; i2 < contentEntryArray.length; ++i2) {
                        ContentEntry contentEntry = contentEntryArray[i2];
                        RiderContentModel.log$default(this.this$0, "     " + contentEntry.getFile(), false, 2, null);
                    }
                }
                RiderContentModel.log$default(this.this$0, "Initial context model was built\n", false, 2, null);
            }
            {
                this.this$0 = riderContentModel;
                this.$moduleDir = file2;
                this.$solutionDir = virtualFile;
            }
        });
    }

    public final void updateExcludedPaths(@NotNull List<String> excludedPaths) {
        Intrinsics.checkParameterIsNotNull(excludedPaths, (String)"excludedPaths");
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.allExcludedPaths = excludedPaths;
        this.shouldUpdateContentModel = true;
        this.shouldUpdateEditors = true;
        this.requestUpdater.requestUpdate();
    }

    public final void refresh() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.shouldUpdateContentModel = true;
        this.shouldUpdateEditors = true;
        this.requestUpdater.requestUpdate();
    }

    public final void afterAdd(@NotNull ProjectModelNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        RiderContentModelChange change = RiderContentModelChange.Companion.afterAdd(node);
        this.onChange(change);
    }

    public final void afterUpdate(@NotNull ProjectModelNodeChange nodeChange) {
        Intrinsics.checkParameterIsNotNull((Object)nodeChange, (String)"nodeChange");
        RiderContentModelChange change = RiderContentModelChange.Companion.afterUpdate(nodeChange);
        this.onChange(change);
    }

    public final void beforeRemove(@NotNull ProjectModelNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        RiderContentModelChange change = RiderContentModelChange.Companion.beforeRemove(node);
        this.onChange(change);
    }

    private final void onChange(RiderContentModelChange change) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.transactions.isInitialized() && change.getUpdateContentModel()) {
            RiderContentModel.log$default(this, "Request content model update: " + change.getDescription(), false, 2, null);
        }
        this.shouldUpdateEditors = this.shouldUpdateEditors || change.getUpdateEditors();
        this.shouldUpdateContentModel = this.shouldUpdateContentModel || change.getUpdateContentModel();
        this.requestUpdater.requestUpdate();
    }

    @NotNull
    public final String dump() {
        StringBuilder writer;
        ApplicationKt.getApplication().assertIsDispatchThread();
        StringBuilder stringBuilder = writer = new StringBuilder();
        CharSequence charSequence = "=== IDEA Content Model ===";
        StringsKt.appendln((StringBuilder)stringBuilder.append((String)charSequence));
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] moduleArray = moduleManager.getModules();
        for (int i2 = 0; i2 < moduleArray.length; ++i2) {
            StringBuilder stringBuilder2;
            StringBuilder contentRoot;
            Module module2 = moduleArray[i2];
            StringBuilder stringBuilder3 = writer;
            CharSequence charSequence2 = "Module '" + module2.getName() + "'";
            StringsKt.appendln((StringBuilder)stringBuilder3.append((String)charSequence2));
            ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            charSequence2 = writer;
            String string2 = "-> roots:";
            StringsKt.appendln((StringBuilder)((StringBuilder)charSequence2).append(string2));
            VirtualFile[] virtualFileArray = model2.getContentRoots();
            for (int i3 = 0; i3 < virtualFileArray.length; ++i3) {
                contentRoot = virtualFileArray[i3];
                stringBuilder2 = writer;
                String string3 = "  " + contentRoot;
                StringsKt.appendln((StringBuilder)stringBuilder2.append(string3));
            }
            contentRoot = writer;
            String string4 = "-> entries:";
            StringsKt.appendln((StringBuilder)contentRoot.append(string4));
            virtualFileArray = model2.getContentEntries();
            for (int i4 = 0; i4 < virtualFileArray.length; ++i4) {
                String string5;
                StringBuilder stringBuilder4;
                StringBuilder sourceFolder;
                VirtualFile entry = virtualFileArray[i4];
                stringBuilder2 = writer;
                StringBuilder stringBuilder5 = new StringBuilder().append("  ");
                String string6 = entry.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"entry.url");
                String string7 = stringBuilder5.append(this.urlToPath(string6)).toString();
                StringsKt.appendln((StringBuilder)stringBuilder2.append(string7));
                stringBuilder2 = writer;
                string7 = "  -> source folders:";
                StringsKt.appendln((StringBuilder)stringBuilder2.append(string7));
                SourceFolder[] sourceFolderArray = entry.getSourceFolders();
                for (int i5 = 0; i5 < sourceFolderArray.length; ++i5) {
                    sourceFolder = sourceFolderArray[i5];
                    stringBuilder4 = writer;
                    StringBuilder stringBuilder6 = new StringBuilder().append("    ");
                    String string8 = sourceFolder.getUrl();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"sourceFolder.url");
                    string5 = stringBuilder6.append(this.urlToPath(string8)).toString();
                    StringsKt.appendln((StringBuilder)stringBuilder4.append(string5));
                }
                sourceFolder = writer;
                String string9 = "  -> exclude folders:";
                StringsKt.appendln((StringBuilder)sourceFolder.append(string9));
                sourceFolderArray = entry.getExcludeFolders();
                for (int i6 = 0; i6 < sourceFolderArray.length; ++i6) {
                    SourceFolder excludeFolder = sourceFolderArray[i6];
                    stringBuilder4 = writer;
                    StringBuilder stringBuilder7 = new StringBuilder().append("    ");
                    String string10 = excludeFolder.getUrl();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"excludeFolder.url");
                    string5 = stringBuilder7.append(this.urlToPath(string10)).toString();
                    StringsKt.appendln((StringBuilder)stringBuilder4.append(string5));
                }
            }
            model2.dispose();
        }
        StringsKt.appendln((StringBuilder)writer);
        StringsKt.appendln((StringBuilder)writer);
        charSequence = writer;
        String string11 = "=== Store ===";
        StringsKt.appendln((StringBuilder)((StringBuilder)charSequence).append(string11));
        this.store.dump(writer);
        StringsKt.appendln((StringBuilder)writer);
        StringsKt.appendln((StringBuilder)writer);
        charSequence = writer;
        string11 = "=== Log ===";
        StringsKt.appendln((StringBuilder)((StringBuilder)charSequence).append(string11));
        writer.append((CharSequence)this.log);
        String string12 = writer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"writer.toString()");
        return string12;
    }

    private final void performUpdate() {
        if (this.shouldUpdateContentModel) {
            this.performUpdateContentModel();
            this.shouldUpdateContentModel = false;
        }
        if (this.shouldUpdateEditors) {
            this.performUpdateEditors();
            this.shouldUpdateEditors = false;
        }
    }

    private final void performUpdateContentModel() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Object[] $receiver$iv = moduleManager.getModules();
        Object single$iv = null;
        boolean found$iv = false;
        for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
            Object element$iv = $receiver$iv[i2];
            Module it = (Module)element$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)RiderProjectOpenProcessor.Companion.getModuleName())) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Module module2 = (Module)single$iv;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        ComponentManager $receiver$iv2 = (ComponentManager)this.myProject;
        Object object = $receiver$iv2.getComponent(ProjectModelViewHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv2);
        }
        ProjectModelViewHost host = (ProjectModelViewHost)object;
        ApplicationKt.getApplication().runWriteAction(new Runnable(this, rootManager, host){
            final /* synthetic */ RiderContentModel this$0;
            final /* synthetic */ ModuleRootManager $rootManager;
            final /* synthetic */ ProjectModelViewHost $host;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                TimeLogger timeLogger = new TimeLogger();
                ModifiableRootModel model2 = this.$rootManager.getModifiableModel();
                model2.clear();
                try {
                    VirtualFileIndexVisitor visitor2 = new VirtualFileIndexVisitor(this, model2){
                        final /* synthetic */ performUpdateContentModel.1 this$0;
                        final /* synthetic */ ModifiableRootModel $model;

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public Pair<VirtualFileIndexVisitor.Result, Object> visitEntry(@NotNull String name, @NotNull VirtualFileIndexEntry entry, @Nullable Object context2) {
                            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                            if (context2 == null) {
                                return new Pair((Object)((Object)VirtualFileIndexVisitor.Result.Continue), (Object)new Context(null, null));
                            }
                            Object object = context2;
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.projectView.contentModel.RiderContentModel.Context");
                            }
                            Context ctx = (Context)object;
                            File file2 = new File(ctx.getParentFile(), name);
                            if (CollectionsKt.any((Iterable)entry.getProjectModelIds())) {
                                boolean bl;
                                ContentEntry contentEntry;
                                String url;
                                block7: {
                                    void $receiver$iv$iv;
                                    url = "file" + "://" + file2.getPath();
                                    ContentEntry contentEntry2 = ctx.getExistingContentEntry();
                                    if (contentEntry2 == null) {
                                        ContentEntry contentEntry3 = this.$model.addContentEntry(url);
                                        contentEntry2 = contentEntry3;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry3, (String)"model.addContentEntry(url)");
                                    }
                                    contentEntry = contentEntry2;
                                    Iterable $receiver$iv = entry.getProjectModelIds();
                                    Iterable iterable = $receiver$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                    for (T item$iv$iv : $receiver$iv$iv) {
                                        void it;
                                        int n2 = ((Number)item$iv$iv).intValue();
                                        Collection collection = destination$iv$iv;
                                        ProjectModelNode projectModelNode = this.this$0.$host.getItemById((int)it);
                                        collection.add(projectModelNode);
                                    }
                                    List nodes = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                                    $receiver$iv = nodes;
                                    for (E element$iv : $receiver$iv) {
                                        ProjectModelNode it = (ProjectModelNode)element$iv;
                                        if (ProjectModelNodeExtensionKt.isSolution(it) || ProjectModelNodeExtensionKt.isSolutionFolder(it)) continue;
                                        bl = false;
                                        break block7;
                                    }
                                    bl = true;
                                }
                                if (bl) {
                                    return new Pair((Object)((Object)VirtualFileIndexVisitor.Result.Continue), (Object)new Context(file2, contentEntry));
                                }
                                contentEntry.addSourceFolder(url, false);
                                return new Pair((Object)((Object)VirtualFileIndexVisitor.Result.Stop), null);
                            }
                            return new Pair((Object)((Object)VirtualFileIndexVisitor.Result.Continue), (Object)new Context(file2, ctx.getExistingContentEntry()));
                        }
                        {
                            this.this$0 = $outer;
                            this.$model = $captured_local_variable$1;
                        }
                    };
                    VirtualFileIndex.visit$default(this.$host.getVirtualFileIndex(), visitor2, null, 2, null);
                    Set excludedPaths = CollectionsKt.union((Iterable)RiderContentModel.access$getAllExcludedPaths$p(this.this$0), (Iterable)ArraysKt.asIterable((Object[])this.this$0.getStore().getExcludedPaths()));
                    for (String excludedPath : excludedPaths) {
                        File file2 = new File(excludedPath);
                        String url = "file" + "://" + file2.getPath();
                        ContentEntry[] contentEntryArray = model2.getContentEntries();
                        for (int i2 = 0; i2 < contentEntryArray.length; ++i2) {
                            ContentEntry entry = contentEntryArray[i2];
                            String string2 = entry.getUrl();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.url");
                            String entryPath = RiderContentModel.access$urlToPath(this.this$0, string2);
                            File entryFile = new File(entryPath);
                            if (!FileUtil.isAncestor((File)entryFile, (File)file2, (boolean)false)) continue;
                            entry.addExcludeFolder(url);
                        }
                    }
                    timeLogger.section("Commit", (Function0)new Function0<Unit>(model2){
                        final /* synthetic */ ModifiableRootModel $model;

                        public final void invoke() {
                            this.$model.commit();
                        }
                        {
                            this.$model = modifiableRootModel;
                            super(0);
                        }
                    });
                }
                catch (Exception ex) {
                    RiderContentModel.access$getLogger$p(this.this$0).error((Throwable)ex);
                }
                finally {
                    if (!model2.isDisposed()) {
                        model2.dispose();
                    }
                    String message2 = timeLogger.complete("Content model was updated");
                    RiderContentModel.log$default(this.this$0, message2, false, 2, null);
                }
            }
            {
                this.this$0 = riderContentModel;
                this.$rootManager = moduleRootManager;
                this.$host = projectModelViewHost;
            }
        });
    }

    private final void performUpdateEditors() {
        this.log("Update editors...", false);
        if (this.myProject.isDisposed()) {
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
        for (int i2 = 0; i2 < virtualFileArray.length; ++i2) {
            VirtualFile file2 = virtualFileArray[i2];
            fileEditorManager.updateFilePresentation(file2);
        }
    }

    private final void log(String message2, boolean globalLog) {
        if (globalLog) {
            this.logger.debug(message2);
        }
        if (ApplicationKt.getApplication().isInternal()) {
            StringBuilder stringBuilder = this.log;
            StringsKt.appendln((StringBuilder)stringBuilder.append(message2));
        }
    }

    static /* bridge */ /* synthetic */ void log$default(RiderContentModel riderContentModel, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        riderContentModel.log(string2, bl);
    }

    private final String urlToPath(String url) {
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)url, (CharSequence)"file"), (CharSequence)"://");
    }

    @NotNull
    public final RiderContentModelStore getStore() {
        return this.store;
    }

    @NotNull
    public final ProjectModelViewTransactions getTransactions() {
        return this.transactions;
    }

    public RiderContentModel(@NotNull Project project2, @NotNull RiderContentModelStore store, @NotNull ProjectModelViewTransactions transactions) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)store), (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)((Object)transactions), (String)"transactions");
        super(project2);
        this.store = store;
        this.transactions = transactions;
        RiderContentModel riderContentModel = this;
        Logger logger = Logger.getInstance(RiderContentModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        riderContentModel.logger = object = logger;
        this.log = new StringBuilder();
        riderContentModel = this;
        riderContentModel.allExcludedPaths = object = CollectionsKt.emptyList();
        this.requestUpdater = this.transactions.createRequestUpdater("ContentModel", (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.performUpdate();
            }
        }));
    }

    public static final /* synthetic */ Project access$getMyProject$p(RiderContentModel $this) {
        return $this.myProject;
    }

    @NotNull
    public static final /* synthetic */ List access$getAllExcludedPaths$p(RiderContentModel $this) {
        return $this.allExcludedPaths;
    }

    public static final /* synthetic */ void access$setAllExcludedPaths$p(RiderContentModel $this, @NotNull List list2) {
        $this.allExcludedPaths = list2;
    }

    @NotNull
    public static final /* synthetic */ String access$urlToPath(RiderContentModel $this, @NotNull String url) {
        return $this.urlToPath(url);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(RiderContentModel $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/projectView/contentModel/RiderContentModel$Context;", "", "parentFile", "Ljava/io/File;", "existingContentEntry", "Lcom/intellij/openapi/roots/ContentEntry;", "(Ljava/io/File;Lcom/intellij/openapi/roots/ContentEntry;)V", "getExistingContentEntry", "()Lcom/intellij/openapi/roots/ContentEntry;", "getParentFile", "()Ljava/io/File;", "rider"})
    private static final class Context {
        @Nullable
        private final File parentFile;
        @Nullable
        private final ContentEntry existingContentEntry;

        @Nullable
        public final File getParentFile() {
            return this.parentFile;
        }

        @Nullable
        public final ContentEntry getExistingContentEntry() {
            return this.existingContentEntry;
        }

        public Context(@Nullable File parentFile, @Nullable ContentEntry existingContentEntry) {
            this.parentFile = parentFile;
            this.existingContentEntry = existingContentEntry;
        }
    }
}

