/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.ideaInterop;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.jetbrains.resharper.projectView.utils.SolutionFilesFinder;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J$\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderCheckoutListener;", "Lcom/intellij/openapi/vcs/checkout/VcsAwareCheckoutListener;", "()V", "OpenProject", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "addRoot", "", "project", "directory", "Ljava/io/File;", "vcsKey", "Lcom/intellij/openapi/vcs/VcsKey;", "findSolutionFile", "processCheckedOutDirectory", "", "rider"})
public final class RiderCheckoutListener
implements VcsAwareCheckoutListener {
    public boolean processCheckedOutDirectory(@Nullable Project project2, @Nullable File directory, @NotNull VcsKey vcsKey) {
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)vcsKey, (String)"vcsKey");
        if (directory == null) {
            return false;
        }
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile = virtualFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
        VirtualFile virtualFile4 = this.findSolutionFile(virtualFile3);
        if (virtualFile4 == null) {
            return true;
        }
        VirtualFile file2 = virtualFile4;
        TransactionGuard.submitTransaction((Disposable)((Disposable)ApplicationKt.getApplication()), (Runnable)new Runnable(this, file2, directory, vcsKey){
            final /* synthetic */ RiderCheckoutListener this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ File $directory;
            final /* synthetic */ VcsKey $vcsKey;

            public final void run() {
                Project openedProject = RiderCheckoutListener.access$OpenProject(this.this$0, this.$file);
                RiderCheckoutListener.access$addRoot(this.this$0, openedProject, this.$directory, this.$vcsKey);
            }
            {
                this.this$0 = riderCheckoutListener;
                this.$file = virtualFile;
                this.$directory = file2;
                this.$vcsKey = vcsKey;
            }
        });
        return true;
    }

    private final VirtualFile findSolutionFile(VirtualFile directory) {
        Collection $receiver$iv;
        VirtualFile[] files2 = SolutionFilesFinder.Companion.chooseSolutionFileInside(directory);
        Object[] objectArray = files2;
        if (objectArray.length == 0) {
            Messages.showInfoMessage((String)"There are no solution files in this directory", (String)"Unable to open a solution");
            return null;
        }
        objectArray = files2;
        if (objectArray.length == 1) {
            return (VirtualFile)ArraysKt.single((Object[])files2);
        }
        HashMap<String, VirtualFile> mapping = new HashMap<String, VirtualFile>();
        for (int i2 = 0; i2 < files2.length; ++i2) {
            VirtualFile file2 = files2[i2];
            String string2 = file2.getPath();
            String string3 = directory.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"directory.path");
            String visibleFileName = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string2, (CharSequence)string3), (CharSequence)"\\"), (CharSequence)"/");
            mapping.put(visibleFileName, file2);
        }
        Collection collection = $receiver$iv = (Collection)CollectionsKt.sorted((Iterable)mapping.keySet());
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] visibleFileNameList = (String[])((Object[])stringArray);
        int index = Messages.showChooseDialog((String)"Select solution to open", (String)"Choose Solution to Open", (String[])visibleFileNameList, (String)visibleFileNameList[0], null);
        if (index < 0) {
            return null;
        }
        return (VirtualFile)mapping.get(visibleFileNameList[index]);
    }

    private final void addRoot(Project project2, File directory, VcsKey vcsKey) {
        if (project2 == null) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        if (!vcsManager.hasAnyMappings()) {
            String path = directory.getPath();
            vcsManager.setDirectoryMappings(Collections.singletonList(new VcsDirectoryMapping(path, vcsKey.getName())));
        }
    }

    private final Project OpenProject(VirtualFile file2) {
        ProjectOpenProcessor projectOpenProcessor = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
        if (projectOpenProcessor == null) {
            Intrinsics.throwNpe();
        }
        return projectOpenProcessor.doOpenProject(file2, null, false);
    }

    @Nullable
    public static final /* synthetic */ Project access$OpenProject(RiderCheckoutListener $this, @NotNull VirtualFile file2) {
        return $this.OpenProject(file2);
    }

    public static final /* synthetic */ void access$addRoot(RiderCheckoutListener $this, @Nullable Project project2, @NotNull File directory, @NotNull VcsKey vcsKey) {
        $this.addRoot(project2, directory, vcsKey);
    }
}

