/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.ideaInterop;

import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeaFrameTitleBuilder;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderFrameTitleBuilder;", "Lcom/intellij/openapi/wm/IdeaFrameTitleBuilder;", "()V", "getFileTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectTitle", "rider"})
public final class RiderFrameTitleBuilder
extends IdeaFrameTitleBuilder {
    @Override
    @NotNull
    public String getFileTitle(@NotNull Project project2, @NotNull VirtualFile file2) {
        VirtualFile parent;
        block9: {
            String fileTitle;
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                if (!SolutionHostExtensionsKt.getHasSolution(project2)) {
                    String string2 = super.getProjectTitle(project2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getProjectTitle(project)");
                    return string2;
                }
                fileTitle = EditorTabbedContainer.calcTabTitle(project2, file2);
                if (SystemInfo.isMac) {
                    String string3 = fileTitle;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fileTitle");
                    return string3;
                }
                parent = file2.getParent();
                if (parent == null) break block8;
                String string4 = file2.getPresentableName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"file.presentableName");
                if (StringsKt.endsWith$default((String)fileTitle, (String)string4, (boolean)false, (int)2, null)) break block9;
            }
            String string5 = fileTitle;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"fileTitle");
            return string5;
        }
        String url = FileUtil.getLocationRelativeToUserHome((String)(parent.getPresentableUrl() + File.separator + file2.getName()));
        VirtualFile solutionDir = project2.getBaseDir();
        if (solutionDir != null && !SystemInfo.isMac) {
            String projectHomeUrl;
            String string6 = projectHomeUrl = solutionDir.getPresentableUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"projectHomeUrl");
            if (StringsKt.startsWith$default((String)url, (String)string6, (boolean)false, (int)2, null)) {
                String string7 = url;
                int n2 = projectHomeUrl.length();
                StringBuilder stringBuilder = new StringBuilder().append("...");
                String string8 = string7;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                String string10 = string9;
                return stringBuilder.append(string10).toString();
            }
        }
        String string11 = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"url");
        return string11;
    }

    @Override
    @NotNull
    public String getProjectTitle(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (!SolutionHostExtensionsKt.getHasSolution(project2)) {
            String string2 = super.getProjectTitle(project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getProjectTitle(project)");
            return string2;
        }
        String solutionName = SolutionHostExtensionsKt.getSolutionName(project2);
        String solutionPath = SolutionHostExtensionsKt.getSolutionPath(project2);
        String presentableSolutionPath = FileUtil.toSystemDependentName((String)solutionPath);
        return solutionName + " - [" + FileUtil.getLocationRelativeToUserHome((String)presentableSolutionPath) + "]";
    }
}

