/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.ideaInterop;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.resharper.projectView.ideaInterop.RiderPlatformProjectOpenProcessor;
import com.jetbrains.resharper.projectView.ideaInterop.RiderPlatformProjectOpenProcessor$WhenMappings;
import com.jetbrains.resharper.projectView.ideaInterop.RiderProjectOpenProcessor;
import com.jetbrains.resharper.projectView.utils.MatchingSolutionFinder;
import com.jetbrains.resharper.projectView.utils.SolutionFilesFinder;
import com.jetbrains.resharper.projectView.utils.TempSolutionManager;
import com.jetbrains.rider.model.OpenExistingSolution;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\"\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor;", "Lcom/intellij/platform/PlatformProjectOpenProcessor;", "()V", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectToClose", "line", "", "options", "Ljava/util/EnumSet;", "Lcom/intellij/platform/PlatformProjectOpenProcessor$Option;", "openFile", "", "project", "file", "Companion", "ExistingSolutionChooserDialog", "rider"})
public final class RiderPlatformProjectOpenProcessor
extends PlatformProjectOpenProcessor {
    @NotNull
    private static final Key<Boolean> existingSolutionFromCommandLineKey;
    public static final Companion Companion;

    @Override
    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, int line, @NotNull EnumSet<PlatformProjectOpenProcessor.Option> options) {
        Project openedProject;
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        boolean forceOpenInNewFrame = options.contains((Object)PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
        boolean tempProject = options.contains((Object)PlatformProjectOpenProcessor.Option.TEMP_PROJECT);
        if (!forceOpenInNewFrame && (openedProject = MatchingSolutionFinder.Companion.findMatchingSolution(virtualFile)) != null) {
            this.openFile(openedProject, virtualFile, line);
            return openedProject;
        }
        if (!tempProject) {
            VirtualFile virtualFile2 = virtualFile.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"virtualFile.parent");
            VirtualFile[] solutionFiles = SolutionFilesFinder.Companion.chooseSolutionFileOutside(virtualFile2);
            if (ArraysKt.any((Object[])solutionFiles)) {
                ExistingSolutionChooserDialog dialog2 = new ExistingSolutionChooserDialog(solutionFiles);
                dialog2.show();
                switch (RiderPlatformProjectOpenProcessor$WhenMappings.$EnumSwitchMapping$0[dialog2.getResult().ordinal()]) {
                    case 1: {
                        Object object = dialog2.getBox().getSelectedItem();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFile");
                        }
                        VirtualFile solutionFile = (VirtualFile)object;
                        String string2 = solutionFile.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"solutionFile.path");
                        OpenExistingSolution solutionOpenStrategy = new OpenExistingSolution(string2, true);
                        Project project2 = RiderProjectOpenProcessor.Companion.doOpenSolution(projectToClose, forceOpenInNewFrame, solutionOpenStrategy);
                        this.openFile(project2, virtualFile, line);
                        Project project3 = project2;
                        if (project3 != null) {
                            project3.putUserData(Companion.getExistingSolutionFromCommandLineKey(), (Object)true);
                        }
                        return project2;
                    }
                    case 2: {
                        tempProject = true;
                        break;
                    }
                    case 3: {
                        WelcomeFrame.showIfNoProjectOpened();
                        return null;
                    }
                }
            }
        }
        if (tempProject || Registry.is((String)"ide.open.file.in.temp.project.dir")) {
            VirtualFile tempSolutionFile = TempSolutionManager.Companion.getOrCreateSolutionFile();
            if (tempSolutionFile == null) {
                WelcomeFrame.showIfNoProjectOpened();
                return RiderProjectOpenProcessor.Companion.showErrorAndThrow("Cannot create an empty solution for file '" + virtualFile + "'");
            }
            String string3 = tempSolutionFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"tempSolutionFile.path");
            Project project4 = RiderProjectOpenProcessor.Companion.doOpenSolution(projectToClose, forceOpenInNewFrame, new OpenExistingSolution(string3, true));
            this.openFile(project4, virtualFile, line);
            return project4;
        }
        WelcomeFrame.showIfNoProjectOpened();
        return null;
    }

    private final void openFile(Project project2, VirtualFile file2, int line) {
        if (project2 == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(project2, file2, line){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $line;

            public final void run() {
                if (!this.$project.isDisposed() && this.$file.isValid() && !this.$file.isDirectory()) {
                    if (this.$line > 0) {
                        new OpenFileDescriptor(this.$project, this.$file, this.$line - 1, 0).navigate(true);
                    } else {
                        new OpenFileDescriptor(this.$project, this.$file).navigate(true);
                    }
                }
            }
            {
                this.$project = project2;
                this.$file = virtualFile;
                this.$line = n2;
            }
        }, ModalityState.NON_MODAL);
    }

    static {
        Companion = new Companion(null);
        existingSolutionFromCommandLineKey = new Key("ExistingSolutionFromCommandLine");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\u0016\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0018\u001a\r\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a0\u0003H\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0014J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003H\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0016\u0010 \u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u0007H\u0016R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "box", "Ljavax/swing/JComboBox;", "kotlin.jvm.PlatformType", "getBox", "()Ljavax/swing/JComboBox;", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getPanel", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "result", "Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog$Result;", "getResult", "()Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog$Result;", "setResult", "(Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog$Result;)V", "tempAction", "com/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog$tempAction$1", "Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog$tempAction$1;", "createActions", "Ljavax/swing/Action;", "Lorg/jetbrains/annotations/NotNull;", "()[Ljavax/swing/Action;", "createCenterPanel", "createLeftSideActions", "doOKAction", "", "getPreferredFocusedComponent", "Result", "rider"})
    private static final class ExistingSolutionChooserDialog
    extends DialogWrapper {
        @NotNull
        private final JComboBox<VirtualFile> box;
        @NotNull
        private final BorderLayoutPanel panel;
        private final tempAction.1 tempAction;
        @NotNull
        private Result result;

        @NotNull
        public final JComboBox<VirtualFile> getBox() {
            return this.box;
        }

        @NotNull
        public final BorderLayoutPanel getPanel() {
            return this.panel;
        }

        @NotNull
        public final Result getResult() {
            return this.result;
        }

        public final void setResult(@NotNull Result result2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)result2), (String)"<set-?>");
            this.result = result2;
        }

        @NotNull
        protected BorderLayoutPanel createCenterPanel() {
            return this.panel;
        }

        @NotNull
        public JComboBox<VirtualFile> getPreferredFocusedComponent() {
            return this.box;
        }

        protected void doOKAction() {
            this.result = Result.OpenProject;
            this.close(0);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] elements$iv = new Action[]{this.getOKAction(), this.getCancelAction()};
            return (Action[])((Object[])elements$iv);
        }

        @NotNull
        protected Action[] createLeftSideActions() {
            Action[] elements$iv = new Action[]{this.tempAction};
            return (Action[])((Object[])elements$iv);
        }

        public ExistingSolutionChooserDialog(@NotNull VirtualFile[] files2) {
            BorderLayoutPanel borderLayoutPanel;
            Intrinsics.checkParameterIsNotNull((Object)files2, (String)"files");
            super(null, null, true, DialogWrapper.IdeModalityType.IDE);
            this.box = new JComboBox(new DefaultComboBoxModel<Object>((Object[])files2));
            BorderLayoutPanel borderLayoutPanel2 = new BorderLayoutPanel();
            ExistingSolutionChooserDialog existingSolutionChooserDialog = this;
            BorderLayoutPanel $receiver = borderLayoutPanel2;
            $receiver.addToCenter((Component)this.box);
            existingSolutionChooserDialog.panel = borderLayoutPanel = borderLayoutPanel2;
            this.tempAction = new AbstractAction(this, "Open in temp solution"){
                final /* synthetic */ ExistingSolutionChooserDialog this$0;

                public void actionPerformed(@Nullable ActionEvent e2) {
                    this.this$0.setResult(Result.OpenTempProject);
                    this.this$0.close(0);
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
            this.setTitle("Select a Solution to Open the File in");
            this.init();
            this.result = Result.Cancel;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$ExistingSolutionChooserDialog$Result;", "", "(Ljava/lang/String;I)V", "OpenProject", "OpenTempProject", "Cancel", "rider"})
        public static final class Result
        extends Enum<Result> {
            public static final /* enum */ Result OpenProject;
            public static final /* enum */ Result OpenTempProject;
            public static final /* enum */ Result Cancel;
            private static final /* synthetic */ Result[] $VALUES;

            static {
                Result[] resultArray = new Result[3];
                Result[] resultArray2 = resultArray;
                resultArray[0] = OpenProject = new Result();
                resultArray[1] = OpenTempProject = new Result();
                resultArray[2] = Cancel = new Result();
                $VALUES = resultArray;
            }

            public static Result[] values() {
                return (Result[])$VALUES.clone();
            }

            public static Result valueOf(String string2) {
                return Enum.valueOf(Result.class, string2);
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderPlatformProjectOpenProcessor$Companion;", "", "()V", "existingSolutionFromCommandLineKey", "Lcom/intellij/openapi/util/Key;", "", "getExistingSolutionFromCommandLineKey", "()Lcom/intellij/openapi/util/Key;", "rider"})
    public static final class Companion {
        @NotNull
        public final Key<Boolean> getExistingSolutionFromCommandLineKey() {
            return existingSolutionFromCommandLineKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

