/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.ideaInterop;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ComponentContainerUtilKt;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.RdCommandProcessor;
import com.jetbrains.rider.model.ReloadCommand;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0016\u0010\u0005\u001a\u00020\u00068BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectModelUndoProvider;", "Lcom/intellij/openapi/command/impl/UndoProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isInsideBackendCommand", "", "()Z", "isInsideCommand", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "protocolCommandProcessor", "Lcom/jetbrains/rider/model/RdCommandProcessor;", "commandFinished", "", "commandStarted", "processMSBuildFileChanged", "path", "", "processNetCoreProjectFileChanged", "NetCoreReloadRequest", "SaveRequest", "rider"})
public final class RiderProjectModelUndoProvider
implements UndoProvider {
    private boolean isInsideCommand;
    private final Logger logger;
    private boolean isInsideBackendCommand;
    private final RdCommandProcessor protocolCommandProcessor;
    @NotNull
    private final Project project;

    private final boolean isInsideBackendCommand() {
        return PropertyExKt.getHasValue(this.protocolCommandProcessor.getCurrentCommand()) && this.protocolCommandProcessor.getCurrentCommand().getValue() != null;
    }

    @Override
    public void commandStarted(@Nullable Project project2) {
        this.isInsideCommand = true;
    }

    @Override
    public void commandFinished(@Nullable Project project2) {
        this.isInsideCommand = false;
    }

    private final void processMSBuildFileChanged(String path) {
        if (this.isInsideBackendCommand() && this.isInsideCommand) {
            this.logger.trace("MSbuild file " + path + " has changed during command");
            UndoManager undoManager = UndoManager.getInstance((Project)this.project);
            if (undoManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            }
            UndoManagerImpl undoManager2 = (UndoManagerImpl)undoManager;
            undoManager2.undoableActionPerformed((UndoableAction)SaveRequest.Companion.getInstance());
        }
    }

    private final void processNetCoreProjectFileChanged(String path) {
        if (this.isInsideBackendCommand() && this.isInsideCommand) {
            this.logger.trace("Net Core project file " + path + " has changed during command");
            UndoManager undoManager = UndoManager.getInstance((Project)this.project);
            if (undoManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            }
            UndoManagerImpl undoManager2 = (UndoManagerImpl)undoManager;
            undoManager2.undoableActionPerformed((UndoableAction)new NetCoreReloadRequest(path, this.project));
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RiderProjectModelUndoProvider(@NotNull Project project2) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        RiderProjectModelUndoProvider riderProjectModelUndoProvider = this;
        Logger logger2 = Logger.getInstance(RiderProjectModelUndoProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        riderProjectModelUndoProvider.logger = logger = logger2;
        this.protocolCommandProcessor = SolutionHostExtensionsKt.getSolution(this.project).getEditors().getCommandProcessor();
        SolutionHostExtensionsKt.getSolution(this.project).getProjectModelSinks().getMSBuildFileChanged().advise(DisposableExKt.makeLifetime((Disposable)this.project), (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                this.processMSBuildFileChanged(path);
            }
        }));
        SolutionHostExtensionsKt.getSolution(this.project).getProjectModelSinks().getNetCoreProjectChanged().advise(DisposableExKt.makeLifetime((Disposable)this.project), (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                this.processNetCoreProjectFileChanged(path);
            }
        }));
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectModelUndoProvider$SaveRequest;", "Lcom/intellij/openapi/command/undo/GlobalUndoableAction;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "redo", "", "saveAndRefresh", "undo", "Companion", "rider"})
    private static final class SaveRequest
    extends GlobalUndoableAction {
        private final Logger logger;
        @NotNull
        private static final SaveRequest instance;
        public static final Companion Companion;

        public void undo() {
            this.saveAndRefresh();
        }

        public void redo() {
            this.saveAndRefresh();
        }

        private final void saveAndRefresh() {
            this.logger.trace("saveAndRefresh command refresh during undo/redo");
            ApplicationKt.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ SaveRequest this$0;

                public final void run() {
                    SaveRequest.access$getLogger$p(this.this$0).trace("performing saving all files/refresh vfs...");
                    ApplicationKt.getApplication().saveAll();
                    LocalFileSystem.getInstance().refresh(false);
                    SaveRequest.access$getLogger$p(this.this$0).trace("done saving all files/refresh vfs.");
                }
                {
                    this.this$0 = saveRequest;
                }
            });
        }

        public SaveRequest() {
            Logger logger;
            SaveRequest saveRequest = this;
            Logger logger2 = Logger.getInstance(RiderProjectModelUndoProvider.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
            saveRequest.logger = logger = logger2;
        }

        static {
            Companion = new Companion(null);
            instance = new SaveRequest();
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLogger$p(SaveRequest $this) {
            return $this.logger;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectModelUndoProvider$SaveRequest$Companion;", "", "()V", "instance", "Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectModelUndoProvider$SaveRequest;", "getInstance", "()Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectModelUndoProvider$SaveRequest;", "rider"})
        public static final class Companion {
            @NotNull
            public final SaveRequest getInstance() {
                return instance;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectModelUndoProvider$NetCoreReloadRequest;", "Lcom/intellij/openapi/command/undo/GlobalUndoableAction;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getPath", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "redo", "", "reloadAffectedProjects", "undo", "rider"})
    private static final class NetCoreReloadRequest
    extends GlobalUndoableAction {
        private final Logger logger;
        @NotNull
        private final String path;
        @NotNull
        private final Project project;

        public void undo() {
            this.reloadAffectedProjects();
        }

        public void redo() {
            this.reloadAffectedProjects();
        }

        private final void reloadAffectedProjects() {
            VirtualFileIndex vfsIndex = VirtualFileIndex.Companion.getInstance(this.project);
            if (this.project.isDisposed()) {
                return;
            }
            VirtualFile virtualFile = ComponentContainerUtilKt.toVirtualFile(this.path);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            VirtualFileIndexEntry virtualFileIndexEntry = vfsIndex.get(virtualFile2);
            if (virtualFileIndexEntry == null) {
                return;
            }
            VirtualFileIndexEntry entry = virtualFileIndexEntry;
            this.logger.trace("reloadAffectedProjects command refresh during undo/redo");
            ReloadCommand command = new ReloadCommand(CollectionsKt.toList((Iterable)entry.getProjectModelIds()));
            ExtensionsKt.syncFromBackend$default(SolutionHostExtensionsKt.getSolution(this.project).getProjectModelTasks().getReloadProjects(), command, this.project, null, 4, null);
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public NetCoreReloadRequest(@NotNull String path, @NotNull Project project2) {
            Logger logger;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            this.path = path;
            this.project = project2;
            NetCoreReloadRequest netCoreReloadRequest = this;
            Logger logger2 = Logger.getInstance(RiderProjectModelUndoProvider.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
            netCoreReloadRequest.logger = logger = logger2;
        }
    }
}

