/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.ideaInterop;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.jetbrains.resharper.ideaInterop.fileTypes.sln.SolutionFileType;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.SolutionInitializer;
import com.jetbrains.resharper.projectView.actions.addExisting.AddExistingProjectAction;
import com.jetbrains.resharper.projectView.projectTypes.RiderProjectTypesManager;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.OpenExistingSolution;
import com.jetbrains.rider.model.SolutionOpenStrategy;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "()V", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "getIcon", "Ljavax/swing/Icon;", "getName", "", "isStrongProjectInfoHolder", "Companion", "rider"})
public final class RiderProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    private static final String moduleName = "riderModule";
    @NotNull
    private static final String moduleId = "RIDER_MODULE";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String getName() {
        return null;
    }

    public boolean isStrongProjectInfoHolder() {
        return true;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean canOpenProject(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        if (file2.isDirectory()) {
            return true;
        }
        return Intrinsics.areEqual((Object)file2.getExtension(), (Object)SolutionFileType.INSTANCE.getDefaultExtension()) || RiderProjectTypesManager.Companion.getInstance().isKnownProjectFile(file2);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        String filePath = virtualFile.getPath();
        File file2 = new File(filePath);
        if (!virtualFile.exists()) {
            WelcomeFrame.showIfNoProjectOpened();
            return Companion.showErrorAndThrow("File '" + filePath + "' does not exist in the file system");
        }
        if (virtualFile.isDirectory()) {
            WelcomeFrame.showIfNoProjectOpened();
            return Companion.showErrorAndThrow("Cannot open directory '" + filePath + "', choose a solution file");
        }
        if (Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)SolutionFileType.INSTANCE.getDefaultExtension())) {
            Object object;
            block8: {
                Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
                Object single$iv = null;
                boolean found$iv = false;
                for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                    Object element$iv = $receiver$iv[i2];
                    Project it = (Project)element$iv;
                    if (!Intrinsics.areEqual((Object)SolutionHostExtensionsKt.getSolutionFile(it), (Object)file2)) continue;
                    if (found$iv) {
                        object = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                object = !found$iv ? null : single$iv;
            }
            Project existingProject = (Project)object;
            if (existingProject != null && Intrinsics.areEqual((Object)existingProject, (Object)projectToClose) ^ true) {
                return existingProject;
            }
            String string2 = filePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"filePath");
            return Companion.doOpenSolution(projectToClose, forceOpenInNewFrame, new OpenExistingSolution(string2, true));
        }
        if (RiderProjectTypesManager.Companion.getInstance().isKnownProjectFile(virtualFile)) {
            String solutionFilePath = virtualFile.getParent().getPath() + File.separator + virtualFile.getParent().getName();
            File solutionFile = new File(solutionFilePath + "." + SolutionFileType.INSTANCE.getDefaultExtension());
            int index = 1;
            while (solutionFile.exists()) {
                solutionFile = new File(solutionFilePath + index + "." + SolutionFileType.INSTANCE.getDefaultExtension());
                ++index;
            }
            AddExistingProjectAction.Companion.unpackSolution(solutionFile, virtualFile);
            String string3 = solutionFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"solutionFile.path");
            return Companion.doOpenSolution(projectToClose, forceOpenInNewFrame, new OpenExistingSolution(string3, true));
        }
        return Companion.showErrorAndThrow("'" + filePath + "' is not a solution or project file");
    }

    static {
        moduleName = moduleName;
        moduleId = moduleId;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/resharper/projectView/ideaInterop/RiderProjectOpenProcessor$Companion;", "", "()V", "moduleId", "", "getModuleId", "()Ljava/lang/String;", "moduleName", "getModuleName", "doOpenSolution", "Lcom/intellij/openapi/project/Project;", "projectToClose", "forceOpenInNewFrame", "", "solutionOpenStrategy", "Lcom/jetbrains/rider/model/SolutionOpenStrategy;", "findExistingProject", "solutionFile", "Ljava/io/File;", "loadAndOpenProject", "projectDir", "prepareToOpen", "projectToCloseOriginal", "showErrorAndThrow", "message", "rider"})
    public static final class Companion {
        @NotNull
        public final String getModuleName() {
            return moduleName;
        }

        @NotNull
        public final String getModuleId() {
            return moduleId;
        }

        @Nullable
        public final Project doOpenSolution(@Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull SolutionOpenStrategy solutionOpenStrategy) {
            Intrinsics.checkParameterIsNotNull((Object)solutionOpenStrategy, (String)"solutionOpenStrategy");
            ApplicationKt.getApplication().assertIsDispatchThread();
            File solutionFile = new File(solutionOpenStrategy.getSolutionFilePath());
            ProgressManager.getInstance().run((Task)new Task.Modal(solutionFile, null, "Checking file system", false){
                final /* synthetic */ File $solutionFile;

                public void run(@NotNull ProgressIndicator visibleIndicator) {
                    Intrinsics.checkParameterIsNotNull((Object)visibleIndicator, (String)"visibleIndicator");
                    this.$solutionFile.exists();
                }
                {
                    this.$solutionFile = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            });
            Project existingProject = this.findExistingProject(solutionFile);
            if (existingProject != null) {
                return existingProject;
            }
            if (!this.prepareToOpen(projectToClose, forceOpenInNewFrame)) {
                return null;
            }
            String ideaDirName = ".idea";
            File baseIdeaDir = new File(solutionFile.getParent(), ideaDirName);
            File projectDir = new File(baseIdeaDir, ideaDirName + "." + FilesKt.getNameWithoutExtension((File)solutionFile));
            File dotIdeaDir = new File(projectDir, ideaDirName);
            if (!dotIdeaDir.exists()) {
                dotIdeaDir.mkdirs();
            }
            try {
                ComponentManager $receiver$iv = (ComponentManager)ApplicationKt.getApplication();
                Object object = $receiver$iv.getComponent(SolutionInitializer.class);
                if (object == null) {
                    throw (Throwable)new IllegalStateException("Component " + SolutionInitializer.class + " not found in container " + $receiver$iv);
                }
                SolutionInitializer initializer = (SolutionInitializer)object;
                return (Project)initializer.withSolution(solutionOpenStrategy, (Function0)new Function0<Project>(projectDir, solutionFile){
                    final /* synthetic */ File $projectDir;
                    final /* synthetic */ File $solutionFile;

                    @Nullable
                    public final Project invoke() {
                        Project project2 = com.jetbrains.resharper.projectView.ideaInterop.RiderProjectOpenProcessor$Companion.access$loadAndOpenProject(RiderProjectOpenProcessor.Companion, this.$projectDir, this.$solutionFile);
                        if (!ApplicationKt.getApplication().isHeadlessEnvironment()) {
                            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project2);
                            IdeFocusManager.getGlobalInstance().toFront(ideFrame.getComponent());
                        }
                        return project2;
                    }
                    {
                        this.$projectDir = file2;
                        this.$solutionFile = file3;
                        super(0);
                    }
                });
            }
            catch (Exception ex) {
                Logger logger = Logger.getInstance(RiderProjectOpenProcessor.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error((Throwable)ex);
                Messages.showErrorDialog((String)ex.getMessage(), (String)"Error loading solution");
                throw (Throwable)ex;
            }
        }

        private final Project findExistingProject(File solutionFile) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            for (int i2 = 0; i2 < openProjects.length; ++i2) {
                Project project2 = openProjects[i2];
                if (project2.isDefault() || !Intrinsics.areEqual((Object)SolutionHostExtensionsKt.getSolutionFile(project2), (Object)solutionFile)) continue;
                ProjectUtil.focusProjectWindow(project2, false);
                return project2;
            }
            return null;
        }

        private final boolean prepareToOpen(Project projectToCloseOriginal, boolean forceOpenInNewFrame) {
            if (forceOpenInNewFrame) {
                return true;
            }
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            Project project2 = projectToCloseOriginal;
            if (project2 == null) {
                project2 = (Project)ArraysKt.lastOrNull((Object[])openProjects);
            }
            if (project2 == null) {
                return true;
            }
            Project projectToClose = project2;
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1) {
                boolean closeResult = ProjectUtil.closeAndDispose(projectToClose);
                if (!closeResult) {
                    String string2 = "Cannot close current project";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return true;
            }
            return exitCode == 0;
        }

        private final Project loadAndOpenProject(File projectDir, File solutionFile) {
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            Project project2 = projectManager.loadProject(projectDir.getPath(), FilesKt.getNameWithoutExtension((File)solutionFile));
            if (project2 == null) {
                WelcomeFrame.showIfNoProjectOpened();
                return null;
            }
            if (!projectManager.openProject(project2)) {
                WelcomeFrame.showIfNoProjectOpened();
                ApplicationKt.getApplication().runWriteAction(new Runnable(project2){
                    final /* synthetic */ Project $project;

                    public final void run() {
                        Disposer.dispose((Disposable)((Disposable)this.$project));
                    }
                    {
                        this.$project = project2;
                    }
                });
                return null;
            }
            return project2;
        }

        @Nullable
        public final Project showErrorAndThrow(@NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Messages.showErrorDialog((String)message2, (String)"Cannot open project");
            throw (Throwable)new UnsupportedOperationException(message2);
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ Project access$loadAndOpenProject(Companion $this, @NotNull File projectDir, @NotNull File solutionFile) {
            return $this.loadAndOpenProject(projectDir, solutionFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

