/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.index;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.index.ExternalRootType;
import com.jetbrains.resharper.projectView.index.PathComponentComparator;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex$WhenMappings;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexVisitor;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeChange;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 D2\u00020\u0001:\u0005DEFGHB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%J\u001a\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0014\u0010)\u001a\u0004\u0018\u00010\n2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\nH\u0002J\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%J\u000e\u0010/\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%J\u0016\u0010/\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020\u001aJ\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002J\u0018\u00103\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u00104\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020+2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020:2\u001c\b\u0002\u0010;\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020#0=\u0018\u00010<J`\u0010>\u001a\u00020\u00132\u0006\u00109\u001a\u00020:2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\n2\b\u0010@\u001a\u0004\u0018\u00010A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070C0\b2\u001a\u0010;\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020#0=\u0018\u00010<H\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "childrenMap", "Ljava/util/TreeMap;", "", "Ljava/util/HashMap;", "", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$Entry;", "entryMap", "Lkotlin/collections/HashMap;", "lock", "Ljava/lang/Object;", "nextId", "parentCountMap", "root", "afterAdd", "", "node", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "afterUpdate", "nodeChange", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNodeChange;", "attachParent", "", "beforeRemove", "beforeUpdate", "dump", "mode", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$DumpMode;", "doNotExpand", "", "get", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndexEntry;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChild", "entry", "pathComponent", "getInternal", "file", "Ljava/io/File;", "getOrCreateEntry", "getParent", "isInProjectModel", "isUnderExternalRoot", "onlyRecursive", "normalize", "part", "removeEntryIfEmpty", "setExternalRoot", "type", "Lcom/jetbrains/resharper/projectView/index/ExternalRootType;", "shouldUpdate", "visit", "visitor", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndexVisitor;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Pair;", "visitInternal", "name", "context", "", "allChildren", "Ljava/util/ArrayList;", "Companion", "Context", "DumpComparator", "DumpMode", "Entry", "rider"})
public final class VirtualFileIndex
extends AbstractProjectComponent {
    private int nextId;
    private final Entry root;
    private final Object lock;
    private final TreeMap<String, HashMap<Integer, Entry>> childrenMap;
    private final HashMap<Integer, Entry> entryMap;
    private final HashMap<Integer, Integer> parentCountMap;
    private static final int RootId = 0;
    public static final Companion Companion = new Companion(null);

    private final Entry getParent(Entry entry) {
        return this.entryMap.get(entry.getParentId());
    }

    private final Entry getChild(Entry entry, String pathComponent) {
        String normalizedPart = this.normalize(pathComponent);
        HashMap<Integer, Entry> hashMap = this.childrenMap.get(normalizedPart);
        if (hashMap == null) {
            return null;
        }
        HashMap<Integer, Entry> map2 = hashMap;
        return map2.get(entry.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VirtualFileIndexEntry get(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Object object = this.lock;
        synchronized (object) {
            VirtualFileIndexEntry virtualFileIndexEntry = this.getInternal(virtualFile);
            return virtualFileIndexEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInProjectModel(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Object object = this.lock;
        synchronized (object) {
            VirtualFileIndexEntry virtualFileIndexEntry;
            block4: {
                if (this.get(virtualFile) != null) break block4;
                boolean bl = false;
                return bl;
            }
            VirtualFileIndexEntry entry = virtualFileIndexEntry;
            boolean bl = CollectionsKt.any((Iterable)entry.getProjectModelIds());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isUnderExternalRoot(@NotNull File file2, boolean onlyRecursive) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            File parent = file2;
            int distance = 0;
            while (true) {
                if (parent == null) {
                    return false;
                }
                entry = this.getInternal(parent);
                if (entry != null) break;
                parent = parent.getParentFile();
                ++distance;
            }
            Entry parentEntry = entry;
            while (parentEntry != null) {
                Integer[] elements$iv;
                if (Intrinsics.areEqual((Object)((Object)parentEntry.getExternalRootType()), (Object)((Object)ExternalRootType.Flat)) && !onlyRecursive && ArraysKt.contains((Object[])(elements$iv = new Integer[]{0, 1}), (Object)distance)) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)((Object)parentEntry.getExternalRootType()), (Object)((Object)ExternalRootType.Recursive))) {
                    return true;
                }
                parentEntry = this.getParent(parentEntry);
                ++distance;
            }
            return false;
        }
    }

    public final boolean isUnderExternalRoot(@NotNull VirtualFile virtualFile) {
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        File file3 = file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
        return this.isUnderExternalRoot(file3, false);
    }

    private final Entry getInternal(VirtualFile virtualFile) {
        String string2;
        if (virtualFile == null) {
            return this.root;
        }
        Entry entry = this.getInternal(virtualFile.getParent());
        if (entry == null) {
            return null;
        }
        Entry parentEntry = entry;
        if (Intrinsics.areEqual((Object)virtualFile.getName(), (Object)File.separator)) {
            string2 = "";
        } else {
            String string3 = virtualFile.getName();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"virtualFile.name");
        }
        String name = string2;
        return this.getChild(parentEntry, name);
    }

    private final Entry getInternal(File file2) {
        List parts = FileUtil.splitPath((String)file2.getPath());
        Entry entry = this.root;
        Iterator iterator2 = parts.iterator();
        while (iterator2.hasNext()) {
            String part;
            String string2 = part = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"part");
            if (this.getChild(entry, string2) != null) continue;
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterAdd(@NotNull ProjectModelNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Object object = this.lock;
        synchronized (object) {
            Entry parent;
            Object object2;
            File file2 = node.getFile();
            if (file2 == null) {
                return;
            }
            File file3 = file2;
            Entry entry = this.getOrCreateEntry(file3);
            entry.getProjectModelIds().add(node.getId());
            if (this.attachParent(node) && (object2 = (parent = this.getParent(entry))) != null && (object2 = ((Entry)object2).getProjectModelIds()) != null) {
                ((HashSet)object2).add(node.getId());
            }
            Iterator<ProjectModelNode> iterator2 = node.getChildren(true, false).iterator();
            while (iterator2.hasNext()) {
                ProjectModelNode child;
                ProjectModelNode projectModelNode = child = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectModelNode, (String)"child");
                this.afterAdd(projectModelNode);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Entry getOrCreateEntry(File file2) {
        List parts = FileUtil.splitPath((String)file2.getPath());
        Entry entry = this.root;
        Iterator iterator2 = parts.iterator();
        while (iterator2.hasNext()) {
            String part;
            String string2 = part = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"part");
            Entry childEntry = this.getChild(entry, string2);
            if (childEntry == null) {
                Object object;
                int n2 = this.nextId;
                this.nextId = n2 + 1;
                childEntry = new Entry(n2, entry.getId());
                this.entryMap.put(childEntry.getId(), childEntry);
                Integer parentCount = this.parentCountMap.getOrDefault(entry.getId(), 0);
                Map map2 = this.parentCountMap;
                Integer n3 = entry.getId();
                Integer n4 = parentCount + 1;
                map2.put(n3, n4);
                String string3 = part;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"part");
                String normalizedPart = this.normalize(string3);
                Map $receiver$iv = this.childrenMap;
                Object value$iv = $receiver$iv.get(normalizedPart);
                if (value$iv == null) {
                    HashMap answer$iv = new HashMap();
                    $receiver$iv.put(normalizedPart, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                HashMap map3 = (HashMap)object;
                map3.put(entry.getId(), childEntry);
            }
            entry = childEntry;
        }
        return entry;
    }

    private final void removeEntryIfEmpty(Entry entry, File file2) {
        if (!this.entryMap.containsKey(entry.getId())) {
            return;
        }
        if (CollectionsKt.any((Iterable)entry.getProjectModelIds())) {
            return;
        }
        if (Intrinsics.areEqual((Object)((Object)entry.getExternalRootType()), (Object)((Object)ExternalRootType.None)) ^ true) {
            return;
        }
        if (this.parentCountMap.containsKey(entry.getId())) {
            return;
        }
        this.entryMap.remove(entry.getId());
        HashMap<Integer, Entry> hashMap = this.childrenMap.get(file2.getName());
        if (hashMap != null) {
            hashMap.remove(entry.getParentId());
        }
        Integer parentsCount = this.parentCountMap.getOrDefault(entry.getParentId(), 0);
        if (Intrinsics.areEqual((Object)parentsCount, (Object)1)) {
            this.parentCountMap.remove(entry.getParentId());
        } else if (Intrinsics.compare((int)parentsCount, (int)1) > 0) {
            Map map2 = this.parentCountMap;
            Integer n2 = entry.getParentId();
            Integer n3 = parentsCount - 1;
            map2.put(n2, n3);
        }
        Entry entry2 = this.getParent(entry);
        if (entry2 == null) {
            return;
        }
        Entry parent = entry2;
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return;
        }
        File parentFile = file3;
        this.removeEntryIfEmpty(parent, parentFile);
    }

    private final String normalize(String part) {
        if (SystemInfo.isMac) {
            String string2 = Normalizer.normalize(part, Normalizer.Form.NFC);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Normalizer.normalize(part, Normalizer.Form.NFC)");
            return string2;
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeRemove(@NotNull ProjectModelNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Object object = this.lock;
        synchronized (object) {
            Entry parent;
            Object object2;
            File file2 = node.getFile();
            if (file2 == null) {
                return;
            }
            File file3 = file2;
            Entry entry = this.getInternal(file3);
            if (entry == null) {
                return;
            }
            Entry entry2 = entry;
            entry2.getProjectModelIds().remove(node.getId());
            if (this.attachParent(node) && (object2 = (parent = this.getParent(entry2))) != null && (object2 = ((Entry)object2).getProjectModelIds()) != null) {
                ((HashSet)object2).remove(node.getId());
            }
            Iterator<ProjectModelNode> iterator2 = node.getChildren(true, false).iterator();
            while (iterator2.hasNext()) {
                ProjectModelNode child;
                ProjectModelNode projectModelNode = child = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectModelNode, (String)"child");
                this.beforeRemove(projectModelNode);
            }
            this.removeEntryIfEmpty(entry2, file3);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExternalRoot(@NotNull File root, @NotNull ExternalRootType type) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.getOrCreateEntry(root);
            entry.setExternalRootType(type);
            this.removeEntryIfEmpty(entry, root);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeUpdate(@NotNull ProjectModelNode node, @NotNull ProjectModelNodeChange nodeChange) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)nodeChange, (String)"nodeChange");
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldUpdate(nodeChange)) {
                this.beforeRemove(node);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterUpdate(@NotNull ProjectModelNode node, @NotNull ProjectModelNodeChange nodeChange) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)nodeChange, (String)"nodeChange");
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldUpdate(nodeChange)) {
                this.afterAdd(node);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean shouldUpdate(ProjectModelNodeChange nodeChange) {
        return nodeChange.customLocationChanged() || nodeChange.descriptorTypeChanged() || nodeChange.parentChanged() || nodeChange.nameChanged() && nodeChange.isEmptyCustomLocation();
    }

    private final boolean attachParent(ProjectModelNode node) {
        if (ProjectModelNodeExtensionKt.isSolution(node)) {
            return true;
        }
        RdProjectModelItemDescriptor descriptor2 = node.getDescriptor();
        if (descriptor2 instanceof RdProjectDescriptor) {
            return !((RdProjectDescriptor)descriptor2).getDirectoryBased();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void visit(@NotNull VirtualFileIndexVisitor visitor2, @Nullable Comparator<Pair<String, VirtualFileIndexEntry>> comparator2) {
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        Object object = this.lock;
        synchronized (object) {
            HashMap<Integer, ArrayList<String>> children2 = new HashMap<Integer, ArrayList<String>>();
            Map map2 = this.childrenMap;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                String childName = (String)entry2.getKey();
                entry2 = entry;
                HashMap childList = (HashMap)entry2.getValue();
                Map map3 = childList;
                Iterator iterator3 = map3.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Object object2;
                    void $receiver$iv;
                    Map.Entry entry3 = entry2 = iterator3.next();
                    int id = ((Number)entry3.getKey()).intValue();
                    entry3 = entry2;
                    Entry childs = (Entry)entry3.getValue();
                    Map map4 = children2;
                    Integer key$iv = id;
                    Object value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        ArrayList answer$iv = new ArrayList();
                        $receiver$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    ArrayList nameList = (ArrayList)object2;
                    nameList.add(childName);
                }
            }
            this.visitInternal(visitor2, "ROOT", this.root, null, children2, comparator2);
            map2 = Unit.INSTANCE;
        }
    }

    public static /* bridge */ /* synthetic */ void visit$default(VirtualFileIndex virtualFileIndex, VirtualFileIndexVisitor virtualFileIndexVisitor, Comparator comparator2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            comparator2 = null;
        }
        virtualFileIndex.visit(virtualFileIndexVisitor, comparator2);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitInternal(VirtualFileIndexVisitor visitor2, String name, Entry entry, Object context2, HashMap<Integer, ArrayList<String>> allChildren, Comparator<Pair<String, VirtualFileIndexEntry>> comparator2) {
        void result2;
        Pair<VirtualFileIndexVisitor.Result, Object> pair = visitor2.visitEntry(name, entry, context2);
        VirtualFileIndexVisitor.Result result3 = (VirtualFileIndexVisitor.Result)((Object)pair.component1());
        Object object = pair.component2();
        pair = null;
        if (Intrinsics.areEqual((Object)result2, (Object)((Object)VirtualFileIndexVisitor.Result.Stop))) {
            return;
        }
        ArrayList<Pair> children2 = new ArrayList<Pair>();
        ArrayList<String> arrayList = allChildren.get(entry.getId());
        if (arrayList == null) {
            return;
        }
        ArrayList<String> childList = arrayList;
        Iterator<String> iterator2 = childList.iterator();
        while (iterator2.hasNext()) {
            String childName;
            String string2 = childName = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"childName");
            Entry child = this.getChild(entry, string2);
            if (child == null) continue;
            children2.add(new Pair((Object)childName, (Object)child));
        }
        if (comparator2 != null) {
            CollectionsKt.sortWith((List)children2, comparator2);
        }
        for (Pair pair2 : children2) {
            void childContext;
            String childName = (String)pair2.component1();
            Entry childNode = (Entry)pair2.component2();
            this.visitInternal(visitor2, childName, childNode, childContext, allChildren, comparator2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String dump(@NotNull DumpMode mode, @NotNull Set<String> doNotExpand) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        Intrinsics.checkParameterIsNotNull(doNotExpand, (String)"doNotExpand");
        Object object = this.lock;
        synchronized (object) {
            VirtualFileIndexVisitor visitor2 = new VirtualFileIndexVisitor(this, doNotExpand, mode){
                @NotNull
                private final StringBuilder builder;
                final /* synthetic */ VirtualFileIndex this$0;
                final /* synthetic */ Set $doNotExpand$inlined;
                final /* synthetic */ DumpMode $mode$inlined;
                {
                    this.this$0 = virtualFileIndex;
                    this.$doNotExpand$inlined = set2;
                    this.$mode$inlined = dumpMode;
                    this.builder = new StringBuilder();
                }

                public final StringBuilder getBuilder() {
                    return this.builder;
                }

                public Pair<VirtualFileIndexVisitor.Result, Object> visitEntry(String name, VirtualFileIndexEntry entry, Object context2) {
                    boolean shouldWriteEntry;
                    VirtualFileIndexVisitor.Result visitResult;
                    VirtualFileIndexVisitor.Result result2 = visitResult = this.$doNotExpand$inlined.contains(name) ? VirtualFileIndexVisitor.Result.Stop : VirtualFileIndexVisitor.Result.Continue;
                    if (context2 == null) {
                        boolean bl;
                        switch (VirtualFileIndex$WhenMappings.$EnumSwitchMapping$0[this.$mode$inlined.ordinal()]) {
                            case 1: {
                                bl = true;
                                break;
                            }
                            case 2: {
                                bl = false;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        boolean shouldWriteEntry2 = bl;
                        if (shouldWriteEntry2) {
                            StringBuilder stringBuilder = this.builder;
                            StringsKt.appendln((StringBuilder)stringBuilder.append(name));
                        }
                        return new Pair((Object)((Object)visitResult), (Object)new Context(0, shouldWriteEntry2));
                    }
                    Object object = context2;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.projectView.index.VirtualFileIndex.Context");
                    }
                    Context ctx = (Context)object;
                    if (ctx.getShouldWriteEntry()) {
                        this.write(name, entry, ctx.getTab());
                        shouldWriteEntry = true;
                    } else if (CollectionsKt.any((Iterable)entry.getProjectModelIds())) {
                        if (entry.getProjectModelIds().contains(ProjectModelViewHost.Companion.getSOLUTION_ID())) {
                            this.write("<SOLUTION ROOT>", entry, ctx.getTab());
                        } else {
                            this.write(name, entry, ctx.getTab());
                        }
                        shouldWriteEntry = true;
                    } else {
                        shouldWriteEntry = false;
                    }
                    Context nextCtx = shouldWriteEntry ? new Context(ctx.getTab() + 1, true) : new Context(ctx.getTab(), false);
                    return new Pair((Object)((Object)visitResult), (Object)nextCtx);
                }

                /*
                 * WARNING - void declaration
                 */
                private final void write(String name, VirtualFileIndexEntry entry, int tab) {
                    int n2 = 1;
                    int n3 = tab;
                    if (n2 <= n3) {
                        while (true) {
                            void t2;
                            this.builder.append(" ");
                            if (t2 == n3) break;
                            ++t2;
                        }
                    }
                    this.builder.append(name);
                    if (CollectionsKt.any((Iterable)entry.getProjectModelIds())) {
                        switch (VirtualFileIndex$WhenMappings.$EnumSwitchMapping$1[this.$mode$inlined.ordinal()]) {
                            case 1: {
                                this.builder.append(" [" + CollectionsKt.joinToString$default((Iterable)entry.getProjectModelIds(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]");
                                break;
                            }
                            case 2: {
                                Collection collection = entry.getProjectModelIds();
                                StringBuilder stringBuilder = new StringBuilder().append(" [Nodes: ");
                                StringBuilder stringBuilder2 = this.builder;
                                int n4 = collection.size();
                                stringBuilder2.append(stringBuilder.append(n4).append("]").toString());
                            }
                        }
                    }
                    switch (VirtualFileIndex$WhenMappings.$EnumSwitchMapping$2[entry.getExternalRootType().ordinal()]) {
                        case 1: {
                            this.builder.append(" FLAT_EXTERNAL_ROOT");
                            break;
                        }
                        case 2: {
                            this.builder.append(" RECURSIVE_EXTERNAL_ROOT");
                        }
                    }
                    StringsKt.appendln((StringBuilder)this.builder);
                }
            };
            this.visit(visitor2, DumpComparator.INSTANCE);
            String string3 = visitor2.getBuilder().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"visitor.builder.toString()");
            String string4 = string3;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
            string2 = string4;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"synchronized(lock) {\n   \u2026lder.toString()\n        }");
        return string2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String dump$default(VirtualFileIndex virtualFileIndex, DumpMode dumpMode, Set set2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set2 = new HashSet();
        }
        return virtualFileIndex.dump(dumpMode, set2);
    }

    public VirtualFileIndex(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.nextId = VirtualFileIndex.Companion.getRootId() + 1;
        this.root = new Entry(VirtualFileIndex.Companion.getRootId(), VirtualFileIndex.Companion.getRootId() - 1);
        this.lock = new Object();
        this.childrenMap = new TreeMap(PathComponentComparator.INSTANCE);
        VirtualFileIndex virtualFileIndex = this;
        HashMap hashMap = new HashMap();
        virtualFileIndex.entryMap = hashMap;
        virtualFileIndex = this;
        hashMap = new HashMap();
        virtualFileIndex.parentCountMap = hashMap;
        this.entryMap.put(this.root.getId(), this.root);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$DumpMode;", "", "(Ljava/lang/String;I)V", "Full", "ToPersist", "rider"})
    public static final class DumpMode
    extends Enum<DumpMode> {
        public static final /* enum */ DumpMode Full;
        public static final /* enum */ DumpMode ToPersist;
        private static final /* synthetic */ DumpMode[] $VALUES;

        static {
            DumpMode[] dumpModeArray = new DumpMode[2];
            DumpMode[] dumpModeArray2 = dumpModeArray;
            dumpModeArray[0] = Full = new DumpMode();
            dumpModeArray[1] = ToPersist = new DumpMode();
            $VALUES = dumpModeArray;
        }

        public static DumpMode[] values() {
            return (DumpMode[])$VALUES.clone();
        }

        public static DumpMode valueOf(String string2) {
            return Enum.valueOf(DumpMode.class, string2);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$Context;", "", "tab", "", "shouldWriteEntry", "", "(IZ)V", "getShouldWriteEntry", "()Z", "getTab", "()I", "rider"})
    private static final class Context {
        private final int tab;
        private final boolean shouldWriteEntry;

        public final int getTab() {
            return this.tab;
        }

        public final boolean getShouldWriteEntry() {
            return this.shouldWriteEntry;
        }

        public Context(int tab, boolean shouldWriteEntry) {
            this.tab = tab;
            this.shouldWriteEntry = shouldWriteEntry;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$DumpComparator;", "Ljava/util/Comparator;", "Lkotlin/Pair;", "", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndexEntry;", "()V", "compare", "", "o1", "o2", "rider"})
    private static final class DumpComparator
    implements Comparator<Pair<? extends String, ? extends VirtualFileIndexEntry>> {
        public static final DumpComparator INSTANCE;

        @Override
        public int compare(@Nullable Pair<String, ? extends VirtualFileIndexEntry> o1, @Nullable Pair<String, ? extends VirtualFileIndexEntry> o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(o1.getFirst(), o2.getFirst());
        }

        private DumpComparator() {
            INSTANCE = this;
        }

        static {
            new DumpComparator();
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR$\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$Entry;", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndexEntry;", "id", "", "parentId", "(II)V", "externalRootType", "Lcom/jetbrains/resharper/projectView/index/ExternalRootType;", "getExternalRootType", "()Lcom/jetbrains/resharper/projectView/index/ExternalRootType;", "setExternalRootType", "(Lcom/jetbrains/resharper/projectView/index/ExternalRootType;)V", "getId", "()I", "getParentId", "projectModelIds", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getProjectModelIds", "()Ljava/util/HashSet;", "rider"})
    private static final class Entry
    implements VirtualFileIndexEntry {
        @NotNull
        private final HashSet<Integer> projectModelIds;
        @NotNull
        private ExternalRootType externalRootType;
        private final int id;
        private final int parentId;

        @Override
        @NotNull
        public HashSet<Integer> getProjectModelIds() {
            return this.projectModelIds;
        }

        @Override
        @NotNull
        public ExternalRootType getExternalRootType() {
            return this.externalRootType;
        }

        public void setExternalRootType(@NotNull ExternalRootType externalRootType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)externalRootType), (String)"<set-?>");
            this.externalRootType = externalRootType;
        }

        public final int getId() {
            return this.id;
        }

        public final int getParentId() {
            return this.parentId;
        }

        public Entry(int id, int parentId) {
            this.id = id;
            this.parentId = parentId;
            Entry entry = this;
            HashSet hashSet = new HashSet();
            entry.projectModelIds = hashSet;
            this.externalRootType = ExternalRootType.None;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex$Companion;", "", "()V", "RootId", "", "getRootId", "()I", "getInstance", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "project", "Lcom/intellij/openapi/project/Project;", "rider"})
    public static final class Companion {
        private final int getRootId() {
            return RootId;
        }

        @NotNull
        public final VirtualFileIndex getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            ComponentManager $receiver$iv = (ComponentManager)project2;
            Object object = $receiver$iv.getComponent(VirtualFileIndex.class);
            if (object == null) {
                throw (Throwable)new IllegalStateException("Component " + VirtualFileIndex.class + " not found in container " + $receiver$iv);
            }
            return (VirtualFileIndex)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

