/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.moveProviders.Impl;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.projectView.moveProviders.Impl.BufferedActionTarget;
import com.jetbrains.resharper.projectView.moveProviders.Impl.BufferedActionType;
import com.jetbrains.resharper.projectView.moveProviders.Impl.IBufferedActionData;
import com.jetbrains.resharper.projectView.moveProviders.Impl.ProjectModelData;
import com.jetbrains.resharper.projectView.moveProviders.Impl.VirtualFilesData;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeFileSystem;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeRider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedAction;", "", "data", "Lcom/jetbrains/resharper/projectView/moveProviders/Impl/IBufferedActionData;", "name", "", "(Lcom/jetbrains/resharper/projectView/moveProviders/Impl/IBufferedActionData;Ljava/lang/String;)V", "action", "Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedActionType;", "getAction", "()Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedActionType;", "setAction", "(Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedActionType;)V", "getData", "()Lcom/jetbrains/resharper/projectView/moveProviders/Impl/IBufferedActionData;", "getName", "()Ljava/lang/String;", "execute", "", "node", "Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;", "isApplicableFor", "", "Companion", "rider"})
public final class BufferedAction {
    @Nullable
    private BufferedActionType action;
    @NotNull
    private final IBufferedActionData data;
    @NotNull
    private final String name;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final BufferedActionType getAction() {
        return this.action;
    }

    public final void setAction(@Nullable BufferedActionType bufferedActionType) {
        this.action = bufferedActionType;
    }

    public final boolean isApplicableFor(@NotNull ISolutionExplorerNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        BufferedActionType bufferedActionType = this.action;
        if (bufferedActionType == null) {
            return false;
        }
        BufferedActionType currentAction = bufferedActionType;
        return this.data.isApplicableFor(node, currentAction);
    }

    public final void execute(@NotNull ISolutionExplorerNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        boolean bl = this.isApplicableFor(node);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "invalid node for execute move/copy context";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        BufferedActionType bufferedActionType = this.action;
        if (bufferedActionType == null) {
            Intrinsics.throwNpe();
        }
        this.data.execute(node, bufferedActionType);
    }

    @NotNull
    public final IBufferedActionData getData() {
        return this.data;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    private BufferedAction(IBufferedActionData data, String name) {
        this.data = data;
        this.name = name;
    }

    public /* synthetic */ BufferedAction(@NotNull IBufferedActionData data, @NotNull String name, DefaultConstructorMarker $constructor_marker) {
        this(data, name);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J7\u0010\t\u001a\u00020\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0019\u0010\u0018\u001a\u00020\u00192\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedAction$Companion;", "", "()V", "calculateTarget", "Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedActionTarget;", "node", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "nodes", "Ljava/util/ArrayList;", "collect", "", "", "Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;", "projectModelNodes", "virtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;Ljava/util/ArrayList;Ljava/util/ArrayList;)V", "createContext", "Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedAction;", "([Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;)Lcom/jetbrains/resharper/projectView/moveProviders/Impl/BufferedAction;", "", "files", "", "Ljava/io/File;", "isAvailable", "", "([Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;)Z", "rider"})
    public static final class Companion {
        public final boolean isAvailable(@NotNull ISolutionExplorerNode[] nodes) {
            Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
            ArrayList<ProjectModelNode> projectModelNodes = new ArrayList<ProjectModelNode>();
            ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
            this.collect(SolutionExplorerExtensionsKt.getRoots(nodes), projectModelNodes, virtualFiles);
            if (CollectionsKt.any((Iterable)projectModelNodes) && CollectionsKt.any((Iterable)virtualFiles)) {
                return false;
            }
            if (CollectionsKt.any((Iterable)projectModelNodes)) {
                return this.calculateTarget(projectModelNodes) != null;
            }
            return CollectionsKt.any((Iterable)virtualFiles);
        }

        @Nullable
        public final BufferedAction createContext(@NotNull ISolutionExplorerNode[] nodes) {
            Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
            ArrayList<ProjectModelNode> projectModelNodes = new ArrayList<ProjectModelNode>();
            ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
            this.collect(SolutionExplorerExtensionsKt.getRoots(nodes), projectModelNodes, virtualFiles);
            if (CollectionsKt.any((Iterable)projectModelNodes) && CollectionsKt.any((Iterable)virtualFiles)) {
                return null;
            }
            if (CollectionsKt.any((Iterable)projectModelNodes)) {
                BufferedActionTarget bufferedActionTarget = this.calculateTarget(projectModelNodes);
                if (bufferedActionTarget == null) {
                    return null;
                }
                BufferedActionTarget target = bufferedActionTarget;
                String name = ((ProjectModelNode)CollectionsKt.first((List)projectModelNodes)).getName();
                Collection collection = projectModelNodes;
                if (collection.size() > 1) {
                    collection = projectModelNodes;
                    StringBuilder stringBuilder = new StringBuilder().append(" and ");
                    StringBuilder stringBuilder2 = new StringBuilder().append(name);
                    int n2 = collection.size();
                    name = stringBuilder2.append(stringBuilder.append(n2 - 1).append(" items").toString()).toString();
                }
                return new BufferedAction(new ProjectModelData((Collection<ProjectModelNode>)projectModelNodes, target), name, null);
            }
            return this.createContext((Collection<? extends VirtualFile>)virtualFiles);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final BufferedAction createContext(@NotNull List<? extends File> files2) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(files2, (String)"files");
            Iterable iterable = $receiver$iv = (Iterable)files2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)it, (boolean)true);
                collection.add(virtualFile);
            }
            List virtualFiles = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
            return this.createContext(virtualFiles);
        }

        private final BufferedAction createContext(Collection<? extends VirtualFile> virtualFiles) {
            if (virtualFiles.isEmpty()) {
                return null;
            }
            String name = ((VirtualFile)CollectionsKt.first((Iterable)virtualFiles)).getName();
            Collection<? extends VirtualFile> collection = virtualFiles;
            if (collection.size() > 1) {
                collection = virtualFiles;
                StringBuilder stringBuilder = new StringBuilder().append(" and ");
                StringBuilder stringBuilder2 = new StringBuilder().append(name);
                int n2 = collection.size();
                name = stringBuilder2.append(stringBuilder.append(n2 - 1).append(" files").toString()).toString();
            }
            IBufferedActionData iBufferedActionData = new VirtualFilesData(virtualFiles);
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            return new BufferedAction(iBufferedActionData, string2, null);
        }

        private final void collect(ISolutionExplorerNode[] nodes, ArrayList<ProjectModelNode> projectModelNodes, ArrayList<VirtualFile> virtualFiles) {
            Object[] $receiver$iv = nodes;
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Object element$iv = $receiver$iv[i2];
                ISolutionExplorerNode it = (ISolutionExplorerNode)element$iv;
                it.visit((ISolutionExplorerNode.Visitor)new ISolutionExplorerNode.Visitor<Unit>(projectModelNodes, virtualFiles){
                    final /* synthetic */ ArrayList $projectModelNodes$inlined;
                    final /* synthetic */ ArrayList $virtualFiles$inlined;
                    {
                        this.$projectModelNodes$inlined = arrayList;
                        this.$virtualFiles$inlined = arrayList2;
                    }

                    public void ProjectModelNode(SolutionExplorerNodeRider node) {
                        this.$projectModelNodes$inlined.add(node.getNode());
                    }

                    public void FileSystemNode(SolutionExplorerNodeFileSystem node) {
                        this.$virtualFiles$inlined.add(node.getVirtualFile());
                    }
                });
            }
        }

        private final BufferedActionTarget calculateTarget(ArrayList<ProjectModelNode> nodes) {
            BufferedActionTarget target = null;
            Iterator<ProjectModelNode> iterator2 = nodes.iterator();
            while (iterator2.hasNext()) {
                BufferedActionTarget nodeTarget;
                ProjectModelNode node;
                ProjectModelNode projectModelNode = node = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectModelNode, (String)"node");
                if (this.calculateTarget(projectModelNode) == null) {
                    return null;
                }
                if (target == null) {
                    target = nodeTarget;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)((Object)target), (Object)((Object)nodeTarget)) ^ true)) continue;
                return null;
            }
            return target;
        }

        private final BufferedActionTarget calculateTarget(ProjectModelNode node) {
            if (ProjectModelNodeExtensionKt.isProjectFile(node) || ProjectModelNodeExtensionKt.isProjectFolder(node)) {
                return BufferedActionTarget.Project;
            }
            if (ProjectModelNodeExtensionKt.isProject(node) || ProjectModelNodeExtensionKt.isSolutionFolder(node)) {
                return BufferedActionTarget.Solution;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

