/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.moveProviders;

import com.intellij.CommonBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.moveProviders.RiderDeleteProvider;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeFileSystem;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeRider;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.DataContextExKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.ProjectModelTaskResult;
import com.jetbrains.rider.model.ProjectModelTaskResultKind;
import com.jetbrains.rider.model.RemoveCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/projectView/moveProviders/RiderDeleteProvider;", "Lcom/intellij/ide/DeleteProvider;", "()V", "canDeleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "checkNode", "node", "Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode;", "deleteElement", "", "reportDeletionProblem", "problems", "", "", "rider"})
public final class RiderDeleteProvider
implements DeleteProvider {
    public static final RiderDeleteProvider INSTANCE;

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
            ISolutionExplorerNode[] nodes = SolutionExplorerExtensionsKt.getSolutionExplorerNodes(dataContext);
            Object[] objectArray = nodes;
            if (objectArray.length == 0) {
                return false;
            }
            Object[] $receiver$iv = nodes;
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Object element$iv = $receiver$iv[i2];
                ISolutionExplorerNode it = (ISolutionExplorerNode)element$iv;
                if (INSTANCE.checkNode(it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean checkNode(ISolutionExplorerNode node) {
        return (Boolean)node.visit((ISolutionExplorerNode.Visitor)new ISolutionExplorerNode.Visitor<Boolean>(){

            @NotNull
            public Boolean ProjectModelNode(@NotNull SolutionExplorerNodeRider node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                ProjectModelNode n2 = node.getNode();
                return ProjectModelNodeExtensionKt.isSolutionFolder(n2) || ProjectModelNodeExtensionKt.isProject(n2) || ProjectModelNodeExtensionKt.isUnloadedProject(n2) || ProjectModelNodeExtensionKt.isProjectFile(n2) || ProjectModelNodeExtensionKt.isProjectFolder(n2) || ProjectModelNodeExtensionKt.isReference(n2) || ProjectModelNodeExtensionKt.isUnresolvedReference(n2);
            }

            @NotNull
            public Boolean FileSystemNode(@NotNull SolutionExplorerNodeFileSystem node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                return true;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void deleteElement(@NotNull DataContext dataContext) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project2 = DataContextExKt.getProject(dataContext);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ISolutionExplorerNode[] solutionExploredNodes = SolutionExplorerExtensionsKt.getRoots(SolutionExplorerExtensionsKt.getSolutionExplorerNodes(dataContext));
        ArrayList projectModelNodes = new ArrayList();
        ArrayList virtualFiles = new ArrayList();
        Object[] $receiver$iv = solutionExploredNodes;
        for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
            Object element$iv = $receiver$iv[i2];
            it = (ISolutionExplorerNode)element$iv;
            it.visit((ISolutionExplorerNode.Visitor)new ISolutionExplorerNode.Visitor<Unit>(projectModelNodes, virtualFiles){
                final /* synthetic */ ArrayList $projectModelNodes$inlined;
                final /* synthetic */ ArrayList $virtualFiles$inlined;
                {
                    this.$projectModelNodes$inlined = arrayList;
                    this.$virtualFiles$inlined = arrayList2;
                }

                public void ProjectModelNode(SolutionExplorerNodeRider node) {
                    this.$projectModelNodes$inlined.add(node.getNode());
                }

                public void FileSystemNode(SolutionExplorerNodeFileSystem node) {
                    this.$virtualFiles$inlined.add(node.getVirtualFile());
                }
            });
        }
        if (!ApplicationKt.getApplication().isUnitTestMode()) {
            String message2;
            int returnValue;
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            void $receiver$iv$iv3;
            void $receiver$iv$iv4;
            void $receiver$iv$iv5;
            int n2;
            ArrayList<String> arrayList;
            deleteElement.3 var26_18;
            void $receiver$iv$iv6;
            Object element$iv$iv2;
            void $receiver$iv$iv7;
            ArrayList<String> messages = new ArrayList<String>();
            Iterable $receiver$iv2 = projectModelNodes;
            it = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv7) {
                ProjectModelNode it2 = (ProjectModelNode)element$iv$iv2;
                if (!(ProjectModelNodeExtensionKt.isProject(it2) || ProjectModelNodeExtensionKt.isUnloadedProject(it2))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List projectNodes = (List)destination$iv$iv;
            if (CollectionsKt.any((Iterable)projectNodes)) {
                String message3 = projectNodes.size() == 1 ? "project " + ((ProjectModelNode)projectNodes.get(0)).getName() : "projects " + CollectionsKt.joinToString$default((Iterable)projectNodes, (CharSequence)",", null, null, (int)0, null, (Function1)deleteElement.message.1.INSTANCE, (int)30, null);
                messages.add(message3);
            }
            deleteElement.2 countString$ = deleteElement.2.INSTANCE;
            deleteElement.3 countString$2 = deleteElement.3.INSTANCE;
            Iterable $receiver$iv3 = projectModelNodes;
            element$iv$iv2 = $receiver$iv3;
            Iterable destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv3 : $receiver$iv$iv6) {
                ProjectModelNode it3 = (ProjectModelNode)element$iv$iv3;
                if (!ProjectModelNodeExtensionKt.isProjectFile(it3)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List fileNodes = (List)destination$iv$iv2;
            if (CollectionsKt.any((Iterable)fileNodes)) {
                $receiver$iv3 = fileNodes;
                var26_18 = countString$2;
                arrayList = messages;
                n2 = $receiver$iv3.size();
                arrayList.add(var26_18.invoke(n2, "file"));
            }
            Iterable $receiver$iv4 = projectModelNodes;
            destination$iv$iv2 = $receiver$iv4;
            Iterable destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv4 : $receiver$iv$iv5) {
                ProjectModelNode it4 = (ProjectModelNode)element$iv$iv4;
                if (!ProjectModelNodeExtensionKt.isProjectFolder(it4)) continue;
                destination$iv$iv3.add(element$iv$iv4);
            }
            List foldersNodes = (List)destination$iv$iv3;
            if (CollectionsKt.any((Iterable)foldersNodes)) {
                $receiver$iv4 = foldersNodes;
                var26_18 = countString$2;
                arrayList = messages;
                n2 = $receiver$iv4.size();
                arrayList.add(var26_18.invoke(n2, "folder"));
            }
            Iterable $receiver$iv5 = projectModelNodes;
            destination$iv$iv3 = $receiver$iv5;
            Iterable destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv5 : $receiver$iv$iv4) {
                ProjectModelNode it5 = (ProjectModelNode)element$iv$iv5;
                if (!(ProjectModelNodeExtensionKt.isReference(it5) || ProjectModelNodeExtensionKt.isUnresolvedReference(it5))) continue;
                destination$iv$iv4.add(element$iv$iv5);
            }
            List referenceNodes = (List)destination$iv$iv4;
            if (CollectionsKt.any((Iterable)referenceNodes)) {
                $receiver$iv5 = referenceNodes;
                var26_18 = countString$2;
                arrayList = messages;
                n2 = $receiver$iv5.size();
                arrayList.add(var26_18.invoke(n2, "reference"));
            }
            Iterable $receiver$iv6 = projectModelNodes;
            destination$iv$iv4 = $receiver$iv6;
            Iterable destination$iv$iv5 = new ArrayList();
            for (Object element$iv$iv6 : $receiver$iv$iv3) {
                ProjectModelNode it6 = (ProjectModelNode)element$iv$iv6;
                if (!ProjectModelNodeExtensionKt.isSolutionFolder(it6)) continue;
                destination$iv$iv5.add(element$iv$iv6);
            }
            List solutionFolderNodes = (List)destination$iv$iv5;
            if (CollectionsKt.any((Iterable)solutionFolderNodes)) {
                $receiver$iv6 = solutionFolderNodes;
                var26_18 = countString$2;
                arrayList = messages;
                n2 = $receiver$iv6.size();
                arrayList.add(var26_18.invoke(n2, "solution folder"));
            }
            Iterable $receiver$iv7 = virtualFiles;
            destination$iv$iv5 = $receiver$iv7;
            Iterable destination$iv$iv6 = new ArrayList();
            for (Object element$iv$iv7 : $receiver$iv$iv2) {
                VirtualFile it7 = (VirtualFile)element$iv$iv7;
                if (!it7.isDirectory()) continue;
                destination$iv$iv6.add(element$iv$iv7);
            }
            List directories = (List)destination$iv$iv6;
            if (CollectionsKt.any((Iterable)directories)) {
                $receiver$iv7 = directories;
                var26_18 = countString$2;
                arrayList = messages;
                n2 = $receiver$iv7.size();
                arrayList.add(var26_18.invoke(n2, "folder"));
            }
            Iterable $receiver$iv8 = virtualFiles;
            destination$iv$iv6 = $receiver$iv8;
            Collection destination$iv$iv7 = new ArrayList();
            for (Object element$iv$iv8 : $receiver$iv$iv) {
                VirtualFile it8 = (VirtualFile)element$iv$iv8;
                if (!(!it8.isDirectory())) continue;
                destination$iv$iv7.add(element$iv$iv8);
            }
            List files2 = (List)destination$iv$iv7;
            if (CollectionsKt.any((Iterable)files2)) {
                $receiver$iv8 = files2;
                var26_18 = countString$2;
                arrayList = messages;
                n2 = $receiver$iv8.size();
                arrayList.add(var26_18.invoke(n2, "file"));
            }
            if ((returnValue = Messages.showOkCancelDialog((String)(message2 = "Delete " + CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "?"), (String)"Delete", (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        List problems = new ArrayList();
        WriteCommandAction.runWriteCommandAction((Project)project3, (Runnable)new Runnable(projectModelNodes, project3, problems, virtualFiles){
            final /* synthetic */ ArrayList $projectModelNodes;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $problems;
            final /* synthetic */ ArrayList $virtualFiles;

            public final void run() {
                for (ProjectModelNode projectModelNode : this.$projectModelNodes) {
                    String errorMessage;
                    RemoveCommand command = new RemoveCommand(projectModelNode.getId());
                    ProjectModelTaskResult commandResult = (ProjectModelTaskResult)ExtensionsKt.syncFromBackend$default(SolutionHostExtensionsKt.getSolution(this.$project).getProjectModelTasks().getRemove(), command, this.$project, null, 4, null);
                    if (commandResult == null || !Intrinsics.areEqual((Object)((Object)commandResult.getResult()), (Object)((Object)ProjectModelTaskResultKind.Error))) continue;
                    if (commandResult.getErrorMessage() == null) {
                        continue;
                    }
                    this.$problems.add(errorMessage);
                }
                for (VirtualFile virtualFile : this.$virtualFiles) {
                    try {
                        virtualFile.delete((Object)RiderDeleteProvider.INSTANCE);
                    }
                    catch (Exception e2) {
                        String string2 = virtualFile.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"virtualFile.name");
                        this.$problems.add(string2);
                    }
                }
            }
            {
                this.$projectModelNodes = arrayList;
                this.$project = project2;
                this.$problems = list2;
                this.$virtualFiles = arrayList2;
            }
        });
        if (!problems.isEmpty()) {
            this.reportDeletionProblem(problems);
        }
    }

    private final void reportDeletionProblem(List<String> problems) {
        List<String> problems2 = problems;
        boolean more = false;
        if (problems2.size() > 10) {
            problems2 = problems2.subList(0, 10);
            more = true;
        }
        String message2 = "Unable to erase files or folders:\n  " + StringUtil.join((Collection)problems2, (String)",\n  ") + (more ? "\n  ..." : "");
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            throw (Throwable)new RuntimeException(message2);
        }
        Messages.showMessageDialog((String)message2, (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    private RiderDeleteProvider() {
        INSTANCE = this;
    }

    static {
        new RiderDeleteProvider();
    }
}

