/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.projectGenerators;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.icons.ReSharperProjectModelIcons;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.actions.newProject.RiderNewProjectManagerKt;
import com.jetbrains.resharper.projectView.ideaInterop.RiderProjectOpenProcessor;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.projectGenerators.RiderProjectGeneratorBase;
import com.jetbrains.resharper.protocol.components.ProjectTemplatesHost;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.AddProjectCommand;
import com.jetbrains.rider.model.FileToOpen;
import com.jetbrains.rider.model.OpenExistingSolutionAndReformat;
import com.jetbrains.rider.model.RdDotNetProjectTemplate;
import com.jetbrains.rider.model.RdDotNetProjectTemplateExpand;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0002#$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/jetbrains/resharper/projectView/projectGenerators/RiderDotNetProjectGenerator;", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderProjectGeneratorBase;", "model", "Lcom/jetbrains/rider/model/RdDotNetProjectTemplate;", "host", "Lcom/jetbrains/resharper/protocol/components/ProjectTemplatesHost;", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "(Lcom/jetbrains/rider/model/RdDotNetProjectTemplate;Lcom/jetbrains/resharper/protocol/components/ProjectTemplatesHost;Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;)V", "getHost", "()Lcom/jetbrains/resharper/protocol/components/ProjectTemplatesHost;", "getItem", "()Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "getModel", "()Lcom/jetbrains/rider/model/RdDotNetProjectTemplate;", "execute", "Lcom/intellij/openapi/project/Project;", "solutionFile", "Ljava/io/File;", "projectFile", "project", "find", "", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "mark", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderDotNetProjectGenerator$FileToOpenMark;", "getCategory", "", "getDefaultProjectExtension", "getDefaultProjectName", "getLogo", "Ljavax/swing/Icon;", "getName", "getTemplateName", "Companion", "FileToOpenMark", "rider"})
public final class RiderDotNetProjectGenerator
extends RiderProjectGeneratorBase {
    @NotNull
    private final RdDotNetProjectTemplate model;
    @NotNull
    private final ProjectTemplatesHost host;
    @Nullable
    private final ProjectModelNode item;
    @NotNull
    private static final Map<String, String> knownDefaultProjectNames;
    @NotNull
    private static final Map<String, String> knownBadProjectNames;
    @NotNull
    private static final Map<String, FileToOpenMark> knownFilesToOpen;
    @NotNull
    private static final String invalidKey = "_Invalid";
    @NotNull
    private static final HashSet<String> excludeProjectTemplateKeys;
    @NotNull
    private static final String categoryName = ".NET Core";
    public static final Companion Companion;

    @Override
    @NotNull
    public String getDefaultProjectName() {
        String string2 = Companion.getKnownDefaultProjectNames().get(this.model.getKey());
        if (string2 == null) {
            string2 = StringsKt.capitalize((String)this.model.getKey());
        }
        return string2;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        String string2;
        Map<String, String> map2 = Companion.getKnownBadProjectNames();
        String string3 = map2.get(string2 = this.model.getName());
        if (string3 == null) {
            string3 = this.model.getName();
        }
        return string3;
    }

    @Override
    @NotNull
    public String getDefaultProjectExtension() {
        return "csproj";
    }

    @Override
    @NotNull
    public String getCategory() {
        return Companion.getCategoryName();
    }

    @Override
    @Nullable
    public Project execute(@Nullable File solutionFile, @NotNull File projectFile, @Nullable Project project2, @Nullable ProjectModelNode item) {
        int caret;
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        String string2 = this.model.getKey();
        String string3 = projectFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"projectFile.path");
        RdDotNetProjectTemplateExpand data = new RdDotNetProjectTemplateExpand(string2, string3);
        ExtensionsKt.syncFromBackendWithoutGateway$default(this.host.getModel().getExpand(), (Object)data, this.host.getProtocol(), null, null, 12, null);
        LocalFileSystem.getInstance().refresh(false);
        IdeEventQueue.getInstance().flushQueue();
        List filesToOpen = CollectionsKt.emptyList();
        FileToOpenMark mark = Companion.getKnownFilesToOpen().get(this.model.getKey());
        if (mark != null && (virtualFile = VfsUtil.findFileByIoFile((File)projectFile.getParentFile(), (boolean)true)) != null && (caret = this.find(virtualFile, mark)) > 0) {
            filesToOpen = CollectionsKt.listOf((Object)new FileToOpen(mark.getName(), caret));
        }
        UUID projectGuid = UUID.randomUUID();
        if (solutionFile != null) {
            Pair pair;
            String projectName = FilesKt.getNameWithoutExtension((File)projectFile);
            String escapedProjectName = StringsKt.replace$default((String)StringsKt.replace$default((String)projectName, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"_", (boolean)false, (int)4, null);
            String projectFilePath = FilesKt.relativeTo((File)projectFile, (File)new File(solutionFile.getParent())).getPath();
            Pair[] pairArray = new Pair[4];
            pairArray[0] = new Pair((Object)"$projectName$", (Object)escapedProjectName);
            String string4 = projectGuid.toString();
            StringBuilder stringBuilder = new StringBuilder().append("{");
            String string5 = "$escapedProjectGuid$";
            Pair pair2 = pair;
            Pair pair3 = pair;
            int n2 = 1;
            Pair[] pairArray2 = pairArray;
            Pair[] pairArray3 = pairArray;
            String string6 = string4;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
            String string8 = string7;
            pair2((Object)string5, (Object)stringBuilder.append(string8).append("}").toString());
            pairArray2[n2] = pair3;
            Pair[] pairArray4 = pairArray3;
            pairArray3[2] = new Pair((Object)"$projectTypeGuid$", (Object)"{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}");
            pairArray4[3] = new Pair((Object)"$projectFileLocation$", (Object)projectFilePath);
            Pair[] elements$iv = pairArray4;
            Pair[] properties = (Pair[])((Object[])elements$iv);
            FileUtil.createDirectory((File)solutionFile.getParentFile());
            RiderNewProjectManagerKt.withResource("solution.sln", null, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(solutionFile){
                final /* synthetic */ File $solutionFile;

                public final void invoke(@NotNull File solutionTemplate) {
                    Intrinsics.checkParameterIsNotNull((Object)solutionTemplate, (String)"solutionTemplate");
                    FilesKt.copyTo$default((File)solutionTemplate, (File)this.$solutionFile, (boolean)false, (int)0, (int)6, null);
                }
                {
                    this.$solutionFile = file2;
                    super(1);
                }
            }));
            String content2 = FilesKt.readText$default((File)solutionFile, null, (int)1, null);
            String modifiedContent = RiderNewProjectManagerKt.modifyContent(content2, properties);
            FilesKt.writeText$default((File)solutionFile, (String)modifiedContent, null, (int)2, null);
            String string9 = solutionFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"solutionFile.path");
            OpenExistingSolutionAndReformat solutionOpenStrategy = new OpenExistingSolutionAndReformat(filesToOpen, string9, true);
            return RiderProjectOpenProcessor.Companion.doOpenSolution(project2, false, solutionOpenStrategy);
        }
        String string10 = projectFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"projectFile.path");
        ProjectModelNode projectModelNode = item;
        if (projectModelNode == null) {
            Intrinsics.throwNpe();
        }
        AddProjectCommand request2 = new AddProjectCommand(string10, projectModelNode.getId(), true, true, projectGuid, filesToOpen);
        Project project3 = project2;
        if (project3 == null) {
            Intrinsics.throwNpe();
        }
        ExtensionsKt.syncFromBackend$default(SolutionHostExtensionsKt.getSolution(project3).getProjectModelTasks().getAddProject(), request2, project2, null, 4, null);
        return project2;
    }

    private final int find(VirtualFile directory, FileToOpenMark mark) {
        VirtualFile[] virtualFileArray = directory.getChildren();
        for (int i2 = 0; i2 < virtualFileArray.length; ++i2) {
            VirtualFile child = virtualFileArray[i2];
            if (!child.isDirectory()) {
                if (!Intrinsics.areEqual((Object)child.getName(), (Object)mark.getName())) continue;
                String text2 = FilesKt.readText$default((File)new File(child.getPath()), null, (int)1, null);
                MatchResult matchResult = Regex.find$default((Regex)mark.getPattern(), (CharSequence)text2, (int)0, (int)2, null);
                if (matchResult == null) continue;
                if (mark.getStart()) {
                    return matchResult.getRange().getStart() - 1;
                }
                return matchResult.getRange().getEndInclusive();
            }
            VirtualFile virtualFile = child;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"child");
            int index = this.find(virtualFile, mark);
            if (index <= 0) continue;
            return index;
        }
        return -1;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getTemplateName();
    }

    @Override
    @Nullable
    public Icon getLogo() {
        return ReSharperProjectModelIcons.Companion.getDotNetCoreProject();
    }

    @NotNull
    public final RdDotNetProjectTemplate getModel() {
        return this.model;
    }

    @NotNull
    public final ProjectTemplatesHost getHost() {
        return this.host;
    }

    @Nullable
    public final ProjectModelNode getItem() {
        return this.item;
    }

    public RiderDotNetProjectGenerator(@NotNull RdDotNetProjectTemplate model2, @NotNull ProjectTemplatesHost host, @Nullable ProjectModelNode item) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.model = model2;
        this.host = host;
        this.item = item;
    }

    static {
        Companion = new Companion(null);
        knownDefaultProjectNames = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"console", (Object)"ConsoleApplication"), new Pair((Object)"classlib", (Object)"ClassLibrary"), new Pair((Object)"xunit", (Object)"UnitTestProject"), new Pair((Object)"web", (Object)"WebApplication"), new Pair((Object)"mvc", (Object)"MvcApplication"), new Pair((Object)"webapi", (Object)"WebApplication")});
        knownBadProjectNames = MapsKt.mapOf((Pair)new Pair((Object)"Class library", (Object)"Class Library"));
        knownFilesToOpen = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"console", (Object)new FileToOpenMark("Program.cs", new Regex("Console\\.WriteLine"), false, 4, null)), new Pair((Object)"classlib", (Object)new FileToOpenMark("Class1.cs", new Regex("Class1\\s*\\{"), false)), new Pair((Object)"xunit", (Object)new FileToOpenMark("UnitTest1.cs", new Regex("Test1\\(\\)\\s*\\{"), false)), new Pair((Object)"web", (Object)new FileToOpenMark("Program.cs", new Regex("var host"), false, 4, null)), new Pair((Object)"mvc", (Object)new FileToOpenMark("HomeController.cs", new Regex("return View"), false, 4, null)), new Pair((Object)"webapi", (Object)new FileToOpenMark("ValuesController.cs", new Regex("return new string"), false, 4, null))});
        invalidKey = invalidKey;
        excludeProjectTemplateKeys = SetsKt.hashSetOf((Object[])new String[]{"mstest"});
        categoryName = categoryName;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/projectView/projectGenerators/RiderDotNetProjectGenerator$FileToOpenMark;", "", "name", "", "pattern", "Lkotlin/text/Regex;", "start", "", "(Ljava/lang/String;Lkotlin/text/Regex;Z)V", "getName", "()Ljava/lang/String;", "getPattern", "()Lkotlin/text/Regex;", "getStart", "()Z", "rider"})
    public static final class FileToOpenMark {
        @NotNull
        private final String name;
        @NotNull
        private final Regex pattern;
        private final boolean start;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Regex getPattern() {
            return this.pattern;
        }

        public final boolean getStart() {
            return this.start;
        }

        public FileToOpenMark(@NotNull String name, @NotNull Regex pattern, boolean start2) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            this.name = name;
            this.pattern = pattern;
            this.start = start2;
        }

        public /* synthetic */ FileToOpenMark(String string2, Regex regex, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = true;
            }
            this(string2, regex, bl);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/resharper/projectView/projectGenerators/RiderDotNetProjectGenerator$Companion;", "", "()V", "categoryName", "", "getCategoryName", "()Ljava/lang/String;", "excludeProjectTemplateKeys", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getExcludeProjectTemplateKeys", "()Ljava/util/HashSet;", "invalidKey", "getInvalidKey", "knownBadProjectNames", "", "getKnownBadProjectNames", "()Ljava/util/Map;", "knownDefaultProjectNames", "getKnownDefaultProjectNames", "knownFilesToOpen", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderDotNetProjectGenerator$FileToOpenMark;", "getKnownFilesToOpen", "rider"})
    public static final class Companion {
        @NotNull
        public final Map<String, String> getKnownDefaultProjectNames() {
            return knownDefaultProjectNames;
        }

        @NotNull
        public final Map<String, String> getKnownBadProjectNames() {
            return knownBadProjectNames;
        }

        @NotNull
        public final Map<String, FileToOpenMark> getKnownFilesToOpen() {
            return knownFilesToOpen;
        }

        @NotNull
        public final String getInvalidKey() {
            return invalidKey;
        }

        @NotNull
        public final HashSet<String> getExcludeProjectTemplateKeys() {
            return excludeProjectTemplateKeys;
        }

        @NotNull
        public final String getCategoryName() {
            return categoryName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

