/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.projectGenerators;

import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.icons.ReSharperProjectModelIcons;
import com.jetbrains.resharper.projectView.actions.newProject.RiderNewProjectManagerKt;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.projectGenerators.RiderProjectGeneratorBase;
import java.io.File;
import java.time.LocalDate;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J'\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000f0\u000e2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0014H&J7\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/resharper/projectView/projectGenerators/RiderZipProjectGenerator;", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderProjectGeneratorBase;", "()V", "addConfigurations", "", "execute", "Lcom/intellij/openapi/project/Project;", "solutionFile", "Ljava/io/File;", "projectFile", "project", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "getFilesToRename", "", "Lkotlin/Pair;", "(Ljava/io/File;)[Lkotlin/Pair;", "getLogo", "Ljavax/swing/Icon;", "getProjectTypeGuidList", "", "getProjectTypeMainGuid", "getProperties", "projectName", "projectFilePath", "solutionDir", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)[Lkotlin/Pair;", "getSolutionName", "isAvailable", "toString", "rider"})
public abstract class RiderZipProjectGenerator
extends RiderProjectGeneratorBase {
    @Override
    @NotNull
    public Icon getLogo() {
        return ReSharperProjectModelIcons.Companion.getCsharpProject();
    }

    @NotNull
    public abstract String getProjectTypeGuidList();

    @NotNull
    public abstract String getProjectTypeMainGuid();

    @Override
    @Nullable
    public Project execute(@Nullable File solutionFile, @NotNull File projectFile, @Nullable Project project2, @Nullable ProjectModelNode item) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        if (solutionFile != null) {
            return RiderNewProjectManagerKt.unpackSolutionAndOpen(solutionFile, projectFile, project2, this);
        }
        ProjectModelNode projectModelNode = item;
        if (projectModelNode == null) {
            Intrinsics.throwNpe();
        }
        Project project3 = project2;
        if (project3 == null) {
            Intrinsics.throwNpe();
        }
        RiderNewProjectManagerKt.unpackProjectAndAdd(projectModelNode, projectFile, project3, this, true);
        return project2;
    }

    @NotNull
    public Pair<String, String>[] getProperties(@NotNull String projectName, @NotNull String projectFilePath, @NotNull String solutionDir) {
        Pair pair;
        Pair pair2;
        Pair pair3;
        Pair pair4;
        Pair pair5;
        Pair pair6;
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkParameterIsNotNull((Object)solutionDir, (String)"solutionDir");
        String escapedProjectName = StringsKt.replace$default((String)StringsKt.replace$default((String)projectName, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"_", (boolean)false, (int)4, null);
        String projectGuid = UUID.randomUUID().toString();
        File file2 = new File(solutionDir);
        File file3 = new File(solutionDir, projectFilePath).getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"File(solutionDir, projectFilePath).parentFile");
        String relativeSolutionRootPath = StringsKt.replace$default((String)FilesKt.relativeTo((File)file2, (File)file3).getPath(), (String)"/", (String)"\\", (boolean)false, (int)4, null);
        Pair[] pairArray = new Pair[10];
        pairArray[0] = new Pair((Object)"$projectName$", (Object)escapedProjectName);
        CharSequence charSequence = escapedProjectName;
        String string2 = "$lowerCasedProjectName$";
        Pair pair7 = pair6;
        Pair pair8 = pair6;
        int n2 = 1;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        String string3 = charSequence;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        CharSequence charSequence2 = string4;
        pair7((Object)string2, (Object)charSequence2);
        pairArray2[n2] = pair8;
        charSequence = projectGuid;
        string2 = "$projectGuid$";
        pair7 = pair5;
        pair8 = pair5;
        n2 = 2;
        pairArray2 = pairArray3;
        String string5 = charSequence;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
        charSequence2 = string6;
        pair7((Object)string2, (Object)charSequence2);
        pairArray2[n2] = pair8;
        charSequence = projectGuid;
        charSequence2 = new StringBuilder().append("{");
        string2 = "$escapedProjectGuid$";
        pair7 = pair4;
        pair8 = pair4;
        n2 = 3;
        pairArray2 = pairArray3;
        String string7 = charSequence;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toUpperCase()");
        String string9 = string8;
        pair7((Object)string2, (Object)((StringBuilder)charSequence2).append(string9).append("}").toString());
        pairArray2[n2] = pair8;
        charSequence = this.getProjectTypeMainGuid();
        charSequence2 = new StringBuilder().append("{");
        string2 = "$projectTypeGuid$";
        pair7 = pair3;
        pair8 = pair3;
        n2 = 4;
        pairArray2 = pairArray3;
        String string10 = charSequence;
        if (string10 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string11 = string10.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).toUpperCase()");
        string9 = string11;
        pair7((Object)string2, (Object)((StringBuilder)charSequence2).append(string9).append("}").toString());
        pairArray2[n2] = pair8;
        charSequence = this.getProjectTypeGuidList();
        string2 = "$projectTypeGuidList$";
        pair7 = pair2;
        pair8 = pair2;
        n2 = 5;
        pairArray2 = pairArray3;
        String string12 = charSequence;
        if (string12 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string13 = string12.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).toUpperCase()");
        charSequence2 = string13;
        pair7((Object)string2, (Object)charSequence2);
        pairArray2[n2] = pair8;
        Pair[] pairArray4 = pairArray3;
        pairArray3[6] = new Pair((Object)"$projectFileLocation$", (Object)projectFilePath);
        pairArray4[7] = new Pair((Object)"$registeredOrganization$", (Object)"");
        charSequence = relativeSolutionRootPath;
        string2 = "$relativeSolutionRootPath$";
        pair7 = pair;
        pair8 = pair;
        n2 = 8;
        pairArray2 = pairArray4;
        pairArray3 = pairArray4;
        boolean bl = charSequence.length() == 0;
        pair7((Object)string2, (Object)(bl ? "." : relativeSolutionRootPath));
        pairArray2[n2] = pair8;
        pairArray3[9] = new Pair((Object)"$year$", (Object)String.valueOf(LocalDate.now().getYear()));
        Pair[] elements$iv = pairArray3;
        return (Pair[])((Object[])elements$iv);
    }

    @NotNull
    public Pair<File, File>[] getFilesToRename(@NotNull File projectFile) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Pair[] elements$iv = new Pair[]{new Pair((Object)new File(projectFile.getParent(), "project." + this.getDefaultProjectExtension()), (Object)projectFile)};
        return (Pair[])((Object[])elements$iv);
    }

    public boolean addConfigurations() {
        return true;
    }

    @NotNull
    public String toString() {
        return this.getName() + " (" + this.getClass().getSimpleName() + ")";
    }

    @NotNull
    public String getSolutionName() {
        return this.addConfigurations() ? "solution.sln" : "solutionWithoutConfig.sln";
    }

    public boolean isAvailable() {
        return true;
    }
}

