/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.projectGenerators;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.projectGenerators.RiderXamarinIOSZipProjectGenerator;
import com.jetbrains.resharper.projectView.projectGenerators.WatchOSAppExtension;
import com.jetbrains.resharper.projectView.projectGenerators.WatchOSAppSimple;
import com.jetbrains.resharper.run.xamarin.ios.XamarinIOSIcons;
import java.io.File;
import java.nio.file.Paths;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/resharper/projectView/projectGenerators/WatchOSApp;", "Lcom/jetbrains/resharper/projectView/projectGenerators/RiderXamarinIOSZipProjectGenerator;", "()V", "execute", "Lcom/intellij/openapi/project/Project;", "solutionFile", "Ljava/io/File;", "projectFile", "project", "item", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "getCategory", "", "getDefaultProjectExtension", "getDefaultProjectName", "getLogo", "Ljavax/swing/Icon;", "getName", "getProjectTypeGuidList", "getProjectTypeMainGuid", "getTemplateName", "rider"})
public final class WatchOSApp
extends RiderXamarinIOSZipProjectGenerator {
    @Override
    @NotNull
    public String getName() {
        return "WatchOS App";
    }

    @Override
    @NotNull
    public String getCategory() {
        return "Xamarin.watchOS";
    }

    @Override
    @NotNull
    public String getDefaultProjectName() {
        return "WatchOSApp";
    }

    @Override
    @NotNull
    public String getProjectTypeMainGuid() {
        return "FAE04EC0-301F-11D3-BF4B-00C04F79EFBC";
    }

    @Override
    @NotNull
    public String getProjectTypeGuidList() {
        return "{A9A6EAC2-568B-4F3E-869D-32CBBA122DF2};{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}";
    }

    @Override
    @NotNull
    public String getDefaultProjectExtension() {
        return "csproj";
    }

    @Override
    @NotNull
    public String getTemplateName() {
        return "";
    }

    @Override
    @NotNull
    public Icon getLogo() {
        Icon icon = XamarinIOSIcons.INSTANCE.getIOS();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"XamarinIOSIcons.IOS");
        return icon;
    }

    @Override
    @Nullable
    public Project execute(@Nullable File solutionFile, @NotNull File projectFile, @Nullable Project project2, @Nullable ProjectModelNode item) {
        String extensionGuid;
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        String projectFolder = projectFile.getParent();
        String baseProjectName = FilesKt.getNameWithoutExtension((File)projectFile);
        String appName = baseProjectName + ".WatchOSApp";
        String extensionName = baseProjectName + ".WatchOSExtension";
        File appProjectFile = Paths.get(projectFolder, appName, appName + ".csproj").toFile();
        File extensionProjectFile = Paths.get(projectFolder, extensionName, extensionName + ".csproj").toFile();
        String string2 = extensionGuid = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"extensionGuid");
        WatchOSAppExtension watchOSAppExtension = new WatchOSAppExtension(string2);
        File file2 = extensionProjectFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"extensionProjectFile");
        Project project3 = watchOSAppExtension.execute(solutionFile, file2, project2, item);
        if (project3 == null) {
            Intrinsics.throwNpe();
        }
        Project extensionProject = project3;
        Thread.sleep(500L);
        ComponentManager $receiver$iv = (ComponentManager)extensionProject;
        Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
        }
        ProjectModelNode solutionNode = ((ProjectModelViewHost)object).getSolutionNode();
        String string3 = extensionGuid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"extensionGuid");
        WatchOSAppSimple watchOSAppSimple = new WatchOSAppSimple(string3, extensionName);
        File file3 = appProjectFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"appProjectFile");
        return watchOSAppSimple.execute(null, file3, extensionProject, solutionNode);
    }
}

