/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.solutionExplorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.jetbrains.resharper.icons.ReSharperProjectModelIcons;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNodeKey;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeBase;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerSettings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0096\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0016\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J!\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 H\u0016\u00a2\u0006\u0002\u0010!R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerNodeFileSystem;", "Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerSettings;)V", "isExcluded", "", "()Z", "isValid", "contains", "file", "getBackgroundColor", "Ljava/awt/Color;", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "getName", "", "getVirtualFile", "isAlwaysLeaf", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "visit", "T", "visitor", "Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode$Visitor;", "(Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode$Visitor;)Ljava/lang/Object;", "rider"})
public final class SolutionExplorerNodeFileSystem
extends SolutionExplorerNodeBase {
    private final VirtualFile virtualFile;
    private final SolutionExplorerSettings settings;

    @Override
    public boolean isValid() {
        return this.virtualFile.isValid();
    }

    @Override
    public <T> T visit(@NotNull ISolutionExplorerNode.Visitor<? extends T> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.FileSystemNode(this);
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return VfsUtil.isAncestor((VirtualFile)this.virtualFile, (VirtualFile)file2, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<? extends AbstractTreeNode<Object>> getChildren() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)SolutionExplorerExtensionsKt.calculateFileSystemChildren(this.getProjectInstance(), this.virtualFile, this.settings);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SolutionExplorerNodeFileSystem solutionExplorerNodeFileSystem = (SolutionExplorerNodeFileSystem)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v0 = it;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.util.treeView.AbstractTreeNode<kotlin.Any>");
            }
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)v0;
            collection.add(abstractTreeNode);
        }
        return CollectionsKt.toMutableList((Collection)((List)var3_3));
    }

    public final boolean isExcluded() {
        return FileIndexFacade.getInstance((Project)this.getProject()).isExcludedFile(this.virtualFile);
    }

    @Override
    @Nullable
    public Color getBackgroundColor() {
        if (this.isExcluded()) {
            return FileColorManager.getInstance((Project)this.getProjectInstance()).getColor("Rose");
        }
        if (this.settings.isDiagnosticMode() && !FileIndexFacade.getInstance((Project)this.getProject()).isInSource(this.virtualFile)) {
            return FileColorManager.getInstance((Project)this.getProjectInstance()).getColor("Blue");
        }
        return FileColorManager.getInstance((Project)this.getProjectInstance()).getScopeColor("Non-Project Files");
    }

    protected void update(@Nullable PresentationData presentation) {
        block2: {
            if (!this.virtualFile.isValid()) {
                return;
            }
            PresentationData presentationData = presentation;
            if (presentationData != null) {
                presentationData.setPresentableText(this.getName());
            }
            Icon icon = this.virtualFile.isDirectory() ? ReSharperProjectModelIcons.Companion.getFolder() : this.virtualFile.getFileType().getIcon();
            PresentationData presentationData2 = presentation;
            if (presentationData2 == null) break block2;
            presentationData2.setIcon(icon);
        }
    }

    public boolean isAlwaysLeaf() {
        return !this.virtualFile.isDirectory();
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.virtualFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"virtualFile.name");
        return string2;
    }

    public SolutionExplorerNodeFileSystem(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull SolutionExplorerSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super(project2, ISolutionExplorerNodeKey.Companion.createKey(virtualFile), settings);
        this.virtualFile = virtualFile;
        this.settings = settings;
    }
}

