/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.projectView.solutionExplorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FileColorManager;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.RiderOpenFileDescriptor;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeKey;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNode;
import com.jetbrains.resharper.projectView.solutionExplorer.ISolutionExplorerNodeKey;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerExtensionsKt;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeBase;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeFileSystem;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerNodeLoading;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerSelectInTarget;
import com.jetbrains.resharper.projectView.solutionExplorer.SolutionExplorerSettings;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectReferenceDescriptor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0011\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0012\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J!\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016\u00a2\u0006\u0002\u0010*R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerNodeRider;", "Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "settings", "Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;Lcom/jetbrains/resharper/projectView/solutionExplorer/SolutionExplorerSettings;)V", "isValid", "", "()Z", "getNode", "()Lcom/jetbrains/resharper/projectView/nodes/ProjectModelNode;", "canNavigate", "canNavigateToSource", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBackgroundColor", "Ljava/awt/Color;", "getChildren", "Ljava/util/ArrayList;", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getName", "", "getVirtualFile", "isAlwaysExpand", "isAlwaysLeaf", "isAlwaysShowPlus", "navigate", "", "requestFocus", "parentAlreadyPresentVirtualFile", "childrenRoot", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "visit", "T", "visitor", "Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode$Visitor;", "(Lcom/jetbrains/resharper/projectView/solutionExplorer/ISolutionExplorerNode$Visitor;)Ljava/lang/Object;", "rider"})
public final class SolutionExplorerNodeRider
extends SolutionExplorerNodeBase {
    @NotNull
    private final ProjectModelNode node;
    private final SolutionExplorerSettings settings;

    @Override
    public boolean isValid() {
        return this.node.isValid();
    }

    @Override
    public void navigate(boolean requestFocus2) {
        if (ProjectModelNodeExtensionKt.isProjectReference(this.node)) {
            RdProjectModelItemDescriptor rdProjectModelItemDescriptor = this.node.getDescriptor();
            if (rdProjectModelItemDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectReferenceDescriptor");
            }
            Integer n2 = ((RdProjectReferenceDescriptor)rdProjectModelItemDescriptor).getTargetProjectId();
            if (n2 == null) {
                return;
            }
            int id = n2;
            Project project2 = this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
            SolutionExplorerSelectInTarget.Companion.navigate(project2, new ProjectModelNodeKey(id), true);
            return;
        }
        if (ProjectModelNodeExtensionKt.isAssemblyReference(this.node)) {
            return;
        }
        VirtualFile file2 = this.getVirtualFile();
        if (file2 == null || !file2.isValid()) {
            return;
        }
        Project project3 = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"myProject");
        RiderOpenFileDescriptor descriptor2 = new RiderOpenFileDescriptor(project3, this.node.getId(), file2, -1);
        descriptor2.navigate(requestFocus2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canNavigate() {
        if (super.canNavigate()) return true;
        if (!ProjectModelNodeExtensionKt.isProjectReference(this.node)) return false;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = this.node.getDescriptor();
        if (rdProjectModelItemDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectReferenceDescriptor");
        }
        if (((RdProjectReferenceDescriptor)rdProjectModelItemDescriptor).getTargetProjectId() == null) return false;
        return true;
    }

    @Override
    public <T> T visit(@NotNull ISolutionExplorerNode.Visitor<? extends T> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.ProjectModelNode(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ArrayList<? extends AbstractTreeNode<?>> getChildren() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean withInternalItems = this.settings.isShowAllItems();
        ArrayList childrenResult = ProjectModelNode.getChildren$default(this.node, withInternalItems, false, 2, null);
        if (childrenResult.isEmpty() && this.node.isLoadingNode()) {
            SolutionExplorerNodeLoading[] solutionExplorerNodeLoadingArray = new SolutionExplorerNodeLoading[1];
            Project project2 = this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
            solutionExplorerNodeLoadingArray[0] = new SolutionExplorerNodeLoading(project2, this.settings);
            return CollectionsKt.arrayListOf((Object[])solutionExplorerNodeLoadingArray);
        }
        SolutionExplorerSettings settings = this.settings;
        Iterable iterable = $receiver$iv = (Iterable)childrenResult;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProjectModelNode projectModelNode = (ProjectModelNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            SolutionExplorerNodeRider solutionExplorerNodeRider = new SolutionExplorerNodeRider(this.getProjectInstance(), (ProjectModelNode)it, settings);
            collection.add(solutionExplorerNodeRider);
        }
        List result2 = (List)destination$iv$iv;
        ArrayList<SolutionExplorerNodeFileSystem> arrayList = new ArrayList<SolutionExplorerNodeFileSystem>(result2);
        if (!settings.isShowFileSystem()) {
            return arrayList;
        }
        VirtualFile virtualFile = ProjectModelNodeExtensionKt.getVirtualFileAsContentRoot(this.node);
        if (virtualFile == null) {
            return arrayList;
        }
        VirtualFile childrenRoot = virtualFile;
        if (this.parentAlreadyPresentVirtualFile(childrenRoot)) {
            return arrayList;
        }
        HashSet set2 = ArraysKt.toHashSet((Object[])ProjectModelNodeExtensionKt.getAffectedVirtualFiles(this.node));
        for (SolutionExplorerNodeRider childNode : result2) {
            ProjectModelNodeExtensionKt.fillAffectedVirtualFilesRecursive(childNode.node, set2, withInternalItems);
        }
        ArrayList<SolutionExplorerNodeFileSystem> children2 = SolutionExplorerExtensionsKt.calculateFileSystemChildren(this.getProjectInstance(), childrenRoot, settings);
        for (SolutionExplorerNodeFileSystem child : children2) {
            if (set2.contains(child.getVirtualFile())) continue;
            arrayList.add(child);
        }
        return arrayList;
    }

    private final boolean parentAlreadyPresentVirtualFile(VirtualFile childrenRoot) {
        for (ProjectModelNode parent = this.node.getParent(); parent != null; parent = parent.getParent()) {
            VirtualFile parentChildrenRoot = ProjectModelNodeExtensionKt.getVirtualFileAsContentRoot(parent);
            if (parentChildrenRoot == null) continue;
            return Intrinsics.areEqual((Object)parentChildrenRoot, (Object)childrenRoot);
        }
        return false;
    }

    protected void update(@Nullable PresentationData presentation) {
        block3: {
            PresentationData presentationData = presentation;
            if (presentationData != null) {
                presentationData.setPresentableText(this.getName());
            }
            PresentationData presentationData2 = presentation;
            if (presentationData2 != null) {
                presentationData2.setIcon(this.node.getIcon());
            }
            if (!Registry.is((String)"projectView.showHierarchyErrors") || !this.node.hasErrors()) break block3;
            PresentationData presentationData3 = presentation;
            if (presentationData3 != null) {
                presentationData3.setAttributesKey(CodeInsightColors.ERRORS_ATTRIBUTES);
            }
        }
    }

    @Override
    @Nullable
    public Color getBackgroundColor() {
        VirtualFile virtualFile;
        if (this.settings.isDiagnosticMode() && (virtualFile = this.getVirtualFile()) != null) {
            if (FileIndexFacade.getInstance((Project)this.getProjectInstance()).isExcludedFile(virtualFile)) {
                return FileColorManager.getInstance((Project)this.getProjectInstance()).getColor("Rose");
            }
            if (!FileIndexFacade.getInstance((Project)this.getProjectInstance()).isInSource(virtualFile)) {
                return FileColorManager.getInstance((Project)this.getProjectInstance()).getColor("Blue");
            }
        }
        return FileColorManager.getInstance((Project)this.getProjectInstance()).getScopeColor("Project Files");
    }

    public boolean isAlwaysLeaf() {
        if (this.node.isLoadingNode()) {
            return false;
        }
        if (this.node.hasChildren()) {
            return false;
        }
        if (ProjectModelNodeExtensionKt.isSolution(this.node) || ProjectModelNodeExtensionKt.isSolutionFolder(this.node) || ProjectModelNodeExtensionKt.isProject(this.node) || ProjectModelNodeExtensionKt.isUnloadedProject(this.node) || ProjectModelNodeExtensionKt.isProjectFolder(this.node)) {
            return !this.settings.isShowFileSystem();
        }
        return true;
    }

    public boolean isAlwaysShowPlus() {
        if (this.node.isLoadingNode()) {
            return false;
        }
        if (this.node.expandApplicable()) {
            return false;
        }
        return this.node.hasChildren();
    }

    public boolean isAlwaysExpand() {
        return ProjectModelNodeExtensionKt.isSolution(this.node);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (ProjectModelNodeExtensionKt.isSolution(this.node)) {
            this.log("Solution node " + this.getName() + " contains " + file2 + " = true");
            return true;
        }
        ComponentManager $receiver$iv = (ComponentManager)this.node.getProject();
        Object object = $receiver$iv.getComponent(ProjectModelViewHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + ProjectModelViewHost.class + " not found in container " + $receiver$iv);
        }
        ProjectModelViewHost host = (ProjectModelViewHost)object;
        ProjectModelNode[] items2 = host.getItemsByVirtualFile(file2);
        this.log("RiderNode " + this.getName() + ": find " + ((Object[])items2).length + " items by " + file2);
        for (int i2 = 0; i2 < items2.length; ++i2) {
            ProjectModelNode item = items2[i2];
            this.log("Check " + item + "...");
            for (ProjectModelNode currentItem = item; currentItem != null; currentItem = currentItem.getParent()) {
                if (!Intrinsics.areEqual((Object)currentItem, (Object)this.node)) continue;
                this.log("true");
                return true;
            }
            this.log("false");
        }
        SolutionExplorerSettings settings = this.settings;
        if (settings instanceof SolutionExplorerSettings && settings.isShowFileSystem()) {
            VirtualFile virtualFile = ProjectModelNodeExtensionKt.getVirtualFileAsContentRoot(this.node);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile currentFile = virtualFile;
            boolean result2 = VfsUtil.isAncestor((VirtualFile)currentFile, (VirtualFile)file2, (boolean)false);
            this.log("FileSystemNode " + this.getName() + ": " + currentFile + " contains " + file2 + " = " + result2);
            return result2;
        }
        this.log(this.getName() + " contains " + file2 + " = false");
        return false;
    }

    public boolean canNavigateToSource() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return !virtualFile2.isDirectory() && ProjectModelNodeExtensionKt.isProjectFile(this.node);
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.node.getVirtualFile();
    }

    @Override
    @NotNull
    public String getName() {
        if (this.settings.isDiagnosticMode()) {
            String name = this.node.getId() + " " + this.node.getPresentableName();
            if (this.node.getErrorMark()) {
                name = name + " [HasErrors]";
            }
            if (this.node.getErrorsBeneath() > 0) {
                name = name + (" [Errors Beneath: " + this.node.getErrorsBeneath() + "]");
            }
            return name;
        }
        return this.node.getPresentableName();
    }

    @NotNull
    public final ProjectModelNode getNode() {
        return this.node;
    }

    public SolutionExplorerNodeRider(@NotNull Project project2, @NotNull ProjectModelNode node, @NotNull SolutionExplorerSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super(project2, ISolutionExplorerNodeKey.Companion.createKey(node), settings);
        this.node = node;
        this.settings = settings;
    }
}

